/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.testfixture;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.rap.rwt.application.Application;
import org.eclipse.rap.rwt.application.ApplicationConfiguration;
import org.eclipse.rap.rwt.client.Client;
import org.eclipse.rap.rwt.client.WebClient;
import org.eclipse.rap.rwt.engine.RWTServletContextListener;
import org.eclipse.rap.rwt.internal.application.ApplicationContextHelper;
import org.eclipse.rap.rwt.internal.application.ApplicationContextUtil;
import org.eclipse.rap.rwt.internal.client.ClientSelector;
import org.eclipse.rap.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rap.rwt.internal.lifecycle.DisplayLifeCycleAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.DisplayUtil;
import org.eclipse.rap.rwt.internal.lifecycle.IUIThreadHolder;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rap.rwt.internal.lifecycle.RWTLifeCycle;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectImpl;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceContext;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.rap.rwt.internal.service.UISessionTestAdapter;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.PhaseId;
import org.eclipse.rap.rwt.lifecycle.WidgetAdapter;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.remote.Connection;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.rap.rwt.service.ResourceManager;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.rap.rwt.testfixture.Message;
import org.eclipse.rap.rwt.testfixture.TestRequest;
import org.eclipse.rap.rwt.testfixture.TestResponse;
import org.eclipse.rap.rwt.testfixture.TestServletContext;
import org.eclipse.rap.rwt.testfixture.TestSession;
import org.eclipse.rap.rwt.testfixture.internal.TestResourceManager;
import org.eclipse.rap.rwt.testfixture.internal.engine.ThemeManagerHelper;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.WidgetAdapterImpl;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Fixture {
    public static final File TEMP_DIR = Fixture.createTempDir();
    public static final File WEB_CONTEXT_DIR = new File(TEMP_DIR, "testapp");
    public static final File WEB_CONTEXT_RWT_RESOURCES_DIR = new File(WEB_CONTEXT_DIR, "rwt-resources");
    public static final String IMAGE1 = "resources/images/image1.gif";
    public static final String IMAGE2 = "resources/images/image2.gif";
    public static final String IMAGE3 = "resources/images/image3.gif";
    public static final String IMAGE_100x50 = "resources/images/test-100x50.png";
    public static final String IMAGE_50x100 = "resources/images/test-50x100.png";
    private static final String SYS_PROP_USE_PERFORMANCE_OPTIMIZATIONS = "usePerformanceOptimizations";
    private static ServletContext servletContext;
    private static RWTServletContextListener rwtServletContextListener;

    static {
        ThemeManagerHelper.replaceStandardResourceLoader();
        Fixture.setSkipResourceRegistration(Fixture.isPerformanceOptimizationsEnabled());
        Fixture.setSkipResourceDeletion(Fixture.isPerformanceOptimizationsEnabled());
    }

    public static ServletContext createServletContext() {
        servletContext = new TestServletContext();
        Fixture.useTestResourceManager();
        return Fixture.getServletContext();
    }

    public static ServletContext getServletContext() {
        return servletContext;
    }

    public static void disposeOfServletContext() {
        servletContext = null;
    }

    public static void setInitParameter(String name, String value) {
        Fixture.ensureServletContext();
        servletContext.setInitParameter(name, value);
    }

    public static void triggerServletContextInitialized() {
        Fixture.ensureServletContext();
        Fixture.registerConfigurer();
        rwtServletContextListener = new RWTServletContextListener();
        ServletContextEvent event = new ServletContextEvent(servletContext);
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Fixture.class.getClassLoader());
            rwtServletContextListener.contextInitialized(event);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    public static void triggerServletContextDestroyed() {
        ServletContextEvent event = new ServletContextEvent(servletContext);
        if (rwtServletContextListener != null) {
            rwtServletContextListener.contextDestroyed(event);
        }
        rwtServletContextListener = null;
    }

    public static void createApplicationContext() {
        Fixture.ensureServletContext();
        Fixture.createWebContextDirectory();
        Fixture.triggerServletContextInitialized();
    }

    public static void disposeOfApplicationContext() {
        Fixture.triggerServletContextDestroyed();
        Fixture.disposeOfServletContext();
        if (!Fixture.isPerformanceOptimizationsEnabled()) {
            Fixture.deleteWebContextDirectory();
        }
    }

    public static void createServiceContext() {
        TestRequest request = new TestRequest();
        request.setBody(Fixture.createEmptyMessage());
        TestResponse response = new TestResponse();
        TestSession session = Fixture.createTestSession();
        request.setSession(session);
        Fixture.createNewServiceContext(request, response);
    }

    private static TestSession createTestSession() {
        TestSession result = new TestSession();
        if (servletContext != null) {
            result.setServletContext(servletContext);
        }
        return result;
    }

    public static void disposeOfServiceContext() {
        ThemeManagerHelper.resetThemeManagerIfNeeded();
        HttpSession session = ContextProvider.getRequest().getSession();
        ContextProvider.disposeContext();
        session.invalidate();
    }

    public static void createWebContextDirectory() {
        WEB_CONTEXT_DIR.mkdirs();
    }

    public static void deleteWebContextDirectory() {
        if (WEB_CONTEXT_DIR.exists()) {
            Fixture.delete(WEB_CONTEXT_DIR);
        }
    }

    public static void setUp() {
        Fixture.useTestResourceManager();
        Fixture.createApplicationContext();
        Fixture.createServiceContext();
        Fixture.fakeClient((Client)new WebClient());
    }

    public static void useDefaultResourceManager() {
        ApplicationContextHelper.fakeResourceManager(null);
    }

    public static void useTestResourceManager() {
        ApplicationContextHelper.fakeResourceManager((ResourceManager)new TestResourceManager());
    }

    public static void tearDown() {
        Fixture.disposeOfServiceContext();
        Fixture.disposeOfApplicationContext();
        Fixture.disposeOfServletContext();
        Fixture.useDefaultResourceManager();
    }

    public static void readDataAndProcessAction(Display display) {
        DisplayLifeCycleAdapter displayLCA = DisplayUtil.getLCA((Display)display);
        Fixture.fakePhase(PhaseId.READ_DATA);
        displayLCA.readData(display);
        Fixture.preserveWidgets();
        Fixture.fakePhase(PhaseId.PROCESS_ACTION);
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    public static void readDataAndProcessAction(Widget widget) {
        AbstractWidgetLCA widgetLCA = WidgetUtil.getLCA((Widget)widget);
        Fixture.fakePhase(PhaseId.READ_DATA);
        widgetLCA.readData(widget);
        Fixture.fakePhase(PhaseId.PROCESS_ACTION);
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    public static void markInitialized(Widget widget) {
        Object adapter = widget.getAdapter(WidgetAdapter.class);
        WidgetAdapterImpl widgetAdapter = (WidgetAdapterImpl)adapter;
        widgetAdapter.setInitialized(true);
    }

    public static void markInitialized(Display display) {
        Object adapter = display.getAdapter(WidgetAdapter.class);
        WidgetAdapterImpl widgetAdapter = (WidgetAdapterImpl)adapter;
        widgetAdapter.setInitialized(true);
    }

    public static void preserveWidgets() {
        Display display = LifeCycleUtil.getSessionDisplay();
        DisplayLifeCycleAdapter displayLCA = DisplayUtil.getLCA((Display)display);
        PhaseId bufferedPhaseId = CurrentPhase.get();
        Fixture.fakePhase(PhaseId.READ_DATA);
        displayLCA.preserveValues(display);
        Fixture.fakePhase(bufferedPhaseId);
    }

    public static void clearPreserved() {
        Display display = LifeCycleUtil.getSessionDisplay();
        DisplayLifeCycleAdapter displayLCA = DisplayUtil.getLCA((Display)display);
        PhaseId bufferedPhaseId = CurrentPhase.get();
        Fixture.fakePhase(PhaseId.RENDER);
        displayLCA.clearPreserved(display);
        Fixture.fakePhase(bufferedPhaseId);
    }

    public static Message getProtocolMessage() {
        TestResponse response = (TestResponse)ContextProvider.getResponse();
        Fixture.finishResponse(response);
        return new Message(response.getContent());
    }

    private static void finishResponse(TestResponse response) {
        if (response.getContent().length() == 0) {
            ProtocolMessageWriter protocolWriter = ContextProvider.getProtocolWriter();
            try {
                response.getWriter().write(protocolWriter.createMessage());
            }
            catch (IOException exception) {
                throw new IllegalStateException("Failed to get response writer", exception);
            }
        }
    }

    public static void fakeClient(Client client) {
        ContextProvider.getUISession().setAttribute(ClientSelector.SELECTED_CLIENT, (Object)client);
    }

    public static void fakeConnection(Connection connection) {
        UISession uiSession = ContextProvider.getUISession();
        UISessionTestAdapter.setConnection(uiSession, connection);
    }

    public static TestRequest fakeNewRequest() {
        TestRequest request = Fixture.createNewRequest("POST");
        request.setBody(Fixture.createEmptyMessage());
        Fixture.createNewServiceContext(request, new TestResponse());
        Fixture.fakeResponseWriter();
        return request;
    }

    public static TestRequest fakeNewGetRequest() {
        TestRequest request = Fixture.createNewRequest("GET");
        Fixture.createNewServiceContext(request, new TestResponse());
        return request;
    }

    private static TestRequest createNewRequest(String method) {
        TestRequest request = new TestRequest();
        request.setMethod(method);
        request.setSession(ContextProvider.getRequest().getSession());
        return request;
    }

    private static void createNewServiceContext(HttpServletRequest request, HttpServletResponse response) {
        ServiceContext serviceContext = new ServiceContext(request, response);
        serviceContext.setServiceStore(new ServiceStore());
        ContextProvider.disposeContext();
        ContextProvider.setContext((ServiceContext)serviceContext);
    }

    public static String createEmptyMessage() {
        JSONObject result = new JSONObject();
        try {
            result.put("head", (Object)new JSONObject());
            result.put("operations", (Object)new JSONArray());
        }
        catch (JSONException exception) {
            throw new IllegalStateException("Failed to create json message", exception);
        }
        return result.toString();
    }

    public static void fakeHeadParameter(String key, Object value) {
        Fixture.checkMessage();
        TestRequest request = (TestRequest)ContextProvider.getRequest();
        String json = request.getBody();
        try {
            JSONObject message = new JSONObject(json);
            JSONObject header = message.getJSONObject("head");
            header.put(key, value);
            request.setBody(message.toString());
        }
        catch (JSONException exception) {
            throw new RuntimeException("Failed to add header parameter", exception);
        }
    }

    public static void fakeSetParameter(String target, String key, Object value) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(key, value);
        Fixture.fakeSetOperation(target, parameters);
    }

    public static void fakeSetOperation(String target, Map<String, Object> parameters) {
        Fixture.checkMessage();
        TestRequest request = (TestRequest)ContextProvider.getRequest();
        String json = request.getBody();
        try {
            JSONObject message = new JSONObject(json);
            JSONArray operations = message.getJSONArray("operations");
            JSONArray newOperation = new JSONArray();
            newOperation.put((Object)"set");
            newOperation.put((Object)target);
            newOperation.put((Object)new JSONObject(parameters));
            operations.put((Object)newOperation);
            request.setBody(message.toString());
        }
        catch (JSONException exception) {
            throw new RuntimeException("Failed to add set operation", exception);
        }
    }

    public static void dispatchNotify(RemoteObject remoteObject, String eventName, Map<String, Object> properties) {
        RemoteObjectImpl remoteObjectImpl = (RemoteObjectImpl)remoteObject;
        remoteObjectImpl.getHandler().handleNotify(eventName, properties);
    }

    public static void dispatchCall(RemoteObject remoteObject, String methodName, Map<String, Object> parameters) {
        RemoteObjectImpl remoteObjectImpl = (RemoteObjectImpl)remoteObject;
        remoteObjectImpl.getHandler().handleCall(methodName, parameters);
    }

    public static void dispatchSet(RemoteObject remoteObject, Map<String, Object> properties) {
        RemoteObjectImpl remoteObjectImpl = (RemoteObjectImpl)remoteObject;
        remoteObjectImpl.getHandler().handleSet(properties);
    }

    public static void fakeNotifyOperation(String target, String eventName, Map<String, Object> properties) {
        Fixture.checkMessage();
        TestRequest request = (TestRequest)ContextProvider.getRequest();
        String json = request.getBody();
        try {
            JSONObject message = new JSONObject(json);
            JSONArray operations = message.getJSONArray("operations");
            JSONArray newOperation = new JSONArray();
            newOperation.put((Object)"notify");
            newOperation.put((Object)target);
            newOperation.put((Object)eventName);
            newOperation.put((Object)new JSONObject(properties));
            operations.put((Object)newOperation);
            request.setBody(message.toString());
        }
        catch (JSONException exception) {
            throw new RuntimeException("Failed to add notify operation", exception);
        }
    }

    public static void fakeCallOperation(String target, String methodName, Map<String, Object> parameters) {
        Fixture.checkMessage();
        TestRequest request = (TestRequest)ContextProvider.getRequest();
        String json = request.getBody();
        try {
            JSONObject message = new JSONObject(json);
            JSONArray operations = message.getJSONArray("operations");
            JSONArray newOperation = new JSONArray();
            newOperation.put((Object)"call");
            newOperation.put((Object)target);
            newOperation.put((Object)methodName);
            newOperation.put((Object)new JSONObject(parameters));
            operations.put((Object)newOperation);
            request.setBody(message.toString());
        }
        catch (JSONException exception) {
            throw new RuntimeException("Failed to add call operation", exception);
        }
    }

    private static void checkMessage() {
        if (ProtocolUtil.isClientMessageProcessed()) {
            throw new IllegalStateException("Client message is already processed");
        }
    }

    public static void fakeResourceManager(ResourceManager resourceManager) {
        ApplicationContextHelper.fakeResourceManager(resourceManager);
    }

    public static void fakeResponseWriter() {
        TestResponse testResponse = (TestResponse)ContextProvider.getResponse();
        testResponse.clearContent();
        ContextProvider.getContext().resetProtocolWriter();
    }

    public static void fakePhase(PhaseId phase) {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        serviceStore.setAttribute(String.valueOf(CurrentPhase.class.getName()) + "#value", (Object)phase);
    }

    public static void executeLifeCycleFromServerThread() {
        IUIThreadHolder threadHolder = Fixture.registerCurrentThreadAsUIThreadHolder();
        Thread serverThread = Fixture.fakeRequestThread(threadHolder);
        Fixture.simulateRequest(threadHolder, serverThread);
        RWTLifeCycle lifeCycle = (RWTLifeCycle)ContextProvider.getApplicationContext().getLifeCycleFactory().getLifeCycle();
        while (LifeCycleUtil.getSessionDisplay().readAndDispatch()) {
        }
        lifeCycle.sleep();
    }

    public static void replaceServiceStore(ServiceStore serviceStore) {
        HttpServletRequest request = ContextProvider.getRequest();
        HttpServletResponse response = ContextProvider.getResponse();
        ServiceContext context = new ServiceContext(request, response);
        if (serviceStore != null) {
            context.setServiceStore(serviceStore);
        }
        ContextProvider.disposeContext();
        ContextProvider.setContext((ServiceContext)context);
    }

    public static void setSkipResourceRegistration(boolean skip) {
        ApplicationContextHelper.setSkipResoureRegistration(skip);
    }

    public static void resetSkipResourceRegistration() {
        ApplicationContextHelper.setSkipResoureRegistration(Fixture.isPerformanceOptimizationsEnabled());
    }

    public static void setSkipResourceDeletion(boolean skip) {
        ApplicationContextHelper.setSkipResoureDeletion(skip);
    }

    public static void resetSkipResourceDeletion() {
        ApplicationContextHelper.setSkipResoureDeletion(Fixture.isPerformanceOptimizationsEnabled());
    }

    public static void copyTestResource(String resourceName, File destination) throws IOException {
        ClassLoader loader = Fixture.class.getClassLoader();
        InputStream is = loader.getResourceAsStream(resourceName);
        if (is == null) {
            throw new IllegalArgumentException("Resource could not be found: " + resourceName);
        }
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            FileOutputStream out = new FileOutputStream(destination);
            BufferedOutputStream bout = new BufferedOutputStream(out);
            try {
                int c = bis.read();
                while (c != -1) {
                    bout.write(c);
                    c = bis.read();
                }
            }
            finally {
                bout.close();
            }
        }
        finally {
            bis.close();
        }
    }

    public static void runInThread(final Runnable runnable) throws Throwable {
        final AtomicReference exception = new AtomicReference();
        Runnable exceptionGuard = new Runnable(){

            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    exception.set(throwable);
                }
            }
        };
        Thread thread = new Thread(exceptionGuard);
        thread.setDaemon(true);
        thread.start();
        thread.join();
        if (exception.get() != null) {
            throw (Throwable)exception.get();
        }
    }

    public static Thread[] startThreads(int threadCount, Runnable runnable) {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        int i = 0;
        while (i < threadCount) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.start();
            threads.add(thread);
            Thread.yield();
            ++i;
        }
        Thread[] result = new Thread[threads.size()];
        threads.toArray(result);
        return result;
    }

    public static void joinThreads(Thread[] threads) throws InterruptedException {
        int i = 0;
        while (i < threads.length) {
            Thread thread = threads[i];
            thread.join();
            ++i;
        }
    }

    public static void delete(File toDelete) {
        ApplicationContextUtil.delete((File)toDelete);
    }

    public static byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(object);
        return outputStream.toByteArray();
    }

    public static Object deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        return objectInputStream.readObject();
    }

    public static <T> T serializeAndDeserialize(T instance) throws Exception {
        byte[] bytes = Fixture.serialize(instance);
        return (T)Fixture.deserialize(bytes);
    }

    public static <T extends Widget> T serializeAndDeserialize(T instance) throws Exception {
        byte[] bytes = Fixture.serialize(instance);
        Widget result = (Widget)Fixture.deserialize(bytes);
        Object adapter = result.getDisplay().getAdapter(IDisplayAdapter.class);
        IDisplayAdapter displayAdapter = (IDisplayAdapter)adapter;
        displayAdapter.attachThread();
        return (T)result;
    }

    private static void ensureServletContext() {
        if (servletContext == null) {
            Fixture.createServletContext();
        }
    }

    private static void registerConfigurer() {
        Fixture.setInitParameter("org.eclipse.rap.applicationConfiguration", FixtureApplicationConfigurator.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void simulateRequest(IUIThreadHolder threadHolder, Thread serverThread) {
        RWTLifeCycle lifeCycle = (RWTLifeCycle)ContextProvider.getApplicationContext().getLifeCycleFactory().getLifeCycle();
        Object object = threadHolder.getLock();
        synchronized (object) {
            serverThread.start();
            try {
                lifeCycle.sleep();
            }
            catch (ThreadDeath e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static Thread fakeRequestThread(final IUIThreadHolder threadHolder) {
        final RWTLifeCycle lifeCycle = (RWTLifeCycle)ContextProvider.getApplicationContext().getLifeCycleFactory().getLifeCycle();
        final ServiceContext context = ContextProvider.getContext();
        Thread result = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = threadHolder.getLock();
                synchronized (object) {
                    ContextProvider.setContext((ServiceContext)context);
                    try {
                        try {
                            lifeCycle.execute();
                            lifeCycle.setPhaseOrder(null);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    finally {
                        ContextProvider.releaseContextHolder();
                        threadHolder.notifyAll();
                    }
                }
            }
        }, "ServerThread");
        return result;
    }

    private static IUIThreadHolder registerCurrentThreadAsUIThreadHolder() {
        IUIThreadHolder result = new IUIThreadHolder(){
            private final Thread thread = Thread.currentThread();

            public void setServiceContext(ServiceContext serviceContext) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void switchThread() {
                Object object = this.getLock();
                synchronized (object) {
                    this.notifyAll();
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            public void updateServiceContext() {
            }

            public void terminateThread() {
            }

            public Thread getThread() {
                return this.thread;
            }

            public Object getLock() {
                return this;
            }
        };
        UISession uiSession = ContextProvider.getUISession();
        LifeCycleUtil.setUIThread((UISession)uiSession, (IUIThreadHolder)result);
        return result;
    }

    private static boolean isPerformanceOptimizationsEnabled() {
        return Boolean.getBoolean(SYS_PROP_USE_PERFORMANCE_OPTIMIZATIONS);
    }

    private static File createTempDir() {
        String subDirName;
        File globalTmpDir = new File(System.getProperty("java.io.tmpdir"));
        File tmpDir = new File(globalTmpDir, subDirName = "rap-test-" + Long.toHexString(System.currentTimeMillis()));
        if (!tmpDir.mkdir()) {
            String message = "Failed to create temp directory: " + tmpDir.getAbsolutePath();
            throw new IllegalStateException(message);
        }
        return tmpDir;
    }

    private Fixture() {
    }

    public static class FixtureApplicationConfigurator
    implements ApplicationConfiguration {
        public void configure(Application application) {
            application.setOperationMode(Application.OperationMode.SWT_COMPATIBILITY);
        }
    }
}

