/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.textsize;

import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.textsize.MeasurementItem;
import org.eclipse.rap.rwt.internal.textsize.MeasurementOperator;
import org.eclipse.rap.rwt.internal.textsize.Probe;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.graphics.FontUtil;

public class MeasurementUtil {
    public static void appendStartupTextSizeProbe(ProtocolMessageWriter writer) {
        MeasurementOperator.getInstance().appendStartupTextSizeProbe(writer);
    }

    static Object createItemParamObject(MeasurementItem item) {
        Object[] result = new Object[8];
        FontData fontData = item.getFontData();
        result[0] = MeasurementUtil.getId(item);
        result[1] = item.getTextToMeasure();
        result[2] = ProtocolUtil.parseFontName(fontData.getName());
        result[3] = fontData.getHeight();
        result[4] = (fontData.getStyle() & 1) != 0;
        result[5] = (fontData.getStyle() & 2) != 0;
        result[6] = item.getWrapWidth();
        result[7] = MeasurementUtil.isMarkup(item.getMode());
        return result;
    }

    static Object createProbeParamObject(Probe probe) {
        Object[] result = new Object[8];
        FontData fontData = probe.getFontData();
        result[0] = MeasurementUtil.getId(probe);
        result[1] = probe.getText();
        result[2] = ProtocolUtil.parseFontName(fontData.getName());
        result[3] = fontData.getHeight();
        result[4] = (fontData.getStyle() & 1) != 0;
        result[5] = (fontData.getStyle() & 2) != 0;
        result[6] = -1;
        result[7] = Boolean.TRUE;
        return result;
    }

    static void addItemToMeasure(String toMeasure, Font font, int wrapWidth, int mode) {
        FontData fontData = FontUtil.getData(font);
        MeasurementItem newItem = new MeasurementItem(toMeasure, fontData, wrapWidth, mode);
        MeasurementOperator.getInstance().addItemToMeasure(newItem);
    }

    static String getId(Probe probe) {
        return MeasurementUtil.getId(probe.getFontData());
    }

    static String getId(MeasurementItem item) {
        return "t" + Integer.toString(item.hashCode());
    }

    static String getId(FontData fontData) {
        return "p" + Integer.toString(fontData.hashCode());
    }

    private static boolean isMarkup(int mode) {
        return mode == 2;
    }

    private MeasurementUtil() {
    }
}

