/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.textsize;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.WidgetTreeVisitor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

class RestoreScrolledCompositeOriginsVisitor
extends WidgetTreeVisitor.AllWidgetTreeVisitor {
    RestoreScrolledCompositeOriginsVisitor() {
    }

    public boolean doVisit(Widget widget) {
        if (widget instanceof ScrolledComposite) {
            this.restoreOrigin((ScrolledComposite)widget);
            this.restoreContentSize((ScrolledComposite)widget);
        }
        return true;
    }

    private void restoreOrigin(ScrolledComposite composite) {
        Point oldOrigin = this.getBufferedOrigin(composite);
        if (oldOrigin != null) {
            composite.setOrigin(oldOrigin);
            composite.setData("org.eclipse.rap.sc-origin", null);
        }
    }

    private void restoreContentSize(ScrolledComposite composite) {
        Control content = composite.getContent();
        if (content != null) {
            this.restoreContentSize(content);
        }
    }

    private void restoreContentSize(Control content) {
        Point size = this.getBufferedContentSize(content);
        if (size != null) {
            content.setSize(size);
            content.setData("org.eclipse.rap.content-size", null);
        }
    }

    private Point getBufferedContentSize(Control content) {
        return (Point)content.getData("org.eclipse.rap.content-size");
    }

    private Point getBufferedOrigin(ScrolledComposite composite) {
        return (Point)composite.getData("org.eclipse.rap.sc-origin");
    }
}

