/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.rwt.internal.lifecycle.DisplayUtil;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.lifecycle.WidgetAdapter;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public final class ActiveKeysUtil {
    private static final Map<String, Integer> KEY_MAP = new HashMap<String, Integer>();
    private static final String ALT = "ALT+";
    private static final String CTRL = "CTRL+";
    private static final String SHIFT = "SHIFT+";
    static final String PROP_ACTIVE_KEYS = "activeKeys";
    static final String PROP_CANCEL_KEYS = "cancelKeys";

    static {
        KEY_MAP.put("BACKSPACE", new Integer(8));
        KEY_MAP.put("BS", new Integer(8));
        KEY_MAP.put("TAB", new Integer(9));
        KEY_MAP.put("RETURN", new Integer(13));
        KEY_MAP.put("ENTER", new Integer(13));
        KEY_MAP.put("CR", new Integer(13));
        KEY_MAP.put("PAUSE", new Integer(19));
        KEY_MAP.put("BREAK", new Integer(19));
        KEY_MAP.put("CAPS_LOCK", new Integer(20));
        KEY_MAP.put("ESCAPE", new Integer(27));
        KEY_MAP.put("ESC", new Integer(27));
        KEY_MAP.put("SPACE", new Integer(32));
        KEY_MAP.put("PAGE_UP", new Integer(33));
        KEY_MAP.put("PAGE_DOWN", new Integer(34));
        KEY_MAP.put("END", new Integer(35));
        KEY_MAP.put("HOME", new Integer(36));
        KEY_MAP.put("ARROW_LEFT", new Integer(37));
        KEY_MAP.put("ARROW_UP", new Integer(38));
        KEY_MAP.put("ARROW_RIGHT", new Integer(39));
        KEY_MAP.put("ARROW_DOWN", new Integer(40));
        KEY_MAP.put("PRINT_SCREEN", new Integer(44));
        KEY_MAP.put("INSERT", new Integer(45));
        KEY_MAP.put("DEL", new Integer(46));
        KEY_MAP.put("DELETE", new Integer(46));
        KEY_MAP.put("F1", new Integer(112));
        KEY_MAP.put("F2", new Integer(113));
        KEY_MAP.put("F3", new Integer(114));
        KEY_MAP.put("F4", new Integer(115));
        KEY_MAP.put("F5", new Integer(116));
        KEY_MAP.put("F6", new Integer(117));
        KEY_MAP.put("F7", new Integer(118));
        KEY_MAP.put("F8", new Integer(119));
        KEY_MAP.put("F9", new Integer(120));
        KEY_MAP.put("F10", new Integer(121));
        KEY_MAP.put("F11", new Integer(122));
        KEY_MAP.put("F12", new Integer(123));
        KEY_MAP.put("NUMPAD_0", new Integer(96));
        KEY_MAP.put("NUMPAD_1", new Integer(97));
        KEY_MAP.put("NUMPAD_2", new Integer(98));
        KEY_MAP.put("NUMPAD_3", new Integer(99));
        KEY_MAP.put("NUMPAD_4", new Integer(100));
        KEY_MAP.put("NUMPAD_5", new Integer(101));
        KEY_MAP.put("NUMPAD_6", new Integer(102));
        KEY_MAP.put("NUMPAD_7", new Integer(103));
        KEY_MAP.put("NUMPAD_8", new Integer(104));
        KEY_MAP.put("NUMPAD_9", new Integer(105));
        KEY_MAP.put("NUMPAD_MULTIPLY", new Integer(106));
        KEY_MAP.put("NUMPAD_ADD", new Integer(107));
        KEY_MAP.put("NUMPAD_SUBTRACT", new Integer(109));
        KEY_MAP.put("NUMPAD_DECIMAL", new Integer(110));
        KEY_MAP.put("NUMPAD_DIVIDE", new Integer(111));
        KEY_MAP.put("NUM_LOCK", new Integer(144));
        KEY_MAP.put("SCROLL_LOCK", new Integer(145));
    }

    private ActiveKeysUtil() {
    }

    public static void preserveActiveKeys(Display display) {
        WidgetAdapter adapter = DisplayUtil.getAdapter(display);
        adapter.preserve(PROP_ACTIVE_KEYS, ActiveKeysUtil.getActiveKeys(display));
    }

    public static void preserveActiveKeys(Control control) {
        WidgetAdapter adapter = WidgetUtil.getAdapter(control);
        adapter.preserve(PROP_ACTIVE_KEYS, ActiveKeysUtil.getActiveKeys(control));
    }

    public static void preserveCancelKeys(Display display) {
        WidgetAdapter adapter = DisplayUtil.getAdapter(display);
        adapter.preserve(PROP_CANCEL_KEYS, ActiveKeysUtil.getCancelKeys(display));
    }

    public static void preserveCancelKeys(Control control) {
        WidgetAdapter adapter = WidgetUtil.getAdapter(control);
        adapter.preserve(PROP_CANCEL_KEYS, ActiveKeysUtil.getCancelKeys(control));
    }

    public static void renderActiveKeys(Display display) {
        if (!display.isDisposed()) {
            boolean hasChanged;
            WidgetAdapter adapter = DisplayUtil.getAdapter(display);
            Object[] newValue = ActiveKeysUtil.getActiveKeys(display);
            Object[] oldValue = (String[])adapter.getPreserved(PROP_ACTIVE_KEYS);
            boolean bl = hasChanged = !Arrays.equals(oldValue, newValue);
            if (hasChanged) {
                IClientObject clientObject = ClientObjectFactory.getClientObject(display);
                clientObject.set(PROP_ACTIVE_KEYS, ActiveKeysUtil.translateKeySequences((String[])newValue));
            }
        }
    }

    public static void renderActiveKeys(Control control) {
        if (!control.isDisposed()) {
            boolean hasChanged;
            WidgetAdapter adapter = WidgetUtil.getAdapter(control);
            Object[] newValue = ActiveKeysUtil.getActiveKeys(control);
            Object[] oldValue = (String[])adapter.getPreserved(PROP_ACTIVE_KEYS);
            boolean bl = hasChanged = !Arrays.equals(oldValue, newValue);
            if (hasChanged) {
                IClientObject clientObject = ClientObjectFactory.getClientObject(control);
                clientObject.set(PROP_ACTIVE_KEYS, ActiveKeysUtil.translateKeySequences((String[])newValue));
            }
        }
    }

    public static void renderCancelKeys(Display display) {
        if (!display.isDisposed()) {
            boolean hasChanged;
            WidgetAdapter adapter = DisplayUtil.getAdapter(display);
            Object[] newValue = ActiveKeysUtil.getCancelKeys(display);
            Object[] oldValue = (String[])adapter.getPreserved(PROP_CANCEL_KEYS);
            boolean bl = hasChanged = !Arrays.equals(oldValue, newValue);
            if (hasChanged) {
                IClientObject clientObject = ClientObjectFactory.getClientObject(display);
                clientObject.set(PROP_CANCEL_KEYS, ActiveKeysUtil.translateKeySequences((String[])newValue));
            }
        }
    }

    public static void renderCancelKeys(Control control) {
        if (!control.isDisposed()) {
            boolean hasChanged;
            WidgetAdapter adapter = WidgetUtil.getAdapter(control);
            Object[] newValue = ActiveKeysUtil.getCancelKeys(control);
            Object[] oldValue = (String[])adapter.getPreserved(PROP_CANCEL_KEYS);
            boolean bl = hasChanged = !Arrays.equals(oldValue, newValue);
            if (hasChanged) {
                IClientObject clientObject = ClientObjectFactory.getClientObject(control);
                clientObject.set(PROP_CANCEL_KEYS, ActiveKeysUtil.translateKeySequences((String[])newValue));
            }
        }
    }

    private static String[] getActiveKeys(Display display) {
        Object data = display.getData("org.eclipse.rap.rwt.activeKeys");
        String[] result = null;
        if (data != null) {
            if (data instanceof String[]) {
                result = ActiveKeysUtil.getArrayCopy(data);
            } else {
                String mesg = "Illegal value for RWT.ACTIVE_KEYS in display data, must be a string array";
                throw new IllegalArgumentException(mesg);
            }
        }
        return result;
    }

    private static String[] getActiveKeys(Control control) {
        Object data = control.getData("org.eclipse.rap.rwt.activeKeys");
        String[] result = null;
        if (data != null) {
            if (data instanceof String[]) {
                result = ActiveKeysUtil.getArrayCopy(data);
            } else {
                String mesg = "Illegal value for RWT.ACTIVE_KEYS in widget data, must be a string array";
                throw new IllegalArgumentException(mesg);
            }
        }
        return result;
    }

    private static String[] getArrayCopy(Object data) {
        String[] activeKeys = (String[])data;
        String[] result = new String[activeKeys.length];
        System.arraycopy(activeKeys, 0, result, 0, activeKeys.length);
        return result;
    }

    private static String[] getCancelKeys(Display display) {
        String[] result = null;
        Object data = display.getData("org.eclipse.rap.rwt.cancelKeys");
        if (data != null) {
            if (data instanceof String[]) {
                result = ActiveKeysUtil.getArrayCopy(data);
            } else {
                String mesg = "Illegal value for RWT.CANCEL_KEYS in display data, must be a string array";
                throw new IllegalArgumentException(mesg);
            }
        }
        return result;
    }

    private static String[] getCancelKeys(Control control) {
        String[] result = null;
        Object data = control.getData("org.eclipse.rap.rwt.cancelKeys");
        if (data != null) {
            if (data instanceof String[]) {
                result = ActiveKeysUtil.getArrayCopy(data);
            } else {
                String mesg = "Illegal value for RWT.CANCEL_KEYS in widget data, must be a string array";
                throw new IllegalArgumentException(mesg);
            }
        }
        return result;
    }

    private static String[] translateKeySequences(String[] activeKeys) {
        String[] result = new String[]{};
        if (activeKeys != null) {
            result = new String[activeKeys.length];
            int i = 0;
            while (i < activeKeys.length) {
                result[i] = ActiveKeysUtil.translateKeySequence(activeKeys[i]);
                ++i;
            }
        }
        return result;
    }

    private static String translateKeySequence(String keySequence) {
        if (keySequence == null) {
            throw new NullPointerException("Null argument");
        }
        if (keySequence.trim().length() == 0) {
            throw new IllegalArgumentException("Empty key sequence definition found");
        }
        int lastPlusIndex = keySequence.lastIndexOf("+");
        String modifierPart = "";
        String keyPart = "";
        if (lastPlusIndex != -1) {
            modifierPart = keySequence.substring(0, lastPlusIndex + 1);
            keyPart = keySequence.substring(lastPlusIndex + 1);
        } else {
            keyPart = keySequence;
        }
        int keyCode = ActiveKeysUtil.getKeyCode(keyPart);
        if (keyCode != -1) {
            keyPart = "#" + keyCode;
        }
        return String.valueOf(ActiveKeysUtil.getModifierKeys(modifierPart)) + keyPart;
    }

    private static String getModifierKeys(String modifier) {
        StringBuilder result = new StringBuilder();
        if (modifier.indexOf(ALT) != -1) {
            result.append(ALT);
        }
        if (modifier.indexOf(CTRL) != -1) {
            result.append(CTRL);
        }
        if (modifier.indexOf(SHIFT) != -1) {
            result.append(SHIFT);
        }
        if (modifier.length() != result.length()) {
            throw new IllegalArgumentException("Unrecognized modifier found in key sequence: " + modifier);
        }
        return result.toString();
    }

    private static int getKeyCode(String key) {
        int result = -1;
        Integer value = KEY_MAP.get(key);
        if (value instanceof Integer) {
            result = value;
        } else if (key.length() == 1) {
            if (Character.isLetterOrDigit(key.charAt(0))) {
                result = key.toUpperCase().charAt(0);
            }
        } else {
            throw new IllegalArgumentException("Unrecognized key: " + key);
        }
        return result;
    }
}

