/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.widgets;

import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rap.rwt.internal.theme.IThemeAdapter;
import org.eclipse.rap.rwt.internal.widgets.IFileUploadAdapter;
import org.eclipse.rap.rwt.internal.widgets.fileuploadkit.FileUploadThemeAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TypedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUpload
extends Canvas {
    private final IFileUploadAdapter fileUploadAdapter = new FileUploadAdapter();
    private String text = "";
    private Image image;
    private String fileName;
    private String url;

    public FileUpload(Composite parent, int style) {
        super(parent, FileUpload.checkStyle(style));
    }

    public void setText(String text) {
        if (text == null) {
            SWT.error(4);
        }
        this.checkWidget();
        this.text = text;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        this.image = image;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public String getFileName() {
        this.checkWidget();
        return this.fileName;
    }

    public void submit(String url) {
        if (url == null) {
            SWT.error(4);
        }
        this.checkWidget();
        if (this.fileName != null) {
            this.url = url;
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        boolean hasText;
        this.checkWidget();
        int width = 0;
        int height = 0;
        boolean hasImage = this.image != null;
        boolean bl = hasText = this.text.length() > 0;
        if (hasImage) {
            Rectangle imageBounds = this.image.getBounds();
            width = imageBounds.width;
            height = imageBounds.height;
        }
        if (hasText) {
            Point extent = TextSizeUtil.stringExtent(this.getFont(), this.text);
            width += extent.x;
            height = Math.max(height, extent.y);
        }
        if (height == 0) {
            height = 10;
        }
        FileUploadThemeAdapter themeAdapter = (FileUploadThemeAdapter)this.getAdapter(IThemeAdapter.class);
        if (hasText && hasImage) {
            int spacing = themeAdapter.getSpacing(this);
            width += spacing;
        }
        Rectangle padding = themeAdapter.getPadding(this);
        width += padding.width;
        height += padding.height;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    @Override
    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    @Override
    public Control[] getChildren() {
        this.checkWidget();
        return new Control[0];
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        IFileUploadAdapter result = adapter == IFileUploadAdapter.class ? this.fileUploadAdapter : super.getAdapter(adapter);
        return (T)result;
    }

    private static int checkStyle(int style) {
        return style & 0x800;
    }

    private final class FileUploadAdapter
    implements IFileUploadAdapter {
        private FileUploadAdapter() {
        }

        public void setFileName(String value) {
            FileUpload.this.fileName = value;
        }

        public String getAndResetUrl() {
            String result = FileUpload.this.url;
            FileUpload.this.url = null;
            return result;
        }
    }
}

