/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.datetimekit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.swt.internal.widgets.datetimekit.AbstractDateTimeLCADelegate;
import org.eclipse.swt.internal.widgets.datetimekit.DateTimeLCAUtil;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Widget;

final class DateTimeTimeLCA
extends AbstractDateTimeLCADelegate {
    private static final String PROP_HOURS = "hours";
    private static final String PROP_MINUTES = "minutes";
    private static final String PROP_SECONDS = "seconds";

    DateTimeTimeLCA() {
    }

    void preserveValues(DateTime dateTime) {
        DateTimeLCAUtil.preserveValues(dateTime);
        WidgetLCAUtil.preserveProperty((Widget)dateTime, PROP_HOURS, dateTime.getHours());
        WidgetLCAUtil.preserveProperty((Widget)dateTime, PROP_MINUTES, dateTime.getMinutes());
        WidgetLCAUtil.preserveProperty((Widget)dateTime, PROP_SECONDS, dateTime.getSeconds());
        DateTimeLCAUtil.preserveSubWidgetsBounds(dateTime, DateTimeTimeLCA.getSubWidgetsBounds(dateTime));
    }

    void readData(DateTime dateTime) {
        String value = WidgetLCAUtil.readPropertyValue(dateTime, PROP_HOURS);
        if (value != null) {
            dateTime.setHours(NumberFormatUtil.parseInt(value));
        }
        if ((value = WidgetLCAUtil.readPropertyValue(dateTime, PROP_MINUTES)) != null) {
            dateTime.setMinutes(NumberFormatUtil.parseInt(value));
        }
        if ((value = WidgetLCAUtil.readPropertyValue(dateTime, PROP_SECONDS)) != null) {
            dateTime.setSeconds(NumberFormatUtil.parseInt(value));
        }
        ControlLCAUtil.processSelection(dateTime, null, true);
        ControlLCAUtil.processDefaultSelection(dateTime, null);
        ControlLCAUtil.processEvents(dateTime);
        ControlLCAUtil.processKeyEvents(dateTime);
        ControlLCAUtil.processMenuDetect(dateTime);
        WidgetLCAUtil.processHelp(dateTime);
    }

    void renderInitialization(DateTime dateTime) throws IOException {
        DateTimeLCAUtil.renderInitialization(dateTime);
    }

    void renderChanges(DateTime dateTime) throws IOException {
        DateTimeLCAUtil.renderChanges(dateTime);
        WidgetLCAUtil.renderProperty((Widget)dateTime, PROP_HOURS, dateTime.getHours(), -1);
        WidgetLCAUtil.renderProperty((Widget)dateTime, PROP_MINUTES, dateTime.getMinutes(), -1);
        WidgetLCAUtil.renderProperty((Widget)dateTime, PROP_SECONDS, dateTime.getSeconds(), -1);
        DateTimeLCAUtil.renderSubWidgetsBounds(dateTime, DateTimeTimeLCA.getSubWidgetsBounds(dateTime));
    }

    private static DateTimeLCAUtil.SubWidgetBounds[] getSubWidgetsBounds(DateTime dateTime) {
        return new DateTimeLCAUtil.SubWidgetBounds[]{DateTimeLCAUtil.getSubWidgetBounds(dateTime, 8), DateTimeLCAUtil.getSubWidgetBounds(dateTime, 11), DateTimeLCAUtil.getSubWidgetBounds(dateTime, 9), DateTimeLCAUtil.getSubWidgetBounds(dateTime, 12), DateTimeLCAUtil.getSubWidgetBounds(dateTime, 10), DateTimeLCAUtil.getSubWidgetBounds(dateTime, 7)};
    }
}

