/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.labelkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.internal.widgets.labelkit.AbstractLabelLCADelegate;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

final class StandardLabelLCA
extends AbstractLabelLCADelegate {
    private static final String TYPE = "rwt.widgets.Label";
    private static final String[] ALLOWED_STYLES = new String[]{"WRAP", "BORDER"};
    private static final String PROP_TEXT = "text";
    private static final String PROP_ALIGNMENT = "alignment";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_MARKUP_ENABLED = "markupEnabled";
    private static final String DEFAULT_ALIGNMENT = "left";

    StandardLabelLCA() {
    }

    void preserveValues(Label label) {
        ControlLCAUtil.preserveValues(label);
        WidgetLCAUtil.preserveCustomVariant(label);
        WidgetLCAUtil.preserveProperty((Widget)label, PROP_TEXT, label.getText());
        WidgetLCAUtil.preserveProperty((Widget)label, PROP_IMAGE, label.getImage());
        WidgetLCAUtil.preserveProperty((Widget)label, PROP_ALIGNMENT, StandardLabelLCA.getAlignment(label));
    }

    void readData(Label label) {
        ControlLCAUtil.processEvents(label);
        ControlLCAUtil.processKeyEvents(label);
        ControlLCAUtil.processMenuDetect(label);
        WidgetLCAUtil.processHelp(label);
    }

    void renderInitialization(Label label) throws IOException {
        IClientObject clientObject = ClientObjectFactory.getClientObject(label);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(label.getParent()));
        clientObject.set("style", WidgetLCAUtil.getStyles(label, ALLOWED_STYLES));
        WidgetLCAUtil.renderProperty((Widget)label, PROP_MARKUP_ENABLED, StandardLabelLCA.isMarkupEnabled(label), false);
    }

    void renderChanges(Label label) throws IOException {
        ControlLCAUtil.renderChanges(label);
        WidgetLCAUtil.renderCustomVariant(label);
        WidgetLCAUtil.renderProperty((Widget)label, PROP_TEXT, label.getText(), "");
        WidgetLCAUtil.renderProperty((Widget)label, PROP_IMAGE, label.getImage(), null);
        WidgetLCAUtil.renderProperty((Widget)label, PROP_ALIGNMENT, StandardLabelLCA.getAlignment(label), DEFAULT_ALIGNMENT);
    }

    private static boolean isMarkupEnabled(Label label) {
        return Boolean.TRUE.equals(label.getData("org.eclipse.rap.rwt.markupEnabled"));
    }

    private static String getAlignment(Label label) {
        int alignment = label.getAlignment();
        String result = (alignment & 0x4000) != 0 ? DEFAULT_ALIGNMENT : ((alignment & 0x1000000) != 0 ? "center" : ((alignment & 0x20000) != 0 ? "right" : DEFAULT_ALIGNMENT));
        return result;
    }
}

