/*
 * Decompiled with CFR 0.152.
 */
package br.com.tti.cockpitrap.dialogs;

import br.com.taragona.nfe.persistence.Empresa;
import br.com.tti.cockpitrap.dialogs.EmpresaTableContentProvider;
import br.com.tti.cockpitrap.dialogs.EmpresaTableLabelProvider;
import br.com.tti.cockpitrap.session.ClientSession;
import br.com.tti.cockpitrap.util.ManagerProxy;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class BuscaEmpressas
extends Dialog {
    private Text textcnpj;
    private Text textrazao;
    private Composite composite;
    private Button btnBuscar;
    private Button btnLimpar;
    private Vector<Empresa> empresa;
    private List<Empresa> empresas;
    private Shell parentShell;
    private TableViewer tableviewer;
    private Button btnSair;
    private Button btnSel;
    private Empresa.TIPO_EMPRESA tipo;

    public BuscaEmpressas(Shell parentShell, List<Empresa> empresas, Empresa.TIPO_EMPRESA tipo) {
        super(parentShell);
        this.empresas = empresas;
        this.parentShell = parentShell;
        this.tipo = tipo;
    }

    protected Point getInitialSize() {
        return new Point(600, 480);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "Fechar", false);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x20 | 0x40 | 0x400);
    }

    protected void configureShell(Shell newShell) {
        String title = this.tipo.toString();
        switch (this.tipo) {
            // Empty switch
        }
        newShell.setText("Busca de Empresa: " + title);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        Label lblNewLabel = new Label(parent, 0);
        lblNewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel.setText("CNPJ/CPF");
        this.textcnpj = new Text(parent, 2048);
        GridData gd_text = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_text.widthHint = 150;
        this.textcnpj.setLayoutData((Object)gd_text);
        this.textcnpj.setTextLimit(14);
        Label lblNewLabel_1 = new Label(parent, 0);
        lblNewLabel_1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel_1.setText("Raz\u00e3o Social");
        this.textrazao = new Text(parent, 2048);
        this.textrazao.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(parent, 0);
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(4, false));
        this.btnBuscar = new Button(this.composite, 0);
        this.btnBuscar.setText("Buscar");
        this.btnLimpar = new Button(this.composite, 0);
        this.btnLimpar.setText("Limpar");
        this.btnSair = new Button(this.composite, 0);
        this.btnSair.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuscaEmpressas.this.close();
            }
        });
        this.btnSair.setText("Sair");
        this.btnSel = new Button(this.composite, 0);
        this.btnSel.setText("Selecionar");
        this.btnSel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selected = BuscaEmpressas.this.tableviewer.getTable().getSelection();
                BuscaEmpressas.this.empresa = new Vector();
                TableItem[] tableItemArray = selected;
                int n = selected.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    Empresa empresa1 = (Empresa)item.getData();
                    BuscaEmpressas.this.empresa.add(empresa1);
                    ++n2;
                }
                if (BuscaEmpressas.this.empresa.isEmpty()) {
                    MessageDialog.openInformation((Shell)BuscaEmpressas.this.getParentShell(), (String)"Busca Empresa", (String)"Nenhuma empresa selecionada");
                } else {
                    BuscaEmpressas.this.close();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(parent, 0).setText("Resultados");
        this.tableviewer = new TableViewer(parent);
        this.tableviewer.setColumnProperties(new String[]{"Codigo", "Nome", "Outro"});
        Table table = this.tableviewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        EmpresaTableLabelProvider labelprovider = new EmpresaTableLabelProvider();
        this.tableviewer.setColumnProperties(labelprovider.initColumnProp(this.tableviewer.getTable()));
        this.tableviewer.setLabelProvider((IBaseLabelProvider)labelprovider);
        this.tableviewer.setContentProvider((IContentProvider)new EmpresaTableContentProvider(this.empresas));
        this.tableviewer.setInput((Object)this);
        this.tableviewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TableItem[] selected = BuscaEmpressas.this.tableviewer.getTable().getSelection();
                BuscaEmpressas.this.empresa = new Vector();
                TableItem[] tableItemArray = selected;
                int n = selected.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    Empresa empresa1 = (Empresa)item.getData();
                    BuscaEmpressas.this.empresa.add(empresa1);
                    ++n2;
                }
                if (BuscaEmpressas.this.empresa.isEmpty()) {
                    MessageDialog.openInformation((Shell)BuscaEmpressas.this.getParentShell(), (String)"Busca Empresa", (String)"Nenhuma empresa selecionada");
                } else {
                    BuscaEmpressas.this.close();
                }
            }
        });
        this.btnBuscar.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<Empresa> searchempresas = new ArrayList();
                String cnpj = BuscaEmpressas.this.textcnpj.getText();
                String razao = BuscaEmpressas.this.textrazao.getText();
                ManagerProxy manager = ClientSession.getInstance().getManagerproxy();
                Hashtable<String, Object> params = new Hashtable<String, Object>();
                params.put("type", BuscaEmpressas.this.tipo);
                try {
                    searchempresas = manager.findEmpresa(ClientSession.getInstance().getAmbiente(), cnpj, razao, params);
                }
                catch (RemoteException e1) {
                    e1.printStackTrace();
                }
                if (searchempresas == null || searchempresas.isEmpty()) {
                    MessageDialog.openInformation((Shell)BuscaEmpressas.this.getShell(), (String)"Busca Empresa", (String)"Nenhuma empresa encontrada");
                    searchempresas = new ArrayList();
                }
                EmpresaTableContentProvider content = (EmpresaTableContentProvider)BuscaEmpressas.this.tableviewer.getContentProvider();
                content.setElements(searchempresas);
                BuscaEmpressas.this.tableviewer.getTable().update();
                BuscaEmpressas.this.tableviewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnLimpar.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BuscaEmpressas.this.textcnpj.setText("");
                BuscaEmpressas.this.textrazao.setText("");
                EmpresaTableContentProvider content = (EmpresaTableContentProvider)BuscaEmpressas.this.tableviewer.getContentProvider();
                content.setElements(new ArrayList<Empresa>());
                BuscaEmpressas.this.tableviewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.textcnpj.setFocus();
        return parent;
    }

    public Vector<Empresa> getEmpresas() {
        return this.empresa;
    }
}

