/*
 * Decompiled with CFR 0.152.
 */
package br.com.tti.cockpitrap.events;

import br.com.taragona.nfe.persistence.GNRE;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.tti.cockpitrap.session.ClientSession;
import br.com.tti.cockpitrap.table.GNRETableContentProvider;
import br.com.tti.cockpitrap.views.ImpressaoDANFEGNREView;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.DateTime;

public class SearchGNREvent
implements SelectionListener {
    private ImpressaoDANFEGNREView view;

    public SearchGNREvent(ImpressaoDANFEGNREView view) {
        this.view = view;
    }

    public void widgetSelected(SelectionEvent e) {
        int pos = this.view.getCnpj().getSelectionIndex();
        String cnpj = this.view.getCnpj().getItem(pos).trim();
        String nInicial = this.view.getnInicial().getText().trim();
        String nFim = this.view.getnFinal().getText().trim();
        Date dInicio = this.convertData(this.view.getdInicio(), true);
        Date dFim = this.convertData(this.view.getdFim(), false);
        boolean hoje = this.view.getrHoje().getSelection();
        boolean periodo = this.view.getrPeriodo().getSelection();
        if (hoje) {
            dInicio = Calendar.getInstance().getTime();
            dFim = new Date(dInicio.getYear(), dInicio.getMonth(), dInicio.getDate() + 1);
        }
        int i = -1;
        if (!nInicial.isEmpty()) {
            try {
                i = Integer.parseInt(nInicial);
            }
            catch (Exception ex) {
                System.out.println("Parsing problem:" + nInicial);
            }
        }
        int f = -1;
        if (!nFim.isEmpty()) {
            try {
                f = Integer.parseInt(nFim);
            }
            catch (Exception ex) {
                System.out.println("Parsing problem:" + nFim);
            }
        }
        Vector<String> cnpjv = new Vector<String>();
        if (cnpj.equals("Todos")) {
            String[] cnpjs;
            String[] stringArray = cnpjs = ClientSession.getInstance().getUser().getPerfil().getCnpjs();
            int n = cnpjs.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                cnpjv.add(c);
                ++n2;
            }
        } else {
            String[] parts = cnpj.split(":");
            if (parts.length >= 2) {
                cnpj = parts[0];
                cnpjv.add(cnpj);
            }
        }
        TableViewer table = this.view.getTableviewer();
        Vector<GNRE.ESTADO_GNRE> estados = this.convertToString(this.view.getStatus());
        Vector<String> ufs = null;
        String ufselect = this.view.getListaufs().getItem(this.view.getListaufs().getSelectionIndex());
        if (!"Todos".equals(ufselect)) {
            ufs = new Vector<String>();
            ufs.add(ufselect);
        }
        GNRETableContentProvider provider = new GNRETableContentProvider();
        provider.fillData(cnpjv, this.view.getSerie().getText(), nInicial, nFim, dInicio, dFim, estados, ufs);
        table.setContentProvider((IContentProvider)provider);
        table.refresh();
    }

    private Date convertData(DateTime date, boolean floor) {
        Date d1 = null;
        if (floor) {
            d1 = new Date(date.getYear() - 1900, date.getMonth(), date.getDay());
            d1.setHours(0);
        } else {
            d1 = new Date(date.getYear() - 1900, date.getMonth(), date.getDay() + 1);
            d1.setHours(23);
        }
        return d1;
    }

    private Vector<GNRE.ESTADO_GNRE> convertToString(Combo statusc) {
        Vector<GNRE.ESTADO_GNRE> status = new Vector<GNRE.ESTADO_GNRE>();
        switch (statusc.getSelectionIndex()) {
            case 0: {
                status = null;
                break;
            }
            case 1: {
                status.add(GNRE.ESTADO_GNRE.SEM_PDF);
                break;
            }
            case 2: {
                status.add(GNRE.ESTADO_GNRE.COMPLETO);
                break;
            }
            case 3: {
                status.add(GNRE.ESTADO_GNRE.NAO_IMPRESSO);
                break;
            }
        }
        return status;
    }

    private Vector<PropriedadesSistema.MODO_OP> convertToStringModo(Combo modocomb) {
        Vector<PropriedadesSistema.MODO_OP> modos = new Vector<PropriedadesSistema.MODO_OP>();
        switch (modocomb.getSelectionIndex()) {
            case 0: {
                modos = null;
                break;
            }
            case 1: {
                modos.add(PropriedadesSistema.MODO_OP.NORMAL);
                break;
            }
            case 2: {
                modos.add(PropriedadesSistema.MODO_OP.CONTINGENCIA);
                break;
            }
            case 3: {
                modos.add(PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC);
                break;
            }
            case 4: {
                modos.add(PropriedadesSistema.MODO_OP.CONTINGENCIA_SCAN);
                break;
            }
        }
        return modos;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

