/*
 * Decompiled with CFR 0.152.
 */
package br.com.tti.cockpitrap.table;

import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.persistence.GNRE;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.tti.cockpitrap.table.NFeGNREpair;
import java.text.SimpleDateFormat;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class GNRETableLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final long serialVersionUID = 1L;
    private SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        Color color = null;
        if (element instanceof NFeGNREpair) {
            NFeGNREpair pair = (NFeGNREpair)element;
            if (GNRE.ESTADO_GNRE.COMPLETO.equals((Object)pair.getGnre().getEstado()) || GNRE.ESTADO_GNRE.SO_DANFE.equals((Object)pair.getGnre().getEstado())) {
                color = Display.getCurrent().getSystemColor(5);
            }
            if (GNRE.ESTADO_GNRE.NAO_IMPRESSO.equals((Object)pair.getGnre().getEstado())) {
                color = Display.getCurrent().getSystemColor(15);
            }
            if (GNRE.ESTADO_GNRE.SEM_PDF.equals((Object)pair.getGnre().getEstado())) {
                color = Display.getCurrent().getSystemColor(3);
            }
        }
        return color;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        NFeGNREpair pair = (NFeGNREpair)element;
        EstadoNFe estado = pair.getEstado();
        GNRE gnre = pair.getGnre();
        String result = null;
        if (columnIndex == 0) {
            try {
                GerenciadorChavesNota key = new GerenciadorChavesNota(estado.getId());
                result = String.valueOf(key.getSerie()) + " - " + key.getNumeroNota();
            }
            catch (Exception e) {
                result = estado.getId();
            }
        }
        if (columnIndex == 1) {
            result = estado.getCnpj();
        }
        if (columnIndex == 3) {
            result = gnre.getEstado() == null ? "" : gnre.getEstado().toString();
        }
        if (columnIndex == 4 && gnre.getDateimpressao() != null) {
            result = this.sdf.format(gnre.getDateimpressao());
        }
        if (columnIndex == 5) {
            result = estado.getId() == null ? "" : estado.getId();
        }
        return result;
    }
}

