/*
 * Decompiled with CFR 0.152.
 */
package br.com.tti.cockpitrap.table;

import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.tti.cockpitrap.session.ClientSession;
import br.com.tti.cockpitrap.util.LoadImages;
import br.com.tti.cockpitrap.util.XMLUtil;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class TableLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

    public Image getColumnImage(Object element, int columnIndex) {
        EstadoNFe estado = (EstadoNFe)element;
        if (columnIndex == 9 && estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.AUTORIZADA)) {
            try {
                Image image = null;
                if (estado.getOutros() != null && estado.getOutros().indexOf("MINIDANFE") > -1) {
                    image = LoadImages.loadImage("signed_yes.gif");
                }
                return image;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (columnIndex == 11 && estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.AUTORIZADA)) {
            Image image = null;
            if (estado.getEmailDest() != null) {
                if (estado.getEmailDest().equals("S")) {
                    image = LoadImages.loadImage("signed_yes.gif");
                } else if (estado.getEmailDest().equals("N")) {
                    image = LoadImages.loadImage("signed_no.gif");
                }
            }
            return image;
        }
        if (columnIndex == 12 && estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.AUTORIZADA)) {
            Image image = null;
            if (estado.getEmailTrans() != null) {
                if (estado.getEmailTrans().equals("S")) {
                    image = LoadImages.loadImage("signed_yes.gif");
                } else if (estado.getEmailTrans().equals("N")) {
                    image = LoadImages.loadImage("signed_no.gif");
                }
            }
            return image;
        }
        if (columnIndex == 13) {
            Image image = null;
            if (estado.getCartacorrecao() != null) {
                image = !estado.getCartacorrecao().equals((Object)EstadoNFe.ESTADO_NFE.AUTORIZADA) ? LoadImages.loadImage("signed_no.gif") : LoadImages.loadImage("signed_yes.gif");
            }
            return image;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String xml;
        EstadoNFe row = (EstadoNFe)element;
        String result = null;
        if (columnIndex == 0) {
            try {
                GerenciadorChavesNota key = new GerenciadorChavesNota(row.getId());
                result = String.valueOf(key.getSerie()) + " - " + key.getNumeroNota();
            }
            catch (Exception e) {
                result = row.getId();
            }
        }
        if (columnIndex == 1) {
            result = row.getCnpj();
        }
        if (columnIndex == 2) {
            result = row.getCnpjDestino() != null ? row.getCnpjDestino() : "";
        }
        if (columnIndex == 3) {
            result = row.getDataEnviada() == null ? "" : this.sdf.format(row.getDataEnviada());
        }
        if (columnIndex == 4) {
            result = row.getDataAutorizada() == null ? "" : this.sdf.format(row.getDataAutorizada());
        }
        if (columnIndex == 5) {
            result = row.getEstado() == null ? "" : row.getEstado().toString();
        }
        String motiv = row.getOutros();
        if (columnIndex == 6 && (result = XMLUtil.getValueByTag(xml = row.getXmlString(), "vNF")) == null) {
            result = "";
        }
        if (columnIndex == 7) {
            String[] split;
            result = motiv != null ? ((split = motiv.split("\\|")).length >= 3 ? split[2] : "") : "";
        }
        if (columnIndex == 8) {
            result = "";
            if (row.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.CANCELADA) || row.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.INUTILIZADA) || row.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.USO_DENEGADO)) {
                Hashtable<String, Object> params = new Hashtable<String, Object>();
                params.put("statuscancel", row.getId());
                try {
                    Hashtable<String, Object> result1 = ClientSession.getInstance().getManagerproxy().genericRemoteCall(params, ClientSession.getInstance().getAmbiente(), ClientSession.getInstance().getUser().getId());
                    if (result1 != null) {
                        result = String.valueOf(String.valueOf(result)) + " - " + result1.get("status");
                    }
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        }
        if (columnIndex == 9) {
            result = "";
        }
        if (columnIndex == 10) {
            String outros = row.getOutros();
            if (outros == null || outros.equals("")) {
                return "";
            }
            String[] v = row.getOutros().split("\\|", -1);
            if (v.length < 2) {
                return "";
            }
            String tipo = v[0];
            String serial = v[1];
            String valor = "";
            valor = tipo;
            if (serial != null && !serial.trim().isEmpty()) {
                if (tipo.toUpperCase().contains("ANYM") || tipo.toUpperCase().contains("OLIST") || tipo.toUpperCase().contains("SITE")) {
                    valor = String.valueOf(valor) + " - " + serial.trim();
                }
                if (tipo.toUpperCase().contains("UNILOG") && serial.toUpperCase().contains("UNILOG")) {
                    valor = String.valueOf(valor) + " - " + v[2].trim();
                } else if (tipo.toUpperCase().contains("UNILOG")) {
                    valor = String.valueOf(valor) + " - " + serial.trim();
                }
            }
            return valor;
        }
        if (columnIndex == 11) {
            result = "";
        }
        if (columnIndex == 12) {
            result = "";
        }
        if (columnIndex == 13) {
            result = "";
        }
        if (columnIndex == 14) {
            result = row == null || row.getModoOperacao() == null ? "" : (row.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC) ? "DPEC" : (row.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_SCAN) ? "SCAN" : row.getModoOperacao().toString()));
        }
        if (columnIndex == 15) {
            result = row.getId();
        }
        return result;
    }

    public Color getBackground(Object element) {
        EstadoNFe info = (EstadoNFe)element;
        Color color = Display.getCurrent().getSystemColor(1);
        if (info.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.ENVIADA)) {
            color = new Color((Device)Display.getCurrent(), 255, 255, 0);
        } else if (info.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.AUTORIZADA)) {
            if (info.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.NORMAL) || info.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA) || info.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.SVC_AN) || info.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.SVC_RS)) {
                color = Display.getCurrent().getSystemColor(5);
            }
            if (info.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_SCAN)) {
                color = new Color((Device)Display.getCurrent(), 24, 188, 73);
            }
            if (info.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_EPEC)) {
                color = new Color((Device)Display.getCurrent(), 24, 188, 73);
            }
            if (info.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC)) {
                color = new Color((Device)Display.getCurrent(), 0, 176, 80);
            }
        } else if (info.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.GERADA) || info.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.EPEC_AUTORIZADO)) {
            if (info.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.NORMAL) || info.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.SVC_AN) || info.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.SVC_RS)) {
                color = Display.getCurrent().getSystemColor(15);
            }
            if (info.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA)) {
                color = new Color((Device)Display.getCurrent(), 33, 109, 62);
            }
            if (info.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC)) {
                color = new Color((Device)Display.getCurrent(), 119, 81, 119);
            }
            if (info.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_EPEC)) {
                color = new Color((Device)Display.getCurrent(), 119, 81, 119);
            }
        } else {
            color = info.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.DPEC_ENVIADO) || info.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.PROBLEMAS_DPEC_ENVIADO) ? new Color((Device)Display.getCurrent(), 0, 255, 255) : (info.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.TENTANDO_ENVIO) ? new Color((Device)Display.getCurrent(), 0, 51, 204) : (info.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.INUTILIZADA) || info.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.ERRO_INUTILIZACAO) ? new Color((Device)Display.getCurrent(), 247, 151, 9) : (info.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.ERRO_ENVIO) ? new Color((Device)Display.getCurrent(), 51, 204, 255) : (info.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.ERRO_VALIDACAO) ? new Color((Device)Display.getCurrent(), 250, 98, 123) : (info.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.ERRO_ESQUEMA) || info.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.ERRO_ESQUEMA_LOTE) ? new Color((Device)Display.getCurrent(), 253, 181, 193) : (info.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.ERRO_CANCELAMENTO) || info.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.CANCELADA) ? new Color((Device)Display.getCurrent(), 255, 124, 128) : Display.getCurrent().getSystemColor(3)))))));
        }
        return color;
    }

    public Color getForeground(Object element) {
        EstadoNFe info = (EstadoNFe)element;
        Color color = Display.getCurrent().getSystemColor(2);
        if (info.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.TENTANDO_ENVIO)) {
            color = Display.getCurrent().getSystemColor(1);
        }
        return color;
    }
}

