/*
 * Decompiled with CFR 0.152.
 */
package br.com.tti.ttirec.datamodel.integrator;

import br.com.tti.nfev200.TLocal;
import br.com.tti.nfev200.TNFe;
import br.com.tti.ttirec.datamodel.integrator.TreeLeaf;
import br.com.tti.ttirec.datamodel.integrator.TreeNode;
import java.io.DataInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.List;

public class IntegratorStructureCreator {
    private Hashtable<String, String> tablemap = new Hashtable();

    public IntegratorStructureCreator() {
        this.loadResource();
        System.out.println(this.tablemap.toString());
    }

    private void loadResource() {
        try {
            InputStream f = IntegratorStructureCreator.class.getResourceAsStream("resources/map.txt");
            DataInputStream dis = new DataInputStream(f);
            String line = dis.readLine();
            while (line != null) {
                if (line.contains("=")) {
                    String[] parts = line.split("=");
                    this.tablemap.put(parts[0].trim().toLowerCase(), parts[1].trim());
                }
                line = dis.readLine();
            }
            dis.close();
            f.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TreeNode createRoot() {
        TreeNode root = new TreeNode("root", "root", "root");
        TreeNode t1 = new TreeNode("1", "TNFe", "TNFe");
        TreeLeaf l1 = new TreeLeaf("2", "InfNFe", "InfNFe");
        t1.addChild(l1);
        root.addChild(t1);
        return root;
    }

    public String createDescr(String descr) {
        String inf = "br.com.tti.versao200.TNFe.InfNFe.";
        String classname = descr.replace(inf, "").replace(".", "_").toLowerCase();
        String descr1 = null;
        descr1 = this.tablemap.containsKey(classname) ? this.tablemap.get(classname) : classname;
        return descr1;
    }

    public void visit(Class classs, TreeNode node) {
        Method[] methods;
        Method[] methodArray = methods = classs.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getParameterTypes().length == 0 && method.getName().startsWith("get") && !method.getReturnType().equals(TLocal.class) && !method.getReturnType().equals(TNFe.InfNFe.Cana.class) && !method.getReturnType().equals(TNFe.InfNFe.Avulsa.class)) {
                TreeNode child;
                String descr;
                if (!(method.getReturnType().equals(String.class) || method.getReturnType().equals(Integer.class) || method.getReturnType().equals(List.class))) {
                    descr = method.getReturnType().getCanonicalName();
                    descr = this.createDescr(descr);
                    child = new TreeNode(method.getReturnType().getName(), descr, method.getReturnType().getName());
                    node.addChild(child);
                    this.visit(method.getReturnType(), child);
                } else if (method.getReturnType().getCanonicalName().equals("java.util.List")) {
                    if (method.getName().equals("getDet")) {
                        descr = method.getReturnType().getCanonicalName();
                        descr = this.createDescr(descr);
                        child = new TreeNode(TNFe.InfNFe.Det.class.getName(), "Dados do Produto", TNFe.InfNFe.Det.class.getName());
                        node.addChild(child);
                        this.visit(TNFe.InfNFe.Det.class, child);
                    }
                } else {
                    descr = String.valueOf(classs.getCanonicalName()) + "." + method.getName().replace("get", "");
                    descr = this.createDescr(descr);
                    TreeLeaf leaf = new TreeLeaf(method.getName(), descr, method.getName());
                    node.addChild(leaf);
                }
            }
            ++n2;
        }
    }
}

