/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.application.ApplicationContextUtil;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.service.UISession;

public final class ServiceContext {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ServiceStore serviceStore;
    private boolean disposed;
    private UISession uiSession;
    private ApplicationContextImpl applicationContext;
    private ProtocolMessageWriter protocolWriter;

    public ServiceContext(HttpServletRequest request, HttpServletResponse response) {
        ParamCheck.notNull(request, "request");
        ParamCheck.notNull(response, "response");
        this.request = request;
        this.response = response;
    }

    public ServiceContext(HttpServletRequest request, HttpServletResponse response, UISession uiSession) {
        this(request, response);
        this.uiSession = uiSession;
    }

    public HttpServletRequest getRequest() {
        this.checkState();
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        this.checkState();
        return this.response;
    }

    public ServiceStore getServiceStore() {
        this.checkState();
        return this.serviceStore;
    }

    public ProtocolMessageWriter getProtocolWriter() {
        if (this.protocolWriter == null) {
            this.protocolWriter = new ProtocolMessageWriter();
        }
        return this.protocolWriter;
    }

    public void resetProtocolWriter() {
        this.protocolWriter = new ProtocolMessageWriter();
    }

    public void setServiceStore(ServiceStore serviceStore) {
        this.checkState();
        ParamCheck.notNull(serviceStore, "serviceStore");
        if (this.serviceStore != null) {
            String msg = "ServiceStore is already set and must not be replaced.";
            throw new IllegalStateException(msg);
        }
        this.serviceStore = serviceStore;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public UISession getUISession() {
        if (this.uiSession != null && !this.uiSession.isBound()) {
            this.uiSession = null;
        }
        return this.uiSession;
    }

    public void setUISession(UISession uiSession) {
        this.uiSession = uiSession;
    }

    public void dispose() {
        this.checkState();
        this.request = null;
        this.response = null;
        this.serviceStore = null;
        this.uiSession = null;
        this.applicationContext = null;
        this.disposed = true;
    }

    public ApplicationContextImpl getApplicationContext() {
        this.checkState();
        if (!this.isApplicationContextBuffered()) {
            this.getApplicationContextFromSession();
            if (!this.isApplicationContextBuffered()) {
                this.getApplicationContextFromServletContext();
                this.bufferApplicationContextInSession();
            }
        }
        return this.applicationContext;
    }

    private boolean isApplicationContextBuffered() {
        return this.applicationContext != null;
    }

    private void bufferApplicationContextInSession() {
        if (this.uiSession != null) {
            ApplicationContextUtil.set(this.uiSession, this.applicationContext);
        }
    }

    private void getApplicationContextFromServletContext() {
        ServletContext servletContext = this.request.getSession().getServletContext();
        this.applicationContext = ApplicationContextUtil.get(servletContext);
    }

    private void getApplicationContextFromSession() {
        ApplicationContextImpl fromSession;
        if (this.uiSession != null && (fromSession = ApplicationContextUtil.get(this.uiSession)) != null && fromSession.isActive()) {
            this.applicationContext = fromSession;
        }
    }

    private void checkState() {
        if (this.disposed) {
            throw new IllegalStateException("The context has been disposed.");
        }
    }
}

