/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.rap.rwt.internal.SingletonManager;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.application.ApplicationContextUtil;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointManager;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointRegistration;
import org.eclipse.rap.rwt.internal.service.UISessionImpl;
import org.eclipse.rap.rwt.internal.theme.ThemeUtil;
import org.eclipse.rap.rwt.service.UISession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UISessionBuilder {
    private final ApplicationContextImpl applicationContext;
    private final HttpServletRequest request;
    private final HttpSession httpSession;
    private final UISessionImpl uiSession;

    public UISessionBuilder(ApplicationContextImpl applicationContext, HttpServletRequest request) {
        this.applicationContext = applicationContext;
        this.request = request;
        this.httpSession = request.getSession(true);
        this.uiSession = new UISessionImpl(this.httpSession);
    }

    public UISession buildUISession() {
        UISessionImpl.attachInstanceToSession(this.httpSession, this.uiSession);
        ApplicationContextUtil.set(this.uiSession, this.applicationContext);
        SingletonManager.install(this.uiSession);
        this.setCurrentTheme();
        this.selectClient();
        return this.uiSession;
    }

    private void setCurrentTheme() {
        Map<String, String> properties = this.getEntryPointProperties();
        String themeId = properties.get("org.eclipse.rap.rwt.webclient.themeId");
        if (themeId != null && themeId.length() > 0) {
            this.verifyThemeId(themeId);
            ThemeUtil.setCurrentThemeId(this.uiSession, themeId);
        } else {
            ThemeUtil.setCurrentThemeId(this.uiSession, "org.eclipse.rap.rwt.theme.Default");
        }
    }

    private void selectClient() {
        this.applicationContext.getClientSelector().selectClient(this.request, this.uiSession);
    }

    private void verifyThemeId(String themeId) {
        if (!this.applicationContext.getThemeManager().hasTheme(themeId)) {
            throw new IllegalArgumentException("Illegal theme id: " + themeId);
        }
    }

    private Map<String, String> getEntryPointProperties() {
        String servletPath;
        Map<String, String> result = Collections.emptyMap();
        EntryPointManager entryPointManager = this.applicationContext.getEntryPointManager();
        EntryPointRegistration registration = entryPointManager.getRegistrationByPath(servletPath = this.request.getServletPath());
        if (registration != null) {
            result = registration.getProperties();
        }
        return result;
    }
}

