/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.textsize;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.rap.rwt.SingletonUtil;
import org.eclipse.rap.rwt.internal.protocol.ClientMessage;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.textsize.MeasurementItem;
import org.eclipse.rap.rwt.internal.textsize.MeasurementUtil;
import org.eclipse.rap.rwt.internal.textsize.Probe;
import org.eclipse.rap.rwt.internal.textsize.ProbeResultStore;
import org.eclipse.rap.rwt.internal.textsize.TextSizeStorageUtil;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.SerializableCompatibility;

class MeasurementOperator
implements SerializableCompatibility {
    static final String TYPE = "rwt.client.TextSizeMeasurement";
    static final String METHOD_MEASURE_ITEMS = "measureItems";
    static final String PROPERTY_ITEMS = "items";
    static final String METHOD_STORE_MEASUREMENTS = "storeMeasurements";
    static final String PROPERTY_RESULTS = "results";
    private final Set<Probe> probes = new HashSet<Probe>();
    private final Set<MeasurementItem> items = new HashSet<MeasurementItem>();
    private boolean isStartupProbeMeasurementPerformed;

    static MeasurementOperator getInstance() {
        return SingletonUtil.getSessionInstance(MeasurementOperator.class);
    }

    MeasurementOperator() {
        this.addStartupProbesToBuffer();
    }

    void appendStartupTextSizeProbe(ProtocolMessageWriter writer) {
        Object startupProbeObject = MeasurementOperator.getStartupProbeObject();
        if (startupProbeObject != null) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put(PROPERTY_ITEMS, startupProbeObject);
            writer.appendCall(TYPE, METHOD_MEASURE_ITEMS, properties);
        }
    }

    void handleMeasurementRequests() {
        this.renderMeasurements();
    }

    boolean handleMeasurementResults() {
        this.readMeasuredFontProbeSizes();
        return this.readMeasuredTextSizes();
    }

    void handleStartupProbeMeasurementResults() {
        if (!this.isStartupProbeMeasurementPerformed) {
            this.readMeasuredFontProbeSizes();
            this.isStartupProbeMeasurementPerformed = true;
        }
    }

    int getProbeCount() {
        return this.probes.size();
    }

    void addProbeToMeasure(FontData fontData) {
        Probe probe = ContextProvider.getApplicationContext().getProbeStore().getProbe(fontData);
        if (probe == null) {
            probe = ContextProvider.getApplicationContext().getProbeStore().createProbe(fontData);
        }
        this.probes.add(probe);
    }

    Probe[] getProbes() {
        return this.probes.toArray(new Probe[this.probes.size()]);
    }

    void addItemToMeasure(MeasurementItem newItem) {
        this.items.add(newItem);
    }

    int getItemCount() {
        return this.items.size();
    }

    MeasurementItem[] getItems() {
        return this.items.toArray(new MeasurementItem[this.items.size()]);
    }

    private static Object getStartupProbeObject() {
        Object[] result = null;
        Probe[] probeList = ContextProvider.getApplicationContext().getProbeStore().getProbes();
        if (probeList.length > 0) {
            result = new Object[probeList.length];
            int i = 0;
            while (i < probeList.length) {
                result[i] = MeasurementUtil.createProbeParamObject(probeList[i]);
                ++i;
            }
        }
        return result;
    }

    private void readMeasuredFontProbeSizes() {
        Iterator<Probe> probeList = this.probes.iterator();
        ClientMessage.CallOperation[] operations = MeasurementOperator.getCallOperationsFor(METHOD_STORE_MEASUREMENTS);
        while (probeList.hasNext()) {
            Probe probe = probeList.next();
            Point size = MeasurementOperator.readMeasuredSize(operations, MeasurementUtil.getId(probe));
            if (size == null) continue;
            this.createProbeResult(probe, size);
            probeList.remove();
        }
    }

    private void createProbeResult(Probe probe, Point size) {
        ProbeResultStore.getInstance().createProbeResult(probe, size);
    }

    private void addStartupProbesToBuffer() {
        Probe[] probeList = ContextProvider.getApplicationContext().getProbeStore().getProbes();
        this.probes.addAll(Arrays.asList(probeList));
    }

    private boolean readMeasuredTextSizes() {
        int originalItemsSize = this.items.size();
        Iterator<MeasurementItem> itemList = this.items.iterator();
        ClientMessage.CallOperation[] operations = MeasurementOperator.getCallOperationsFor(METHOD_STORE_MEASUREMENTS);
        while (itemList.hasNext()) {
            MeasurementItem item = itemList.next();
            Point size = MeasurementOperator.readMeasuredSize(operations, MeasurementUtil.getId(item));
            if (size == null) continue;
            MeasurementOperator.storeTextMeasurement(item, size);
            itemList.remove();
        }
        return this.itemsHasBeenMeasured(originalItemsSize);
    }

    private static ClientMessage.CallOperation[] getCallOperationsFor(String methodName) {
        return ProtocolUtil.getClientMessage().getAllCallOperationsFor(TYPE, methodName);
    }

    private static Point readMeasuredSize(ClientMessage.CallOperation[] operations, String id) {
        Point result = null;
        int i = 0;
        while (i < operations.length) {
            Object value;
            Map resultsMap = (Map)operations[i].getProperty(PROPERTY_RESULTS);
            if (resultsMap != null && (value = resultsMap.get(id)) != null) {
                result = ProtocolUtil.toPoint(value);
            }
            ++i;
        }
        return result;
    }

    private static void storeTextMeasurement(MeasurementItem item, Point size) {
        FontData fontData = item.getFontData();
        String textToMeasure = item.getTextToMeasure();
        int wrapWidth = item.getWrapWidth();
        int mode = item.getMode();
        TextSizeStorageUtil.store(fontData, textToMeasure, wrapWidth, mode, size);
    }

    private boolean itemsHasBeenMeasured(int originalItemsSize) {
        return originalItemsSize != this.items.size();
    }

    private void renderMeasurements() {
        Probe[] probes = this.getProbes();
        MeasurementItem[] items = this.getItems();
        if (probes.length > 0 || items.length > 0) {
            Object[] itemsObject = new Object[probes.length + items.length];
            int i = 0;
            while (i < probes.length) {
                itemsObject[i] = MeasurementUtil.createProbeParamObject(probes[i]);
                ++i;
            }
            i = 0;
            while (i < items.length) {
                itemsObject[probes.length + i] = MeasurementUtil.createItemParamObject(items[i]);
                ++i;
            }
            MeasurementOperator.callClientMethod(METHOD_MEASURE_ITEMS, PROPERTY_ITEMS, itemsObject);
        }
    }

    private static void callClientMethod(String method, String property, Object value) {
        ProtocolMessageWriter protocolWriter = ContextProvider.getProtocolWriter();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, value);
        protocolWriter.appendCall(TYPE, method, properties);
    }
}

