/*
 * Decompiled with CFR 0.152.
 */
package assinador;

import assinador.AssinadorInt;
import br.com.taragona.nfe.danfe.ImprimirDANFEImpl;
import br.com.taragona.nfe.util.xml.XMLFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Main
implements AssinadorInt {
    protected Certificate certificate = null;
    protected PrivateKey privateKey = null;
    String configIpLocal = "localhost";

    public Main() {
    }

    public Main(String certificado, String senha) {
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance("pkcs12");
        }
        catch (KeyStoreException ex) {
            System.out.println("Nao conseguiu criar keystore com pkcs12");
            System.exit(1);
        }
        try {
            new FileInputStream(certificado);
        }
        catch (FileNotFoundException e) {
            System.out.println("Arquivo nao encontrado: " + certificado);
            System.exit(222);
        }
        try {
            ks.load(new FileInputStream(certificado), senha.toCharArray());
        }
        catch (IOException ex) {
            System.out.println("Senha digitada invalida");
        }
        catch (NoSuchAlgorithmException ex) {
            System.out.println("Algoritmo do certificado invalido");
        }
        catch (CertificateException ex) {
            System.out.println("Certificado ou senha invalidos");
        }
        Enumeration<String> aliases = null;
        try {
            aliases = ks.aliases();
        }
        catch (KeyStoreException ex) {
            System.out.println("Nenhuma entrada no keystore");
            System.exit(5);
        }
        Object alias = null;
        KeyStore.PrivateKeyEntry entry = null;
        try {
            while (aliases.hasMoreElements()) {
                String alias1 = aliases.nextElement();
                if (!ks.isKeyEntry(alias1)) continue;
                entry = (KeyStore.PrivateKeyEntry)ks.getEntry(alias1, new KeyStore.PasswordProtection(senha.toCharArray()));
                this.privateKey = entry.getPrivateKey();
                this.certificate = entry.getCertificate();
                break;
            }
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnrecoverableEntryException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (KeyStoreException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String myAssinaCanc(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = factory.newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes()));
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        ArrayList<Transform> transformList = new ArrayList<Transform>();
        TransformParameterSpec tps = null;
        Transform envelopedTransform = fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", tps);
        Transform c14NTransform = fac.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", tps);
        transformList.add(envelopedTransform);
        transformList.add(c14NTransform);
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        ArrayList<Certificate> x509Content = new ArrayList<Certificate>();
        x509Content.add(this.certificate);
        X509Data xd = kif.newX509Data(x509Content);
        KeyInfo ki = kif.newKeyInfo(Collections.singletonList(xd));
        try {
            NodeList elements = doc.getElementsByTagName("infCanc");
            Element el = (Element)elements.item(0);
            String id = el.getAttribute("Id");
            el.setIdAttribute("Id", true);
            Reference ref = fac.newReference("#" + id, fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), transformList, null, null);
            SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(ref));
            XMLSignature signature = fac.newXMLSignature(si, ki);
            DOMSignContext dsc = new DOMSignContext(this.privateKey, (Node)doc.getDocumentElement());
            signature.sign(dsc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.transform(new DOMSource(doc), new StreamResult(os));
        return os.toString();
    }

    public String myAssinaDpec(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = factory.newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes()));
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        ArrayList<Transform> transformList = new ArrayList<Transform>();
        TransformParameterSpec tps = null;
        Transform envelopedTransform = fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", tps);
        Transform c14NTransform = fac.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", tps);
        transformList.add(envelopedTransform);
        transformList.add(c14NTransform);
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        ArrayList<Certificate> x509Content = new ArrayList<Certificate>();
        x509Content.add(this.certificate);
        X509Data xd = kif.newX509Data(x509Content);
        KeyInfo ki = kif.newKeyInfo(Collections.singletonList(xd));
        try {
            NodeList elements = doc.getElementsByTagName("infDPEC");
            Element el = (Element)elements.item(0);
            String id = el.getAttribute("Id");
            el.setIdAttribute("Id", true);
            Reference ref = fac.newReference("#" + id, fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), transformList, null, null);
            SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(ref));
            XMLSignature signature = fac.newXMLSignature(si, ki);
            DOMSignContext dsc = new DOMSignContext(this.privateKey, (Node)doc.getDocumentElement());
            signature.sign(dsc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.transform(new DOMSource(doc), new StreamResult(os));
        return os.toString();
    }

    public String myAssinaInut(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = factory.newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes()));
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        ArrayList<Transform> transformList = new ArrayList<Transform>();
        TransformParameterSpec tps = null;
        Transform envelopedTransform = fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", tps);
        Transform c14NTransform = fac.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", tps);
        transformList.add(envelopedTransform);
        transformList.add(c14NTransform);
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        ArrayList<Certificate> x509Content = new ArrayList<Certificate>();
        x509Content.add(this.certificate);
        X509Data xd = kif.newX509Data(x509Content);
        KeyInfo ki = kif.newKeyInfo(Collections.singletonList(xd));
        try {
            NodeList elements = doc.getElementsByTagName("infInut");
            Element el = (Element)elements.item(0);
            String id = el.getAttribute("Id");
            el.setIdAttribute("Id", true);
            Reference ref = fac.newReference("#" + id, fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), transformList, null, null);
            SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(ref));
            XMLSignature signature = fac.newXMLSignature(si, ki);
            DOMSignContext dsc = new DOMSignContext(this.privateKey, (Node)doc.getDocumentElement());
            signature.sign(dsc);
        }
        catch (Exception e) {
            System.out.println("Problemas no processo de assinatura");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.transform(new DOMSource(doc), new StreamResult(os));
        return os.toString();
    }

    public String myAssinaCCe(String xml) throws Exception {
        Vector<String> notas = new Vector<String>();
        notas.add(xml);
        String lote = XMLFactory.montarLoteTempo("12345", notas);
        lote = this.myAssina(lote, "infEvento", "evento");
        return lote.substring(lote.indexOf("<envEvento"), lote.indexOf("</enviNFe>"));
    }

    public String myAssinaNota(String xml) throws Exception {
        Vector<String> notas = new Vector<String>();
        notas.add(xml);
        String lote = XMLFactory.montarLoteTempo("12345", notas);
        lote = this.myAssina(lote, "infNFe", "NFe");
        return lote.substring(lote.indexOf("<NFe"), lote.indexOf("</enviNFe>"));
    }

    public String myAssina(String xml, String tag, String root) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = factory.newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes()));
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        ArrayList<Transform> transformList = new ArrayList<Transform>();
        TransformParameterSpec tps = null;
        Transform envelopedTransform = fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", tps);
        Transform c14NTransform = fac.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", tps);
        transformList.add(envelopedTransform);
        transformList.add(c14NTransform);
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        ArrayList<Certificate> x509Content = new ArrayList<Certificate>();
        x509Content.add(this.certificate);
        X509Data xd = kif.newX509Data(x509Content);
        KeyInfo ki = kif.newKeyInfo(Collections.singletonList(xd));
        try {
            int i = 0;
            while (i < doc.getDocumentElement().getElementsByTagName(root).getLength()) {
                NodeList elements = doc.getElementsByTagName(tag);
                Element el = (Element)elements.item(i);
                String id = el.getAttribute("Id");
                el.setIdAttribute("Id", true);
                Reference ref = fac.newReference("#" + id, fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), transformList, null, null);
                SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(ref));
                XMLSignature signature = fac.newXMLSignature(si, ki);
                DOMSignContext dsc = new DOMSignContext(this.privateKey, doc.getDocumentElement().getElementsByTagName(root).item(i));
                signature.sign(dsc);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.transform(new DOMSource(doc), new StreamResult(os));
        return os.toString();
    }

    private void assinarNFE(XMLSignatureFactory fac, ArrayList transformList, PrivateKey privateKey, KeyInfo ki, Document doc, int i) throws Exception {
        NodeList elements = doc.getElementsByTagName("infNFe");
        Element el = (Element)elements.item(i);
        String id = el.getAttribute("Id");
        Reference ref = fac.newReference("#" + id, fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), transformList, null, null);
        SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(ref));
        XMLSignature signature = fac.newXMLSignature(si, ki);
        DOMSignContext dsc = new DOMSignContext(privateKey, doc.getDocumentElement().getElementsByTagName("NFe").item(i));
        signature.sign(dsc);
    }

    public String assinaCancelamento(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = factory.newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes()));
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        ArrayList<Transform> transformList = new ArrayList<Transform>();
        TransformParameterSpec tps = null;
        Transform envelopedTransform = fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", tps);
        Transform c14NTransform = fac.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", tps);
        transformList.add(envelopedTransform);
        transformList.add(c14NTransform);
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        ArrayList<Certificate> x509Content = new ArrayList<Certificate>();
        x509Content.add(this.certificate);
        X509Data xd = kif.newX509Data(x509Content);
        KeyInfo ki = kif.newKeyInfo(Collections.singletonList(xd));
        NodeList elements = doc.getElementsByTagName("cancNFe");
        Element el = (Element)elements.item(0);
        String id = el.getAttribute("Id");
        Reference ref = fac.newReference("#" + id, fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), transformList, null, null);
        SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(ref));
        XMLSignature signature = fac.newXMLSignature(si, ki);
        DOMSignContext dsc = new DOMSignContext(this.privateKey, (Node)doc.getDocumentElement());
        signature.sign(dsc);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.transform(new DOMSource(doc), new StreamResult(os));
        return os.toString();
    }

    @Override
    public String assina(String xml, String tag) throws RemoteException {
        try {
            if (tag.equals("infNFe")) {
                return this.myAssinaNota(xml);
            }
            if (tag.equals("infEvento")) {
                return this.myAssinaCCe(xml);
            }
            if (tag.equals("infCanc")) {
                return this.myAssinaCanc(xml);
            }
            if (tag.equals("infInut")) {
                return this.myAssinaInut(xml);
            }
            if (tag.equals("infDPEC")) {
                return this.myAssinaDpec(xml);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getConfigIpLocal() {
        return this.configIpLocal;
    }

    private static String repareXML(String xml) {
        xml = xml.replace("ns2:", "");
        xml = xml.replace("xmlns:ns2=\"http://www.portalfiscal.inf.br/nfe\" xmlns=\"http://www.w3.org/2000/09/xmldsig#\"", "xmlns=\"http://www.portalfiscal.inf.br/nfe\"");
        xml = xml.replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>", "");
        xml = xml.replace("<evento versao=\"1.00\">", "<evento versao=\"1.00\" xmlns=\"http://www.portalfiscal.inf.br/nfe\">");
        return xml;
    }

    public static void main(String[] args) {
        String xml = ImprimirDANFEImpl.lerArquivo("C:/TTINFe/bin/evento.xml");
        Main assinador = new Main("C:\\comm.pfx", "itambe");
        try {
            System.out.println(xml);
            String xmlass = assinador.myAssina(xml, "infEvento", "evento");
            System.out.println(xmlass);
            FileWriter fw = new FileWriter("C:\\rps_assinado.xml");
            fw.write(xmlass);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

