/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.cancinut;

import br.com.taragona.nfe.cancinut.SenderCancel;
import br.com.taragona.nfe.danfe.ImprimirDANFEImpl;
import br.com.taragona.nfe.event.EventXMLCreator;
import br.com.taragona.nfe.event.xml.classes.TEnvEvento;
import br.com.taragona.nfe.event.xml.classes.TEvento;
import br.com.taragona.nfe.event.xml.classes.ret.TRetEnvEvento;
import br.com.taragona.nfe.event.xml.classes.ret.TretEvento;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.EntidadeId;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.persistence.EventoInfo;
import br.com.taragona.nfe.tools.PathFileFinder;
import br.com.taragona.nfe.util.CodigoNFeManager;
import br.com.taragona.nfe.util.DelayTable;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.IDSetManager;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.UFTable;
import br.com.taragona.nfe.util.logger.NFeLogger;
import br.com.taragona.nfe.xmlgenerator.XMLGenerator;
import java.io.File;
import java.io.FileWriter;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBElement;

public class CancelEventManager {
    private DAOGenerico<EventoInfo> daoEvent = new DAOGenerico(EventoInfo.class);
    private DAOGenerico<EstadoNFe> daoxml = new DAOGenerico(EstadoNFe.class);
    private XMLGenerator gen = new XMLGenerator("br.com.taragona.nfe.event.xml.classes");
    private XMLGenerator genret = new XMLGenerator("br.com.taragona.nfe.event.xml.classes.ret");
    private SimpleDateFormat sdfnordeste = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:00'-04:00'");
    private SimpleDateFormat sdfcentral = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:00'-03:00'");
    private SimpleDateFormat sdfsemfuso = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:00");
    private ImprimirDANFEImpl print = new ImprimirDANFEImpl();

    public void cancelNFe(String keyxml, String tpAmb, String nprot, String justificativa, String idUsuario) throws Exception {
        TEvento event = new TEvento();
        TEvento.InfEvento infevent = new TEvento.InfEvento();
        TEvento.InfEvento.DetEvento detevent = new TEvento.InfEvento.DetEvento();
        GerenciadorChavesNota km = new GerenciadorChavesNota(keyxml);
        infevent.setDetEvento(detevent);
        infevent.setChNFe(keyxml.replace("NFe", ""));
        infevent.setCNPJ(km.getCnpj());
        infevent.setCOrgao(km.getUF());
        infevent.setTpEvento("110111");
        infevent.setVerEvento("1.00");
        infevent.setTpAmb(tpAmb);
        detevent.setVersao("1.00");
        detevent.setDescEvento("Cancelamento");
        detevent.setnProt(nprot);
        detevent.setxJust("Motivo do cancelamento da NF-e:" + justificativa);
        event.setInfEvento(infevent);
        EventoInfo info = new EventoInfo();
        info.setEvent(event);
        this.adicionarEvento(keyxml, tpAmb, info, null, idUsuario);
    }

    public String adicionarEvento(String keyxml, String tpAmb, EventoInfo info, Hashtable<String, String> props, String idUsuario) throws RemoteException {
        int nseqn = 1;
        info.setEstado(EstadoNFe.ESTADO_NFE.GERADA);
        info.setDataGerada(Calendar.getInstance().getTime());
        info.getEvent().getInfEvento().setNSeqEvento(String.valueOf(nseqn));
        info.getEvent().setVersao("1.00");
        long currentlonf = Calendar.getInstance().getTimeInMillis();
        Date currentdata = new Date(currentlonf);
        try {
            String delay = DelayTable.delay.getString(info.getEvent().getInfEvento().getCOrgao());
            if (delay.contains("+")) {
                delay = delay.replace("+", "");
                currentdata = new Date(currentlonf + (long)(Integer.parseInt(delay) * 60) * 1000L);
            } else {
                delay = delay.replace("-", "");
                currentdata = new Date(currentlonf - (long)(Integer.parseInt(delay) * 60) * 1000L);
            }
        }
        catch (Exception delay) {
            // empty catch block
        }
        String fusohorario = "-03:00";
        String dhevento = "";
        try {
            fusohorario = UFTable.fuso.getString(info.getEvent().getInfEvento().getCOrgao());
            dhevento = String.valueOf(this.sdfsemfuso.format(currentdata)) + fusohorario;
        }
        catch (Exception e) {
            System.out.println("nao foi possivel usar o arquivo fusohorario.properties");
            dhevento = info.getEvent().getInfEvento().getCOrgao().equals("42") || info.getEvent().getInfEvento().getCOrgao().equals("35") || info.getEvent().getInfEvento().getCOrgao().equals("33") || info.getEvent().getInfEvento().getCOrgao().equals("31") || info.getEvent().getInfEvento().getCOrgao().equals("32") || info.getEvent().getInfEvento().getCOrgao().equals("43") || info.getEvent().getInfEvento().getCOrgao().equals("53") || info.getEvent().getInfEvento().getCOrgao().equals("52") || info.getEvent().getInfEvento().getCOrgao().equals("41") || info.getEvent().getInfEvento().getCOrgao().equals("51") || info.getEvent().getInfEvento().getCOrgao().equals("50") ? this.sdfcentral.format(currentdata) : this.sdfnordeste.format(currentdata);
        }
        info.getEvent().getInfEvento().setDhEvento(dhevento);
        info.getEvent().getInfEvento().setTpAmb(tpAmb);
        String id = String.valueOf(info.getEvent().getInfEvento().getTpEvento()) + info.getEvent().getInfEvento().getChNFe() + "0" + info.getEvent().getInfEvento().getNSeqEvento();
        info.getEvent().setVersao("1.00");
        info.getEvent().getInfEvento().setId("ID" + id);
        String xmlCancelEvent = null;
        try {
            this.daoEvent.salvar(info);
            xmlCancelEvent = this.toXMLString(info);
            xmlCancelEvent = this.repareXML(info.getEvent().getInfEvento().getCNPJ(), xmlCancelEvent);
            FileWriter fw = new FileWriter("cancelamento_evento.xml");
            fw.write(xmlCancelEvent);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String resultxml = null;
        try {
            resultxml = GerenciadorProxy.enviarMensagemXML(PropriedadesSistema.ID_SERVICO_RECEPCAO_EVENTO, info.getEvent().getInfEvento().getCNPJ(), "", xmlCancelEvent, info.getEvent().getInfEvento().getCOrgao(), idUsuario);
        }
        catch (Exception e) {
            throw new RemoteException(e.getLocalizedMessage(), e.fillInStackTrace());
        }
        if (resultxml != null) {
            info.setEstado(EstadoNFe.ESTADO_NFE.ENVIADA);
            info.setDataEnviada(Calendar.getInstance().getTime());
            info.setDataAtualizada(Calendar.getInstance().getTime());
            String rets = this.processResult(info, resultxml);
            String endtag = "</retEnvEvento>";
            int pos1 = resultxml.indexOf("<retEnvEvento");
            int pos2 = resultxml.indexOf(endtag);
            if (pos1 != -1 && pos2 != -1) {
                resultxml = resultxml.substring(pos1, pos2 + endtag.length());
            }
            info.setXmlString(xmlCancelEvent);
            info.setProtocoloXML(resultxml);
            this.daoEvent.unir(info);
            this.daoEvent.flush();
            if (info.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.AUTORIZADA)) {
                if (!keyxml.startsWith("NFe")) {
                    keyxml = "NFe" + keyxml;
                }
                EntidadeId eid = new EntidadeId(keyxml, tpAmb);
                EstadoNFe xmlinfo = this.daoxml.buscarPorIdObject(eid);
                xmlinfo.setEstado(EstadoNFe.ESTADO_NFE.CANCELADA);
                xmlinfo.setProtocoloCancelamentoXML(resultxml);
                xmlinfo.setDataActualizada(Calendar.getInstance().getTime());
                xmlinfo.setEstadoNFe(101L);
                xmlinfo.setMotivoErro(info.getEvent().getInfEvento().getDhEvento());
                this.daoxml.unir(xmlinfo);
                this.daoxml.flush();
                NFeLogger.log(xmlinfo.getId(), xmlinfo.getAmbiente(), xmlinfo.getModoOperacao(), EstadoNFe.ESTADO_NFE.CANCELADA, null, idUsuario);
                try {
                    GerenciadorProxy.gerenciador.atualizarNota(xmlinfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    GerenciadorProxy.gerenciador.notificarNotaConector(xmlinfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String pathcancel = PathFileFinder.getINSTANCE().findXMLCancelPath(keyxml, tpAmb, Calendar.getInstance().getTime());
                String cancelfile = String.valueOf(pathcancel) + "/" + keyxml + "_canc_prot.xml";
                EventXMLCreator xmlc = new EventXMLCreator(info);
                String protcancel = xmlc.extractXML();
                try {
                    FileWriter fw = new FileWriter(cancelfile);
                    fw.write(protcancel);
                    fw.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String pdfpath = PathFileFinder.getINSTANCE().findPDFPath(keyxml, tpAmb, xmlinfo.getDataGerada());
                String pdffile = String.valueOf(pdfpath) + "/" + keyxml + ".pdf";
                File file = new File(pdffile);
                long lasmodified = file.lastModified();
                this.print.imprimirNota(keyxml, tpAmb, "PDF", false, null, idUsuario);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    SenderCancel.getInstace().sendCancel(xmlinfo.getId(), tpAmb, xmlinfo.getCnpjDestino().trim(), protcancel);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                if (!keyxml.startsWith("NFe")) {
                    keyxml = "NFe" + keyxml;
                }
                EntidadeId eid = new EntidadeId(keyxml, tpAmb);
                EstadoNFe xmlinfo = this.daoxml.buscarPorIdObject(eid);
                xmlinfo.setEstado(EstadoNFe.ESTADO_NFE.ERRO_CANCELAMENTO);
                xmlinfo.setMotivoErro(info.getMensagem());
                try {
                    xmlinfo.setEstadoNFe(Long.parseLong(info.getCstat()));
                }
                catch (Exception pathcancel) {
                    // empty catch block
                }
                try {
                    GerenciadorProxy.gerenciador.notificarNotaConector(xmlinfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    GerenciadorProxy.gerenciador.atualizarNota(xmlinfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return rets;
        }
        throw new RemoteException("Evento sem retorno da sefaz");
    }

    private String toXMLString(EventoInfo info) {
        TEnvEvento envevento = new TEnvEvento();
        envevento.setIdLote(IDSetManager.getNexIdSet().toString());
        envevento.getEvento().add(info.getEvent());
        envevento.setVersao("1.00");
        try {
            String xml = this.gen.toXMLString(envevento);
            return xml;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String processResult(EventoInfo event, String xml) {
        String endtag = "</retEnvEvento>";
        int pos1 = xml.indexOf("<retEnvEvento");
        int pos2 = xml.indexOf(endtag);
        if (pos1 != -1 && pos2 != -1) {
            xml = xml.substring(pos1, pos2 + endtag.length());
        }
        try {
            JAXBElement ret = (JAXBElement)this.genret.toObject(xml);
            String cstat = ((TRetEnvEvento)ret.getValue()).getCStat();
            System.out.println(cstat);
            CodigoNFeManager.insereCodigo(Integer.valueOf(cstat), ((TRetEnvEvento)ret.getValue()).getXMotivo());
            if (cstat.equals("128")) {
                List<TretEvento> results = ((TRetEnvEvento)ret.getValue()).getRetEvento();
                Iterator<TretEvento> iterator = results.iterator();
                if (iterator.hasNext()) {
                    TretEvento rett = iterator.next();
                    if (rett.getInfEvento().getCStat().equals("135") || rett.getInfEvento().getCStat().equals("136") || rett.getInfEvento().getCStat().equals("155")) {
                        event.setEstado(EstadoNFe.ESTADO_NFE.AUTORIZADA);
                        event.setDataAutorizada(Calendar.getInstance().getTime());
                        event.setDataAtualizada(Calendar.getInstance().getTime());
                        event.setCstat(rett.getInfEvento().getCStat());
                        event.setMensagem(rett.getInfEvento().getXMotivo());
                        event.getEvent().getInfEvento().setDhEvento(String.valueOf(rett.getInfEvento().getNProt()) + "|" + rett.getInfEvento().getDhRegEvento());
                    } else {
                        event.setEstado(EstadoNFe.ESTADO_NFE.REJEITADA);
                        event.setMensagem(rett.getInfEvento().getXMotivo());
                        event.setDataAtualizada(Calendar.getInstance().getTime());
                        event.setCstat(rett.getInfEvento().getCStat());
                    }
                    System.out.println(event.getEstado().toString());
                    return String.valueOf(rett.getInfEvento().getCStat()) + ":" + rett.getInfEvento().getXMotivo();
                }
            } else {
                event.setEstado(EstadoNFe.ESTADO_NFE.ERRO);
                event.setMensagem(((TRetEnvEvento)ret.getValue()).getXMotivo());
                event.setDataAtualizada(Calendar.getInstance().getTime());
            }
            return String.valueOf(((TRetEnvEvento)ret.getValue()).getCStat()) + ":" + ((TRetEnvEvento)ret.getValue()).getXMotivo();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String repareXML(String cnpj, String xml) {
        FileWriter fw;
        try {
            fw = new FileWriter("C:\\preassinado.xml");
            fw.write(xml);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        xml = xml.replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>", "");
        xml = xml.replace("<envEvento versao=\"1.00\" xmlns=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:ns2=\"http://www.portalfiscal.inf.br/nfe\">", "<envEvento versao=\"1.00\" xmlns=\"http://www.portalfiscal.inf.br/nfe\">");
        xml = xml.replace("ns2:", "");
        try {
            xml = GerenciadorProxy.gerenciador.assinar(cnpj, xml, "infEvento");
            xml = xml.replace("<envEvento versao=\"1.00\">", "<envEvento versao=\"1.00\" xmlns=\"http://www.portalfiscal.inf.br/nfe\">");
            fw = new FileWriter("C:\\postpreassinado.xml");
            fw.write(xml);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xml;
    }
}

