/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.cancinut;

import br.com.taragona.nfe.cancinut.CancelEventManager;
import br.com.taragona.nfe.cancinut.InutilizacaoThread;
import br.com.taragona.nfe.cancinut.SenderCancel;
import br.com.taragona.nfe.controle.ControleLotesAsStringInstance;
import br.com.taragona.nfe.mensageiro.caches.CacheNotas;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Hashtable;

public class CanceladorInutilizador {
    private Hashtable<String, Thread> cancelamentos;
    private Hashtable<String, Thread> inutilizadores;
    private CacheNotas cache = CacheNotas.obterInstancia();
    private CancelEventManager cancevent;

    public CanceladorInutilizador() {
        this.cancelamentos = new Hashtable();
        this.inutilizadores = new Hashtable();
        this.cancevent = new CancelEventManager();
    }

    public void consultarNota(String idNota, String tpAmb, boolean notify, String idUsuario) {
        GerenciadorChavesNota chave = new GerenciadorChavesNota(idNota);
        ControleLotesAsStringInstance controle = new ControleLotesAsStringInstance(tpAmb, chave.getCnpj(), chave.getUF());
        controle.consularNota(idNota, tpAmb, notify, idUsuario);
    }

    public void cancelarNota(String idNota, String tpAmb, String just, boolean contingencia, String idUsuario) throws Exception {
        GerenciadorChavesNota chave = new GerenciadorChavesNota(idNota);
        String cnpj = chave.getCnpj();
        int estado = GerenciadorProxy.getGerenciador().estadoOperacao(cnpj);
        EstadoNFe nota = this.cache.obterEstadoNota(idNota, tpAmb);
        System.out.println("Cancelando para CNPJ: " + cnpj);
        System.out.println("Estado: " + estado);
        System.out.println("NF-e: " + idNota);
        boolean fez_alguma_coisa = false;
        if (estado == 0) {
            String chave1;
            if (nota != null && nota.getEstado() == EstadoNFe.ESTADO_NFE.GERADA && nota.getModoOperacao() == PropriedadesSistema.MODO_OP.CONTINGENCIA) {
                this.cache.ajustarEstado(idNota, tpAmb, EstadoNFe.ESTADO_NFE.CANCELADA_CONTINGENCIA, true, idUsuario);
                chave1 = idNota.replace("NFe", "");
                GerenciadorProxy.getGerenciador().notificarProtocoloCancelamentoNormal(chave1, tpAmb, null);
                fez_alguma_coisa = true;
            }
            if (nota != null && nota.getEstado() == EstadoNFe.ESTADO_NFE.AUTORIZADA) {
                this.cache.ajustarEstado(idNota, tpAmb, EstadoNFe.ESTADO_NFE.CANCELAR_SAIDA_CONTINGENCIA, true, idUsuario);
                this.cache.ajustarXMotivo(idNota, tpAmb, just);
                chave1 = idNota.replace("NFe", "");
                GerenciadorProxy.getGerenciador().notificarProtocoloCancelamentoNormal(chave1, tpAmb, null);
                fez_alguma_coisa = true;
            }
        } else {
            if (nota == null) {
                this.salvarNota(idNota, tpAmb);
            }
            this.consultarNota(idNota, tpAmb, false, idUsuario);
            nota = this.cache.obterEstadoNota(idNota, tpAmb);
            String protocolo = "sem protocolo";
            if (nota.getProtocolo() != null) {
                String[] prots = nota.getProtocolo().split("\\|");
                protocolo = prots.length >= 1 ? prots[0] : nota.getProtocolo();
            }
            if (nota.getEstado() == EstadoNFe.ESTADO_NFE.AUTORIZADA) {
                idNota = idNota.replace("NFe", "");
                this.cancevent.cancelNFe(idNota, tpAmb, protocolo, just, idUsuario);
                fez_alguma_coisa = true;
            } else if (nota.getEstado() != EstadoNFe.ESTADO_NFE.CANCELADA) {
                this.inutulizarNota(idNota, tpAmb, just, false, idUsuario);
                fez_alguma_coisa = true;
            } else if (nota.getEstado() == EstadoNFe.ESTADO_NFE.CANCELADA) {
                System.out.println("NF-e ja cancelada na SEFAZ");
                String protxmlcancel = "<procEventoNFe xmlns=\"http://www.portalfiscal.inf.br/nfe\" versao=\"1.00\">" + nota.getProtocoloCancelamentoXML() + "</procEventoNFe>";
                SenderCancel.getInstace().sendCancel(nota.getId(), tpAmb, nota.getCnpjDestino().trim(), protxmlcancel);
                fez_alguma_coisa = true;
            }
        }
    }

    public String inutilizarNota(String UF, String ano, String cnpj, String mod, String serie, String ini, String fim, String just, boolean contingencia, String tpAmb, String idUsuario) throws Exception {
        InutilizacaoThread i = new InutilizacaoThread(UF, ano, cnpj, mod, serie, ini, fim, just, contingencia, tpAmb, idUsuario);
        i.run();
        return i.getCodigoResult();
    }

    public void inutulizarNota(String idNota, String tpAmb, String just, boolean contingencia, String idUsuario) throws Exception {
        InutilizacaoThread i = new InutilizacaoThread(idNota, tpAmb, String.valueOf(just) + idNota, contingencia, idUsuario);
        Thread t = new Thread(i);
        t.start();
    }

    private void salvarNota(String idNota, String tpAmb) {
        GerenciadorChavesNota chave = new GerenciadorChavesNota(idNota);
        EstadoNFe nota = new EstadoNFe();
        nota.setId(idNota);
        nota.setAmbiente(tpAmb);
        nota.setDataGerada(new Date());
        nota.setCnpj(chave.getCnpj());
        nota.setEstado(EstadoNFe.ESTADO_NFE.PEDIDO_CANCELAMENTO);
        nota.setModoOperacao(PropriedadesSistema.MODO_OP.NORMAL);
        nota.setServerName(PropriedadesMain.getServerName());
        this.cache.salvarNota(nota);
        try {
            GerenciadorProxy.getGerenciador().atualizarNota(nota);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }
}

