/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.cancinut;

import br.com.taragona.nfe.cancinut.SenderCancel;
import br.com.taragona.nfe.classes.cancelamento.TCancNFe;
import br.com.taragona.nfe.classes.retcancelamento.TRetCancNFe;
import br.com.taragona.nfe.mensageiro.caches.CacheNotas;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.tools.PathFileFinder;
import br.com.taragona.nfe.util.CodigoNFeManager;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.xml.XMLFactory;
import br.com.taragona.nfe.xmlgenerator.XMLGenerator;
import java.io.File;
import java.io.FileWriter;
import java.util.Calendar;
import javax.xml.bind.JAXBElement;

public class CancelamentoInutThread
implements Runnable {
    private String idNota;
    private String tpAmb;
    private String CNPJ;
    private XMLGenerator xmlsRet = XMLFactory.getXmlsRetCanc();
    private CacheNotas cacheNotas = CacheNotas.obterInstancia();
    private Exception e;
    private String just;
    private boolean contingencia;
    private GerenciadorChavesNota chave;
    private String protocolo;
    private String idUsuario;

    public CancelamentoInutThread(String idNota, String tpAmb, String protocolo, String just, boolean contingencia, String idUsuario) throws Exception {
        this.idNota = idNota;
        this.tpAmb = tpAmb;
        this.chave = new GerenciadorChavesNota(this.idNota);
        this.CNPJ = this.chave.getCnpj();
        this.just = just;
        this.contingencia = contingencia;
        this.protocolo = protocolo;
        this.idUsuario = idUsuario;
    }

    public boolean cancelarNota() throws Exception {
        return this.cancelarNota(this.idNota, this.tpAmb, this.protocolo);
    }

    public boolean cancelarNota(String idNota, String tpAmb, String protocolo) throws Exception {
        String cabecalho = XMLFactory.montarCabecalho(TCancNFe.class, this.CNPJ);
        String cancString = XMLFactory.montarCancelamento(idNota, tpAmb, protocolo, this.CNPJ, this.just);
        String resultado = null;
        try {
            System.out.println("XML Cancelamento:" + cancString);
            cancString = GerenciadorProxy.getGerenciador().assinar(this.CNPJ, cancString, "infCanc");
            resultado = GerenciadorProxy.enviarMensagemXML(PropriedadesSistema.ID_SERVICO_CANCELAMENTO, this.CNPJ, cabecalho, cancString, this.chave.getUF(), this.idUsuario);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (resultado != null) {
            return this.processarRespostaCanc(idNota, resultado);
        }
        return false;
    }

    private boolean processarRespostaCanc(String idNota, String resultado) {
        int codigo;
        JAXBElement canc;
        block17: {
            String idNotaNFe;
            block16: {
                try {
                    String chaveNota = idNota.replace("NFe", "");
                    if (this.contingencia) {
                        GerenciadorProxy.getGerenciador().notificarProtocoloCancelamentoContingecia(chaveNota, this.tpAmb, resultado);
                    } else {
                        GerenciadorProxy.getGerenciador().notificarProtocoloCancelamentoNormal(chaveNota, this.tpAmb, resultado);
                    }
                }
                catch (Exception e) {
                    System.out.println("Nao foi possivel notificar ao ERP");
                }
                canc = (JAXBElement)this.xmlsRet.toObject(resultado);
                idNotaNFe = "NFe" + ((TRetCancNFe)canc.getValue()).getInfCanc().getChNFe();
                codigo = Integer.parseInt(((TRetCancNFe)canc.getValue()).getInfCanc().getCStat());
                CodigoNFeManager.insereCodigo(codigo, ((TRetCancNFe)canc.getValue()).getInfCanc().getXMotivo());
                System.out.println("Ajustando nota cancelamento: " + idNota + " codigo: " + codigo);
                if (codigo != PropriedadesSistema.LIMITE_CANCELAMENTO.getId()) break block16;
                if (!idNota.startsWith("NFe")) {
                    idNota = "NFe" + idNota;
                }
                EstadoNFe estado = this.cacheNotas.obterEstadoNota(idNota, this.tpAmb);
                estado.setEstado(EstadoNFe.ESTADO_NFE.ERRO_CANCELAMENTO);
                estado.setEstadoNFe(new Long(codigo));
                if (((TRetCancNFe)canc.getValue()).getInfCanc().getXMotivo() != null) {
                    estado.setMotivoErro(((TRetCancNFe)canc.getValue()).getInfCanc().getXMotivo());
                }
                GerenciadorProxy.notificarNota(estado);
                return true;
            }
            if (codigo != PropriedadesSistema.NOTA_CANCELADA.getId() && codigo != PropriedadesSistema.JA_CANCELADA.getId() && codigo != 420) break block17;
            if (!idNotaNFe.startsWith("NFe")) {
                idNotaNFe = "NFe" + idNotaNFe;
            }
            EstadoNFe estado = this.cacheNotas.obterEstadoNota(idNotaNFe, this.tpAmb);
            this.cacheNotas.ajustarCancelada(idNotaNFe, this.tpAmb, ((TRetCancNFe)canc.getValue()).getInfCanc().getNProt(), "Cancelamento de NF-e homologado", true, this.idUsuario);
            if (PropriedadesMain.isCancelamento()) {
                String cnpj = "";
                if (estado.getCnpjDestino() != null) {
                    cnpj = estado.getCnpjDestino().trim();
                }
                SenderCancel.getInstace().sendCancel(idNotaNFe, this.tpAmb, cnpj, resultado);
                String filename = String.valueOf(estado.getId()) + "_canc_prot.xml";
                String path = PathFileFinder.getINSTANCE().findXMLCancelPath(estado.getId(), this.tpAmb, Calendar.getInstance().getTime());
                FileWriter fw = new FileWriter(String.valueOf(path) + "/" + filename);
                fw.write(resultado);
                fw.close();
            }
            return true;
        }
        try {
            if (codigo != PropriedadesSistema.NOTA_CANCELADA.getId()) {
                if (!idNota.startsWith("NFe")) {
                    idNota = "NFe" + idNota;
                }
                EstadoNFe estado = this.cacheNotas.obterEstadoNota(idNota, this.tpAmb);
                estado.setEstado(EstadoNFe.ESTADO_NFE.ERRO_CANCELAMENTO);
                estado.setEstadoNFe(new Long(codigo));
                if (((TRetCancNFe)canc.getValue()).getInfCanc().getXMotivo() != null) {
                    estado.setMotivoErro(((TRetCancNFe)canc.getValue()).getInfCanc().getXMotivo());
                }
                GerenciadorProxy.notificarNota(estado);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public void run() {
        boolean cancelar = false;
        int counter = 0;
        while (!cancelar) {
            try {
                cancelar = this.cancelarNota();
                Thread.sleep(2000L);
                if (++counter < 3) continue;
                break;
            }
            catch (Exception e) {
                this.e = e;
                e.printStackTrace();
            }
        }
    }

    public Exception getE() {
        return this.e;
    }

    public static void main(String[] args) {
        try {
            XMLGenerator xmls = XMLFactory.getXmlsRetCanc();
            JAXBElement t = (JAXBElement)xmls.toObjectFromFile(new File("/home/cnoriega/resposta_canc.xml"));
            System.out.println(((TRetCancNFe)t.getValue()).getInfCanc().getCStat());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

