/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.cancinut;

import br.com.taragona.nfe.classes.inutilizacao.TInutNFe;
import br.com.taragona.nfe.classes.inutilizacao.TRetInutNFe;
import br.com.taragona.nfe.mensageiro.caches.CacheNotas;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.tools.PathFileFinder;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.logger.LoggingJava;
import br.com.taragona.nfe.util.logger.NFeLogger;
import br.com.taragona.nfe.util.xml.XMLFactory;
import br.com.taragona.nfe.xmlgenerator.XMLGenerator;
import java.io.FileWriter;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.bind.JAXBElement;

public class InutilizacaoThread
implements Runnable {
    private XMLGenerator xmlsInut = XMLFactory.getXmlsInut();
    private String CNPJ;
    private CacheNotas cacheNotas = CacheNotas.obterInstancia();
    private String idNota;
    private String tpAmb;
    private String UF;
    private String ano;
    private String cnpj;
    private String mod;
    private String serie;
    private String ini;
    private String fim;
    private String just;
    boolean contingencia;
    private boolean once;
    private Exception e;
    private GerenciadorChavesNota chave;
    private String codigoResult = "";
    private String idUsuario;

    public InutilizacaoThread(String idNota, String tpAmb, String just, boolean contingencia, String idUsuario) {
        this.idNota = idNota;
        this.tpAmb = tpAmb;
        this.chave = new GerenciadorChavesNota(idNota);
        this.CNPJ = this.chave.getCnpj();
        this.just = just;
        this.once = true;
        this.contingencia = contingencia;
        this.idUsuario = idUsuario;
    }

    public InutilizacaoThread(String uf, String ano, String cnpj, String mod, String serie, String ini, String fim, String just, boolean contingencia, String tpAmb, String idUsuario) {
        this.UF = uf;
        this.ano = ano;
        this.cnpj = cnpj;
        this.mod = mod;
        this.serie = serie;
        this.ini = ini;
        this.fim = fim;
        this.just = just;
        this.once = false;
        this.contingencia = contingencia;
        this.tpAmb = tpAmb;
        this.idUsuario = idUsuario;
    }

    private boolean processarRespostaInut(String idNota, String tpAmb, String resultado) {
        int codigo;
        JAXBElement inut;
        block11: {
            block10: {
                try {
                    String chaveNota = idNota.replace("NFe", "");
                    if (this.contingencia) {
                        GerenciadorProxy.getGerenciador().notificarProtocoloInutilizcaoContingecia(chaveNota, tpAmb, resultado);
                    } else {
                        GerenciadorProxy.getGerenciador().notificarProtocoloInutilizcaoNormal(chaveNota, tpAmb, resultado);
                    }
                }
                catch (Exception e1) {
                    System.out.println("Nao foi possivel notificar ao ERP");
                }
                inut = (JAXBElement)this.xmlsInut.toObject(resultado);
                codigo = Integer.parseInt(((TRetInutNFe)inut.getValue()).getInfInut().getCStat());
                LoggingJava.logger.log(Level.WARNING, " Ajustando nota inutilizacao: " + idNota + " codigo: " + codigo);
                if (codigo != PropriedadesSistema.NOTA_INUTILIZADA.getId()) break block10;
                this.cacheNotas.ajustarEstadoNotaInut(idNota, tpAmb, new Long(PropriedadesSistema.NOTA_INUTILIZADA.getId()), resultado, String.valueOf(((TRetInutNFe)inut.getValue()).getInfInut().getNProt()) + "|" + ((TRetInutNFe)inut.getValue()).getInfInut().getDhRecbto().toString(), true, true, this.idUsuario);
                EstadoNFe estado = this.cacheNotas.obterEstadoNota(idNota, tpAmb);
                String filename = String.valueOf(estado.getId()) + "_inut_prot.xml";
                String path = PathFileFinder.getINSTANCE().findXMLInutPath(estado.getId(), tpAmb, Calendar.getInstance().getTime());
                FileWriter fw = new FileWriter(String.valueOf(path) + "/" + filename);
                fw.write(resultado);
                fw.close();
                this.cacheNotas.salvarNota(estado);
                return true;
            }
            if (codigo != 563 && codigo != 256) break block11;
            this.cacheNotas.ajustarEstadoNotaInut(idNota, tpAmb, new Long(PropriedadesSistema.NOTA_INUTILIZADA.getId()), resultado, String.valueOf(((TRetInutNFe)inut.getValue()).getInfInut().getNProt()) + "|" + ((TRetInutNFe)inut.getValue()).getInfInut().getDhRecbto().toString(), true, false, this.idUsuario);
            EstadoNFe estado = this.cacheNotas.obterEstadoNota(idNota, tpAmb);
            String filename = String.valueOf(estado.getId()) + "_inut_prot.xml";
            String path = PathFileFinder.getINSTANCE().findXMLInutPath(estado.getId(), tpAmb, Calendar.getInstance().getTime());
            FileWriter fw = new FileWriter(String.valueOf(path) + "/" + filename);
            fw.write(resultado);
            fw.close();
            this.cacheNotas.salvarNota(estado);
            return true;
        }
        try {
            if (codigo != PropriedadesSistema.NOTA_INUTILIZADA.getId()) {
                EstadoNFe estado = this.cacheNotas.obterEstadoNota(idNota, tpAmb);
                estado.setEstado(EstadoNFe.ESTADO_NFE.ERRO_INUTILIZACAO);
                estado.setEstadoNFe(new Long(codigo));
                if (((TRetInutNFe)inut.getValue()).getInfInut().getXMotivo() != null) {
                    estado.setMotivoErro(((TRetInutNFe)inut.getValue()).getInfInut().getXMotivo());
                }
                GerenciadorProxy.notificarNota(estado);
                GerenciadorProxy.notificarNotaConector(estado);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean processarRespostaInutVarias(Vector<EstadoNFe> notas, String resultado) {
        String cont;
        Integer codigo;
        JAXBElement inut;
        block5: {
            inut = (JAXBElement)this.xmlsInut.toObject(resultado);
            codigo = Integer.parseInt(((TRetInutNFe)inut.getValue()).getInfInut().getCStat());
            cont = " normal";
            if (this.contingencia) {
                cont = " contingencia";
            }
            this.codigoResult = String.valueOf(codigo.toString()) + "|" + ((TRetInutNFe)inut.getValue()).getInfInut().getXMotivo() + "|" + cont;
            if (!codigo.equals(PropriedadesSistema.NOTA_INUTILIZADA.getId())) break block5;
            GerenciadorProxy.getGerenciador().atualizarInut(this.serie, this.cnpj, this.ini, "" + codigo, "Inutilizacao de numero homologado", cont);
            for (EstadoNFe nota : notas) {
                this.cacheNotas.ajustarEstado(nota.getId(), this.tpAmb, EstadoNFe.ESTADO_NFE.INUTILIZADA, true, this.idUsuario);
                this.cacheNotas.ajustarEstadoNota(nota.getId(), nota.getAmbiente(), new Long(PropriedadesSistema.NOTA_INUTILIZADA.getId()), this.idUsuario);
                GerenciadorProxy.notificarNota(nota);
            }
            return true;
        }
        try {
            GerenciadorProxy.getGerenciador().atualizarInut(this.serie, this.cnpj, this.ini, "" + codigo, ((TRetInutNFe)inut.getValue()).getInfInut().getXMotivo(), cont);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean inutilizarNota(String UF, String ano, String cnpj, String mod, String serie, String ini, String fim, String just, String tpAmb) throws RemoteException {
        String cabecalho = XMLFactory.montarCabecalho(TInutNFe.class, this.cnpj);
        String inutString = XMLFactory.montarInutilizacao(UF, ano, cnpj, mod, serie, ini, fim, just, tpAmb);
        String resultado = null;
        try {
            inutString = GerenciadorProxy.getGerenciador().assinar(this.cnpj, inutString, "infInut");
            System.out.println(inutString);
            resultado = GerenciadorProxy.enviarMensagemXML(PropriedadesSistema.ID_SERVICO_INUTILIZACAO, this.cnpj, cabecalho, inutString, this.UF, this.idUsuario);
            System.out.println("Resultado inut:" + resultado);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Vector<EstadoNFe> notas = this.cacheNotas.filtrarNotas(tpAmb, UF, ano, cnpj, mod, serie, ini, fim);
        System.out.println("Encontrada " + notas.size() + " notas");
        if (notas.isEmpty()) {
            DAOGenerico<EstadoNFe> dao = new DAOGenerico<EstadoNFe>(EstadoNFe.class);
            int nI = Integer.parseInt(ini);
            int nF = Integer.parseInt(fim);
            int i = nI;
            while (i <= nF) {
                Date hoje = new Date();
                int mes = hoje.getMonth() + 1;
                String AAMM = String.valueOf(ano) + String.format("%02d", mes);
                String chave = this.criaChave(UF, AAMM, cnpj, mod, serie, Integer.toString(i));
                EstadoNFe e = new EstadoNFe();
                e.setAmbiente(tpAmb);
                e.setId("NFe" + chave);
                e.setCnpj(cnpj);
                e.setDataGerada(hoje);
                e.setEstado(EstadoNFe.ESTADO_NFE.INUTILIZADA);
                e.setMotivoErro(just);
                e.setDataActualizada(hoje);
                e.setDataEnviada(hoje);
                e.setXmlString(inutString);
                dao.salvar(e);
                GerenciadorProxy.notificarNota(e);
                GerenciadorProxy.notificarNotaConector(e);
                NFeLogger.log(e.getId(), e.getAmbiente(), e.getModoOperacao(), e.getEstado(), null, this.idUsuario);
                ++i;
            }
        }
        return this.processarRespostaInutVarias(notas, resultado);
    }

    public boolean inutilizarNota(String idNota, String tpAmb) {
        LoggingJava.logger.log(Level.WARNING, "inutilizar nota: " + idNota);
        String cabecalho = XMLFactory.montarCabecalho(TInutNFe.class, this.CNPJ);
        String inutString = XMLFactory.montarInutilizacaoNota(idNota, tpAmb, this.CNPJ, this.just);
        String resultado = null;
        try {
            System.out.println("Inutilizando nota: " + inutString);
            LoggingJava.logger.log(Level.WARNING, "Nota ID: " + idNota + " xml: " + inutString);
            inutString = GerenciadorProxy.getGerenciador().assinar(this.CNPJ, inutString, "infInut");
            resultado = GerenciadorProxy.enviarMensagemXML(PropriedadesSistema.ID_SERVICO_INUTILIZACAO, this.CNPJ, cabecalho, inutString, this.chave.getUF(), this.idUsuario);
            System.out.println("result inut: " + resultado);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (resultado != null) {
            return this.processarRespostaInut(idNota, tpAmb, resultado);
        }
        return false;
    }

    public Exception getE() {
        return this.e;
    }

    @Override
    public void run() {
        boolean result = false;
        int counter = 0;
        while (!result) {
            if (++counter >= 3) {
                return;
            }
            try {
                result = this.once ? this.inutilizarNota(this.idNota, this.tpAmb) : this.inutilizarNota(this.UF, this.ano, this.cnpj, this.mod, this.serie, this.ini, this.fim, this.just, this.tpAmb);
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.e = e;
            }
        }
    }

    public String getCodigoResult() {
        return this.codigoResult;
    }

    public static void main(String[] args) {
    }

    String calculaChave(String chave) {
        String result = null;
        int[] multiplicador = new int[]{4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2};
        int tmp1 = 0;
        int dv = 0;
        int total = 0;
        int ind = 0;
        while (ind < 43) {
            int dig = Integer.parseInt(chave.substring(ind, ind + 1));
            total += dig * multiplicador[ind];
            ++ind;
        }
        tmp1 = total % 11;
        dv = tmp1 < 2 ? 0 : 11 - tmp1;
        result = String.valueOf(chave) + dv;
        return result;
    }

    String criaChave(String cuf, String AAMM, String cnpj, String modelo, String serie, String numero) {
        String chave = null;
        String taamm = AAMM;
        int tmp = Integer.parseInt(serie);
        String tserie = String.format("%03d", tmp);
        tmp = Integer.parseInt(numero);
        String tnumero = String.format("%09d", tmp);
        tmp = Integer.parseInt(cuf);
        String tcuf = String.format("%02d", tmp);
        String trand = "000000001";
        String tmodelo = "55";
        chave = String.valueOf(tcuf) + taamm + cnpj + tmodelo + tserie + tnumero + trand;
        return this.calculaChave(chave);
    }
}

