/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.controle;

import br.com.taragona.nfe.controle.ControleLotesAsString;
import br.com.taragona.nfe.controle.eventoret.TConsSitNFe;
import br.com.taragona.nfe.controle.eventoret.TRetConsSitNFe;
import br.com.taragona.nfe.persistence.CodigoNFe;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.xml.XMLFactory;
import javax.xml.bind.JAXBElement;

public class ControleLotesAsStringInstance
extends ControleLotesAsString {
    private DAOGenerico<CodigoNFe> daoCodigo = new DAOGenerico(CodigoNFe.class);

    public ControleLotesAsStringInstance(String tpAmb, String CNPJ, String UF) {
        super(tpAmb, CNPJ, UF, PropriedadesSistema.MODO_OP.NORMAL);
    }

    @Override
    protected synchronized void processarCodigoConsulta(int codigo, String idNota, String tpAmb, String numeroProtocolo, String xmlProtocolo, boolean notificar, String idUsuario) {
        if (!idNota.startsWith("NFe")) {
            idNota = "NFe" + idNota;
        }
        try {
            System.out.println("codigo cstat: " + codigo + " id: " + idNota);
            this.cacheNotas.ajustarEstadoNota(idNota, tpAmb, new Long(codigo), idUsuario);
            if (codigo == 217) {
                this.cacheNotas.ajustarEstadoNota(idNota, tpAmb, 217L, idUsuario);
                this.cacheNotas.ajustarEstado(idNota, tpAmb, EstadoNFe.ESTADO_NFE.ERRO, notificar, idUsuario);
                return;
            }
            if (codigo == 110 || codigo == 205) {
                this.cacheNotas.ajustarDenegada(idNota, tpAmb, numeroProtocolo, xmlProtocolo, notificar, false, idUsuario);
                return;
            }
            if (codigo == 101) {
                this.cacheNotas.ajustarCancelada(idNota, tpAmb, numeroProtocolo, xmlProtocolo, notificar, idUsuario);
                return;
            }
            if (PropriedadesSistema.isCodigoAutorizado(codigo)) {
                this.cacheNotas.ajustarAutorizada(idNota, tpAmb, xmlProtocolo, numeroProtocolo, notificar, idUsuario);
                System.out.println("Controle instance ajustando autorizada" + idNota);
                this.cacheNotas.flushcache();
                return;
            }
            if (201 <= codigo && codigo <= 299 || 401 <= codigo && codigo <= 600) {
                this.cacheNotas.ajustarEstado(idNota, tpAmb, EstadoNFe.ESTADO_NFE.REJEITADA, notificar, idUsuario);
            } else if (301 <= codigo && codigo <= 302) {
                this.cacheNotas.ajustarDenegada(idNota, tpAmb, xmlProtocolo, numeroProtocolo, notificar, false, idUsuario);
                this.imprimir.enviarDenegadaEmail(idNota, tpAmb);
            } else if (101 == codigo) {
                this.cacheNotas.ajustarEstado(idNota, tpAmb, EstadoNFe.ESTADO_NFE.CANCELADA, notificar, idUsuario);
            } else {
                this.cacheNotas.ajustarEstado(idNota, tpAmb, EstadoNFe.ESTADO_NFE.ERRO, notificar, idUsuario);
            }
            this.cacheNotas.flushcache();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized String consultarNotaInstance(String id, String idUsuario) {
        id = id.replace("NFe", "");
        try {
            String consulta = XMLFactory.criarConsultaNota(id, this.tpAmb, this.CNPJ);
            String cabecalho = XMLFactory.montarCabecalhoUF(TConsSitNFe.class, this.UF);
            System.out.println("consulta nota:" + consulta);
            String resultado = GerenciadorProxy.enviarMensagemXML(PropriedadesSistema.ID_SERVICO_CONSULTA, this.CNPJ, cabecalho, consulta, this.UF, idUsuario);
            JAXBElement protocolo = (JAXBElement)this.xmlsConsulta.toObject(resultado);
            int codigo = Integer.parseInt(((TRetConsSitNFe)protocolo.getValue()).getCStat());
            CodigoNFe code = this.daoCodigo.buscarPorIdInt(codigo);
            if (code == null) {
                code = new CodigoNFe();
                code.setId(codigo);
                code.setName(((TRetConsSitNFe)protocolo.getValue()).getXMotivo().trim());
                this.daoCodigo.salvar(code);
            }
            return String.valueOf(codigo);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public synchronized String consultarNotaInstanceXml(String id, String tpAmb, String idUsuario) {
        id = id.replace("NFe", "");
        try {
            String consulta = XMLFactory.criarConsultaNotaUF(id, tpAmb, this.UF);
            String cabecalho = XMLFactory.montarCabecalhoUF(TConsSitNFe.class, this.UF);
            System.out.println("Consulta nota:" + consulta);
            String resultado = GerenciadorProxy.enviarMensagemXML(PropriedadesSistema.ID_SERVICO_CONSULTA, null, cabecalho, consulta, this.UF, idUsuario);
            return resultado;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String extrairXMotivo(String xml) {
        if (xml == null) {
            return null;
        }
        int start = xml.indexOf("<xMotivo>");
        if (start == -1) {
            return null;
        }
        int end = xml.indexOf("</xMotivo>", start);
        if (end == -1) {
            return null;
        }
        String value = xml.substring(start + 9, end).trim();
        return value.isEmpty() ? null : value;
    }
}

