/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.danfe;

import br.com.taragona.nfe.danfe.ImprimirDANFEImpl;
import br.com.taragona.nfe.danfe.ReadXML;
import java.util.Hashtable;

public class RepareProtocol {
    private static String PROTOCOL_TAG_OPEN = "<ns2:retConsSitNFe";
    private static String PROTOCOL_TAG_CLOSE = "</ns2:retConsSitNFe>";
    private static String PROTOCOL_TAG_OPEN_2 = "<tRetConsSitNFe";
    private static String PROTOCOL_TAG_CLOSE_2 = "</tRetConsSitNFe>";
    private static String PROTOCOL_TAG_OPEN_3 = "<protNFe";
    private static String PROTOCOL_TAG_CLOSE_3 = "</protNFe>";
    private String versao = "3.10";

    public String repare(String xml) {
        String protocol = this.extractProtocol(xml);
        if (protocol == null) {
            protocol = xml;
        }
        ReadXML read = new ReadXML();
        read.parseXML(protocol);
        String newProtocol = this.makeNewProtocol(read.getValues().get(0));
        return xml.replace(protocol, newProtocol);
    }

    public String getVersao() {
        return this.versao;
    }

    public void setVersao(String versao) {
        this.versao = versao;
    }

    private String makeNewProtocol(Hashtable<String, String> prop) {
        String prot = "<protNFe versao=\"" + this.versao + "\" xmlns=\"http://www.portalfiscal.inf.br/nfe\">" + "<infProt>" + "<tpAmb>" + prop.get("tpAmb") + "</tpAmb>" + "<verAplic>" + prop.get("verAplic") + "</verAplic>" + "<chNFe>" + prop.get("chNFe") + "</chNFe>" + "<dhRecbto>" + prop.get("dhRecbto") + "</dhRecbto>" + "<nProt>" + prop.get("nProt") + "</nProt>" + "<digVal>" + prop.get("digVal") + "</digVal>" + "<cStat>" + prop.get("cStat") + "</cStat>" + "<xMotivo>" + prop.get("xMotivo") + "</xMotivo>" + "</infProt></protNFe>";
        return prot;
    }

    private String extractProtocol(String xml) {
        int pos1 = xml.indexOf(PROTOCOL_TAG_OPEN);
        int pos2 = xml.indexOf(PROTOCOL_TAG_CLOSE) + PROTOCOL_TAG_CLOSE.length();
        String protocol = null;
        if (pos1 != -1 && pos2 != -1) {
            protocol = xml.substring(pos1, pos2);
        }
        if (protocol == null) {
            pos1 = xml.indexOf(PROTOCOL_TAG_OPEN_2);
            pos2 = xml.indexOf(PROTOCOL_TAG_CLOSE_2) + PROTOCOL_TAG_CLOSE_2.length();
            if (pos1 != -1 && pos2 != -1) {
                protocol = xml.substring(pos1, pos2);
            }
        }
        if (protocol == null && protocol == null) {
            pos1 = xml.indexOf(PROTOCOL_TAG_OPEN_3);
            pos2 = xml.indexOf(PROTOCOL_TAG_CLOSE_3) + PROTOCOL_TAG_CLOSE_3.length();
            if (pos1 != -1 && pos2 != -1) {
                protocol = xml.substring(pos1, pos2);
            }
        }
        return protocol;
    }

    public static void main(String[] args) {
        String xml = ImprimirDANFEImpl.lerArquivo("C:\\Users\\Administrador.WIN-SERVIDOR\\Downloads\\NFe35131117149516000103550010000004301000000010_prot.xml");
        RepareProtocol p = new RepareProtocol();
        System.out.println("-->" + p.repare(xml));
    }
}

