/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.dpec;

import br.com.taragona.nfe.classes.recepcao.TNFe;
import br.com.taragona.nfe.clientreferencia.ReferenciaGerenciador;
import br.com.taragona.nfe.dpec.CheckNFeDPEC;
import br.com.taragona.nfe.gerenciador.GerenciadorInterface;
import br.com.taragona.nfe.mensageiro.caches.CacheNotas;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.tools.PathFileFinder;
import br.com.taragona.nfe.util.ConfiguracaoSys;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.data.BaseDadosConfig;
import br.com.taragona.nfe.xmlgenerator.XMLGenerator;
import br.com.tti.dpec.classes.TDPEC;
import br.com.tti.dpec.classes.TUf;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBElement;

public class GeradorDPEC {
    private static String NOME_ARQUIVO = "DPEC_";
    private static String PASTA_ARQUIVOS = "";
    private static int MAXIMO_NOTAS = 50;
    private XMLGenerator xmlDpec;
    private XMLGenerator xmlNFe;
    private CacheNotas cache;
    private List<TDPEC.InfDPEC.ResNFe> dpecsLote;
    private String CNPJ;
    private String UF;
    private String IE;
    private String tpAmb;
    private int count;

    public GeradorDPEC(String CNPJ, String UF) {
        GeradorDPEC.setPASTA_ARQUIVOS(ConfiguracaoSys.getPastaWrapper());
        this.xmlDpec = new XMLGenerator("br.com.tti.dpec.classes");
        this.xmlNFe = new XMLGenerator("br.com.taragona.nfe.classes.recepcao");
        this.cache = CacheNotas.obterInstancia();
        this.dpecsLote = new ArrayList<TDPEC.InfDPEC.ResNFe>();
        this.CNPJ = CNPJ;
        this.count = 0;
        this.UF = UF;
    }

    public void adicionarNota(EstadoNFe nota, String cnpj) {
        if (nota.getXmlString() != null) {
            TDPEC.InfDPEC.ResNFe dpec = this.montarDpecDeNota(nota.getXmlString());
            if (dpec == null) {
                return;
            }
            this.dpecsLote.add(dpec);
            if (this.dpecsLote.size() == MAXIMO_NOTAS) {
                this.criarArquivoDpec(this.dpecsLote);
                ++this.count;
                this.dpecsLote.clear();
            }
        }
    }

    public String obterNomeArquivo() {
        SimpleDateFormat df = new SimpleDateFormat("ddMMyyyyHHmmSS");
        String pasta = PathFileFinder.getINSTANCE().findXMLDPECPath(this.CNPJ, Calendar.getInstance().getTime());
        return String.valueOf(pasta) + "/" + NOME_ARQUIVO + this.CNPJ + "_" + df.format(new Date()) + "_" + this.count + ".xml";
    }

    public TDPEC.InfDPEC.ResNFe montarDpecDeNota(String xml) {
        try {
            TNFe nfe = (TNFe)((JAXBElement)this.xmlNFe.toObject(xml)).getValue();
            TDPEC.InfDPEC.ResNFe res = new TDPEC.InfDPEC.ResNFe();
            if (this.IE == null) {
                this.IE = nfe.getInfNFe().getEmit().getIE();
            }
            if (this.tpAmb == null) {
                this.tpAmb = nfe.getInfNFe().getIde().getTpAmb();
            }
            res.setChNFe(nfe.getInfNFe().getId().replace("NFe", ""));
            if (nfe.getInfNFe().getDest().getCNPJ() != null) {
                res.setCNPJ(nfe.getInfNFe().getDest().getCNPJ());
            }
            if (nfe.getInfNFe().getDest().getCPF() != null) {
                res.setCPF(nfe.getInfNFe().getDest().getCPF());
            }
            if (nfe.getInfNFe().getDest().getEnderDest().getUF() != null) {
                res.setUF(TUf.fromValue(nfe.getInfNFe().getDest().getEnderDest().getUF().toString()));
            }
            res.setVICMS(nfe.getInfNFe().getTotal().getICMSTot().getVICMS());
            res.setVNF(nfe.getInfNFe().getTotal().getICMSTot().getVNF());
            res.setVST(nfe.getInfNFe().getTotal().getICMSTot().getVST());
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String cleanXml(String xml) {
        System.out.println("->" + xml);
        xml = xml.replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>", "");
        xml = xml.replace("ns2:", "");
        xml = xml.replace("xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "");
        xml = xml.replace(" xmlns=\"http://www.w3.org/2000/09/xmldsig#\"", "");
        xml = xml.replace(":ns2", "");
        System.out.println("saida->" + xml);
        return xml;
    }

    public String cleanXml2(String xml) {
        return xml;
    }

    public String createDpecNow() {
        return this.criarArquivoDpec(this.dpecsLote);
    }

    public String criarArquivoDpec(List<TDPEC.InfDPEC.ResNFe> dpecs) {
        TDPEC dpec = new TDPEC();
        TDPEC.InfDPEC.IdeDec ide = new TDPEC.InfDPEC.IdeDec();
        ide.setCNPJ(this.CNPJ);
        if (dpecs.get(0).getUF() != null) {
            ide.setCUF(this.UF);
        }
        ide.setIE(this.IE);
        ide.setTpAmb(this.tpAmb);
        ide.setVerProc("1.01");
        TDPEC.InfDPEC info = new TDPEC.InfDPEC();
        info.setResNFe(dpecs);
        info.setIdeDec(ide);
        info.setId("DPEC" + this.CNPJ);
        dpec.setVersao("1.01");
        dpec.setInfDPEC(info);
        String loteDpec = null;
        try {
            loteDpec = this.xmlDpec.toXMLString(dpec);
            loteDpec = this.cleanXml(loteDpec);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        String loteDpecAssinado = null;
        try {
            GerenciadorInterface ger = null;
            try {
                ger = ReferenciaGerenciador.obterReferenciaGerenciador("localhost");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            loteDpecAssinado = ger.assinar(this.CNPJ, loteDpec, "infDPEC");
            loteDpecAssinado = loteDpecAssinado.replace("<envDPEC versao=\"1.01\">", "<envDPEC xmlns=\"http://www.portalfiscal.inf.br/nfe\" versao=\"1.01\">");
            loteDpecAssinado = loteDpecAssinado.replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>", "");
            String arquivo = this.obterNomeArquivo();
            FileWriter fw = new FileWriter(arquivo);
            fw.write(loteDpecAssinado);
            fw.close();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return loteDpecAssinado;
    }

    public void criarArquivosDpec() {
        CheckNFeDPEC checker = new CheckNFeDPEC();
        Vector<EstadoNFe> notasDpec = this.cache.obterNotasDpec(null, null, this.CNPJ);
        for (EstadoNFe estadoNFe : notasDpec) {
            if (checker.isNFeDPEC(estadoNFe.getId())) continue;
            this.adicionarNota(estadoNFe, this.CNPJ);
            checker.registerNFe(estadoNFe.getId());
        }
        if (!this.dpecsLote.isEmpty()) {
            this.criarArquivoDpec(this.dpecsLote);
            ++this.count;
            this.dpecsLote.clear();
        }
    }

    public static String getPASTA_ARQUIVOS() {
        return PASTA_ARQUIVOS;
    }

    public static void setPASTA_ARQUIVOS(String pasta_arquivos) {
        PASTA_ARQUIVOS = pasta_arquivos;
    }

    public static void main(String[] args) {
        System.out.println(TUf.valueOf("MG").value());
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
        }
        catch (Exception exception) {
            // empty catch block
        }
        PropriedadesMain.processarComandos(args);
        GeradorDPEC.setPASTA_ARQUIVOS(ConfiguracaoSys.getPastaWrapper());
        BaseDadosConfig bd = new BaseDadosConfig();
        bd.setNomeDriver(ConfiguracaoSys.getDRIVER());
        bd.setUsuario(ConfiguracaoSys.getUSER_NAME());
        bd.setSenha(ConfiguracaoSys.getPASSWORD());
        bd.setUrl(ConfiguracaoSys.getURL_CONECTION());
        bd.setToplinkProp("update");
        PropriedadesSistema.setBdConfig(bd);
        GeradorDPEC ger = new GeradorDPEC(PropriedadesMain.getCnpjs().get(0), null);
        ger.criarArquivosDpec();
    }
}

