/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.email;

import br.com.taragona.nfe.clientreferencia.ReferenciaGerenciador;
import br.com.taragona.nfe.email.MailSender;
import br.com.taragona.nfe.gerenciador.GerenciadorInterface;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.LogEnvioEmail;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import javax.persistence.Query;

public class CheckResendMail
implements Runnable {
    private static CheckResendMail INSTANCE;
    private String tpAmb;
    private ResourceBundle bundleconfig;
    private DAOGenerico<LogEnvioEmail> logemail;
    private GerenciadorInterface ger;
    private Hashtable<String, Integer> counter;
    private MailSender sender = new MailSender();

    public static CheckResendMail getInstance(String tpAmb) {
        if (INSTANCE == null) {
            INSTANCE = new CheckResendMail(tpAmb);
            Thread t = new Thread(INSTANCE);
            t.start();
        }
        return INSTANCE;
    }

    public CheckResendMail(String tpAmb) {
        this.tpAmb = tpAmb;
        this.counter = new Hashtable();
        try {
            this.bundleconfig = ResourceBundle.getBundle("configuracao_email");
            this.logemail = new DAOGenerico(LogEnvioEmail.class);
            this.ger = ReferenciaGerenciador.obterReferenciaGerenciador("localhost");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (true) {
            Query q = this.logemail.criarQuery("select l from LogEnvioEmail as l where l.estado = :estado and l.ambiente = :tpAmb order by l.id desc");
            q.setMaxResults(50);
            q.setParameter("estado", (Object)LogEnvioEmail.ESTADO_EMAIL.NAO_ENVIADO);
            q.setParameter("tpAmb", (Object)this.tpAmb);
            List logs = q.getResultList();
            for (Object object : logs) {
                Integer cc;
                if (!(object instanceof LogEnvioEmail)) continue;
                LogEnvioEmail log = (LogEnvioEmail)object;
                Query q1 = this.logemail.criarQuery("select l from LogEnvioEmail as l where l.estado = :estado and l.keyxml = :keyxml and l.ambiente = :tpAmb");
                q1.setParameter("estado", (Object)LogEnvioEmail.ESTADO_EMAIL.ENVIADO);
                q1.setParameter("keyxml", (Object)log.getKeyxml());
                q1.setParameter("tpAmb", (Object)this.tpAmb);
                List rrr = q1.getResultList();
                if (rrr != null && !rrr.isEmpty()) continue;
                String key = log.getKeyxml();
                if (key != null) {
                    String string = key = !key.startsWith("NFe") ? "NFe" + key : key;
                }
                if ((cc = this.counter.get(key)) == null) {
                    cc = 0;
                }
                cc = cc + 1;
                this.counter.put(key, cc);
                if (cc <= Integer.parseInt(this.bundleconfig.getString("quantidade"))) {
                    try {
                        this.ger.enviarEmailNota(key, this.tpAmb);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                GerenciadorChavesNota chave = new GerenciadorChavesNota(key);
                String[] to = this.bundleconfig.getString("emails_erro").split(",");
                String mesagem = this.bundleconfig.getString("mensagem_email_erro").replace("%CHAVE%", key).replace("%NUMERO%", chave.getNumeroNota()).replace("%CNPJ%", chave.getCnpj());
                String subj = this.bundleconfig.getString("assunto_email_erro");
                try {
                    this.sender.myMail(key, this.tpAmb, to, subj, mesagem, new String[0], new LogEnvioEmail());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                log.setEstado(LogEnvioEmail.ESTADO_EMAIL.DONT_CONSIDER);
                log.setAmbiente(this.tpAmb);
                this.logemail.salvar(log);
                this.logemail.flush();
            }
            try {
                Thread.sleep((long)(Integer.parseInt(this.bundleconfig.getString("intervalo")) * 60) * 1000L);
                continue;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

