/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.email;

import br.com.taragona.nfe.persistence.CadastroEmail;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.util.ConfiguracaoSys;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.data.BaseDadosConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Hashtable;
import java.util.List;
import javax.persistence.Query;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;

public class ExcelRecreateConsumer2
implements Runnable {
    private static ExcelRecreateConsumer2 INSTANCE = null;
    private String tpAmb;
    private String directory;
    private DAOGenerico<CadastroEmail> daoEmail;

    public static ExcelRecreateConsumer2 getInstance(String tpAmb) {
        if (INSTANCE == null) {
            INSTANCE = new ExcelRecreateConsumer2(tpAmb);
            Thread t = new Thread(INSTANCE);
            t.start();
        }
        return INSTANCE;
    }

    private ExcelRecreateConsumer2(String tpAmb) {
        this.tpAmb = tpAmb;
        this.directory = PropriedadesMain.getTrustStore();
        if (this.directory == null) {
            this.directory = PropriedadesMain.getOutros();
        }
        System.out.println("Planilha da pasta: " + this.directory);
        this.daoEmail = new DAOGenerico(CadastroEmail.class);
    }

    private Hashtable<String, String> readEmails(File file) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        try {
            FileInputStream fis = new FileInputStream(file);
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)fis, Charset.forName("ISO-8859-1")));
            String line = r.readLine();
            while (line != null) {
                System.out.println("Reading:" + line);
                String[] splits = line.split("=");
                if (splits.length == 2) {
                    table.put(splits[0].trim(), splits[1].trim());
                }
                if (splits.length == 1) {
                    table.put(splits[0].trim(), "");
                }
                line = r.readLine();
            }
            r.close();
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return table;
    }

    public void updateEmails(Hashtable<String, String> table) {
        for (String cnpj : table.keySet()) {
            CadastroEmail cad;
            Query q;
            List list;
            if (cnpj.endsWith("_assunto") || cnpj.endsWith("_mensagem")) {
                cnpj = cnpj.replace("_assunto", "");
                cnpj = cnpj.replace("_mensagem", "");
            }
            if ((list = (q = this.daoEmail.criarQuery("select e from CadastroEmail as e where e.cnpj = '" + cnpj + "'")).getResultList()).isEmpty()) {
                cad = new CadastroEmail();
                cad.setCnpj(cnpj);
                cad.setEmails(table.get(cnpj));
                cad.setSubject(table.get(String.valueOf(cnpj) + "_assunto"));
                cad.setMessage(table.get(String.valueOf(cnpj) + "_mensagem"));
                this.daoEmail.salvar(cad);
                this.daoEmail.flush();
                continue;
            }
            cad = (CadastroEmail)list.get(0);
            cad.setEmails(table.get(cnpj));
            cad.setSubject(table.get(String.valueOf(cnpj) + "_assunto"));
            cad.setMessage(table.get(String.valueOf(cnpj) + "_mensagem"));
            this.daoEmail.unir(cad);
            this.daoEmail.flush();
        }
    }

    public CadastroEmail findEmails(String cnpj) {
        List list;
        block6: {
            this.daoEmail.clear();
            if (cnpj == null || cnpj.trim().isEmpty()) {
                return null;
            }
            Query q = this.daoEmail.criarQuery("select e from CadastroEmail as e where e.cnpj = '" + cnpj + "'");
            CadastroEmail cad = null;
            try {
                list = q.getResultList();
                if (list.size() != 0) break block6;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return cad;
            }
        }
        CadastroEmail cc = (CadastroEmail)list.get(0);
        try {
            this.daoEmail.refresh(cc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cc;
    }

    private void readFiles() {
        File[] files;
        File dir = new File(this.directory);
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getAbsolutePath().endsWith(".xls") || file.getAbsolutePath().endsWith(".properties")) {
                System.out.println("Tratando arquivo Excel:" + file.getAbsolutePath());
                try {
                    HSSFWorkbook workbook = new HSSFWorkbook((InputStream)new FileInputStream(file));
                    HSSFSheet sheet = workbook.getSheetAt(0);
                    for (Row row : sheet) {
                        try {
                            String chave = row.getCell(0).getStringCellValue();
                            try {
                                if (!chave.startsWith("NFe")) {
                                    chave = "NFe" + chave;
                                }
                                GerenciadorProxy.gerenciador.enviarEmailNota(chave, this.tpAmb);
                                Thread.sleep(1000L);
                                GerenciadorProxy.gerenciador.reImprimirNota(chave, this.tpAmb, null);
                            }
                            catch (Exception e) {
                                System.out.print("error procesando nota: " + chave);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.out.println("error: " + e.getLocalizedMessage());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                boolean ok = true;
                while (ok) {
                    ok = file.delete();
                }
            }
            ++n2;
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.readFiles();
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static void main(String[] args) {
        String[] splits = "1234567890=".split("=");
        System.out.println(splits.length);
        PropriedadesMain.processarComandos(args);
        BaseDadosConfig bd = new BaseDadosConfig();
        bd.setNomeDriver(ConfiguracaoSys.getDRIVER());
        bd.setUsuario(ConfiguracaoSys.getUSER_NAME());
        bd.setSenha(ConfiguracaoSys.getPASSWORD());
        bd.setUrl(ConfiguracaoSys.getURL_CONECTION());
        bd.setToplinkProp("create-tables");
        PropriedadesSistema.setBdConfig(bd);
        ExcelRecreateConsumer2 c = new ExcelRecreateConsumer2(ConfiguracaoSys.getTipoAmbiente());
        c.readFiles();
    }
}

