/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.email;

import br.com.taragona.nfe.email.EmailConsomer;
import br.com.taragona.nfe.mensageiro.caches.CacheNotas;
import br.com.taragona.nfe.persistence.CadastroEmail;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.Empresa;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.persistence.LogEnvioEmail;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.tti.sefaz.log.MyLogger;
import com.sun.mail.smtp.SMTPAddressFailedException;
import com.sun.mail.smtp.SMTPAddressSucceededException;
import com.sun.mail.smtp.SMTPSendFailedException;
import com.sun.mail.smtp.SMTPTransport;
import java.io.File;
import java.io.FilenameFilter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MailSender {
    private ResourceBundle bundlescnpjs;
    private ResourceBundle bundleconfig;
    private boolean isConfig;
    private ResourceBundle bundleEmitente;
    private DAOGenerico<LogEnvioEmail> logemail;

    public MailSender(boolean t) {
    }

    public MailSender() {
        this.isConfig = true;
        try {
            this.bundleconfig = ResourceBundle.getBundle("configuracao_email");
        }
        catch (Exception e) {
            this.isConfig = false;
        }
        this.logemail = new DAOGenerico(LogEnvioEmail.class);
    }

    public void postMail(String[] recipients, String subject, String message, String from) throws MessagingException {
        boolean debug = false;
        Properties props = new Properties();
        props.put("mail.smtp.host", "smtp.jcom.net");
        Session session = Session.getDefaultInstance((Properties)props, null);
        session.setDebug(debug);
        MimeMessage msg = new MimeMessage(session);
        InternetAddress addressFrom = new InternetAddress(from);
        msg.setFrom((Address)addressFrom);
        InternetAddress[] addressTo = new InternetAddress[recipients.length];
        int i = 0;
        while (i < recipients.length) {
            addressTo[i] = new InternetAddress(recipients[i]);
            ++i;
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])addressTo);
        msg.addHeader("MyHeaderName", "myHeaderValue");
        msg.setSubject(subject);
        msg.setContent((Object)message, "text/plain");
        Transport.send((Message)msg);
    }

    private String formatCNPJOrCPF(String cnpjOrCpf) {
        String formated = "";
        int tam = cnpjOrCpf.trim().length();
        switch (tam) {
            case 10: {
                formated = String.valueOf(cnpjOrCpf.substring(0, 2)) + "." + cnpjOrCpf.substring(2, 5) + "." + cnpjOrCpf.substring(5, 8) + "-" + cnpjOrCpf.substring(8);
                break;
            }
            case 11: {
                formated = String.valueOf(cnpjOrCpf.substring(0, 3)) + "." + cnpjOrCpf.substring(3, 6) + "." + cnpjOrCpf.substring(6, 9) + "-" + cnpjOrCpf.substring(9);
                break;
            }
            case 14: {
                formated = String.valueOf(cnpjOrCpf.substring(0, 2)) + "." + cnpjOrCpf.substring(2, 5) + "." + cnpjOrCpf.substring(5, 8) + "/" + cnpjOrCpf.substring(8, 12) + "-" + cnpjOrCpf.substring(12);
                break;
            }
            default: {
                formated = cnpjOrCpf;
            }
        }
        return formated;
    }

    private String clearEncode(String str) {
        if (str != null) {
            try {
                return new String(str.getBytes(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String applyTemplate(String str, String id, String tpAmb) {
        try {
            Empresa transp;
            Empresa dest;
            if (str == null) {
                str = "";
            }
            str = str.replace("|", "\r\n");
            System.out.println(str);
            EstadoNFe info = CacheNotas.obterInstancia().obterEstadoNota(id, tpAmb);
            if (info != null) {
                GerenciadorChavesNota kk = new GerenciadorChavesNota(info.getId());
                str = str.replace("%CHAVE%", info.getId().replace("NFe", "").replace("CTe", ""));
                str = str.replace("%NUMERO%", kk.getNumeroNota());
                str = str.replace("%SERIE%", kk.getSerie());
                if (EstadoNFe.ESTADO_NFE.AUTORIZADA.equals((Object)info.getEstado())) {
                    str = str.replace("%PROTOCOLO%", String.valueOf(info.getProtocolo()));
                }
                if (EstadoNFe.ESTADO_NFE.CANCELADA.equals((Object)info.getEstado())) {
                    str = str.replace("%PROTOCOLO%", String.valueOf(info.getMotivoErro()).replace("|", " "));
                }
                str = str.replace("%STATUS%", "" + (Object)((Object)info.getEstado()));
            }
            if ((dest = CacheNotas.obterInstancia().obterEmpresa(info.getAmbiente(), info.getCnpjDestino() == null ? "" : info.getCnpjDestino())) != null) {
                str = str.replace("%DEST%", String.valueOf(this.formatCNPJOrCPF(dest.getCnpj())) + " - " + dest.getNome());
            }
            if ((transp = CacheNotas.obterInstancia().obterEmpresa(info.getAmbiente(), info.getCnpjTransp() == null ? "" : info.getCnpjTransp())) != null) {
                str = str.replace("%TRANSP%", String.valueOf(this.formatCNPJOrCPF(transp.getCnpj())) + " - " + transp.getNome());
            }
            return str;
        }
        catch (Exception e) {
            MyLogger.getLog().log(Level.INFO, e.getLocalizedMessage(), e);
            return str;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void myMail(String id, String tpAmb, String[] to, String subj, String mesagem, String[] filenames, LogEnvioEmail log) throws Exception {
        block30: {
            block32: {
                block31: {
                    if (this.bundleconfig == null) {
                        System.out.println("conf/configuracao_email.properties");
                        System.out.println("Nao e possivel enviar emails");
                        return;
                    }
                    if (!this.bundleconfig.containsKey("from")) {
                        System.out.println("from nao encontrado em conf/configuracao_email.properties");
                        System.out.println("Nao e possivel enviar emails");
                        return;
                    }
                    from = this.bundleconfig.getString("from").trim();
                    if (from == null || from.trim().isEmpty()) {
                        System.out.println("Nao e possivel enviar email sem from");
                        System.out.println("favor verificar o arquiv conf/configuracao_email.properties");
                        return;
                    }
                    mesagem = this.applyTemplate(mesagem, id, tpAmb);
                    subj = this.applyTemplate(subj, id, tpAmb);
                    System.out.println("Execuntado");
                    subject = subj;
                    message = mesagem;
                    mailhost = this.bundleconfig.getString("smtp_server").trim();
                    user = this.bundleconfig.getString("usuario").trim();
                    password = this.bundleconfig.getString("senha").trim();
                    auth2 = new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(user, password);
                        }
                    };
                    auth = PropriedadesMain.isAutenticar();
                    ssl = PropriedadesMain.isEmailssl();
                    props = System.getProperties();
                    if (mailhost != null) {
                        props.put("mail.smtp.host", mailhost);
                    }
                    if (auth) {
                        System.out.println("autenticar");
                        props.put("mail.smtp.auth", "true");
                    }
                    props.put("mail.smtp.port", PropriedadesMain.getPorta_email());
                    props.setProperty("mail.smtp.starttls.enable", "true");
                    System.out.println("ssl:" + ssl);
                    System.out.println("host:" + props.getProperty("mail.smtp.host"));
                    System.out.println("port:" + props.getProperty("mail.smtp.port"));
                    session = Session.getInstance((Properties)props, (Authenticator)auth2);
                    msg = new MimeMessage(session);
                    try {
                        addressTo = new InternetAddress[to.length];
                        i = 0;
                        while (i < to.length) {
                            addressTo[i] = new InternetAddress(to[i]);
                            ++i;
                        }
                        msg.setFrom((Address)new InternetAddress(from));
                        msg.setRecipients(Message.RecipientType.TO, (Address[])addressTo);
                        msg.setSubject(subject);
                        msg.setSentDate(new Date());
                        msg.setText(message);
                        mp = new MimeMultipart();
                        mbp2 = new MimeBodyPart();
                        mbp2.setText(message);
                        mp.addBodyPart((BodyPart)mbp2);
                        var26_27 = filenames;
                        var25_29 = filenames.length;
                        var24_35 = 0;
                        while (var24_35 < var25_29) {
                            filename = var26_27[var24_35];
                            if (filename != null) {
                                mbp = new MimeBodyPart();
                                fds = new FileDataSource(filename);
                                mbp.setDataHandler(new DataHandler((DataSource)fds));
                                mbp.setFileName(fds.getName());
                                mp.addBodyPart((BodyPart)mbp);
                            }
                            msg.setContent((Multipart)mp);
                            ++var24_35;
                        }
                        if (System.getProperty("pasta_boletos") != null) {
                            info = CacheNotas.obterInstancia().obterEstadoNota(id, tpAmb);
                            chave = new GerenciadorChavesNota(info.getId());
                            pasta_boletos = new File(System.getProperty("pasta_boletos"));
                            var30_47 = boletos = pasta_boletos.listFiles(new FilenameFilter(){

                                @Override
                                public boolean accept(File dir, String name) {
                                    return name.contains(String.valueOf(chave.getCnpj()) + "_" + Integer.parseInt(chave.getNumeroNota()));
                                }
                            });
                            var29_48 = boletos.length;
                            var28_46 = 0;
                            while (var28_46 < var29_48) {
                                boleto = var30_47[var28_46];
                                System.out.println("adicionando aquivo de boleto: " + boleto.getAbsolutePath());
                                mbp = new MimeBodyPart();
                                fds = new FileDataSource(boleto.getAbsolutePath());
                                mbp.setDataHandler(new DataHandler((DataSource)fds));
                                mbp.setFileName(fds.getName());
                                mp.addBodyPart((BodyPart)mbp);
                                msg.setContent((Multipart)mp);
                                ++var28_46;
                            }
                        }
                        t = (SMTPTransport)session.getTransport(ssl != false ? "smtps" : "smtp");
                        try {
                            if (auth) {
                                t.connect(mailhost, user, password);
                            } else {
                                t.connect();
                            }
                            t.sendMessage((Message)msg, msg.getAllRecipients());
                        }
                        finally {
                            block29: {
                                try {
                                    t.close();
                                }
                                catch (Exception e) {
                                    if (e.getMessage().indexOf("Connection closed by remote host") >= 0) break block29;
                                    e.printStackTrace();
                                }
                            }
                        }
                        if (!id.startsWith("NFe")) {
                            id = "NFe" + id;
                        }
                        allemailagain = "@";
                        var28_45 = to;
                        var27_44 = to.length;
                        var26_28 = 0;
                        while (var26_28 < var27_44) {
                            string = var28_45[var26_28];
                            allemailagain = String.valueOf(allemailagain) + ", " + string;
                            ++var26_28;
                        }
                        allemailagain = allemailagain.replace("@,", "");
                        log.setDestinatario(allemailagain);
                        log.setKeyxml(id);
                        log.setEstado(LogEnvioEmail.ESTADO_EMAIL.ENVIADO);
                        this.log("Mail was sent successfully.");
                        break block30;
                    }
                    catch (Exception e) {
                        if (!(e instanceof SendFailedException)) break block31;
                        sfe = (MessagingException)e;
                        if (sfe instanceof SMTPSendFailedException) {
                            ssfe = (SMTPSendFailedException)sfe;
                            this.log("Smtp_Send_Failed:");
                        }
                        ** while ((ne = sfe.getNextException()) != null && ne instanceof MessagingException)
                    }
lbl-1000:
                    // 1 sources

                    {
                        sfe = (MessagingException)ne;
                        if (sfe instanceof SMTPAddressFailedException) {
                            ssfe = (SMTPAddressFailedException)sfe;
                            this.log("Address failed:");
                            this.log(ssfe.toString());
                            this.log("  Address: " + ssfe.getAddress());
                            this.log("  Command: " + ssfe.getCommand());
                            this.log("  Return Code: " + ssfe.getReturnCode());
                            this.log("  Response: " + ssfe.getMessage());
                            continue;
                        }
                        if (!(sfe instanceof SMTPAddressSucceededException)) continue;
                        this.log("Address succeeded:");
                        var23_41 = (SMTPAddressSucceededException)sfe;
                        continue;
lbl146:
                        // 1 sources

                        break block32;
                    }
                }
                this.log("Got Exception : " + e);
            }
            if (!id.startsWith("NFe")) {
                id = "NFe" + id;
            }
            allemailagain = "@";
            var25_34 = to;
            var24_39 = to.length;
            var23_42 = 0;
            while (var23_42 < var24_39) {
                string = var25_34[var23_42];
                allemailagain = String.valueOf(allemailagain) + ", " + string;
                ++var23_42;
            }
            log.setKeyxml(id);
            log.setEstado(LogEnvioEmail.ESTADO_EMAIL.NAO_ENVIADO);
            log.setMessage1(String.valueOf(e.getLocalizedMessage()) + " para " + allemailagain);
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void myMailRaw(String[] to, String subj, String mesagem, String[] filenames) throws Exception {
        block21: {
            block23: {
                block22: {
                    from = "alarme@brasmar.com";
                    subject = subj;
                    message = mesagem;
                    mailhost = "smtp.office365.com";
                    user = "alarme@brasmar.com";
                    password = "Luho1693";
                    auth = true;
                    ssl = false;
                    props = System.getProperties();
                    if (mailhost != null) {
                        props.put("mail.smtp.host", mailhost);
                    }
                    if (auth) {
                        props.put("mail.smtp.auth", "true");
                    }
                    props.put("mail.smtp.auth", "true");
                    props.put("mail.smtp.starttls.enable", "true");
                    props.put("mail.smtp.host", mailhost);
                    props.put("mail.smtp.port", "587");
                    session = Session.getInstance((Properties)props, null);
                    msg = new MimeMessage(session);
                    try {
                        addressTo = new InternetAddress[to.length];
                        i = 0;
                        while (i < to.length) {
                            addressTo[i] = new InternetAddress(to[i]);
                            ++i;
                        }
                        msg.setFrom((Address)new InternetAddress(from));
                        msg.setRecipients(Message.RecipientType.TO, (Address[])addressTo);
                        msg.setSubject(subject);
                        msg.setSentDate(new Date());
                        msg.setText(message);
                        mp = new MimeMultipart();
                        mbp2 = new MimeBodyPart();
                        mbp2.setText(message);
                        mp.addBodyPart((BodyPart)mbp2);
                        var22_23 = filenames;
                        var21_24 = filenames.length;
                        var20_27 = 0;
                        while (var20_27 < var21_24) {
                            filename = var22_23[var20_27];
                            if (filename != null) {
                                mbp = new MimeBodyPart();
                                fds = new FileDataSource(filename);
                                mbp.setDataHandler(new DataHandler((DataSource)fds));
                                mbp.setFileName(fds.getName());
                                mp.addBodyPart((BodyPart)mbp);
                            }
                            msg.setContent((Multipart)mp);
                            ++var20_27;
                        }
                        t = (SMTPTransport)session.getTransport(ssl != false ? "smtps" : "smtp");
                        try {
                            if (auth) {
                                t.connect(mailhost, "alarme@brasmar.com", "Luho1693");
                            } else {
                                t.connect();
                            }
                            t.sendMessage((Message)msg, msg.getAllRecipients());
                        }
                        finally {
                            block20: {
                                try {
                                    t.close();
                                }
                                catch (Exception e) {
                                    if (e.getMessage().indexOf("Connection closed by remote host") >= 0) break block20;
                                    e.printStackTrace();
                                }
                            }
                        }
                        this.log("Mail was sent successfully.");
                        break block21;
                    }
                    catch (Exception e) {
                        if (!(e instanceof SendFailedException)) break block22;
                        sfe = (MessagingException)e;
                        if (sfe instanceof SMTPSendFailedException) {
                            ssfe = (SMTPSendFailedException)sfe;
                            this.log("Smtp_Send_Failed:");
                        }
                        ** while ((ne = sfe.getNextException()) != null && ne instanceof MessagingException)
                    }
lbl-1000:
                    // 1 sources

                    {
                        sfe = (MessagingException)ne;
                        if (sfe instanceof SMTPAddressFailedException) {
                            ssfe = (SMTPAddressFailedException)sfe;
                            this.log("Address failed:");
                            this.log(ssfe.toString());
                            this.log("  Address: " + ssfe.getAddress());
                            this.log("  Command: " + ssfe.getCommand());
                            this.log("  Return Code: " + ssfe.getReturnCode());
                            this.log("  Response: " + ssfe.getMessage());
                            continue;
                        }
                        if (!(sfe instanceof SMTPAddressSucceededException)) continue;
                        this.log("Address succeeded:");
                        var19_30 = (SMTPAddressSucceededException)sfe;
                        continue;
lbl97:
                        // 1 sources

                        break block23;
                    }
                }
                this.log("Got Exception : " + e);
            }
            e.printStackTrace();
            throw e;
        }
    }

    public void log(String a) {
        System.out.println(a);
    }

    public void sendCNPJDB2(String id, String tpAmb, String cnpj, String[] filenames) {
        if (cnpj == null) {
            cnpj = "";
        }
        CadastroEmail cad = EmailConsomer.getInstance().findEmails(cnpj);
        CadastroEmail default1 = EmailConsomer.getInstance().findEmails("default");
        String copias = "";
        String allto = String.valueOf(cad.getEmails()) + copias;
        if (cad == null) {
            return;
        }
        String[] tos = MailSender.cleanEmails(allto);
        String subj = default1.getSubject();
        String msg = default1.getMessage();
        String[] stringArray = tos;
        int n = tos.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            System.out.println("Sending to email:" + string);
            ++n2;
        }
        System.out.println("Files:" + filenames[0]);
        try {
            this.myMail(id, tpAmb, tos, subj, msg, filenames, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendCNPJDBEmail(String id, String tpAmb, String allto, String[] filenames) throws Exception {
        String string;
        CadastroEmail default1 = EmailConsomer.getInstance().findEmails("default");
        allto = allto.replace("null,", "");
        allto = allto.replace(",null,", "");
        allto = allto.replace(",null", "");
        allto = allto.replace(",@", "");
        allto = allto.replace(",@,", "");
        allto = allto.replace("@,", "");
        String[] tos = MailSender.cleanEmails(allto);
        String subj = default1.getSubject();
        String msg = default1.getMessage();
        System.out.println("Size length:" + tos.length);
        String[] stringArray = tos;
        int n = tos.length;
        int n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            System.out.println("Sending to email:" + string);
            ++n2;
        }
        stringArray = filenames;
        n = filenames.length;
        n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            System.out.println("Files:" + string);
            ++n2;
        }
        if (subj == null || subj.isEmpty()) {
            subj = "assunto nao cadastrado";
        }
        if (msg == null || msg.isEmpty()) {
            msg = "mensagem nao cadastrado";
        }
        LogEnvioEmail log = new LogEnvioEmail();
        this.myMail(id, tpAmb, tos, subj, msg, filenames, log);
    }

    public void sendCNPJDB(String id, String tpAmb, String cnpjemit, String cnpj, String[] filenames, LogEnvioEmail logemail, boolean without) throws Exception {
        String string3;
        int n;
        int n2;
        String[] stringArray;
        EstadoNFe nota = CacheNotas.obterInstancia().obterEstadoNota(id, tpAmb);
        CadastroEmail exportacad = null;
        if (cnpj == null || cnpj.trim().isEmpty()) {
            cnpj = "";
            exportacad = EmailConsomer.getInstance().findEmails("exporta");
        }
        CadastroEmail cad = EmailConsomer.getInstance().findEmails(cnpj);
        CadastroEmail cademit = EmailConsomer.getInstance().findEmails(cnpjemit);
        CadastroEmail default1 = EmailConsomer.getInstance().findEmails("default");
        CadastroEmail copia = EmailConsomer.getInstance().findEmails(String.valueOf(cnpjemit) + "_copias");
        GerenciadorChavesNota chave = new GerenciadorChavesNota(id);
        boolean sap_boleto = false;
        ArrayList<String> boletos = null;
        if (nota.getGerouBoleto() && PropriedadesMain.isSAPBoleto()) {
            System.out.println("-------> entrou em sap boleto <-------");
            String[] stringArray2 = filenames;
            int n3 = filenames.length;
            int n4 = 0;
            while (n4 < n3) {
                String string2 = stringArray2[n4];
                if (string2.toLowerCase().contains("boleto")) {
                    sap_boleto = true;
                    break;
                }
                ++n4;
            }
            if (!sap_boleto) {
                String[] files;
                String filename = filenames[0];
                String path = "";
                int i = filename.length() - 1;
                while (i > 0) {
                    if (filename.charAt(i) == File.separatorChar) {
                        path = filename.substring(0, i).replace(String.valueOf(File.separatorChar) + "XML" + File.separatorChar, String.valueOf(File.separatorChar) + "BOLETOS" + File.separatorChar);
                        break;
                    }
                    --i;
                }
                File f = new File(path);
                if (f.exists() && (files = f.list()) != null && files.length > 0) {
                    boletos = new ArrayList<String>();
                    stringArray = files;
                    n2 = files.length;
                    n = 0;
                    while (n < n2) {
                        String file = stringArray[n];
                        if (file.toLowerCase().endsWith(".pdf") && file.contains(chave.getNumeroNota())) {
                            boletos.add(String.valueOf(path) + File.separator + file);
                            sap_boleto = true;
                        }
                        ++n;
                    }
                }
            }
        }
        System.out.println("-------> sap_boleto: " + sap_boleto + " <-------");
        if (without && cad == null) {
            cad = default1;
        }
        String allto = "";
        System.out.println("-------> Antes de pegar os emails <-------");
        if (cad != null && cad.getEmails() != null && !cad.getEmails().trim().isEmpty()) {
            System.out.println("-------> Antes de pegar os emails 2 <-------");
            if (sap_boleto || !nota.getGerouBoleto() || !PropriedadesMain.isSAPBoleto()) {
                allto = cad.getEmails();
                System.out.println("-------> Pegou os emails: " + allto + " <-------");
            }
        }
        System.out.println("-------> Passou a pegada de emails <-------");
        if (without && copia != null && copia.getEmails() != null && !copia.getEmails().trim().isEmpty() && !sap_boleto) {
            allto = String.valueOf(allto) + "," + copia.getEmails();
        }
        if (exportacad != null && exportacad.getEmails() != null && !exportacad.getEmails().trim().isEmpty() && !sap_boleto) {
            allto = String.valueOf(allto) + "," + exportacad.getEmails();
        }
        allto = allto.replace("null,", "");
        allto = allto.replace(",null,", "");
        allto = allto.replace(",null", "");
        allto = allto.replace(",@", "");
        allto = allto.replace(",@,", "");
        allto = allto.replace("@,", "");
        logemail.setDestinatario(allto);
        if (cademit == null) {
            cademit = default1;
        }
        if (cademit == null) {
            System.out.println("E-Mail do Emitente n\u00e3o encontrado !!!");
            return;
        }
        String[] tos = MailSender.cleanEmails(allto);
        String subj = cademit.getSubject();
        String msg = cademit.getMessage();
        if (subj == null || subj.isEmpty()) {
            subj = "assunto nao cadastrado";
        }
        if (msg == null || msg.isEmpty()) {
            msg = "mensagem nao cadastrado";
        }
        System.out.println("Size length:" + tos.length);
        stringArray = tos;
        n2 = tos.length;
        n = 0;
        while (n < n2) {
            string3 = stringArray[n];
            System.out.println("Sending to email:" + string3);
            ++n;
        }
        stringArray = filenames;
        n2 = filenames.length;
        n = 0;
        while (n < n2) {
            string3 = stringArray[n];
            System.out.println("Files:" + string3);
            ++n;
        }
        if (tos.length == 0) {
            System.out.println("Nenhum email cadastrado");
            logemail.setEstado(LogEnvioEmail.ESTADO_EMAIL.NAO_CADASTRADO);
            logemail.setKeyxml(id);
            logemail.setAmbiente(tpAmb);
        } else {
            try {
                System.out.println("-------> emails antes de enviar: " + allto + " <-------");
                this.myMail(id, tpAmb, tos, subj, msg, filenames, logemail);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        try {
            logemail.setAmbiente(tpAmb);
            this.logemail.salvar(logemail);
            this.logemail.flush();
            if (nota != null) {
                GerenciadorProxy.gerenciador.atualizarNota(nota);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (boletos != null && !boletos.isEmpty()) {
            allto = "";
            if (!(cad == null || cad.getEmails() == null || cad.getEmails().trim().isEmpty() || !sap_boleto && nota.getGerouBoleto() && PropriedadesMain.isSAPBoleto())) {
                allto = cad.getEmails();
            }
            allto = allto.replace("null,", "");
            allto = allto.replace(",null,", "");
            allto = allto.replace(",null", "");
            allto = allto.replace(",@", "");
            allto = allto.replace(",@,", "");
            allto = allto.replace("@,", "");
            logemail.setDestinatario(allto);
            if (cademit == null) {
                cademit = default1;
            }
            if (cademit == null) {
                System.out.println("E-Mail do Emitente n\u00e3o encontrado !!!");
                return;
            }
            tos = MailSender.cleanEmails(allto);
            System.out.println("Size length:" + tos.length);
            stringArray = tos;
            n2 = tos.length;
            n = 0;
            while (n < n2) {
                string3 = stringArray[n];
                System.out.println("Sending to email:" + string3);
                ++n;
            }
            for (String string3 : boletos) {
                System.out.println("Files:" + string3);
            }
            if (tos.length == 0) {
                System.out.println("Nenhum email cadastrado");
                logemail.setEstado(LogEnvioEmail.ESTADO_EMAIL.NAO_CADASTRADO);
                logemail.setKeyxml(id);
                logemail.setAmbiente(tpAmb);
            } else {
                try {
                    this.myMail(id, tpAmb, tos, subj, msg, boletos.toArray(new String[0]), logemail);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }
            try {
                logemail.setAmbiente(tpAmb);
                this.logemail.salvar(logemail);
                this.logemail.flush();
                if (nota != null) {
                    GerenciadorProxy.gerenciador.atualizarNota(nota);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void sendCNPJDBEvent(String id, String tpAmb, String cnpj, String[] filenames, LogEnvioEmail logemail, boolean without) {
        String string;
        CadastroEmail exportacad = null;
        CadastroEmail cad = EmailConsomer.getInstance().findEmails(cnpj);
        CadastroEmail default1 = EmailConsomer.getInstance().findEmails("cartacorrecao");
        CadastroEmail copia = EmailConsomer.getInstance().findEmails("copias");
        if (without && cad == null) {
            cad = default1;
        }
        String allto = "";
        if (cad != null && cad.getEmails() != null && !cad.getEmails().trim().isEmpty()) {
            allto = cad.getEmails();
        }
        if (without && copia != null && copia.getEmails() != null && !copia.getEmails().trim().isEmpty()) {
            allto = String.valueOf(allto) + "," + copia.getEmails();
        }
        if (exportacad != null && exportacad.getEmails() != null && !exportacad.getEmails().trim().isEmpty()) {
            allto = String.valueOf(allto) + "," + exportacad.getEmails();
        }
        allto = allto.replace("null,", "");
        allto = allto.replace(",null,", "");
        allto = allto.replace(",null", "");
        allto = allto.replace(",@", "");
        allto = allto.replace(",@,", "");
        allto = allto.replace("@,", "");
        logemail.setDestinatario(allto);
        String[] tos = MailSender.cleanEmails(allto);
        String subj = default1.getSubject();
        String msg = default1.getMessage();
        System.out.println("Size length:" + tos.length);
        String[] stringArray = tos;
        int n = tos.length;
        int n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            System.out.println("Sending to email:" + string);
            ++n2;
        }
        stringArray = filenames;
        n = filenames.length;
        n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            System.out.println("Files:" + string);
            ++n2;
        }
        if (tos.length == 0) {
            System.out.println("Nenhum email cadastrado");
            logemail.setEstado(LogEnvioEmail.ESTADO_EMAIL.NAO_CADASTRADO);
            logemail.setKeyxml(id);
            logemail.setAmbiente(tpAmb);
        } else {
            try {
                this.myMail(id, tpAmb, tos, subj, msg, filenames, logemail);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            logemail.setAmbiente(tpAmb);
            this.logemail.salvar(logemail);
            this.logemail.flush();
            EstadoNFe nota = CacheNotas.obterInstancia().obterEstadoNota(id, tpAmb);
            if (nota != null) {
                GerenciadorProxy.gerenciador.atualizarNota(nota);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendCNPJDBCancel(String id, String tpAmb, String cnpj, String[] filenames) {
        if (cnpj == null) {
            cnpj = "";
        }
        CadastroEmail cad = EmailConsomer.getInstance().findEmails(cnpj);
        CadastroEmail default1 = EmailConsomer.getInstance().findEmails("default");
        CadastroEmail copia = EmailConsomer.getInstance().findEmails("copias");
        CadastroEmail cancel = EmailConsomer.getInstance().findEmails("cancelamento");
        String copias = "";
        if (copia != null && copia.getEmails() != null) {
            copias = "," + copia.getEmails();
        }
        if (cad == null) {
            cad = default1;
        }
        String allto = String.valueOf(cad.getEmails()) + copias;
        if (cad == null) {
            return;
        }
        String[] tos = allto.split("\\,");
        String subj = cancel.getSubject();
        String msg = cancel.getMessage();
        System.out.println("Sending to:" + allto);
        System.out.println("Files:" + filenames[0]);
        try {
            this.myMail(id, tpAmb, tos, subj, msg, filenames, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendCNPJ(String id, String tpAmb, String cnpj, String[] filenames) {
        this.bundlescnpjs = ResourceBundle.getBundle("emails_cnpj");
        if (cnpj == null) {
            cnpj = "";
        }
        String to = null;
        String subj = null;
        String msg = null;
        String copias = null;
        try {
            copias = this.bundlescnpjs.getString("email_copias");
        }
        catch (Exception e) {
            copias = this.bundlescnpjs.getString("email_copias");
        }
        try {
            to = this.bundlescnpjs.getString(cnpj);
        }
        catch (Exception e) {
            to = this.bundlescnpjs.getString("default_email");
        }
        if (to.isEmpty()) {
            to = this.bundlescnpjs.getString("default_email");
        }
        try {
            msg = this.bundlescnpjs.getString(String.valueOf(cnpj) + "_mensagem");
        }
        catch (Exception e) {
            msg = this.bundlescnpjs.getString("default_mensagem");
        }
        if (msg.isEmpty()) {
            msg = this.bundlescnpjs.getString("default_mensagem");
        }
        try {
            subj = this.bundlescnpjs.getString(String.valueOf(cnpj) + "_assunto");
        }
        catch (Exception e) {
            subj = this.bundlescnpjs.getString("default_assunto");
        }
        if (subj.isEmpty()) {
            subj = this.bundlescnpjs.getString("default_assunto");
        }
        if (to == null) {
            System.out.println("Nao se encontrou emails para o CNPJ:" + cnpj);
            return;
        }
        if (copias != null) {
            to = String.valueOf(to) + "," + copias.trim();
        }
        String[] tos = to.split("\\,");
        System.out.println("Sending to:" + to);
        System.out.println("Files:" + filenames[0]);
        try {
            this.myMail(id, tpAmb, tos, subj, msg, filenames, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            tos = new String[]{this.bundlescnpjs.getString("default_email_erro")};
            try {
                this.myMail(id, tpAmb, tos, subj, msg, filenames, null);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public void sendToEmail(String id, String tpAmb, String emails, String[] filenames, boolean witoutcopy, LogEnvioEmail logemail) {
        this.bundlescnpjs = ResourceBundle.getBundle("emails_cnpj");
        String to = null;
        String subj = null;
        String msg = null;
        String copias = null;
        to = emails;
        if (to == null) {
            to = "";
        }
        if (witoutcopy && to.isEmpty()) {
            to = this.bundlescnpjs.getString("default_email");
        }
        if (witoutcopy) {
            copias = this.bundlescnpjs.getString("email_copias");
        }
        msg = this.bundlescnpjs.getString("default_mensagem");
        subj = this.bundlescnpjs.getString("default_assunto");
        if (copias != null) {
            to = String.valueOf(to) + "," + copias.trim();
        }
        String[] tos = MailSender.cleanEmails(to);
        System.out.println("Sending to:" + to);
        System.out.println("Files:" + filenames[0]);
        try {
            this.myMail(id, tpAmb, tos, subj, msg, filenames, logemail);
        }
        catch (Exception e) {
            e.printStackTrace();
            tos = new String[]{this.bundlescnpjs.getString("default_email_erro")};
            try {
                this.myMail(id, tpAmb, tos, subj, msg, filenames, null);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        logemail.setDestinatario(to);
        if (tos.length == 0) {
            System.out.println("Nenhum email cadastrado");
            logemail.setEstado(LogEnvioEmail.ESTADO_EMAIL.NAO_CADASTRADO);
            logemail.setKeyxml(id);
            logemail.setAmbiente(tpAmb);
        } else {
            try {
                this.myMail(id, tpAmb, tos, subj, msg, filenames, logemail);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            logemail.setAmbiente(tpAmb);
            this.logemail.salvar(logemail);
            this.logemail.flush();
            EstadoNFe nota = CacheNotas.obterInstancia().obterEstadoNota(id, tpAmb);
            if (nota != null) {
                GerenciadorProxy.gerenciador.atualizarNota(nota);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendIFS(String id, String tpAmb, String cnpj, String[] filenames, LogEnvioEmail log) {
        this.bundlescnpjs = ResourceBundle.getBundle("ifs_email");
        String msg = this.bundlescnpjs.getString("mensagem");
        String subj = this.bundlescnpjs.getString("assunto");
        String url = this.bundlescnpjs.getString("url");
        String sql = this.bundlescnpjs.getString("sql");
        String usuario = this.bundlescnpjs.getString("usuario");
        String senha = this.bundlescnpjs.getString("senha");
        String driver = this.bundlescnpjs.getString("driver");
        String column = this.bundlescnpjs.getString("column");
        String defaultemail = this.bundlescnpjs.getString("default_email");
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e2) {
            e2.printStackTrace();
        }
        try {
            Connection cx = DriverManager.getConnection(url, usuario, senha);
            Statement stat = cx.createStatement();
            sql = sql.replace("%CNPJ%", cnpj);
            System.out.println("Quering:" + sql);
            ResultSet res = stat.executeQuery(sql);
            String emails = "";
            while (res.next()) {
                String email = res.getString(column);
                emails = String.valueOf(emails) + email + ",";
            }
            emails = String.valueOf(emails) + "@";
            if ((emails = emails.replace(",@", "")).trim().equals("@")) {
                emails = defaultemail;
            }
            res.close();
            stat.close();
            String[] tos = MailSender.cleanEmails(emails.trim());
            System.out.println("Sending to:" + emails);
            this.myMail(id, tpAmb, tos, subj, msg, filenames, log);
            try {
                log.setAmbiente(tpAmb);
                this.logemail.salvar(log);
                this.logemail.flush();
                EstadoNFe nota = CacheNotas.obterInstancia().obterEstadoNota(id, tpAmb);
                if (nota != null) {
                    GerenciadorProxy.gerenciador.atualizarNota(nota);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendCNPJEmitente(String id, String tpAmb, String cnpjEmitente, String cnpjDestinatario, String[] filenames) {
        this.bundlescnpjs = ResourceBundle.getBundle("emails_cnpj");
        try {
            this.bundleEmitente = ResourceBundle.getBundle("emails_emitente");
        }
        catch (Exception e) {
            System.out.println("Exception:" + e.getLocalizedMessage());
        }
        String emitentes = null;
        if (this.bundleEmitente != null) {
            try {
                emitentes = this.bundleEmitente.getString(cnpjEmitente);
            }
            catch (Exception e) {
                System.out.println("Exception:" + e.getLocalizedMessage());
            }
        }
        if (cnpjDestinatario == null) {
            cnpjDestinatario = "";
        }
        String to = null;
        String subj = null;
        String msg = null;
        String copias = null;
        try {
            copias = this.bundlescnpjs.getString("email_copias");
        }
        catch (Exception e) {
            copias = this.bundlescnpjs.getString("email_copias");
        }
        try {
            to = this.bundlescnpjs.getString(cnpjDestinatario);
        }
        catch (Exception e) {
            to = this.bundlescnpjs.getString("default_email");
        }
        if (to.isEmpty()) {
            to = this.bundlescnpjs.getString("default_email");
        }
        try {
            msg = this.bundlescnpjs.getString(String.valueOf(cnpjDestinatario) + "_mensagem");
        }
        catch (Exception e) {
            msg = this.bundlescnpjs.getString("default_mensagem");
        }
        if (msg.isEmpty()) {
            msg = this.bundlescnpjs.getString("default_mensagem");
        }
        try {
            subj = this.bundlescnpjs.getString(String.valueOf(cnpjDestinatario) + "_assunto");
        }
        catch (Exception e) {
            subj = this.bundlescnpjs.getString("default_assunto");
        }
        if (subj.isEmpty()) {
            subj = this.bundlescnpjs.getString("default_assunto");
        }
        if (to == null) {
            System.out.println("Nao se encontrou emails para o CNPJ:" + cnpjDestinatario);
            to = "";
        }
        if (copias != null) {
            to = String.valueOf(to) + "," + copias.trim();
        }
        if (emitentes != null) {
            to = String.valueOf(to) + "," + emitentes;
        }
        String[] tos = to.split("\\,");
        Vector<String> tosv = new Vector<String>();
        String[] stringArray = tos;
        int n = tos.length;
        int n2 = 0;
        while (n2 < n) {
            String tt = stringArray[n2];
            if (!tt.trim().isEmpty()) {
                tosv.add(tt);
            }
            ++n2;
        }
        tos = new String[tosv.size()];
        tosv.toArray(tos);
        System.out.println("Sending to:" + to);
        System.out.println("Files:" + filenames[0]);
        try {
            this.myMail(id, tpAmb, tos, subj, msg, filenames, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            tos = new String[]{this.bundlescnpjs.getString("default_email_erro")};
            try {
                this.myMail(id, tpAmb, tos, subj, msg, filenames, null);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public static String filtrarEmails(String emails) {
        String regex = "^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,}$";
        Pattern pattern = Pattern.compile(regex);
        Set emailSet = Arrays.stream(emails.split(",")).map(String::trim).filter(email -> pattern.matcher((CharSequence)email).matches()).collect(Collectors.toCollection(LinkedHashSet::new));
        return String.join((CharSequence)",", emailSet);
    }

    private static String[] cleanEmails(String all) {
        all = MailSender.filtrarEmails(all);
        System.out.println("Tratando emails:" + all);
        String[] mm = all.split("\\,");
        Vector<String> mmv = new Vector<String>();
        String[] stringArray = mm;
        int n = mm.length;
        int n2 = 0;
        while (n2 < n) {
            String mail = stringArray[n2];
            if (!((mail = mail.trim()) == null || mail.trim().isEmpty() || mail.equals("null") || mail.equals("@") || mmv.contains(mail))) {
                mmv.add(mail);
            }
            ++n2;
        }
        String[] mms = new String[mmv.size()];
        mmv.toArray(mms);
        return mms;
    }

    public static void ajustarPropriedadesFwd2(String fileTrust, String fileKey, String passwordTrust, String passwordKey) {
        System.setProperty("javax.net.ssl.keyStore", fileKey);
        System.setProperty("javax.net.ssl.trustStore", fileTrust);
        System.setProperty("javax.net.ssl.keyStorePassword", passwordKey);
        System.setProperty("javax.net.ssl.trustStorePassword", passwordTrust);
        System.setProperty("javax.net.ssl.keyStoreType", "PKCS12");
    }

    public static void main(String[] args) {
        MailSender sender = new MailSender();
        try {
            sender.myMailRaw(new String[]{"crhisnoriega@gmail.com"}, "subject", "mensagem", new String[]{"C:\\saida.pdf"});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

