/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.gerenciador;

import br.com.taragona.nfe.cockpitserver.CockpitServer;
import br.com.taragona.nfe.controle.ControleInterface;
import br.com.taragona.nfe.email.EmailConsomer;
import br.com.taragona.nfe.erpinterface.InterfaceERP;
import br.com.taragona.nfe.gerenciador.GerenciadorInterface;
import br.com.taragona.nfe.mensageiro.MensageiroRemote;
import br.com.taragona.nfe.nfecockpitdesktop.data.Perfil;
import br.com.taragona.nfe.nfecockpitdesktop.data.Usuario;
import br.com.taragona.nfe.nfecockpitdesktop.gerenciadorlistener.GerenciadorListener;
import br.com.taragona.nfe.persistence.CadastroEmail;
import br.com.taragona.nfe.persistence.CodigoNFe;
import br.com.taragona.nfe.persistence.Empresa;
import br.com.taragona.nfe.persistence.EstadoLote;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.persistence.EstadoRecibo;
import br.com.taragona.nfe.persistence.EventoInfo;
import br.com.taragona.nfe.persistence.LogEnvioEmail;
import br.com.taragona.nfe.persistence.LogNFe;
import br.com.taragona.nfe.persistence.Notificacao;
import br.com.taragona.nfe.sender.SenderPort;
import br.com.taragona.nfe.sender.SenderRemote;
import br.com.taragona.nfe.sender.util.ConfiguracaoXML;
import br.com.taragona.nfe.util.ConfiguracaoSys;
import br.com.taragona.nfe.util.GerenciadorSenhas;
import br.com.taragona.nfe.util.ParChave;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.data.BaseDadosConfig;
import br.com.taragona.nfe.util.data.MensageiroConfig;
import br.com.taragona.nfe.util.data.SenderConf;
import br.com.taragona.nfe.util.data.ServicosConfig;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import nfeimpressao.TaragonaInt;

public class Gerenciador
implements GerenciadorInterface {
    private Hashtable<String, MensageiroRemote> mensageiros;
    private Hashtable<String, ControleInterface> controladores;
    private Vector<GerenciadorListener> listeners;
    private Hashtable<String, SenderRemote> senders;
    private Vector<InterfaceERP> interfaces;
    private Vector<TaragonaInt> impressoes;
    private Hashtable<ParChave, String> tipoServicos = new Hashtable();
    private Hashtable<String, PropriedadesSistema.MODO_OP> modoAtual = new Hashtable();
    private Hashtable<String, Long> timeouts = new Hashtable();
    private Hashtable<String, Integer> numeroNotas = new Hashtable();
    private Hashtable<String, Long> tamanhoArquivos = new Hashtable();
    private Hashtable<String, Long> tempoProcessamento = new Hashtable();
    private GerenciadorSenhas senhas;
    private CockpitServer server;

    public Gerenciador() {
        PropriedadesSistema.setBdConfig(this.obterBDConfig());
        this.mensageiros = new Hashtable();
        this.controladores = new Hashtable();
        this.interfaces = new Vector();
        this.impressoes = new Vector();
        this.listeners = new Vector();
        this.senders = new Hashtable();
        this.senhas = new GerenciadorSenhas();
        this.server = new CockpitServer();
        for (String cnpj : ConfiguracaoSys.obterCNPJsRegistrados()) {
            ParChave chave = new ParChave(cnpj, ConfiguracaoSys.getTipoAmbiente());
            this.tipoServicos.put(chave, ConfiguracaoSys.getTipoAmbiente());
            this.modoAtual.put(cnpj, ConfiguracaoSys.getModoOperacao());
            this.numeroNotas.put(cnpj, ConfiguracaoSys.getNNotas().get(cnpj));
            this.timeouts.put(cnpj, ConfiguracaoSys.getTimeouts().get(cnpj));
            this.tempoProcessamento.put(cnpj, ConfiguracaoSys.getTempoProc().get(cnpj));
            this.tamanhoArquivos.put(cnpj, ConfiguracaoSys.getTamanhoLote().get(cnpj));
        }
    }

    @Override
    public void enviarNota(String CNPJEmitente, String CNPJDestino, String idNota, String tpAmb, String nota, Date data, String idUsuario) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.enviarNota(CNPJEmitente, CNPJDestino, idNota, tpAmb, nota, data, idUsuario);
    }

    @Override
    public void enviarNota(String CNPJEmitente, String CNPJDestino, String idNota, String tpAmb, String nota, Date data, Hashtable<String, Object> props, String idUsuario) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.enviarNota(CNPJEmitente, CNPJDestino, idNota, tpAmb, nota, data, props, idUsuario);
    }

    @Override
    public String consultarNota(String idNota, String tpAmb, String idUsuario) throws RemoteException {
        Collection<ControleInterface> ctrls = this.controladores.values();
        ControleInterface ctrl = ctrls.iterator().next();
        return ctrl.consultarNota(idNota, tpAmb, idUsuario);
    }

    @Override
    public String consultarNotaXml(String idNota, String tpAmb, String idUsuario) throws RemoteException {
        Collection<ControleInterface> ctrls = this.controladores.values();
        ControleInterface ctrl = ctrls.iterator().next();
        return ctrl.consultarNotaXml(idNota, tpAmb, idUsuario);
    }

    @Override
    public void enviarNotaErro(String cnpj, String cnpjdest, String idNota, String tpAmb, String xml, String erro, String idUsuario) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.enviarNotaErro(cnpj, cnpjdest, idNota, tpAmb, xml, erro);
    }

    @Override
    public void tentarEnvioNotas(String cnpj, String tpAmb, String idUsuario) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.tentarEnvioNotas(cnpj, tpAmb, idUsuario);
        Collection<ControleInterface> ctrls = this.controladores.values();
        ControleInterface controle = ctrls.iterator().next();
        controle.tentarChecarRecibos(cnpj, idUsuario);
    }

    @Override
    public void cancelarNota(String cnpj, String idNota, String tpAmb, String justificativa, String idUsuario) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.cancelarNota(cnpj, idNota, tpAmb, justificativa, idUsuario);
    }

    @Override
    public String inutilizarNota(String UF, String ano, String cnpj, String mod, String serie, String ini, String fim, String just, String tpAmb, String idUsuario) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        return mensageiro.inutilizarNota(UF, ano, cnpj, mod, serie, ini, fim, just, tpAmb, idUsuario);
    }

    @Override
    public MensageiroRemote obterMensageiro(String id) throws RemoteException {
        MensageiroRemote mensageiro = this.mensageiros.get(id);
        if (mensageiro == null) {
            throw new RemoteException("Mensageiro com id: " + id + " nao registrado");
        }
        return mensageiro;
    }

    @Override
    public ControleInterface obterControlador(String id) throws RemoteException {
        ControleInterface controle = this.controladores.get(id);
        if (controle == null) {
            throw new RemoteException("Controle com id: " + id + " nao registrado");
        }
        return controle;
    }

    @Override
    public void registrarControle(String id, ControleInterface controle) throws RemoteException {
        this.controladores.put(id, controle);
        System.out.println("Controle registrado: " + id + " list-> " + this.controladores.toString());
    }

    @Override
    public void registrarMensageiro(String id, MensageiroRemote mensageiro) throws RemoteException {
        this.mensageiros.put(id, mensageiro);
        System.out.println("Mensageiro registrado: " + id + " list-> " + this.mensageiros.toString());
    }

    @Override
    public Vector<String> obterMensageiros() throws RemoteException {
        Vector<String> msns = new Vector<String>();
        for (String ip : this.mensageiros.keySet()) {
            msns.add(ip);
        }
        return msns;
    }

    private void adicionarObjeto(String cnpj, Hashtable hash, Object obj) {
        Vector<Object> lista = (Vector<Object>)hash.get(cnpj);
        if (lista == null) {
            lista = new Vector<Object>();
        }
        if (!lista.contains(obj)) {
            lista.add(obj);
        }
        hash.put(cnpj, lista);
    }

    @Override
    public Vector<String> obterControles() throws RemoteException {
        Vector<String> ctrls = new Vector<String>();
        for (String ip : this.controladores.keySet()) {
            ctrls.add(ip);
        }
        return ctrls;
    }

    private boolean isMensageiroAtivo(String cnpj) {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        boolean temAtivo = false;
        for (MensageiroRemote msn : msns) {
            try {
                msn.getEstado(cnpj);
            }
            catch (Exception e) {
                continue;
            }
            temAtivo = true;
        }
        return temAtivo;
    }

    @Override
    public void mudarEstadoContingencia(String cnpj, String tpAmb) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        for (MensageiroRemote msn : msns) {
            msn.mudarEstadoContingencia(cnpj, tpAmb);
        }
        Collection<ControleInterface> ctrls = this.controladores.values();
        for (ControleInterface ctrl : ctrls) {
            ctrl.mudarEstadoContingencia(cnpj);
        }
        this.modoAtual.put(cnpj, PropriedadesSistema.MODO_OP.CONTINGENCIA);
    }

    @Override
    public synchronized void mudarEstadoNormalEnvioContingencia(String cnpj, String tpAmb, String idUsuario) throws RemoteException {
        this.modoAtual.put(cnpj, PropriedadesSistema.MODO_OP.NORMAL);
        Collection<ControleInterface> ctrls = this.controladores.values();
        for (ControleInterface ctrl : ctrls) {
            ctrl.mudarEstadoNormal(cnpj);
        }
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        for (MensageiroRemote msn : msns) {
            msn.mudarEstadoNormal(cnpj, tpAmb, idUsuario);
        }
    }

    @Override
    public void mudarEstadoNormalSemEnvio(String cnpj, String tpAmb) throws RemoteException {
        if (this.modoAtual.get(cnpj) != PropriedadesSistema.MODO_OP.NORMAL) {
            this.modoAtual.put(cnpj, PropriedadesSistema.MODO_OP.NORMAL);
            Collection<ControleInterface> ctrls = this.controladores.values();
            for (ControleInterface ctrl : ctrls) {
                ctrl.mudarEstadoNormal(cnpj);
            }
            Collection<MensageiroRemote> msns = this.mensageiros.values();
            for (MensageiroRemote msn : msns) {
                msn.mudarEstadoNormalSemEnvio(cnpj, tpAmb);
            }
        }
    }

    @Override
    public Hashtable[] obterTodosServicos() throws RemoteException {
        return ConfiguracaoSys.obterTodosServicos();
    }

    @Override
    public int estadoOperacao(String cnpj) throws RemoteException {
        PropriedadesSistema.MODO_OP estado = this.modoAtual.get(cnpj);
        if (estado == PropriedadesSistema.MODO_OP.CONTINGENCIA) {
            return 0;
        }
        if (estado == PropriedadesSistema.MODO_OP.NORMAL) {
            return 1;
        }
        return 2;
    }

    @Override
    public Vector<String> obterCNPJRegistrados() throws RemoteException {
        return ConfiguracaoSys.obterCNPJsRegistrados();
    }

    @Override
    public void registrarListener(GerenciadorListener listener) throws RemoteException {
        this.listeners.add(listener);
    }

    @Override
    public void registrarImpressao(TaragonaInt impressao) throws RemoteException {
        int i = this.impressoes.size() - 1;
        while (i >= 0) {
            TaragonaInt imp = this.impressoes.get(i);
            this.impressoes.remove(i);
            --i;
        }
        System.out.println("Impressao registrado: " + impressao.toString());
        this.impressoes.add(impressao);
    }

    @Override
    public void imprimir(String chaveNota, String estado, String xml, Hashtable<String, String> prop) throws RemoteException {
        Vector<TaragonaInt> remove = new Vector<TaragonaInt>();
        for (TaragonaInt imp : this.impressoes) {
            try {
                imp.imprimeDanfe(chaveNota, estado, xml, prop);
            }
            catch (RemoteException e) {
                System.out.println("Eliminando impressao:" + e.getMessage());
                remove.add(imp);
            }
        }
        for (TaragonaInt tar : remove) {
            this.impressoes.remove(tar);
        }
    }

    @Override
    public String assinar(String cnpj, String xml, String tag) throws RemoteException {
        Collection<SenderRemote> sendersCNPJ = this.senders.values();
        SenderRemote sender = sendersCNPJ.iterator().next();
        return sender.assinarCNPJ(cnpj, xml, tag);
    }

    @Override
    public void atualizarLote(EstadoLote lote) throws RemoteException {
        Vector<GerenciadorListener> remove = new Vector<GerenciadorListener>();
        for (GerenciadorListener lis : this.listeners) {
            try {
                lis.atualizarLote(lote);
            }
            catch (Exception e) {
                System.out.println("Eliminando listener:" + e.getMessage());
                remove.add(lis);
            }
        }
        for (GerenciadorListener lis : remove) {
            this.listeners.remove(lis);
        }
    }

    @Override
    public void atualizarNota(EstadoNFe nota) throws RemoteException {
        try {
            Vector<GerenciadorListener> remove = new Vector<GerenciadorListener>();
            for (GerenciadorListener lis : this.listeners) {
                try {
                    lis.atualizarNota(nota);
                }
                catch (Exception e) {
                    System.out.println("Eliminando listener:" + e.getMessage());
                    remove.add(lis);
                }
            }
            for (GerenciadorListener lis : remove) {
                this.listeners.remove(lis);
            }
        }
        catch (Exception e) {
            System.out.println("Erro atualizando nota cockpit");
        }
    }

    @Override
    public void notificarNotaConector(EstadoNFe nota) throws RemoteException {
        try {
            Vector<GerenciadorListener> remove = new Vector<GerenciadorListener>();
            for (GerenciadorListener lis : this.listeners) {
                try {
                    lis.notificarNotaConnector(nota);
                }
                catch (Exception e) {
                    System.out.println("Eliminando listener conector:" + e.getMessage());
                    remove.add(lis);
                }
            }
            for (GerenciadorListener lis : remove) {
                this.listeners.remove(lis);
            }
        }
        catch (Exception e) {
            System.out.println("Erro atualizando nota conector");
        }
    }

    @Override
    public String enviarMensagemXML(String idServico, String cnpj, String cabecalho, String xml, Hashtable prop, String idUsuario) throws RemoteException {
        Collection<SenderRemote> sendersCNPJ = this.senders.values();
        for (SenderRemote sender : sendersCNPJ) {
            try {
                prop.put("TIPO", this.tipoServicos.get(cnpj));
                return sender.enviarMensagemXML(idServico, cnpj, cabecalho, xml, prop, idUsuario);
            }
            catch (RemoteException e) {
                e.printStackTrace();
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void registrarSender(String id, SenderRemote sender) throws RemoteException {
        this.senders.clear();
        this.senders.put(id, sender);
        System.out.println("Sender registrado: " + id + " list-> " + this.senders.toString());
    }

    @Override
    public void registrarInterface(String id, InterfaceERP retorno) throws RemoteException {
        this.interfaces.clear();
        this.interfaces.add(retorno);
        System.out.println("Interface registrada: " + id + " list-> " + this.interfaces.toString());
    }

    @Override
    public void notificarNotasCancelamentoERP(String[] idNotas, String tpAmb) throws RemoteException {
        Vector<InterfaceERP> remove = new Vector<InterfaceERP>();
        for (InterfaceERP interf : this.interfaces) {
            try {
                interf.notificarNotasCancelamentoERP(idNotas, tpAmb);
            }
            catch (RemoteException e) {
                System.out.println("Eliminando interface ERP:" + e.getMessage());
                remove.add(interf);
            }
        }
        for (InterfaceERP r : remove) {
            this.interfaces.remove(r);
        }
    }

    @Override
    public void notificarNotaERP(String chave, String tpAmb, String modo, String protocolo) throws RemoteException {
        Vector<InterfaceERP> remove = new Vector<InterfaceERP>();
        for (InterfaceERP interf : this.interfaces) {
            try {
                interf.notificarNotaERP(chave, tpAmb, modo, protocolo);
            }
            catch (RemoteException e) {
                System.out.println("Eliminando interface ERP:" + e.getMessage());
                remove.add(interf);
            }
        }
        for (InterfaceERP r : remove) {
            this.interfaces.remove(r);
        }
    }

    @Override
    public void retornoExcecao(String chaveNFe, String tpAmb, String metodoAraujoInt, String mensagemExcecao) throws RemoteException {
        Vector<InterfaceERP> remove = new Vector<InterfaceERP>();
        for (InterfaceERP interf : this.interfaces) {
            try {
                interf.retornoExcecao(chaveNFe, tpAmb, metodoAraujoInt, mensagemExcecao);
            }
            catch (RemoteException e) {
                System.out.println("Eliminando interface ERP:" + e.getMessage());
                remove.add(interf);
            }
        }
        for (InterfaceERP r : remove) {
            this.interfaces.remove(r);
        }
    }

    @Override
    public void notificarProtocoloCancelamentoContingecia(String chaveNota, String tpAmb, String protocolo) throws RemoteException {
        Vector<InterfaceERP> remove = new Vector<InterfaceERP>();
        for (InterfaceERP interf : this.interfaces) {
            try {
                interf.notificarProtocoloCancelamentoContingecia(chaveNota, tpAmb, protocolo);
            }
            catch (RemoteException e) {
                System.out.println("Eliminando interface ERP:" + e.getMessage());
                remove.add(interf);
            }
        }
        for (InterfaceERP r : remove) {
            this.interfaces.remove(r);
        }
    }

    @Override
    public void notificarProtocoloCancelamentoNormal(String chaveNota, String tpAmb, String protocolo) throws RemoteException {
        Vector<InterfaceERP> remove = new Vector<InterfaceERP>();
        for (InterfaceERP interf : this.interfaces) {
            try {
                interf.notificarProtocoloCancelamentoNormal(chaveNota, tpAmb, protocolo);
            }
            catch (RemoteException e) {
                System.out.println("Eliminando interface ERP:" + e.getMessage());
                remove.add(interf);
            }
        }
        for (InterfaceERP r : remove) {
            this.interfaces.remove(r);
        }
    }

    @Override
    public void notificarProtocoloInutilizcaoContingecia(String chaveNota, String tpAmb, String protocolo) throws RemoteException {
        Vector<InterfaceERP> remove = new Vector<InterfaceERP>();
        for (InterfaceERP interf : this.interfaces) {
            try {
                interf.notificarProtocoloInutilizcaoContingecia(chaveNota, tpAmb, protocolo);
            }
            catch (RemoteException e) {
                System.out.println("Eliminando interface ERP:" + e.getMessage());
                remove.add(interf);
            }
        }
        for (InterfaceERP r : remove) {
            this.interfaces.remove(r);
        }
    }

    @Override
    public void notificarProtocoloInutilizcaoNormal(String chaveNota, String tpAmb, String protocolo) throws RemoteException {
        Vector<InterfaceERP> remove = new Vector<InterfaceERP>();
        for (InterfaceERP interf : this.interfaces) {
            try {
                interf.notificarProtocoloInutilizcaoNormal(chaveNota, tpAmb, protocolo);
            }
            catch (RemoteException e) {
                System.out.println("Eliminando interface ERP:" + e.getMessage());
                remove.add(interf);
            }
        }
        for (InterfaceERP r : remove) {
            this.interfaces.remove(r);
        }
    }

    @Override
    public String obterTrustStore() throws RemoteException {
        return ConfiguracaoSys.getTrustStore();
    }

    @Override
    public void reImprimirNota(String idNota, String tpAmb, String idUsuario) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.reImprimirNota(idNota, tpAmb, idUsuario);
    }

    @Override
    public void reImprimirNota(String idNota, String tpAmb, String tipo, String idUsuario) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.reImprimirNota(idNota, tpAmb, tipo, idUsuario);
    }

    @Override
    public String obterTxtMiniDanfe(String idNota, String tpAmb, String tipo) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        return mensageiro.obterTxtMiniDanfe(idNota, tpAmb, tipo);
    }

    @Override
    public byte[] obterPdfMiniDanfe(String idNota, String tpAmb, String tipo) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        return mensageiro.obterPdfMiniDanfe(idNota, tpAmb, tipo);
    }

    @Override
    public void registrarUsuario(Usuario usuario, Perfil perfil) throws RemoteException {
        this.server.registrarUsuario(usuario, perfil);
    }

    @Override
    public void removerUsuario(Usuario usuario) throws RemoteException {
        this.server.removerUsuario(usuario);
    }

    @Override
    public Usuario obterUsuario(String login, String senha) throws RemoteException {
        return this.server.obterUsuario(login, senha);
    }

    @Override
    public boolean login(String login, String senha) throws RemoteException {
        return this.server.login(login, senha);
    }

    @Override
    public List<LogNFe> obterHistorico(String idNota, String tpAmb) throws RemoteException {
        return this.server.obterHistorico(idNota, tpAmb);
    }

    @Override
    public Vector obterNotas(String tpAmb, Date d1, Date d2) throws RemoteException {
        return this.server.obterNotas(tpAmb, d1, d2);
    }

    @Override
    public Vector<EstadoNFe> obterNotas(String tpAmb, String CNPJDestinatario, String serie, String n1, String n2, Date d1, Date d2) throws RemoteException {
        return this.server.obterNotas(tpAmb, CNPJDestinatario, serie, n1, n2, d1, d2);
    }

    @Override
    public Vector<EstadoLote> obterLotes(String tpAmb, Date d1) throws RemoteException {
        return this.server.obterLotes(tpAmb, d1);
    }

    @Override
    public CodigoNFe obterCodigo(int codigo) throws RemoteException {
        return this.server.obterCodigo(codigo);
    }

    @Override
    public void ajustarSenhas(Hashtable<String, String> senhas) throws RemoteException {
        for (String arquivo : senhas.keySet()) {
            this.senhas.salvarSenha(arquivo, senhas.get(arquivo));
        }
        try {
            this.senders.clear();
            SenderPort s = new SenderPort(this, ConfiguracaoSys.getArquivoServicos(), null);
            this.senders.put("123", s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean checarSenha(String arquivo, String senha) throws RemoteException {
        return this.senhas.checarSenha(arquivo, senha);
    }

    @Override
    public EstadoLote obterLote(String idNota, String tpAmb) throws RemoteException {
        return this.server.obterLote(idNota, tpAmb);
    }

    @Override
    public Vector<EstadoNFe> obterNotas(String idLote, String tpAmb) throws RemoteException {
        return this.server.obterNotas(idLote, tpAmb);
    }

    @Override
    public EstadoRecibo obterRecibo(String idLote, String tpAmb) throws RemoteException {
        return this.server.obterRecibo(idLote, tpAmb);
    }

    @Override
    public void notificarControle(String cnpj, String idLote, String recibo, Set<String> notas, String tpAmb, String idUsuario) throws RemoteException {
        Collection<ControleInterface> ctrls = this.controladores.values();
        ControleInterface ctrl = ctrls.iterator().next();
        ctrl.notificarControle(cnpj, idLote, recibo, notas, tpAmb, idUsuario);
    }

    @Override
    public void trocarSenha(String login, String senha) throws RemoteException {
        this.server.trocarSenha(login, senha);
    }

    @Override
    public Hashtable<String, String> obterNomesFantasia() throws RemoteException {
        return ConfiguracaoSys.getNomesFantasia();
    }

    @Override
    public void ajustarTipoServico(String cnpj, String tipo) throws RemoteException {
        ParChave chave = new ParChave(cnpj, tipo);
        this.tipoServicos.put(chave, tipo);
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        for (MensageiroRemote msn : msns) {
            msn.ajustarTipoServicos(this.tipoServicos);
        }
    }

    @Override
    public String obterTipoServico(String cnpj) throws RemoteException {
        return this.tipoServicos.get(cnpj);
    }

    @Override
    public void ajustarMensageiroConfig(String cnpj, MensageiroConfig conf) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        for (MensageiroRemote msn : msns) {
            msn.numeroNotas(cnpj, conf.getNumeroNotas());
            msn.timeOut(cnpj, conf.getTimeout());
            msn.tamanhoLote(cnpj, conf.getTamanhoLote());
        }
        Collection<ControleInterface> ctrls = this.controladores.values();
        for (ControleInterface ctrl : ctrls) {
            ctrl.tempoProcessamento(cnpj, conf.getTempoProc());
        }
        this.numeroNotas.put(cnpj, conf.getNumeroNotas());
        this.timeouts.put(cnpj, conf.getTimeout());
        this.tamanhoArquivos.put(cnpj, conf.getTamanhoLote());
        this.tempoProcessamento.put(cnpj, conf.getTempoProc());
    }

    @Override
    public MensageiroConfig obterMensageiroConfig(String cnpj) throws RemoteException {
        MensageiroConfig conf = new MensageiroConfig();
        conf.setOp(this.modoAtual.get(cnpj));
        conf.setNumeroNotas(this.numeroNotas.get(cnpj));
        conf.setTimeout(this.timeouts.get(cnpj));
        conf.setTempoProc(this.tempoProcessamento.get(cnpj));
        conf.setTamanhoLote(this.tamanhoArquivos.get(cnpj));
        conf.setCnpj(cnpj);
        return conf;
    }

    @Override
    public void ajustarServicosConfig(ServicosConfig conf) throws RemoteException {
    }

    @Override
    public ServicosConfig obterServicosConfig() throws RemoteException {
        ServicosConfig conf = new ServicosConfig();
        conf.setArquivosPFX(ConfiguracaoSys.getKeyFiles());
        conf.setTodosEsquemas(ConfiguracaoSys.getVersaoEsquema());
        conf.setCnpjsUf(ConfiguracaoSys.getCnpjsUF());
        conf.setUfs(ConfiguracaoSys.obterUFsCadastrados());
        conf.setArquivoServicos(ConfiguracaoSys.getArquivoServicos());
        conf.setPfxDeTransmissao(ConfiguracaoSys.getPfxDeTransmissao());
        conf.setTipoAmbiente(ConfiguracaoSys.getTipoAmbiente());
        conf.setTrustStore(ConfiguracaoSys.getTrustStore());
        return conf;
    }

    @Override
    public Hashtable<ParChave, String> obterTipoServicos() throws RemoteException {
        return this.tipoServicos;
    }

    @Override
    public BaseDadosConfig obterBDConfig() {
        BaseDadosConfig conf = new BaseDadosConfig();
        conf.setUrl(ConfiguracaoSys.getURL_CONECTION());
        conf.setSenha(ConfiguracaoSys.getPASSWORD());
        conf.setUsuario(ConfiguracaoSys.getUSER_NAME());
        return conf;
    }

    @Override
    public void ajustarTodosServicos(Hashtable[] servicos) throws RemoteException {
        ConfiguracaoSys.ajustarTodosServicos(servicos);
        Collection<SenderRemote> senderss = this.senders.values();
        for (SenderRemote senderRemote : senderss) {
        }
    }

    @Override
    public SenderConf obterSenderConfig() throws RemoteException {
        SenderConf conf = new SenderConf();
        ConfiguracaoXML senderConfig = ConfiguracaoSys.getSenderConfig();
        Hashtable<String, Class> classs = senderConfig.getClasses();
        Hashtable<String, String> class_s = new Hashtable<String, String>();
        for (String t : classs.keySet()) {
            class_s.put(t, classs.get(t).getCanonicalName());
        }
        conf.setClasses(class_s);
        conf.setNamespaceNames(senderConfig.getNamespaceNames());
        conf.setNomeOperacao(senderConfig.getNomeOperacao());
        conf.setNomeServico(senderConfig.getNomeServico());
        conf.setPortNames(senderConfig.getPortNames());
        conf.setUrlServicosHomolgacao(senderConfig.getUrlServicosHomolgacao());
        conf.setUrlServicosNormal(senderConfig.getUrlServicosNormal());
        conf.setUrlServicosScan(senderConfig.getUrlServicosScan());
        return conf;
    }

    @Override
    public void todoEmContingencia(String tpAmb, String idUsuario) throws RemoteException {
        Vector<String> cnpjs = this.obterCNPJRegistrados();
        for (String cnpj : cnpjs) {
            this.mudarEstadoNormalEnvioContingencia(cnpj, tpAmb, idUsuario);
        }
    }

    @Override
    public void criarDpec(String cnpj, String tpAmb) throws RemoteException {
    }

    @Override
    public void enviarNotasDpec(String cnpj, String tpAmb, String idUsuario) throws RemoteException {
    }

    @Override
    public void mudarEstadoDpec(String cnpj, String tpAmb) throws RemoteException {
    }

    @Override
    public String obterXml(String idNota, String tpAmb) throws RemoteException {
        return null;
    }

    @Override
    public void cancelarNota(String cnpj, String mod, String serie, String numero, String just, String tpAmb, String idUsuario) throws RemoteException {
    }

    @Override
    public void inutilizarNumero(String idNota, String tpAmb, String justificativa, String idUsuario) throws RemoteException {
    }

    public void atualizarInut(String serie, String cnpj, String numero, String codigo, String something) throws RemoteException {
    }

    @Override
    public void changeOp(String cnpj, String tpEmis, String tpAmb) throws RemoteException {
    }

    @Override
    public void atualizarInut(String serie, String cnpj, String numero, String codigo, String something, String modo) throws RemoteException {
    }

    @Override
    public void findProtocol(String cnpj, String serie, String numero, String tpAmb, String idUsuario) throws RemoteException {
    }

    @Override
    public Vector<String> findPrinters() throws RemoteException {
        return null;
    }

    @Override
    public Hashtable<String, String> obterImpressorasDefault() throws RemoteException {
        return null;
    }

    @Override
    public Hashtable<String, String> obterImpressorasPermitidas() throws RemoteException {
        return null;
    }

    @Override
    public void setPrinter(String codigo, String printer) throws RemoteException {
    }

    @Override
    public Vector<EstadoNFe> findNota(String tpAmb, String cnpj, String serie, String ini, String fim, Date data) throws RemoteException {
        return null;
    }

    @Override
    public void enviarEmailNota(String id, String tpAmb, Hashtable<String, String> props) throws RemoteException {
    }

    @Override
    public void mudarEstadoScan(String cnpj, String tpAmb) throws RemoteException {
    }

    @Override
    public void addBoletoXML(String id, String xml) throws RemoteException {
    }

    @Override
    public byte[] downloadPDF(String id, String tpAmb, String idUsuario) throws RemoteException {
        return null;
    }

    @Override
    public Vector<EstadoNFe> obterNotas(String tpAmb, Vector<String> cnpjs, String serie, String n1, String n2, Date d1, Date d2) throws RemoteException {
        return null;
    }

    @Override
    public void notificarArquivoNaoTratado(String nomeArquivo, String motivo, String chave) throws RemoteException {
    }

    @Override
    public Vector<String> obterEmails(String cnpj) throws RemoteException {
        return null;
    }

    @Override
    public void checarConsistencia(Vector<String> chaves, String tpAmb, String idUsuario) throws RemoteException {
    }

    @Override
    public void notificarArquivos(Notificacao not) throws RemoteException {
    }

    @Override
    public List<Notificacao> obterNotificacoes(Date d1, Date d2) throws RemoteException {
        return null;
    }

    @Override
    public void persistPrintKey(String id, String key) throws RemoteException {
    }

    @Override
    public void setEmail(String codigo, String emaildest, String emailtransp) throws RemoteException {
    }

    @Override
    public CadastroEmail getEmails(String cnpj) throws RemoteException {
        return null;
    }

    @Override
    public void updateEmail(Hashtable<String, String> table) throws RemoteException {
        EmailConsomer.getInstance().updateEmails(table);
    }

    @Override
    public String adicionarEvento(String keyxml, String tpAmb, EventoInfo info, Hashtable<String, String> props, String idUsuario) throws RemoteException {
        return null;
    }

    @Override
    public List<EventoInfo> obterEventos(String keyxml, String tpAmb, Hashtable<String, String> props) throws RemoteException {
        return null;
    }

    @Override
    public String enviarEvento(String idevento, String keyxml, String tpAmb, Hashtable<String, String> props, String idUsuario) throws RemoteException {
        return null;
    }

    @Override
    public List<LogEnvioEmail> logemail(String keyxml, String tpAmb, Hashtable<String, String> props) throws RemoteException {
        return null;
    }

    @Override
    public EstadoNFe getEstadoNFe(String id, String tpAmb) throws RemoteException {
        return null;
    }

    @Override
    public Hashtable<String, Hashtable<String, Object>> readAllPFXPRoperties() throws RemoteException {
        return null;
    }

    @Override
    public String dowloadLog(File file, Hashtable<String, String> props) throws RemoteException {
        return null;
    }

    @Override
    public Vector<File> logList(Hashtable<String, String> props) throws RemoteException {
        return null;
    }

    @Override
    public void registerOperacao(Hashtable<String, String> props) throws RemoteException {
    }

    @Override
    public void enviarNotaErro(String cnpj, String idNota, String tpAmb, String xml, String erro, String idUsuario) throws RemoteException {
    }

    @Override
    public Hashtable<String, Object> genericRemoteCall(Hashtable<String, Object> params, String tpAmb, String idUsuario) throws RemoteException {
        return null;
    }

    @Override
    public void enviarEmailNota(String id, String tpAmb) throws RemoteException {
    }

    @Override
    public byte[] downloadFile(String filename, File file, Hashtable<String, Object> props) throws RemoteException {
        return null;
    }

    @Override
    public File process(String tpAmb, Vector<String> cnpjsemit, Vector<String> cnpjsdest, Date d1, Date d2, Hashtable<String, String> props) throws RemoteException {
        return null;
    }

    @Override
    public Vector<EstadoNFe> findXMLDocument(String query, Hashtable<String, Object> params, Hashtable<String, String> tablequery) throws RemoteException {
        return null;
    }

    @Override
    public String saveXMLDocument(String id, String xml, Hashtable<String, String> prop) throws RemoteException {
        return null;
    }

    @Override
    public File createRelatorio(Hashtable<String, String> headerdata, Vector<EstadoNFe> infos) throws RemoteException {
        return null;
    }

    @Override
    public File process(String tpAmb, Vector<String> xmls) throws RemoteException {
        return null;
    }

    @Override
    public String xmlCCe(String id, String tpAmb, int number) throws RemoteException {
        return null;
    }

    @Override
    public void changeModeTo(String cnpj, PropriedadesSistema.MODO_OP modoop, Hashtable<String, Object> params) throws RemoteException {
    }

    @Override
    public List<Empresa> empresasLFU(String login, String tpAmb) throws RemoteException {
        return null;
    }

    @Override
    public void registerEmpresaLFU(String tpAmb, String login, Empresa emp) throws RemoteException {
    }

    @Override
    public List<Empresa> findEmpresa(String tpAmb, String cnpj, String razaosocial, Hashtable<String, Object> params) throws RemoteException {
        return null;
    }

    @Override
    public void enviarNotasEPEC(String cnpj, String tpAmb, String idUsuario) throws RemoteException {
    }

    @Override
    public void notificarEventoCCe(String chave, String response) throws RemoteException {
    }
}

