/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.main;

import br.com.taragona.nfe.clientreferencia.ReferenciaGerenciador;
import br.com.taragona.nfe.controle.Controle;
import br.com.taragona.nfe.controle.ControleInterface;
import br.com.taragona.nfe.gerenciador.GerenciadorInterface;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import java.net.InetAddress;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;

public class IniciarControle {
    private static String OBJECTNAME = "controle";
    private Controle controle;
    private String objname = "//localhost/" + OBJECTNAME;
    private GerenciadorInterface gerenciador = this.obterGerenciador();

    public IniciarControle() {
        try {
            PropriedadesSistema.setBdConfig(this.gerenciador.obterBDConfig());
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        if (this.gerenciador == null) {
            System.out.println("Gerenciador nao encontrado!");
            System.exit(100);
        }
        GerenciadorProxy.setGerenciador(this.gerenciador);
        try {
            this.controle = new Controle(this.gerenciador);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private GerenciadorInterface obterGerenciador() {
        Vector<String> ips = PropriedadesMain.getIps();
        GerenciadorInterface ger = null;
        for (String ip : ips) {
            try {
                ger = ReferenciaGerenciador.obterReferenciaGerenciador(ip);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ger;
    }

    private void register() {
        ControleInterface cos = null;
        try {
            cos = (ControleInterface)UnicastRemoteObject.exportObject((Remote)this.controle, 0);
            Registry reg = LocateRegistry.getRegistry();
            reg.rebind(OBJECTNAME, cos);
            String id = InetAddress.getLocalHost().getHostAddress().toString();
            this.gerenciador.registrarControle(id, cos);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Controle nao registrado em gerenciador!!");
        }
    }

    public static void main(String[] argv) {
        PropriedadesMain.processarComandos(argv);
        IniciarControle i = new IniciarControle();
        i.register();
        System.out.println("Controle Iniciado");
    }
}

