/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.main;

import br.com.taragona.nfe.gerenciador.Gerenciador;
import br.com.taragona.nfe.gerenciador.GerenciadorInterface;
import br.com.taragona.nfe.main.IniciarGerenciadorOnce;
import br.com.taragona.nfe.sender.util.MyAuthenticator;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.tti.sefaz.sender.dispatch.SenderDispatchController;
import br.com.tti.sefaz.util.MainParameters;
import java.net.Authenticator;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ResourceBundle;

public class IniciarGerenciador {
    private static String OBJECTNAME = "gerenciador";
    private Gerenciador gerenciador;
    private String host = System.getProperty("java.rmi.server.hostname", "localhost");
    private String objname = "//" + this.host + "/" + OBJECTNAME;

    public IniciarGerenciador() {
        this.gerenciador = new Gerenciador();
    }

    public void registrar() {
        try {
            GerenciadorInterface ger = (GerenciadorInterface)UnicastRemoteObject.exportObject((Remote)this.gerenciador, PropriedadesMain.getPorta());
            Registry reg = LocateRegistry.getRegistry(this.host, PropriedadesMain.getPorta());
            reg.rebind(OBJECTNAME, ger);
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            SenderDispatchController.isPaired = true;
        }
        catch (Throwable e) {
            System.out.println("jar TTINFePartch errado!");
            System.exit(-222);
        }
        PropriedadesMain.processarComandos(args);
        MainParameters.processArguments((String[])args);
        if (PropriedadesMain.isProxy()) {
            ResourceBundle rb = ResourceBundle.getBundle("proxy");
            MyAuthenticator.loginStatic = rb.getString("usuario");
            MyAuthenticator.passStatic = rb.getString("senha");
            MyAuthenticator.httpsHost = rb.getString("servidor");
            MyAuthenticator.httpsPort = rb.getString("porta");
            Authenticator.setDefault(new MyAuthenticator(MyAuthenticator.loginStatic, MyAuthenticator.passStatic));
            System.getProperties().put("proxySet", "true");
            System.getProperties().put("https.proxyHost", MyAuthenticator.httpsHost);
            System.getProperties().put("https.proxyPort", MyAuthenticator.httpsPort);
        }
        if (PropriedadesMain.isRmiregistry()) {
            try {
                int porta = PropriedadesMain.getPorta();
                if (porta < 1) {
                    porta = 1099;
                }
                LocateRegistry.createRegistry(porta);
                System.out.println("rmiregistry iniciado");
            }
            catch (RemoteException e) {
                System.out.println("Nao foi possivel iniciar o rmiregistry");
                System.exit(1);
            }
        }
        long inicio = System.currentTimeMillis();
        if (PropriedadesMain.isLocal()) {
            System.out.println("Inicializando o GerenciadorOnce");
            IniciarGerenciadorOnce i = new IniciarGerenciadorOnce();
            System.out.println("GerenciadorOnce Inicializado");
            i.registrar();
            long total = System.currentTimeMillis() - inicio;
            System.out.println("Gerenciador Local Iniciado em " + total + " ms");
        } else {
            IniciarGerenciador i = new IniciarGerenciador();
            i.registrar();
            long total = System.currentTimeMillis() - inicio;
            System.out.println("Gerenciador Iniciado em " + total + " ms");
        }
        System.out.println("Versao v8.1.0 - SERVER/INGRAM - contingencia SVC/NFe 3.10/Sender por pfx/email/EPEC/retorno/salva boleto/XML Denegada");
    }
}

