/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.main;

import br.com.taragona.nfe.clientreferencia.ReferenciaGerenciador;
import br.com.taragona.nfe.gerenciador.GerenciadorInterface;
import br.com.taragona.nfe.mensageiro.Mensageiro;
import br.com.taragona.nfe.mensageiro.MensageiroRemote;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import java.net.InetAddress;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;

public class IniciarMensageiro {
    private static String OBJECTNAME = "mensageiro";
    private Mensageiro msn;
    private String objname = "//localhost/" + OBJECTNAME;
    private GerenciadorInterface gerenciador = this.obterGerenciador();

    public IniciarMensageiro(String idUsuario) {
        try {
            PropriedadesSistema.setBdConfig(this.gerenciador.obterBDConfig());
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        if (this.gerenciador == null) {
            System.out.println("Gerenciador nao encontrado!");
            System.exit(100);
        }
        GerenciadorProxy.setGerenciador(this.gerenciador);
        try {
            this.msn = new Mensageiro(this.gerenciador);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private GerenciadorInterface obterGerenciador() {
        Vector<String> ips = PropriedadesMain.getIps();
        GerenciadorInterface ger = null;
        for (String ip : ips) {
            try {
                ger = ReferenciaGerenciador.obterReferenciaGerenciador(ip);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ger;
    }

    private void register() {
        MensageiroRemote obj = null;
        try {
            obj = (MensageiroRemote)UnicastRemoteObject.exportObject((Remote)this.msn, 0);
            Registry reg = LocateRegistry.getRegistry();
            reg.rebind("mensageiro", obj);
            String id = InetAddress.getLocalHost().getHostAddress().toString();
            this.gerenciador.registrarMensageiro(id, obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Mensageiro nao registrado em gerenciador!!");
        }
    }

    public static void main(String[] argv) {
        PropriedadesMain.processarComandos(argv);
        IniciarMensageiro i = new IniciarMensageiro(null);
        i.register();
        System.out.println("Mensageiro Iniciado");
    }
}

