/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.mensageiro;

import br.com.taragona.nfe.cockpitserver.CockpitPartch;
import br.com.taragona.nfe.controle.ControleLotesAsString;
import br.com.taragona.nfe.controle.ControleLotesAsStringInstance;
import br.com.taragona.nfe.danfe.ImprimirDANFE;
import br.com.taragona.nfe.danfe.ImprimirDANFEImpl;
import br.com.taragona.nfe.gerenciador.GerenciadorInterface;
import br.com.taragona.nfe.mensageiro.Mensageiro;
import br.com.taragona.nfe.mensageiro.MonitorarBoletosService;
import br.com.taragona.nfe.mensageiro.TratadorLoteThread;
import br.com.taragona.nfe.mensageiro.caches.CacheNotas;
import br.com.taragona.nfe.mensageiro.contingencia.ContingenciaDPEC;
import br.com.taragona.nfe.mensageiro.contingencia.EstrategiaContingencia;
import br.com.taragona.nfe.mensageiro.contingencia.TratadorContingenciaTaragona;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.Empresa;
import br.com.taragona.nfe.persistence.EntidadeCnpj;
import br.com.taragona.nfe.persistence.EntidadeId;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.persistence.EstadoNFeOld;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.IDSetManager;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.logger.LoggingJava;
import br.com.taragona.nfe.util.logger.NFeLogger;
import br.com.taragona.nfe.util.xml.XMLFactory;
import br.com.tti.sefaz.epec.EstrategiaEPECImpl;
import java.io.ByteArrayInputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class GerenaciadoLotesAsString
extends Thread {
    private static Random rand = new Random(Calendar.getInstance().getTimeInMillis());
    private int NUMERO_NOTAS;
    private Long MAX_TAMANHO_ARQUIVO;
    private Long TIME_OUT;
    private Long INTERVALO;
    private PropriedadesSistema.MODO_OP modoAtual;
    private PropriedadesSistema.ESTRATEGIA estrategiaAtual;
    private Vector<String> bufferNotas;
    private Long tamanhoLote = 0L;
    private Long timeOut;
    private CacheNotas cacheNotas;
    private Set<String> notasDoLote = new HashSet<String>();
    private EstrategiaContingencia contigencia;
    private EstrategiaContingencia contingenciaDpec;
    private boolean isSuspend = false;
    private ImprimirDANFE imprimir = new ImprimirDANFEImpl();
    private boolean stop = false;
    private Hashtable<String, TratadorLoteThread> threadLotes;
    private ControleLotesAsString consultor;
    private String tpAmb;
    private String CNPJ;
    private String UF;
    private DAOGenerico<EstadoNFeOld> daoNotaOld;
    private DAOGenerico<EstadoNFe> daoNota;
    private DAOGenerico<Empresa> daoEmp;

    public GerenaciadoLotesAsString(String tpAmb, String CNPJ, String UF, PropriedadesSistema.MODO_OP modoAtual, DAOGenerico<EstadoNFe> daoNota, DAOGenerico<EstadoNFeOld> daoNotaOld, DAOGenerico<Empresa> daoEmp) {
        this.daoNota = daoNota;
        this.daoNotaOld = daoNotaOld;
        this.daoEmp = daoEmp;
        this.tpAmb = tpAmb;
        this.CNPJ = CNPJ;
        this.UF = UF;
        this.modoAtual = modoAtual;
        this.bufferNotas = new Vector();
        this.timeOut = Calendar.getInstance().getTimeInMillis();
        this.cacheNotas = CacheNotas.obterInstancia();
        this.consultor = new ControleLotesAsStringInstance(this.tpAmb, this.CNPJ, this.UF);
        this.threadLotes = new Hashtable();
        this.contingenciaDpec = new ContingenciaDPEC(this.CNPJ);
        this.estrategiaAtual = PropriedadesSistema.ESTRATEGIA.TARAGONA;
        this.ajustarEstrategia(this.estrategiaAtual, null);
    }

    private void backupNota(EstadoNFe nota) {
        EstadoNFeOld old = new EstadoNFeOld();
        this.daoNota.refresh(nota);
        old.setIdNota(nota.getId());
        old.setAmbiente(nota.getAmbiente());
        old.setCnpj(nota.getCnpj());
        old.setAssinada(nota.isAssinada());
        old.setCnpjDestino(nota.getCnpjDestino());
        old.setDataActualizacao(nota.getDataActualizada());
        old.setDataAutorizada(nota.getDataAutorizada());
        old.setDataEnviada(nota.getDataEnviada());
        old.setDataGerada(nota.getDataGerada());
        old.setEstado(nota.getEstado());
        old.setEstadoNFe(nota.getEstadoNFe());
        old.setModoOperacao(nota.getModoOperacao());
        old.setXmlStringRecibo(nota.getXmlStringRecibo());
        old.setXmlString(nota.getXmlString());
        old.setProtocoloXML(nota.getProtocoloXML());
        old.setLote(null);
        this.daoNotaOld.salvar(old);
    }

    public void preProcessarNota(String CNPJEmitente, String CNPJDestino, String idNota, String tpAmb, String nota, Date data, Hashtable<String, Object> props, String idUsuario) throws RemoteException {
        List<String> pagamentos;
        EntidadeId id = new EntidadeId(idNota, tpAmb);
        EstadoNFe existente = this.daoNota.buscarPorIdObject(id);
        PropriedadesSistema.MODO_OP lastOp = null;
        boolean wasCont = false;
        if (existente != null) {
            this.daoNota.refresh(existente);
            GerenciadorProxy.getGerenciador().atualizarNota(existente);
            if (existente.getEstado() != EstadoNFe.ESTADO_NFE.AUTORIZADA && existente.getEstado() != EstadoNFe.ESTADO_NFE.CANCELADA && existente.getEstado() != EstadoNFe.ESTADO_NFE.INUTILIZADA && existente.getEstado() != EstadoNFe.ESTADO_NFE.USO_DENEGADO) {
                if (existente.getModoOperacao() == PropriedadesSistema.MODO_OP.CONTINGENCIA || existente.getModoOperacao() == PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC || existente.getModoOperacao() == PropriedadesSistema.MODO_OP.CONTINGENCIA_EPEC || existente.getModoOperacao() == PropriedadesSistema.MODO_OP.CONTINGENCIA_SCAN) {
                    lastOp = existente.getModoOperacao();
                    wasCont = true;
                }
            } else {
                GerenciadorProxy.getGerenciador().retornoExcecao(existente.getId(), tpAmb, "enviarNota", "NF-e ja autorizada/cancelada/inutilizada/denegada na SEFAZ:" + existente.getId());
                GerenciadorProxy.notificarNotaConector(existente);
                throw new RemoteException("NF-e ja autorizada/cancelada/inutilizada/denegada na SEFAZ:" + existente.getId());
            }
        }
        GerenciadorInterface gerenciador = GerenciadorProxy.getGerenciador();
        try {
            System.out.println("Assinando nota: " + idNota);
            nota = this.tirarCabecalho(nota.replace(" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", ""));
            nota = gerenciador.assinar(CNPJEmitente, nota, "infNFe");
            nota = nota.replace("<NFe>", "<NFe xmlns=\"http://www.portalfiscal.inf.br/nfe\">");
        }
        catch (Exception e) {
            GerenciadorProxy.getGerenciador().retornoExcecao(idNota, tpAmb, "enviarNota", "Problemas na assinatura da nota: " + idNota);
            System.out.println("Problemas na assinatura da nota: " + nota);
            return;
        }
        EstadoNFe e = new EstadoNFe();
        e.setAssinada(false);
        e.setId(idNota);
        e.setAmbiente(tpAmb);
        e.setDataGerada(new Date());
        e.setEstado(EstadoNFe.ESTADO_NFE.GERADA);
        e.setXmlString(nota);
        e.setDataActualizada(data);
        if (wasCont) {
            e.setModoOperacao(lastOp);
        } else {
            e.setModoOperacao(this.modoAtual);
        }
        e.setCnpj(CNPJEmitente);
        e.setCnpjDestino(CNPJDestino);
        e.setEstadoNFe(null);
        e.setDataEnviada(null);
        e.setLote(null);
        e.setServerName(PropriedadesMain.getServerName());
        if (props != null) {
            try {
                if (props.containsKey("cnpjtransp") && props.get("cnpjtransp") != null && props.containsKey("transpnome") && props.get("transpnome") != null) {
                    String cnpjtransp = props.get("cnpjtransp").toString();
                    e.setCnpjTransp(cnpjtransp);
                    String transpnome = props.get("transpnome").toString();
                    EntidadeCnpj eCnpj = new EntidadeCnpj(cnpjtransp, tpAmb);
                    Empresa emp = this.daoEmp.buscarPorIdObject(eCnpj);
                    if (emp == null) {
                        emp = new Empresa();
                        emp.setCnpj(cnpjtransp);
                        emp.setAmbiente(tpAmb);
                        emp.setNome(transpnome);
                        emp.setTipo(Empresa.TIPO_EMPRESA.TRANSP);
                        this.daoEmp.salvar(emp);
                        this.daoEmp.flush();
                    }
                }
                if (CNPJDestino != null && !CNPJDestino.isEmpty() && props.containsKey("destnome") && props.get("destnome") != null) {
                    String destnome = props.get("destnome").toString();
                    EntidadeCnpj eCnpj = new EntidadeCnpj(CNPJDestino, tpAmb);
                    Empresa emp = this.daoEmp.buscarPorIdObject(eCnpj);
                    if (emp == null) {
                        emp = new Empresa();
                        emp.setCnpj(CNPJDestino);
                        emp.setAmbiente(tpAmb);
                        emp.setNome(destnome);
                        emp.setTipo(Empresa.TIPO_EMPRESA.DEST);
                        this.daoEmp.salvar(emp);
                        this.daoEmp.flush();
                    }
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        System.out.println("props: " + props);
        if (props != null && props.get("TYPE_CUSTOMER") != null) {
            String texto;
            String tipoCustomer = props.get("TYPE_CUSTOMER").toString();
            String string = texto = props.get("TXT") != null ? props.get("TXT").toString() : "";
            if (tipoCustomer.contains("Site") || tipoCustomer.contains("UNILOG")) {
                e.setOutros(String.valueOf(tipoCustomer) + "|" + texto);
            } else {
                String pedido = props.get("PEDIDO") != null ? props.get("PEDIDO").toString() : "";
                String demi = props.get("DEMI") != null ? props.get("DEMI").toString() : "";
                e.setOutros(String.valueOf(tipoCustomer) + "|" + pedido + "|" + demi);
            }
        }
        if (props != null && props.get("TEXTO_AVULSO") != null && !props.get("TEXTO_AVULSO").equals("")) {
            e.setObservacao(props.get("TEXTO_AVULSO").toString());
        }
        if (PropriedadesMain.isSAPBoleto() && (pagamentos = this.extrairFormasPagamento(nota)).size() > 0) {
            for (String pag : pagamentos) {
                if (!pag.equals("15")) continue;
                e.setGerouBoleto(true);
                break;
            }
        }
        if (existente != null) {
            this.daoNota.refresh(existente);
            if (existente.getEstado() != EstadoNFe.ESTADO_NFE.AUTORIZADA) {
                this.daoNota.unir(e);
            }
        } else {
            this.daoNota.salvar(e);
        }
        this.daoNota.flush();
        this.adicionarNota(idNota, tpAmb, nota, idUsuario);
        LoggingJava.logger.log(Level.WARNING, "nota ja processada:" + idNota);
        if (PropriedadesMain.isSAPBoleto() && e.getGerouBoleto()) {
            MonitorarBoletosService.getInstance().agendarNota(idNota, tpAmb, nota, CNPJEmitente, CNPJDestino, data, idUsuario);
        }
    }

    public void preProcessarNota(String CNPJEmitente, String CNPJDestino, String idNota, String tpAmb, String nota, Date data, String idUsuario) throws RemoteException {
        this.preProcessarNota(CNPJEmitente, CNPJDestino, idNota, tpAmb, nota, data, null, idUsuario);
    }

    public synchronized void adicionarNota(String idNota, String tpAmb, String nota, String idUsuario) {
        System.out.println("Adicionando nota: " + idNota);
        GerenciadorProxy.notificarNota(this.cacheNotas.obterEstadoNota(idNota, tpAmb));
        System.out.println("-------> Antes de chamar o log <-------");
        NFeLogger.log(idNota, tpAmb, Mensageiro.modoAtual.get(this.CNPJ), EstadoNFe.ESTADO_NFE.GERADA, null, idUsuario);
        System.out.println("-------> Depois de chamar o log <-------");
        nota = this.tirarCabecalho(nota);
        this.timeOut = Calendar.getInstance().getTimeInMillis();
        if (this.notasDoLote.contains(idNota)) {
            return;
        }
        if (this.bufferNotas.size() < this.NUMERO_NOTAS && this.tamanhoLote + XMLFactory.tamanhoLoteVazio() + (long)nota.length() < this.MAX_TAMANHO_ARQUIVO) {
            this.bufferNotas.add(nota);
            this.notasDoLote.add(idNota);
            this.tamanhoLote = this.tamanhoLote + (long)nota.length();
        } else {
            String idLote = this.obterIDLote();
            String lote = XMLFactory.montarLote(idLote, this.bufferNotas, this.CNPJ);
            TratadorLoteThread tratador = new TratadorLoteThread(idLote, tpAmb, lote, this.CNPJ, this.UF, this.notasDoLote, this.modoAtual, this.imprimir, this.threadLotes, idUsuario);
            this.threadLotes.put(idLote, tratador);
            this.bufferNotas = new Vector();
            this.notasDoLote.clear();
            this.tamanhoLote = 0L;
            this.bufferNotas.add(nota);
            this.notasDoLote.add(idNota);
            this.tamanhoLote = this.tamanhoLote + (long)nota.length();
            Thread t = new Thread(tratador);
            t.start();
        }
    }

    public synchronized void enviarLote(String tpAmb, String idUsuario) {
        try {
            String idLote = this.obterIDLote();
            String lote = XMLFactory.montarLote(idLote, this.bufferNotas, this.CNPJ);
            if (tpAmb == null || tpAmb.equals("")) {
                tpAmb = CockpitPartch.getValueByTag(lote, "tpAmb");
                if (tpAmb == null || tpAmb.equals("")) {
                    tpAmb = XMLFactory.obterTipoAmbiente(this.CNPJ, tpAmb);
                }
            } else {
                String ambiente = CockpitPartch.getValueByTag(lote, "tpAmb");
                if (ambiente != null && !ambiente.equals("") && !ambiente.equals(tpAmb)) {
                    tpAmb = ambiente;
                }
            }
            TratadorLoteThread tratador = new TratadorLoteThread(idLote, tpAmb, lote, this.CNPJ, this.UF, this.notasDoLote, this.modoAtual, this.imprimir, this.threadLotes, idUsuario);
            this.threadLotes.put(idLote, tratador);
            this.bufferNotas = new Vector();
            this.notasDoLote.clear();
            this.tamanhoLote = 0L;
            Thread t = new Thread(tratador);
            t.start();
        }
        catch (Exception e) {
            System.out.println("Erro timeout: " + e.getMessage());
        }
    }

    private String obterIDLote() {
        return IDSetManager.getNexIdSet().toString();
    }

    public synchronized void ajustarModoOperacao(PropriedadesSistema.MODO_OP modo) {
        this.modoAtual = modo;
    }

    public synchronized void ajustarModoEnvio(String tpAmb, String idUsuario) {
        this.modoAtual = PropriedadesSistema.MODO_OP.NORMAL;
        System.out.println("Modo Normal:" + this.CNPJ);
        this.contigencia.salirDeContingencia(tpAmb, idUsuario);
    }

    public synchronized void ajustarModoContingenciaDpec(String tpAmb) {
        this.modoAtual = PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC;
        System.out.println("Modo Contingencia DPEC:" + this.CNPJ);
        this.contingenciaDpec.entrarEmContingencia(tpAmb);
    }

    public synchronized void chageToMode(PropriedadesSistema.MODO_OP modoop) {
        this.modoAtual = modoop;
        System.out.println("Alterado para modo de opera\u00e7\u00e3o:" + (Object)((Object)modoop));
    }

    public synchronized void enviarNotasContingenciaDpec(String tpAmb, String idUsuario) {
        this.modoAtual = PropriedadesSistema.MODO_OP.NORMAL;
        System.out.println("Enviando notas Modo Contingencia DPEC:" + this.CNPJ);
        this.contingenciaDpec.salirDeContingencia(tpAmb, idUsuario);
    }

    public synchronized void ajustarModoContigencia(String tpAmb) {
        this.modoAtual = PropriedadesSistema.MODO_OP.CONTINGENCIA;
        System.out.println("Modo Contingencia:" + this.CNPJ);
        this.contigencia.entrarEmContingencia(tpAmb);
    }

    public synchronized void ajustarEstrategia(PropriedadesSistema.ESTRATEGIA estrategia, String idUsuario) {
        if (estrategia == PropriedadesSistema.ESTRATEGIA.TARAGONA) {
            this.contigencia = new TratadorContingenciaTaragona(this.CNPJ, this.consultor);
        }
        this.estrategiaAtual = estrategia;
    }

    private void checkTimeout(String tpAmb, String idUsuario) {
        if (Calendar.getInstance().getTimeInMillis() - this.timeOut > this.TIME_OUT && !this.bufferNotas.isEmpty()) {
            System.out.println("Enviando por timeout");
            this.enviarLote(tpAmb, idUsuario);
            this.timeOut = Calendar.getInstance().getTimeInMillis();
        }
    }

    private String tirarCabecalho(String nota) {
        int posicao = nota.indexOf("<NFe");
        return nota.substring(posicao);
    }

    public String getCNPJ() {
        return this.CNPJ;
    }

    public void setCNPJ(String cnpj) {
        this.CNPJ = cnpj;
    }

    @Override
    public void run() {
        while (!this.stop) {
            this.checkTimeout(null, null);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public EstrategiaContingencia getContigencia() {
        return this.contigencia;
    }

    public void setContigencia(EstrategiaContingencia contigencia) {
        this.contigencia = contigencia;
    }

    public void reiniciarServicos() {
    }

    private void killThreads() {
        for (String idLote : this.threadLotes.keySet()) {
            TratadorLoteThread t = this.threadLotes.get(idLote);
            t.setStop(true);
        }
    }

    public boolean isIsSuspend() {
        return this.isSuspend;
    }

    public void setIsSuspend(boolean isSuspend) {
        this.isSuspend = isSuspend;
    }

    public PropriedadesSistema.MODO_OP getModoAtual() {
        return this.modoAtual;
    }

    public PropriedadesSistema.ESTRATEGIA getEstrategiaAtual() {
        return this.estrategiaAtual;
    }

    public int getNUMERO_NOTAS() {
        return this.NUMERO_NOTAS;
    }

    public void setNUMERO_NOTAS(int numero_notas) {
        this.NUMERO_NOTAS = numero_notas;
    }

    public Long getMAX_TAMANHO_ARQUIVO() {
        return this.MAX_TAMANHO_ARQUIVO;
    }

    public void setMAX_TAMANHO_ARQUIVO(Long max_tamanho_arquivo) {
        this.MAX_TAMANHO_ARQUIVO = max_tamanho_arquivo;
    }

    public Long getTIME_OUT() {
        return this.TIME_OUT;
    }

    public void setTIME_OUT(Long time_out) {
        this.TIME_OUT = time_out;
    }

    public Long getINTERVALO() {
        return this.INTERVALO;
    }

    public void setINTERVALO(Long intervalo) {
        this.INTERVALO = intervalo;
    }

    public synchronized void ajustarModoScan() {
        this.modoAtual = PropriedadesSistema.MODO_OP.CONTINGENCIA_SCAN;
        System.out.println("Modo SCAN:" + this.CNPJ);
    }

    public synchronized void enviarNotasContingenciaEPEC(String tpAmb, String idUsuario) {
        this.modoAtual = PropriedadesSistema.MODO_OP.NORMAL;
        System.out.println("Enviando notas Modo Contingencia EPEC:" + this.CNPJ);
        EstrategiaEPECImpl epecimpl = new EstrategiaEPECImpl(this.CNPJ);
        epecimpl.salirDeContingencia(tpAmb, idUsuario);
    }

    private synchronized List<String> extrairFormasPagamento(String xml) {
        ArrayList<String> pagamentos = new ArrayList<String>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(xml.getBytes()));
            NodeList nodes = doc.getElementsByTagName("tPag");
            int i = 0;
            while (i < nodes.getLength()) {
                pagamentos.add(nodes.item(i).getTextContent());
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pagamentos;
    }
}

