/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.mensageiro;

import br.com.taragona.nfe.cancinut.CanceladorInutilizador;
import br.com.taragona.nfe.clientreferencia.ReferenciaGerenciador;
import br.com.taragona.nfe.controle.ControleLotesAsStringInstance;
import br.com.taragona.nfe.danfe.ImprimirDANFEImpl;
import br.com.taragona.nfe.danfe.ReImprimirThread;
import br.com.taragona.nfe.dpec.GeradorDPEC;
import br.com.taragona.nfe.gerenciador.GerenciadorInterface;
import br.com.taragona.nfe.mensageiro.CancelarThread;
import br.com.taragona.nfe.mensageiro.EnviarThread;
import br.com.taragona.nfe.mensageiro.GerenaciadoLotesAsString;
import br.com.taragona.nfe.mensageiro.MensageiroRemote;
import br.com.taragona.nfe.mensageiro.MonitorarBoletosService;
import br.com.taragona.nfe.mensageiro.caches.CacheNotas;
import br.com.taragona.nfe.nfecockpitdesktop.gerenciadorlistener.GerenciadorListener;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.Empresa;
import br.com.taragona.nfe.persistence.EntidadeId;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.persistence.EstadoNFeOld;
import br.com.taragona.nfe.util.ConfiguracaoSys;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.ParChave;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.data.MensageiroConfig;
import br.com.taragona.nfe.util.data.ServicosConfig;
import br.com.taragona.nfe.util.extract.XMLFormer;
import br.com.taragona.nfe.util.logger.NFeLogger;
import br.com.taragona.nfe.util.xml.XMLFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationID;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class Mensageiro
implements MensageiroRemote {
    public static Hashtable<String, PropriedadesSistema.MODO_OP> modoAtual = new Hashtable();
    private Hashtable<String, GerenaciadoLotesAsString> gerenciadores;
    private DAOGenerico<EstadoNFe> daoNota = new DAOGenerico(EstadoNFe.class);
    private DAOGenerico<EstadoNFeOld> daoNotaOld = new DAOGenerico(EstadoNFeOld.class);
    private DAOGenerico<Empresa> daoEmp = new DAOGenerico(Empresa.class);
    private GerenciadorInterface gerenciador;
    private CanceladorInutilizador cancInut;
    private ImprimirDANFEImpl imprimir = new ImprimirDANFEImpl();
    private Hashtable<String, String> cnpjsUfs;
    private ServicosConfig servicosConf;
    private XMLFormer former;

    public Mensageiro(ActivationID id, MarshalledObject<String> m) throws RemoteException {
        try {
            this.gerenciador = ReferenciaGerenciador.obterReferenciaGerenciador(m.get());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GerenciadorProxy.setGerenciador(this.gerenciador);
        this.servicosConf = this.gerenciador.obterServicosConfig();
        this.cnpjsUfs = this.servicosConf.getCnpjsUf();
        PropriedadesSistema.setBdConfig(this.gerenciador.obterBDConfig());
        XMLFactory.setVersaoEsquema(this.servicosConf.getTodosEsquemas());
        XMLFactory.setTipoAmbienteDefault(this.servicosConf.getTipoAmbiente());
        XMLFactory.setTipoServicos(this.gerenciador.obterTipoServicos());
        XMLFactory.setCnpjsUfs(this.cnpjsUfs);
        this.gerenciadores = new Hashtable();
        this.cancInut = new CanceladorInutilizador();
        this.former = new XMLFormer(ConfiguracaoSys.getTipoAmbiente());
        try {
            this.inicializarMensageiros();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Mensageiro(GerenciadorInterface gerenciador) throws RemoteException {
        GerenciadorProxy.setGerenciador(gerenciador);
        this.servicosConf = gerenciador.obterServicosConfig();
        this.cnpjsUfs = this.servicosConf.getCnpjsUf();
        PropriedadesSistema.setBdConfig(gerenciador.obterBDConfig());
        XMLFactory.setVersaoEsquema(this.servicosConf.getTodosEsquemas());
        XMLFactory.setTipoAmbienteDefault(this.servicosConf.getTipoAmbiente());
        XMLFactory.setTipoServicos(gerenciador.obterTipoServicos());
        XMLFactory.setCnpjsUfs(this.cnpjsUfs);
        this.gerenciador = gerenciador;
        this.gerenciadores = new Hashtable();
        this.cancInut = new CanceladorInutilizador();
        this.former = new XMLFormer(ConfiguracaoSys.getTipoAmbiente());
        try {
            this.inicializarMensageiros();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actualiarParametros() throws RemoteException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void inicializarMensageiros() throws Exception {
        Vector<String> cnpjs = this.gerenciador.obterCNPJRegistrados();
        for (String cnpj : cnpjs) {
            int estado = this.gerenciador.estadoOperacao(cnpj);
            if (estado == 0) {
                modoAtual.put(cnpj, PropriedadesSistema.MODO_OP.CONTINGENCIA);
            } else if (estado == 8) {
                modoAtual.put(cnpj, PropriedadesSistema.MODO_OP.CONTINGENCIA_EPEC);
            } else {
                modoAtual.put(cnpj, PropriedadesSistema.MODO_OP.NORMAL);
            }
            GerenaciadoLotesAsString ger = new GerenaciadoLotesAsString(this.servicosConf.getTipoAmbiente(), cnpj, this.cnpjsUfs.get(cnpj), modoAtual.get(cnpj), this.daoNota, this.daoNotaOld, this.daoEmp);
            MensageiroConfig config = this.gerenciador.obterMensageiroConfig(cnpj);
            ger.setNUMERO_NOTAS(config.getNumeroNotas());
            ger.setMAX_TAMANHO_ARQUIVO(config.getTamanhoLote());
            ger.setTIME_OUT(config.getTimeout());
            ger.start();
            this.gerenciadores.put(cnpj, ger);
        }
        if (PropriedadesMain.isSAPBoleto()) {
            MonitorarBoletosService.getInstance().iniciar(this.daoNota);
        }
    }

    @Override
    public void enviarNotaErro(String cnpj, String idNota, String tpAmb, String xml, String erro, String idUsuario) throws RemoteException {
        this.enviarNotaErro(cnpj, null, idNota, tpAmb, xml, erro, idUsuario);
    }

    @Override
    public void enviarNotaErro(String CNPJEmitente, String cnpjdest, String idNota, String tpAmb, String xml, String erro, String idUsuario) throws RemoteException {
        EstadoNFe e;
        System.out.println("Nota Erro: " + idNota);
        GerenaciadoLotesAsString ger = this.gerenciadores.get(CNPJEmitente.trim());
        if (ger == null) {
            throw new RemoteException("CNPJ nao cadastrado no TaragonaNFe" + CNPJEmitente);
        }
        EntidadeId eid = new EntidadeId(idNota, tpAmb);
        EstadoNFe existente = this.daoNota.buscarPorIdObject(eid);
        if (existente != null) {
            this.daoNota.refresh(existente);
            if (existente.getEstado() == EstadoNFe.ESTADO_NFE.AUTORIZADA) {
                throw new RemoteException("Nota ja autorizada na SEFAZ:" + idNota);
            }
        }
        if ((e = this.daoNota.buscarPorIdObject(eid)) == null) {
            e = new EstadoNFe();
        }
        e.setAssinada(false);
        e.setId(idNota);
        System.out.println("ambiente: " + tpAmb);
        e.setAmbiente(tpAmb);
        e.setDataGerada(new Date());
        e.setEstado(EstadoNFe.ESTADO_NFE.ERRO_VALIDACAO);
        e.setXmlString(xml);
        e.setModoOperacao(ger.getModoAtual());
        e.setCnpj(CNPJEmitente);
        e.setCnpjDestino(cnpjdest);
        e.setMotivoErro(erro);
        e.setServerName(PropriedadesMain.getServerName());
        this.daoNota.salvar(e);
        this.daoNota.flush();
        GerenciadorProxy.notificarNota(e);
        GerenciadorProxy.notificarNotaConector(e);
        NFeLogger.log(idNota, tpAmb, modoAtual.get(CNPJEmitente), EstadoNFe.ESTADO_NFE.ERRO_VALIDACAO, null, idUsuario);
    }

    private String tirarAssinatura(String nota) {
        int i1 = nota.indexOf("<Signature");
        int i2 = nota.indexOf("</Signature>");
        if (i1 < 0 || i2 < 0) {
            return nota;
        }
        String assinatura = nota.substring(i1, i2 + "</Signature>".length());
        return nota.replace(assinatura, "");
    }

    @Override
    public void checarConsistencia(Vector<String> chaves, String tpAmb, String idUsuario) throws RemoteException {
        EstadoNFe nota;
        EntidadeId eid;
        GerenciadorInterface ger = GerenciadorProxy.getGerenciador();
        Field field = null;
        Vector conectores = null;
        try {
            field = ger.getClass().getDeclaredField("conectores");
            field.setAccessible(true);
            conectores = (Vector)field.get(ger);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GerenciadorListener conectorDB = null;
        if (conectores != null) {
            for (GerenciadorListener lis : conectores) {
                try {
                    String tipo = lis.tipoListener();
                    if (tipo == null || !tipo.equals("CONECTOR_DB")) continue;
                    conectorDB = lis;
                    break;
                }
                catch (Exception tipo) {
                    // empty catch block
                }
            }
        }
        System.out.println("Notas a consultar:" + chaves.toString());
        for (String chave : chaves) {
            eid = new EntidadeId(chave, tpAmb);
            nota = this.daoNota.buscarPorIdObject(eid);
            this.cancInut.consultarNota(nota.getId(), tpAmb, true, idUsuario);
        }
        System.out.println("Notas a enviar:" + chaves.toString());
        for (String chave : chaves) {
            eid = new EntidadeId(chave, tpAmb);
            nota = this.daoNota.buscarPorIdObject(eid);
            try {
                if (nota.getXmlString() == null) continue;
                this.daoNota.refresh(nota);
                System.out.println((Object)nota.getEstado());
                if (nota.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.CANCELADA) || nota.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.USO_DENEGADO)) continue;
                Long estadoCodigo = nota.getEstadoNFe();
                boolean autorizada = PropriedadesSistema.isCodigoAutorizado(estadoCodigo);
                if (!autorizada || estadoCodigo != null && estadoCodigo.equals(217L)) {
                    if (conectorDB != null) {
                        conectorDB.atualizarNota(nota);
                        continue;
                    }
                    if (nota.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.ERRO_VALIDACAO) || nota.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.ERRO_ESQUEMA)) continue;
                    String notaString = this.tirarAssinatura(nota.getXmlString());
                    ger.enviarNota(nota.getCnpj(), nota.getCnpjDestino(), nota.getId(), tpAmb, notaString, nota.getDataActualizada(), idUsuario);
                    continue;
                }
                nota.setEstado(EstadoNFe.ESTADO_NFE.AUTORIZADA);
                this.daoNota.unir(nota);
            }
            catch (Exception e) {
                System.out.println("Problemas no reenvio");
                e.printStackTrace();
            }
        }
    }

    @Override
    public void tentarEnvioNotas(String cnpj, String tpAmb, String idUsuario) throws RemoteException {
        Vector<EstadoNFe> notasEnviadas = CacheNotas.obterInstancia().obterNotasEnviadas(cnpj.trim(), Calendar.getInstance().getTime());
        System.out.println("notas a consultar:" + notasEnviadas.toString());
        System.out.println("cnpj:" + cnpj);
        for (EstadoNFe nota : notasEnviadas) {
            EntidadeId eid = new EntidadeId(nota.getId(), tpAmb);
            nota = this.daoNota.buscarPorIdObject(eid);
            this.cancInut.consultarNota(nota.getId(), tpAmb, false, idUsuario);
        }
        Vector<EstadoNFe> notas = CacheNotas.obterInstancia().obterNotasNaoEnviadas(cnpj.trim(), Calendar.getInstance().getTime());
        System.out.println("notas a enviar:" + notas.toString());
        System.out.println("cnpj:" + cnpj);
        for (EstadoNFe nota : notas) {
            EntidadeId eid = new EntidadeId(nota.getId(), tpAmb);
            nota = this.daoNota.buscarPorIdObject(eid);
            try {
                if (nota.getXmlString() == null) continue;
                Long estadoCodigo = nota.getEstadoNFe();
                boolean autorizada = PropriedadesSistema.isCodigoAutorizado(estadoCodigo);
                if (!autorizada || estadoCodigo != null && estadoCodigo.equals(217L)) {
                    String notaString = this.tirarAssinatura(nota.getXmlString());
                    GerenciadorProxy.getGerenciador().enviarNota(nota.getCnpj(), nota.getCnpjDestino(), nota.getId(), tpAmb, notaString, nota.getDataActualizada(), idUsuario);
                    continue;
                }
                nota.setEstado(EstadoNFe.ESTADO_NFE.AUTORIZADA);
                this.daoNota.unir(nota);
            }
            catch (Exception e) {
                System.out.println("Problemas no reenvio");
                e.printStackTrace();
            }
        }
    }

    @Override
    public void enviarNotaLaser(String CNPJEmitente, String Destino, String idNota, String tpAmb, String nota) throws RemoteException {
        Vector<String> cnpjs = this.gerenciador.obterCNPJRegistrados();
        if (!cnpjs.contains(CNPJEmitente)) {
            throw new RemoteException("CNPJ nao cadastrado no TaragonaNFe: " + CNPJEmitente);
        }
        EstadoNFe e = new EstadoNFe();
        e.setAssinada(false);
        e.setId(idNota);
        e.setAmbiente(tpAmb);
        e.setDataGerada(new Date());
        e.setEstado(EstadoNFe.ESTADO_NFE.GERADA);
        e.setXmlString(nota);
        e.setModoOperacao(PropriedadesSistema.MODO_OP.LASER);
        e.setCnpj(CNPJEmitente);
        e.setCnpjDestino(Destino);
        this.daoNota.salvar(e);
        try {
            this.gerenciador.imprimir(idNota, "Laser", nota, null);
        }
        catch (Exception ex) {
            e.setMotivoErro(ex.getMessage());
            e.setEstado(EstadoNFe.ESTADO_NFE.ERRO_IMPRESSAO);
            this.daoNota.unir(e);
            return;
        }
        e.setEstado(EstadoNFe.ESTADO_NFE.IMPRESSA_LASER);
        this.daoNota.unir(e);
    }

    private String lerArquivo(String id) {
        ResourceBundle rb = ResourceBundle.getBundle("pastas_cnpj");
        GerenciadorChavesNota chave = new GerenciadorChavesNota(id);
        String path = rb.getString(chave.getCnpj());
        String file = String.valueOf(path) + "\\NFe_" + chave.getCnpj() + "_" + Integer.parseInt(chave.getSerie()) + "_" + Integer.parseInt(chave.getNumeroNota()) + ".xml";
        String xml = ImprimirDANFEImpl.lerArquivo(file);
        return xml;
    }

    @Override
    public void enviarNota(String CNPJEmitente, String CNPJDestino, String idNota, String tpAmb, String nota, Date data, String idUsuario) throws RemoteException {
        GerenaciadoLotesAsString ger = this.gerenciadores.get(CNPJEmitente);
        if (ger == null) {
            throw new RemoteException("CNPJ nao cadastrado no TaragonaNFe: " + CNPJEmitente);
        }
        try {
            String coding = "";
            coding = PropriedadesMain.isUtf() ? "UTF-8" : "ISO-8859-1";
            nota = new String(nota.getBytes(), Charset.forName(coding));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        EnviarThread e = new EnviarThread(ger, CNPJEmitente, CNPJDestino, idNota, tpAmb, nota, data, null, idUsuario);
        Thread t = new Thread(e);
        t.start();
    }

    @Override
    public void enviarNota(String CNPJEmitente, String CNPJDestino, String idNota, String tpAmb, String nota, Date data, Hashtable<String, Object> props, String idUsuario) throws RemoteException {
        GerenaciadoLotesAsString ger = this.gerenciadores.get(CNPJEmitente);
        if (ger == null) {
            throw new RemoteException("CNPJ nao cadastrado no TaragonaNFe: " + CNPJEmitente);
        }
        try {
            String coding = "";
            coding = PropriedadesMain.isUtf() ? "UTF-8" : "ISO-8859-1";
            nota = new String(nota.getBytes(), Charset.forName(coding));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        EnviarThread e = new EnviarThread(ger, CNPJEmitente, CNPJDestino, idNota, tpAmb, nota, data, props, idUsuario);
        Thread t = new Thread(e);
        t.start();
    }

    private String tirarCabecalho(String nota) {
        int posicao = nota.indexOf("<NFe");
        if (posicao < 0) {
            return nota;
        }
        return nota.substring(posicao);
    }

    @Override
    public int getEstado(String cnpj) throws RemoteException {
        GerenaciadoLotesAsString msn = this.gerenciadores.get(cnpj);
        if (msn.getModoAtual() == PropriedadesSistema.MODO_OP.CONTINGENCIA) {
            return 0;
        }
        if (msn.getModoAtual() == PropriedadesSistema.MODO_OP.NORMAL) {
            return 1;
        }
        return -1;
    }

    @Override
    public void ajustarEstrategia(int estrategia, String idUsuario) throws RemoteException {
        for (String cnpj : this.gerenciadores.keySet()) {
            if (estrategia == 0) {
                this.gerenciadores.get(cnpj).ajustarEstrategia(PropriedadesSistema.ESTRATEGIA.MANUAL_CONTINGENCIA, idUsuario);
            }
            if (estrategia != 1) continue;
            this.gerenciadores.get(cnpj).ajustarEstrategia(PropriedadesSistema.ESTRATEGIA.TARAGONA, idUsuario);
        }
    }

    @Override
    public void cancelarNota(String cnpj, String mod, String serie, String numero, String just, String tpAmb, String idUsuario) throws RemoteException {
        CacheNotas cache = CacheNotas.obterInstancia();
        EstadoNFe nota = cache.procurarNota(cnpj, mod, serie, numero);
        System.out.println("Achou nota para cancelar: " + nota.getId());
        if (nota != null) {
            this.cancelarNota(cnpj, tpAmb, nota.getId(), just, idUsuario);
        }
    }

    @Override
    public void cancelarNota(String cnpj, String idNota, String tpAmb, String justificativa, String idUsuario) throws RemoteException {
        if (!idNota.startsWith("NFe")) {
            idNota = "NFe" + idNota.trim();
        }
        GerenciadorChavesNota chave = new GerenciadorChavesNota(idNota);
        Vector<String> cnpjs = this.gerenciador.obterCNPJRegistrados();
        if (!cnpjs.contains(chave.getCnpj())) {
            throw new RemoteException("CNPJ nao cadastrado no TaragonaNFe: " + chave.getCnpj());
        }
        EntidadeId eid = new EntidadeId(idNota, tpAmb);
        EstadoNFe existente = this.daoNota.buscarPorIdObject(eid);
        if (existente != null) {
            this.daoNota.refresh(existente);
            GerenciadorProxy.getGerenciador().atualizarNota(existente);
            if (existente.getEstado() == EstadoNFe.ESTADO_NFE.CANCELADA) {
                throw new RemoteException("NF-e ja cancelada no TTINFe: " + idNota);
            }
        }
        CancelarThread c = new CancelarThread(this.cancInut, idNota, tpAmb, justificativa, idUsuario);
        Thread t = new Thread(c);
        t.start();
    }

    @Override
    public String inutilizarNota(String UF, String ano, String cnpj, String mod, String serie, String ini, String fim, String just, String tpAmb, String idUsuario) throws RemoteException {
        try {
            return this.cancInut.inutilizarNota(UF, ano, cnpj, mod, serie, ini, fim, just, false, tpAmb, idUsuario);
        }
        catch (Exception e) {
            RemoteException re = new RemoteException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
    }

    @Override
    public void inutilizarNumero(String idNota, String tpAmb, String justificativa, String idUsuario) throws RemoteException {
        try {
            this.cancInut.inutulizarNota(idNota, tpAmb, justificativa, false, idUsuario);
        }
        catch (Exception e) {
            RemoteException re = new RemoteException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
    }

    @Override
    public void mudarEstadoContingencia(String cnpj, String tpAmb) throws RemoteException {
        try {
            GerenaciadoLotesAsString gerenciador = this.gerenciadores.get(cnpj);
            if (gerenciador == null) {
                throw new RemoteException("CNPJ nao registrado: " + cnpj);
            }
            modoAtual.put(cnpj, PropriedadesSistema.MODO_OP.CONTINGENCIA);
            gerenciador.ajustarModoContigencia(tpAmb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void criarDpec(String cnpj, String tpAmb) throws RemoteException {
        try {
            GerenaciadoLotesAsString gerenciador = this.gerenciadores.get(cnpj);
            if (gerenciador == null) {
                throw new RemoteException("CNPJ nao registrado: " + cnpj);
            }
            GeradorDPEC.setPASTA_ARQUIVOS(ConfiguracaoSys.getPastaWrapper());
            GeradorDPEC gerador = new GeradorDPEC(cnpj, null);
            gerador.criarArquivosDpec();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void enviarNotasEPEC(String cnpj, String tpAmb, String idUsuario) throws RemoteException {
        try {
            GerenaciadoLotesAsString gerenciador = this.gerenciadores.get(cnpj);
            if (gerenciador == null) {
                throw new RemoteException("CNPJ nao registrado: " + cnpj);
            }
            modoAtual.put(cnpj, PropriedadesSistema.MODO_OP.NORMAL);
            gerenciador.enviarNotasContingenciaEPEC(tpAmb, idUsuario);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void enviarNotasDpec(String cnpj, String tpAmb, String idUsuario) throws RemoteException {
        try {
            GerenaciadoLotesAsString gerenciador = this.gerenciadores.get(cnpj);
            if (gerenciador == null) {
                throw new RemoteException("CNPJ nao registrado: " + cnpj);
            }
            modoAtual.put(cnpj, PropriedadesSistema.MODO_OP.NORMAL);
            gerenciador.enviarNotasContingenciaDpec(tpAmb, idUsuario);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void mudarEstadoNormal(String cnpj, String tpAmb, String idUsuario) throws RemoteException {
        try {
            GerenaciadoLotesAsString gerenciador = this.gerenciadores.get(cnpj);
            if (gerenciador == null) {
                throw new RemoteException("CNPJ nao registrado: " + cnpj);
            }
            modoAtual.put(cnpj, PropriedadesSistema.MODO_OP.NORMAL);
            gerenciador.ajustarModoEnvio(tpAmb, idUsuario);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void mudarEstadoNormalSemEnvio(String cnpj, String tpAmb) throws RemoteException {
        try {
            GerenaciadoLotesAsString gerenciador = this.gerenciadores.get(cnpj);
            if (gerenciador == null) {
                throw new RemoteException("CNPJ nao registrado: " + cnpj);
            }
            modoAtual.put(cnpj, PropriedadesSistema.MODO_OP.NORMAL);
            gerenciador.ajustarModoOperacao(PropriedadesSistema.MODO_OP.NORMAL);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getNumeroNotas(String cnpj) throws RemoteException {
        GerenaciadoLotesAsString gerenciador = this.gerenciadores.get(cnpj);
        if (gerenciador == null) {
            throw new RemoteException("CNPJ nao registrado: " + cnpj);
        }
        return gerenciador.getNUMERO_NOTAS();
    }

    @Override
    public Long getTamanhoLote(String cnpj) throws RemoteException {
        return null;
    }

    @Override
    public Long getTimeOut(String cnpj) throws RemoteException {
        GerenaciadoLotesAsString gerenciador = this.gerenciadores.get(cnpj);
        if (gerenciador == null) {
            throw new RemoteException("CNPJ nao registrado: " + cnpj);
        }
        return gerenciador.getTIME_OUT();
    }

    @Override
    public void numeroNotas(String cnpj, int quantidade) throws RemoteException {
        GerenaciadoLotesAsString gerenciador = this.gerenciadores.get(cnpj);
        if (gerenciador == null) {
            throw new RemoteException("CNPJ nao registrado: " + cnpj);
        }
        gerenciador.setNUMERO_NOTAS(quantidade);
    }

    @Override
    public void tamanhoLote(String cnpj, Long tamanho) throws RemoteException {
        GerenaciadoLotesAsString gerenciador = this.gerenciadores.get(cnpj);
        if (gerenciador == null) {
            throw new RemoteException("CNPJ nao registrado: " + cnpj);
        }
        gerenciador.setMAX_TAMANHO_ARQUIVO(tamanho);
    }

    @Override
    public void timeOut(String cnpj, Long time) throws RemoteException {
        GerenaciadoLotesAsString gerenciador = this.gerenciadores.get(cnpj);
        if (gerenciador == null) {
            throw new RemoteException("CNPJ nao registrado: " + cnpj);
        }
        gerenciador.setTIME_OUT(time);
    }

    @Override
    public void registrarGerenciador(GerenciadorInterface gerenciador) throws RemoteException {
        GerenciadorProxy.setGerenciador(gerenciador);
    }

    private void backupNota(EstadoNFe nota) {
        EstadoNFeOld old = new EstadoNFeOld();
        this.daoNota.refresh(nota);
        old.setIdNota(nota.getId());
        old.setCnpj(nota.getCnpj());
        old.setAssinada(nota.isAssinada());
        old.setCnpjDestino(nota.getCnpjDestino());
        old.setDataActualizacao(nota.getDataActualizada());
        old.setDataAutorizada(nota.getDataAutorizada());
        old.setDataEnviada(nota.getDataEnviada());
        old.setDataGerada(nota.getDataGerada());
        old.setEstado(nota.getEstado());
        old.setEstadoNFe(nota.getEstadoNFe());
        old.setModoOperacao(nota.getModoOperacao());
        old.setXmlStringRecibo(nota.getXmlStringRecibo());
        old.setXmlString(nota.getXmlString());
        old.setProtocoloXML(nota.getProtocoloXML());
        old.setLote(null);
        this.daoNotaOld.unir(old);
    }

    @Override
    @Deprecated
    public void reImprimirNota(String idNota, String tpAmb, String idUsuario) throws RemoteException {
        ReImprimirThread re = new ReImprimirThread(this.imprimir, idNota, tpAmb, "IMPRIMIR/PDF", idUsuario);
        Thread t = new Thread(re);
        t.start();
    }

    @Override
    public void reImprimirNota(String idNota, String tpAmb, String tipo, String idUsuario) throws RemoteException {
        if (!tipo.startsWith("etiqueta")) {
            ReImprimirThread re = new ReImprimirThread(this.imprimir, idNota, tpAmb, tipo, idUsuario);
            Thread t = new Thread(re);
            t.start();
        } else {
            String[] params = tipo.split("\\|");
            try {
                this.imprimir.reImprimirNota(idNota, tpAmb, params[1], params[2], idUsuario);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String obterTxtMiniDanfe(String idNota, String tpAmb, String tipo) throws RemoteException {
        String txt = "";
        try {
            txt = this.imprimir.obterTxtMiniDanfe(idNota, tpAmb, tipo, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return txt;
    }

    @Override
    public byte[] obterPdfMiniDanfe(String idNota, String tpAmb, String tipo) throws RemoteException {
        byte[] bytes = null;
        try {
            bytes = this.imprimir.obterPdfMiniDanfe(idNota, tpAmb, tipo, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes;
    }

    @Override
    public void ajustarTipoServicos(Hashtable<ParChave, String> tipoServicos) throws RemoteException {
        XMLFactory.setTipoServicos(tipoServicos);
    }

    @Override
    public void findProtocol(String cnpj, String serie, String numero, String tpAmb, String idUsuario) throws RemoteException {
        EstadoNFe estado = CacheNotas.obterInstancia().procurarNota(cnpj, "55", serie, numero);
        if (estado != null) {
            GerenciadorChavesNota chave = new GerenciadorChavesNota(estado.getId());
            ControleLotesAsStringInstance controle = new ControleLotesAsStringInstance(tpAmb, estado.getCnpj(), chave.getUF());
            controle.consularNota(estado.getId(), tpAmb, false, idUsuario);
            estado = CacheNotas.obterInstancia().obterEstadoNota(estado.getId(), tpAmb);
            GerenciadorProxy.getGerenciador().atualizarNota(estado);
        }
    }

    @Override
    public void gerarXMLProt(String idNota, String tpAmb, String idUsuario) throws Exception {
        this.imprimir.gerarXMLProtAndPDF(idNota, tpAmb, "PDF", false, idUsuario);
    }

    @Override
    public void sendEmail(String id, String tpAmb, Hashtable<String, String> props) throws RemoteException {
        try {
            if (props == null) {
                this.imprimir.enviarEmail(id, tpAmb);
            } else {
                boolean boleto;
                System.out.println(props.toString());
                String emails = props.get("sendemail");
                boolean pdf = Boolean.parseBoolean(props.get("pdf"));
                boolean xml = Boolean.parseBoolean(props.get("xml"));
                boolean cce = Boolean.parseBoolean(props.get("cce"));
                if (pdf || xml || cce) {
                    this.imprimir.enviarEmailFiles(id, tpAmb, emails, pdf, xml, cce);
                }
                if (PropriedadesMain.isSAPBoleto() && (boleto = Boolean.parseBoolean(props.get("boleto")))) {
                    this.imprimir.enviarEmailBoleto(id, tpAmb, emails);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RemoteException(e.getLocalizedMessage());
        }
    }

    @Override
    public void mudarEstadoScan(String cnpj, String tpAmb) throws RemoteException {
        try {
            GerenaciadoLotesAsString gerenciador = this.gerenciadores.get(cnpj);
            if (gerenciador == null) {
                throw new RemoteException("CNPJ nao registrado: " + cnpj);
            }
            modoAtual.put(cnpj, PropriedadesSistema.MODO_OP.CONTINGENCIA_SCAN);
            gerenciador.ajustarModoScan();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void mudarEstadoDpec(String cnpj, String tpAmb) throws RemoteException {
        try {
            GerenaciadoLotesAsString gerenciador = this.gerenciadores.get(cnpj);
            if (gerenciador == null) {
                throw new RemoteException("CNPJ nao registrado: " + cnpj);
            }
            modoAtual.put(cnpj, PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC);
            gerenciador.ajustarModoContingenciaDpec(tpAmb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void changeModeTo(String cnpj, PropriedadesSistema.MODO_OP modoop, Hashtable<String, Object> params) throws RemoteException {
        try {
            GerenaciadoLotesAsString gerenciador = this.gerenciadores.get(cnpj);
            if (gerenciador == null) {
                throw new RemoteException("CNPJ nao registrado: " + cnpj);
            }
            modoAtual.put(cnpj, modoop);
            gerenciador.chageToMode(modoop);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

