/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.mensageiro;

import br.com.taragona.nfe.mensageiro.MonitorarBoletosScheduler;
import br.com.taragona.nfe.mensageiro.MonitorarBoletosThread;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.EstadoNFe;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class MonitorarBoletosService
implements Runnable {
    private static final long INTERVALO_CHECAGEM_MS = TimeUnit.MINUTES.toMillis(5L);
    private static final MonitorarBoletosService INSTANCE = new MonitorarBoletosService();
    private final Set<String> notasMonitoradas = ConcurrentHashMap.newKeySet();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "monitorar-boletos-service");
        t.setDaemon(true);
        return t;
    });
    private DAOGenerico<EstadoNFe> daoNotas;

    private MonitorarBoletosService() {
    }

    public static MonitorarBoletosService getInstance() {
        return INSTANCE;
    }

    public synchronized void iniciar(DAOGenerico<EstadoNFe> dao) {
        if (this.daoNotas == null) {
            this.daoNotas = dao;
            this.scheduler.scheduleAtFixedRate(this, 0L, INTERVALO_CHECAGEM_MS, TimeUnit.MILLISECONDS);
        }
    }

    public void agendarNota(String idNota, String tpAmb, String xml, String cnpjEmitente, String cnpjDestino, Date data, String idUsuario) {
        if (this.daoNotas == null) {
            return;
        }
        if (this.notasMonitoradas.add(this.buildKey(idNota, tpAmb))) {
            MonitorarBoletosThread tarefa = new MonitorarBoletosThread(idNota, tpAmb, xml, cnpjEmitente, cnpjDestino, data, idUsuario, this);
            MonitorarBoletosScheduler.getInstance().iniciarMonitoramento(tarefa);
        }
    }

    public void notificarConclusao(String idNota, String tpAmb) {
        this.notasMonitoradas.remove(this.buildKey(idNota, tpAmb));
    }

    @Override
    public void run() {
        if (this.daoNotas == null) {
            return;
        }
        try {
            String qry = "select e\n";
            qry = String.valueOf(qry) + "  from EstadoNFe e\n";
            qry = String.valueOf(qry) + " where e.gerouBoleto = true\n";
            qry = String.valueOf(qry) + "   and e.importouBoleto = false\n";
            List notas = this.daoNotas.criarQuery(qry).getResultList();
            for (EstadoNFe nota : notas) {
                this.agendarNota(nota.getId(), nota.getAmbiente(), nota.getXmlString(), nota.getCnpj(), nota.getCnpjDestino(), nota.getDataGerada(), null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String buildKey(String idNota, String tpAmb) {
        return String.valueOf(idNota) + "|" + tpAmb;
    }
}

