/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.mensageiro;

import br.com.taragona.nfe.classes.recepcao.TEnviNFe;
import br.com.taragona.nfe.controle.ChecarLoteThread;
import br.com.taragona.nfe.danfe.ImprimirDANFE;
import br.com.taragona.nfe.dpec.GeradorDPEC;
import br.com.taragona.nfe.mensageiro.caches.CacheLotesPendentes;
import br.com.taragona.nfe.mensageiro.caches.CacheNotas;
import br.com.taragona.nfe.mensageiro.caches.CacheRecibos;
import br.com.taragona.nfe.persistence.DPECInfo;
import br.com.taragona.nfe.persistence.EstadoLote;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.util.CodigoNFeManager;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.logger.LoggingJava;
import br.com.taragona.nfe.util.xml.XMLFactory;
import br.com.taragona.nfe.xmlgenerator.XMLGenerator;
import br.com.tti.dpec.classes.TRetDPEC;
import br.com.tti.nfev310.retreci.TRetEnviNFe;
import br.com.tti.sefaz.epec.EPECEventGenerator;
import java.io.StringReader;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.bind.JAXBElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class TratadorLoteThread
implements Runnable {
    private Long INTERVALO_TENTATIVA = 5000L;
    private String lote;
    private String idLote;
    private String tpAmb;
    private CacheLotesPendentes cacheLotes;
    private CacheRecibos cacheRecibos;
    private CacheNotas cacheNotas;
    private XMLGenerator xmls;
    private PropriedadesSistema.MODO_OP modoAtual;
    private Set<String> notasLoteClone;
    private Hashtable<String, TratadorLoteThread> threadLotes;
    private boolean stop = false;
    private ImprimirDANFE imprimir;
    private String CNPJ;
    private String UF;
    private GeradorDPEC dpec;
    private XMLGenerator xmlsDpec;
    private EPECEventGenerator epecgen;
    private String idUsuario;
    private boolean sincrono;

    public TratadorLoteThread(String idLote, String tpAmb, String lote, String CNPJ, String UF, Set<String> notasLote, PropriedadesSistema.MODO_OP modoAtual, ImprimirDANFE imprimir, Hashtable<String, TratadorLoteThread> threadLotes, String idUsuario) {
        this.idUsuario = idUsuario;
        this.notasLoteClone = new HashSet<String>();
        this.idLote = idLote;
        this.tpAmb = tpAmb;
        this.lote = lote;
        this.CNPJ = CNPJ;
        this.UF = UF;
        this.modoAtual = modoAtual;
        this.xmls = XMLFactory.getXmlsRecepcao();
        this.cacheLotes = CacheLotesPendentes.obterInstancia();
        this.cacheRecibos = CacheRecibos.obterInstancia();
        this.cacheNotas = CacheNotas.obterInstancia();
        this.sincrono = lote.contains("<indSinc>1</indSinc>");
        String idNotass = "";
        for (String string : notasLote) {
            this.notasLoteClone.add(string);
            idNotass = String.valueOf(idNotass) + string;
        }
        LoggingJava.logger.log(Level.WARNING, "lote id: " + this.idLote + " notas: " + idNotass);
        this.imprimir = imprimir;
        this.threadLotes = threadLotes;
        this.dpec = new GeradorDPEC(this.CNPJ, this.UF);
        this.epecgen = new EPECEventGenerator();
        this.cacheLotes.cacheLotePendente(this.lote, this.idLote, tpAmb, this.CNPJ, this.notasLoteClone);
    }

    /*
     * Unable to fully structure code
     */
    private String enviarLote(String loteXML, String idLote, Set<String> notasDoLote) {
        if (this.modoAtual == PropriedadesSistema.MODO_OP.NORMAL || this.modoAtual == PropriedadesSistema.MODO_OP.CONTINGENCIA_SCAN || this.modoAtual == PropriedadesSistema.MODO_OP.SVC_AN || this.modoAtual == PropriedadesSistema.MODO_OP.SVC_RS) {
            try {
                cabecalho = XMLFactory.montarCabecalho(TEnviNFe.class, this.CNPJ);
                for (String idNota : this.notasLoteClone) {
                    nn = this.cacheNotas.obterEstadoNota(idNota, this.tpAmb);
                    if (nn.getEstado() == EstadoNFe.ESTADO_NFE.AUTORIZADA) continue;
                    this.cacheNotas.ajustarEstado(idNota, this.tpAmb, EstadoNFe.ESTADO_NFE.TENTANDO_ENVIO, true, this.idUsuario);
                }
                recibo = GerenciadorProxy.enviarMensagemXML(PropriedadesSistema.ID_SERVICO_RECEPCAO, this.CNPJ, cabecalho, loteXML, this.UF, this.idUsuario);
                LoggingJava.logger.log(Level.WARNING, "Lote enviado:" + idLote + " estado: " + (Object)this.modoAtual);
                return recibo;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.cacheLotes.ajustarEstadoSemNotas(idLote, this.tpAmb, EstadoLote.ESTADO_LOTE.ERRO_ENVIO);
                ** for (idNota : this.notasLoteClone)
            }
lbl-1000:
            // 1 sources

            {
                nn = this.cacheNotas.obterEstadoNota(idNota, this.tpAmb);
                if (nn.getEstado() == EstadoNFe.ESTADO_NFE.AUTORIZADA) continue;
                this.cacheNotas.ajustarEstado(idNota, this.tpAmb, EstadoNFe.ESTADO_NFE.ERRO_ENVIO, true, this.idUsuario);
                continue;
            }
lbl20:
            // 1 sources

            return null;
        }
        if (this.modoAtual == PropriedadesSistema.MODO_OP.CONTINGENCIA) {
            this.cacheLotes.ajustarContingencia(idLote, this.tpAmb);
            for (String idNota : this.notasLoteClone) {
                this.cacheNotas.ajustarModoOp(idNota, this.tpAmb, PropriedadesSistema.MODO_OP.CONTINGENCIA);
                this.imprimir.imprimirNota(idNota, this.tpAmb, "IMPRIMIR", false, null, this.idUsuario);
                try {
                    GerenciadorProxy.gerenciador.notificarNotaERP(idNota.replace("NFe", ""), this.tpAmb, PropriedadesSistema.MODO_OP.CONTINGENCIA.toString(), null);
                }
                catch (RemoteException e) {
                    System.out.println("Nao foi possivel notificar a nota para o ERP: " + idNota);
                }
            }
            return null;
        }
        if (this.modoAtual == PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC) {
            this.cacheLotes.ajustarContingenciaDpec(idLote, this.tpAmb);
            for (String idNota : this.notasLoteClone) {
                nota = this.cacheNotas.obterEstadoNota(idNota, this.tpAmb);
                this.dpec.adicionarNota(nota, this.CNPJ);
            }
            xmlDPEC = this.dpec.createDpecNow();
            try {
                recibo = GerenciadorProxy.enviarMensagemXML(PropriedadesSistema.ID_SERVICO_RECEPCAO_DPEC, this.CNPJ, null, xmlDPEC, this.UF, this.idUsuario);
                if (recibo != null) {
                    this.processReciboDPEC(xmlDPEC, recibo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
        if (PropriedadesSistema.MODO_OP.CONTINGENCIA_EPEC.equals((Object)this.modoAtual)) {
            for (String idNota : this.notasLoteClone) {
                nota = this.cacheNotas.obterEstadoNota(idNota, this.tpAmb);
                props = new Hashtable<String, String>();
                try {
                    this.epecgen.adicionarEvento(nota.getId(), this.tpAmb, nota.getXmlString(), props, this.idUsuario);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private boolean processReciboDPEC(String xmlDPEC, String result) {
        this.xmlsDpec = XMLFactory.getXmlsDpec();
        try {
            TRetDPEC retDpec = (TRetDPEC)this.xmlsDpec.toObject(result);
            int codigo = Integer.parseInt(retDpec.getInfDPECReg().getCStat());
            if (codigo == PropriedadesSistema.DPEC_RECEBIDO.getId()) {
                String data = "";
                if (retDpec.getInfDPECReg().getDhRegDPEC() != null) {
                    data = "|" + retDpec.getInfDPECReg().getDhRegDPEC().toString();
                }
                for (String idNota : this.notasLoteClone) {
                    this.cacheNotas.ajustarProtocolo(idNota, this.tpAmb, String.valueOf(retDpec.getInfDPECReg().getNRegDPEC().toString()) + data);
                    this.cacheNotas.ajustarEstado(idNota, this.tpAmb, EstadoNFe.ESTADO_NFE.DPEC_ENVIADO, true, this.idUsuario);
                    this.cacheNotas.ajustarEstadoNota(idNota, this.tpAmb, 124L, this.idUsuario);
                    this.cacheNotas.ajustarProtocolo(idNota, this.tpAmb, String.valueOf(retDpec.getInfDPECReg().getNRegDPEC().toString()) + data);
                    this.cacheNotas.ajustarModoOp(idNota, this.tpAmb, PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC);
                    this.cacheNotas.ajustarEstadoNota(idNota, this.tpAmb, 124L, this.idUsuario);
                    this.imprimir.imprimirNota(idNota, this.tpAmb, "IMPRIMIR/PDF", false, null, this.idUsuario);
                    EstadoNFe nota = this.cacheNotas.obterEstadoNota(idNota, this.tpAmb);
                    this.dpec.adicionarNota(nota, this.CNPJ);
                }
                String[] chaves = new String[this.notasLoteClone.size()];
                this.notasLoteClone.toArray(chaves);
                DPECInfo dpecInfo = new DPECInfo();
                dpecInfo.setChaves(chaves);
                dpecInfo.setCodigoEstado(codigo);
                dpecInfo.setMotivo(retDpec.getInfDPECReg().getXMotivo());
                dpecInfo.setResultadoDPEC(result);
                dpecInfo.setXmlDPEC(xmlDPEC);
                dpecInfo.setDataEnvio(new Date());
                if (retDpec.getInfDPECReg().getNRegDPEC() != null) {
                    dpecInfo.setProcolo(retDpec.getInfDPECReg().getNRegDPEC().toString());
                }
                if (retDpec.getInfDPECReg().getDhRegDPEC() != null) {
                    String prot = dpecInfo.getProcolo();
                    dpecInfo.setProcolo(String.valueOf(prot) + "|" + retDpec.getInfDPECReg().getDhRegDPEC().toString());
                }
            } else {
                String notaErro = null;
                if (retDpec.getInfDPECReg().getChNFe() != null) {
                    notaErro = retDpec.getInfDPECReg().getChNFe();
                }
                for (String idNota : this.notasLoteClone) {
                    this.cacheNotas.ajustarEstado(idNota, this.tpAmb, EstadoNFe.ESTADO_NFE.PROBLEMAS_DPEC_ENVIADO, true, this.idUsuario);
                    this.cacheNotas.ajustarXMotivo(idNota, this.tpAmb, retDpec.getInfDPECReg().getXMotivo());
                    this.cacheNotas.ajustarEstadoNota(idNota, this.tpAmb, new Long(999L), this.idUsuario);
                }
                String[] chaves = new String[this.notasLoteClone.size()];
                this.notasLoteClone.toArray(chaves);
                DPECInfo dpecInfo = new DPECInfo();
                dpecInfo.setChaves(chaves);
                dpecInfo.setCodigoEstado(codigo);
                dpecInfo.setMotivo(retDpec.getInfDPECReg().getXMotivo());
                dpecInfo.setResultadoDPEC(result);
                dpecInfo.setXmlDPEC(xmlDPEC);
                dpecInfo.setDataEnvio(new Date());
                dpecInfo.setFirstNota(notaErro);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private synchronized boolean processarRecibo(String reciboStr, String idLote) {
        JAXBElement recibo;
        block15: {
            int codigo;
            block14: {
                block13: {
                    recibo = null;
                    recibo = (JAXBElement)this.xmls.toObject(reciboStr);
                    codigo = Integer.parseInt(((TRetEnviNFe)recibo.getValue()).getCStat());
                    CodigoNFeManager.insereCodigo(codigo, ((TRetEnviNFe)recibo.getValue()).getXMotivo());
                    if (codigo != PropriedadesSistema.FALHA_ESQUEMA.getId() && codigo != PropriedadesSistema.FALHA_ESQUEMA_NFE.getId() && codigo != PropriedadesSistema.XML_MAL_FORMADO.getId()) break block13;
                    this.cacheLotes.ajustarEstadoNFe(idLote, this.tpAmb, Long.parseLong(((TRetEnviNFe)recibo.getValue()).getCStat()));
                    this.cacheLotes.ajustarEstado(idLote, this.tpAmb, EstadoLote.ESTADO_LOTE.ERRO_ESQUEMA);
                    for (String idNota : this.notasLoteClone) {
                        this.cacheNotas.ajustarEstado(idNota, this.tpAmb, EstadoNFe.ESTADO_NFE.ERRO_ESQUEMA_LOTE, true, this.idUsuario);
                    }
                    return true;
                }
                if (((TRetEnviNFe)recibo.getValue()).getProtNFe() == null) break block14;
                ChecarLoteThread check = new ChecarLoteThread(this.CNPJ, this.UF, "", this.notasLoteClone, this.imprimir, 2000L, this.tpAmb, this.idUsuario);
                String idNota = ((TRetEnviNFe)recibo.getValue()).getProtNFe().getInfProt().getChNFe();
                String numeroProtocolo = ((TRetEnviNFe)recibo.getValue()).getProtNFe().getInfProt().getNProt();
                if (numeroProtocolo != null && !numeroProtocolo.equals("") && ((TRetEnviNFe)recibo.getValue()).getProtNFe().getInfProt().getDhRecbto() != null && !((TRetEnviNFe)recibo.getValue()).getProtNFe().getInfProt().getDhRecbto().equals("")) {
                    numeroProtocolo = String.valueOf(numeroProtocolo) + "|" + ((TRetEnviNFe)recibo.getValue()).getProtNFe().getInfProt().getDhRecbto();
                }
                String protocolo = "";
                if (!idNota.startsWith("NFe")) {
                    idNota = "NFe" + idNota;
                }
                if (reciboStr.indexOf("<protNFe") > 0) {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(false);
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document doc = db.parse(new InputSource(new StringReader(reciboStr)));
                    XPath xp = XPathFactory.newInstance().newXPath();
                    Node prot = (Node)xp.evaluate("//protNFe", doc, XPathConstants.NODE);
                    if (prot != null) {
                        Transformer tf = TransformerFactory.newInstance().newTransformer();
                        tf.setOutputProperty("omit-xml-declaration", "yes");
                        StringWriter sw = new StringWriter();
                        tf.transform(new DOMSource(prot), new StreamResult(sw));
                        protocolo = sw.toString();
                    }
                }
                if (this.sincrono) {
                    this.cacheNotas.ajustarAEnviada(idNota, this.tpAmb, this.idUsuario);
                }
                String xMotivo = ((TRetEnviNFe)recibo.getValue()).getProtNFe().getInfProt().getXMotivo();
                int codigo2 = Integer.parseInt(((TRetEnviNFe)recibo.getValue()).getProtNFe().getInfProt().getCStat());
                CodigoNFeManager.insereCodigo(codigo2, xMotivo);
                check.processarCodigoConsulta(codigo2, idNota, numeroProtocolo, protocolo, xMotivo);
                return true;
            }
            if (codigo == PropriedadesSistema.LOTE_RECEBIDO.getId()) break block15;
            System.out.println("Erro envio do lote:" + idLote + " codigo: " + codigo);
            this.cacheLotes.ajustarEstadoNFe(idLote, this.tpAmb, Long.parseLong(((TRetEnviNFe)recibo.getValue()).getCStat()));
            this.cacheLotes.ajustarErroEnvio(idLote, this.tpAmb, -1);
            this.cacheLotes.ajustarEstadoSemNotas(idLote, this.tpAmb, EstadoLote.ESTADO_LOTE.ERRO_ENVIO);
            for (String idNota : this.notasLoteClone) {
                EstadoNFe nn = this.cacheNotas.obterEstadoNota(idNota, this.tpAmb);
                if (nn.getEstado() == EstadoNFe.ESTADO_NFE.AUTORIZADA) continue;
                this.cacheNotas.ajustarEstado(idNota, this.tpAmb, EstadoNFe.ESTADO_NFE.ERRO_ENVIO, true, this.idUsuario);
                this.cacheNotas.ajustarEstadoNota(idNota, this.tpAmb, Long.parseLong(((TRetEnviNFe)recibo.getValue()).getCStat()), this.idUsuario);
            }
            return false;
        }
        try {
            this.cacheRecibos.cacheReciboWithLote((TRetEnviNFe)recibo.getValue(), idLote, this.tpAmb, reciboStr);
            this.cacheLotes.ajustarEstadoNFe(idLote, this.tpAmb, Long.parseLong(((TRetEnviNFe)recibo.getValue()).getCStat()));
            this.cacheLotes.ajustarAEnviado(idLote, this.tpAmb);
            for (String idNota : this.notasLoteClone) {
                EstadoNFe nn = this.cacheNotas.obterEstadoNota(idNota, this.tpAmb);
                if (nn.getEstado() == EstadoNFe.ESTADO_NFE.AUTORIZADA) continue;
                this.cacheNotas.ajustarAEnviada(idNota, this.tpAmb, this.idUsuario);
            }
            this.cacheNotas.flushcache();
            this.cacheLotes.flushcache();
            GerenciadorProxy.getGerenciador().notificarControle(this.CNPJ, idLote, ((TRetEnviNFe)recibo.getValue()).getInfRec().getNRec(), this.notasLoteClone, this.tpAmb, this.idUsuario);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public void run() {
        boolean recebeulote = false;
        int counter = 0;
        while (!recebeulote && !this.stop) {
            String recibo = this.enviarLote(this.lote, this.idLote, this.notasLoteClone);
            if (recibo != null) {
                System.out.println("Recibo: " + recibo);
                recebeulote = this.processarRecibo(recibo, this.idLote);
            } else if (this.modoAtual == PropriedadesSistema.MODO_OP.CONTINGENCIA || this.modoAtual == PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC || this.modoAtual == PropriedadesSistema.MODO_OP.CONTINGENCIA_EPEC) break;
            try {
                Thread.sleep(this.calcularTempo(this.idLote));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.cacheLotes.ajustarTempoDeTentativa(this.idLote, this.tpAmb);
            if (counter >= 3) {
                return;
            }
            ++counter;
        }
        this.threadLotes.remove(this.idLote);
    }

    private Long calcularTempo(String idLote) {
        EstadoLote lote = this.cacheLotes.obterLotePendente(idLote, this.tpAmb);
        return (long)lote.getNumeroTentativa() * this.INTERVALO_TENTATIVA;
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public Long getINTERVALO_TENTATIVA() {
        return this.INTERVALO_TENTATIVA;
    }

    public void setINTERVALO_TENTATIVA(Long intervalo_tentativa) {
        this.INTERVALO_TENTATIVA = intervalo_tentativa;
    }
}

