/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.mensageiro.caches;

import br.com.taragona.nfe.classes.recepcao.TNFe;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.Empresa;
import br.com.taragona.nfe.persistence.EntidadeCnpj;
import br.com.taragona.nfe.persistence.EntidadeId;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.persistence.db.QuickDB;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.data.BaseDadosConfig;
import br.com.taragona.nfe.util.logger.NFeLogger;
import br.com.taragona.nfe.xmlgenerator.XMLGenerator;
import br.com.tti.util.DataUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.persistence.Query;

public class CacheNotas {
    public static Long CODIGO_ATIVO = 100L;
    private static CacheNotas INSTANCIA = null;
    private XMLGenerator xmls;
    private DAOGenerico<EstadoNFe> daoNotas;
    private QuickDB quick;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public static CacheNotas obterInstancia() {
        if (INSTANCIA == null) {
            INSTANCIA = new CacheNotas();
        }
        return INSTANCIA;
    }

    private CacheNotas() {
        BaseDadosConfig bdConfig = PropriedadesSistema.getBdConfig();
        this.quick = new QuickDB(bdConfig.getUrl(), bdConfig.getUsuario(), bdConfig.getSenha());
        this.daoNotas = new DAOGenerico(EstadoNFe.class);
        this.xmls = new XMLGenerator("br.com.taragona.nfe.classes.recepcao");
    }

    public synchronized EstadoNFe obterEstadoNota(String idNota, String tpAmb) {
        EntidadeId id = new EntidadeId(idNota, tpAmb);
        EstadoNFe nota = this.daoNotas.buscarPorIdObject(id);
        if (nota != null) {
            this.daoNotas.refresh(nota);
            return nota;
        }
        return null;
    }

    public synchronized Empresa obterEmpresa(String tpAmb, String cnpj) {
        DAOGenerico<Empresa> daoEmp = new DAOGenerico<Empresa>(Empresa.class);
        EntidadeCnpj eCnpj = new EntidadeCnpj(cnpj, tpAmb);
        Empresa emp = (Empresa)daoEmp.buscarPorIdObject(eCnpj);
        if (emp != null) {
            daoEmp.refresh(emp);
            daoEmp.close();
            daoEmp = null;
            return emp;
        }
        daoEmp.close();
        daoEmp = null;
        return null;
    }

    public synchronized EstadoNFe.ESTADO_NFE obterEstado(String id, String tpAmb) {
        EntidadeId eid = new EntidadeId(id, tpAmb);
        return this.daoNotas.buscarPorIdObject(eid).getEstado();
    }

    public synchronized Long obterEstadoNFe(String id, String tpAmb) {
        EntidadeId eid = new EntidadeId(id, tpAmb);
        return this.daoNotas.buscarPorIdObject(eid).getEstadoNFe();
    }

    public synchronized void removeNota(String id) {
        this.daoNotas.remover(id);
    }

    public synchronized void cacheNota(TNFe nota) {
        try {
            EstadoNFe estadoNota = new EstadoNFe();
            estadoNota.setId(nota.getInfNFe().getId());
            estadoNota.setAmbiente(nota.getInfNFe().getIde().getTpAmb());
            estadoNota.setEstado(EstadoNFe.ESTADO_NFE.GERADA);
            estadoNota.setAssinada(false);
            this.xmls.notaToXMLFile(nota, nota.getInfNFe().getId());
            this.daoNotas.salvar(estadoNota);
            GerenciadorProxy.notificarNota(estadoNota);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized void ajustarEstadoNota(String id, String tpAmb, Long estado, String idUsuario) {
        EntidadeId eid = new EntidadeId(id, tpAmb);
        EstadoNFe estadoNota = this.daoNotas.buscarPorIdObject(eid);
        if (estadoNota != null) {
            estadoNota.setEstadoNFe(estado);
            this.daoNotas.unir(estadoNota);
            this.daoNotas.flush();
            GerenciadorProxy.notificarNota(estadoNota);
            NFeLogger.log(estadoNota.getId(), estadoNota.getAmbiente(), estadoNota.getModoOperacao(), EstadoNFe.ESTADO_NFE.RESULTADO_SEFAZ, estado, idUsuario);
        }
    }

    public synchronized void ajustarAutorizada(String id, String tpAmb, String protocoloXML, String nProtocolo, boolean notificar, String idUsuario) {
        EntidadeId eid = new EntidadeId(id, tpAmb);
        EstadoNFe estadoNota = this.daoNotas.buscarPorIdObject(eid);
        if (estadoNota != null) {
            estadoNota.setDataAutorizada(new Date());
            estadoNota.setEstado(EstadoNFe.ESTADO_NFE.AUTORIZADA);
            estadoNota.setProtocoloXML(protocoloXML);
            estadoNota.setProtocolo(nProtocolo);
            try {
                String[] spp = nProtocolo.split("\\|");
                estadoNota.setDataAutorizada(this.sdf.parse(spp[1].replace("-03:00", "").replace("-02:00", "").replace("-04:00", "")));
            }
            catch (Exception e) {
                System.err.println("erro tratando data autorizada: " + e.getLocalizedMessage());
            }
            this.daoNotas.unir(estadoNota);
            this.daoNotas.clear();
            this.quick.autorizarNota(id);
            estadoNota = this.daoNotas.buscarPorIdObject(eid);
            this.daoNotas.refresh(estadoNota);
            GerenciadorProxy.notificarNota(estadoNota);
            if (notificar) {
                GerenciadorProxy.notificarNotaConector(estadoNota);
            }
            NFeLogger.log(estadoNota.getId(), estadoNota.getAmbiente(), estadoNota.getModoOperacao(), EstadoNFe.ESTADO_NFE.AUTORIZADA, null, idUsuario);
        }
    }

    public synchronized void ajustarDenegada(String id, String tpAmb, String protocoloXML, String nProtocolo, boolean notificar, boolean alterarProtocolo, String idUsuario) {
        EntidadeId eid = new EntidadeId(id, tpAmb);
        EstadoNFe estadoNota = this.daoNotas.buscarPorIdObject(eid);
        if (estadoNota != null) {
            estadoNota.setDataAutorizada(new Date());
            estadoNota.setEstado(EstadoNFe.ESTADO_NFE.USO_DENEGADO);
            if (alterarProtocolo) {
                estadoNota.setProtocoloXML(protocoloXML);
                estadoNota.setProtocolo(nProtocolo);
            }
            this.daoNotas.unir(estadoNota);
            this.daoNotas.clear();
            estadoNota = this.daoNotas.buscarPorIdObject(eid);
            this.daoNotas.refresh(estadoNota);
            GerenciadorProxy.notificarNota(estadoNota);
            if (notificar) {
                GerenciadorProxy.notificarNotaConector(estadoNota);
            }
            NFeLogger.log(estadoNota.getId(), estadoNota.getAmbiente(), estadoNota.getModoOperacao(), EstadoNFe.ESTADO_NFE.USO_DENEGADO, null, idUsuario);
        }
    }

    public synchronized void ajustarAEnviada(String idNota, String tpAmb, String idUsuario) {
        EstadoNFe estadoNota = this.obterEstadoNota(idNota, tpAmb);
        if (estadoNota != null) {
            estadoNota.setEstado(EstadoNFe.ESTADO_NFE.ENVIADA);
            estadoNota.setDataEnviada(new Date());
            this.daoNotas.unir(estadoNota);
            GerenciadorProxy.notificarNota(estadoNota);
            NFeLogger.log(estadoNota.getId(), estadoNota.getAmbiente(), estadoNota.getModoOperacao(), EstadoNFe.ESTADO_NFE.ENVIADA, null, idUsuario);
        }
    }

    public synchronized void ajustarEstado(String id, String tpAmb, EstadoNFe.ESTADO_NFE estado, boolean notificar, String idUsuario) {
        EntidadeId eid = new EntidadeId(id, tpAmb);
        EstadoNFe estadoNota = this.daoNotas.buscarPorIdObject(eid);
        if (estadoNota != null) {
            this.daoNotas.refresh(estadoNota);
            estadoNota.setEstado(estado);
            this.daoNotas.unir(estadoNota);
            GerenciadorProxy.notificarNota(estadoNota);
            if (notificar) {
                GerenciadorProxy.notificarNotaConector(estadoNota);
            }
            NFeLogger.log(estadoNota.getId(), estadoNota.getAmbiente(), estadoNota.getModoOperacao(), estado, null, idUsuario);
        }
    }

    public synchronized void ajustarMensagem(String id, String tpAmb, String mensagem) {
        EntidadeId eid = new EntidadeId(id, tpAmb);
        EstadoNFe estadoNota = this.daoNotas.buscarPorIdObject(eid);
        if (estadoNota != null) {
            this.daoNotas.refresh(estadoNota);
            estadoNota.setMotivoErro(mensagem);
            this.daoNotas.unir(estadoNota);
            GerenciadorProxy.notificarNota(estadoNota);
        }
    }

    public synchronized void ajustarProtocolo(String id, String tpAmb, String protocolo) {
        EntidadeId eid = new EntidadeId(id, tpAmb);
        EstadoNFe estadoNota = this.daoNotas.buscarPorIdObject(eid);
        if (estadoNota != null) {
            estadoNota.setProtocolo(protocolo);
            this.daoNotas.unir(estadoNota);
            GerenciadorProxy.notificarNota(estadoNota);
        }
    }

    public synchronized void salvarNota(EstadoNFe estado) {
        this.daoNotas.salvar(estado);
    }

    public synchronized void ajustarCancelada(String id, String tpAmb, String protocolo, String protocoloXML, boolean notificar, String idUsuario) {
        EntidadeId eid = new EntidadeId(id, tpAmb);
        EstadoNFe estadoNota = this.daoNotas.buscarPorIdObject(eid);
        if (estadoNota != null) {
            estadoNota.setEstado(EstadoNFe.ESTADO_NFE.CANCELADA);
            estadoNota.setEstadoNFe(new Long(PropriedadesSistema.NOTA_CANCELADA.getId()));
            estadoNota.setProtocoloCancelamentoXML(protocoloXML.substring(protocoloXML.indexOf("<retEvento")));
            estadoNota.setMotivoErro(protocolo);
            this.daoNotas.unir(estadoNota);
            this.daoNotas.flush();
            GerenciadorProxy.notificarNota(estadoNota);
            if (notificar) {
                GerenciadorProxy.notificarNotaConector(estadoNota);
            }
            NFeLogger.log(estadoNota.getId(), estadoNota.getAmbiente(), estadoNota.getModoOperacao(), EstadoNFe.ESTADO_NFE.CANCELADA, null, idUsuario);
        }
    }

    public synchronized Vector<EstadoNFe> obterNotasEnviadas(String cnpj, Date data) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        String sql = "select id,dataGerada, dataEnviada, dataAutorizada, dataAtualizada, cnpj, modoOperacao, estado,estadoNFe,protocolo, motivoErro from ESTADONFE where (estado = 5 or estado = 17 or estado = 11) and cnpj = '" + cnpj + "' and dataGerada >= ?1";
        data = DataUtil.truncate(data);
        System.out.println("Quering obterNotasEnviadas:" + sql);
        Query q = this.daoNotas.filter(sql);
        q.setParameter(1, (Object)data);
        List o = q.getResultList();
        return this.convert(o);
    }

    public synchronized Vector<EstadoNFe> obterNotasNaoEnviadas(String cnpj, Date data) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        String sql = "select id,dataGerada, dataEnviada, dataAutorizada, dataAtualizada, cnpj, modoOperacao, estado,estadoNFe,protocolo, motivoErro from ESTADONFE where (estado = 11 or estado = 12 or estado = 14 or estado = 3 or estado = 27) and (modoOperacao = 1) and (cnpj = '" + cnpj + "') and dataGerada >= '" + sf.format(data) + "'";
        Query q = this.daoNotas.filter(sql);
        System.out.println("Quering obterNotasNaoEnviadas:" + sql);
        List o = q.getResultList();
        return this.convert(o);
    }

    public synchronized void ajustarImpressaCont(String idNota, String tpAmb) {
        EntidadeId eid = new EntidadeId(idNota, tpAmb);
        EstadoNFe nota = this.daoNotas.buscarPorIdObject(eid);
        nota.setAssinada(true);
        this.daoNotas.unir(nota);
    }

    public void clear() {
        this.daoNotas.clear();
    }

    public synchronized void ajustarModoOp(String idNota, String tpAmb, PropriedadesSistema.MODO_OP modo) {
        EntidadeId eid = new EntidadeId(idNota, tpAmb);
        EstadoNFe estado = this.daoNotas.buscarPorIdObject(eid);
        if (estado != null) {
            estado.setModoOperacao(modo);
            this.daoNotas.unir(estado);
        }
    }

    public synchronized Vector<EstadoNFe> filtrarNotas(String tpAmb, String UF, String ano, String cnpj, String mod, String serie, String ini, String fim) {
        try {
            Vector<EstadoNFe> novas = new Vector<EstadoNFe>();
            long i = Long.parseLong(ini);
            long f = Long.parseLong(fim);
            long counter = i;
            while (counter <= f) {
                String qry = "select e from EstadoNFe as e where e.cnpj = :cnpj";
                qry = String.valueOf(qry) + " and e.id like '%" + UF + ano + "%" + cnpj + mod + serie + String.format("%09d", counter) + "%'" + " and e.ambiente='" + tpAmb + "'";
                Query q1 = this.daoNotas.criarQuery(qry);
                q1.setParameter("cnpj", (Object)cnpj);
                List resultado = q1.getResultList();
                for (EstadoNFe r : resultado) {
                    novas.add(r);
                }
                ++counter;
            }
            return novas;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Vector<EstadoNFe>();
        }
    }

    public synchronized Vector<EstadoNFe> filtrarNotasDeprecated(String UF, String ano, String cnpj, String mod, String serie, String ini, String fim) {
        try {
            Query q = this.daoNotas.criarQuery("select e from EstadoNFe as e where e.cnpj = :cnpj and e.id like '%" + serie + "%'");
            q.setParameter("cnpj", (Object)cnpj);
            List notas = q.getResultList();
            Vector<EstadoNFe> novas = new Vector<EstadoNFe>();
            for (EstadoNFe nota : notas) {
                try {
                    GerenciadorChavesNota chave = new GerenciadorChavesNota(nota.getId());
                    long p_inii = Long.parseLong(ini);
                    long p_inif = Long.parseLong(fim);
                    long p_serieNota = Long.parseLong(serie);
                    long nnota = Long.parseLong(chave.getNumeroNota());
                    long snota = Long.parseLong(chave.getSerie());
                    if (p_serieNota != snota || p_inii > nnota || nnota > p_inif) continue;
                    novas.add(nota);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return novas;
        }
        catch (Exception exception) {
            return new Vector<EstadoNFe>();
        }
    }

    public synchronized void ajustarXMotivo(String idNota, String tpAmb, String xMotivo) {
        EntidadeId eid = new EntidadeId(idNota, tpAmb);
        EstadoNFe estado = this.daoNotas.buscarPorIdObject(eid);
        if (estado != null) {
            estado.setMotivoErro(xMotivo);
            this.daoNotas.unir(estado);
        }
    }

    public synchronized void flushcache() {
        this.daoNotas.flush();
        this.daoNotas.clear();
    }

    public Vector<EstadoNFe> obterNotasDpec(String d1, String d2, String cnpj) {
        List notas = null;
        Vector<EstadoNFe> notasDpec = new Vector<EstadoNFe>();
        if (d1 != null && d2 == null) {
            Query q = this.daoNotas.criarQuery("SELECT e FROM EstadoNFe e WHERE e.dataGerada >= :dataLim AND e.cnpj = :cnpj AND e.estado = :estado1 AND e.modoOperacao = :op ORDER BY e.dataGerada DESC");
            q.setParameter("dataLim", (Object)d1);
            q.setParameter("cnpj", (Object)cnpj);
            q.setParameter("estado1", (Object)EstadoNFe.ESTADO_NFE.GERADA);
            q.setParameter("op", (Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC);
            try {
                notas = q.getResultList();
            }
            catch (Exception e) {
                e.printStackTrace();
                return new Vector<EstadoNFe>();
            }
            for (EstadoNFe nota : notas) {
                notasDpec.add(nota);
            }
            return notasDpec;
        }
        if (d1 == null && d2 == null) {
            Query q = this.daoNotas.criarQuery("SELECT e FROM EstadoNFe e WHERE e.cnpj = :cnpj AND e.estado = :estado1 AND e.modoOperacao = :op ORDER BY e.dataGerada DESC");
            q.setParameter("cnpj", (Object)cnpj);
            q.setParameter("estado1", (Object)EstadoNFe.ESTADO_NFE.GERADA);
            q.setParameter("op", (Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC);
            notas = q.getResultList();
            for (EstadoNFe nota : notas) {
                this.daoNotas.refresh(nota);
                notasDpec.add(nota);
            }
            return notasDpec;
        }
        Query q = this.daoNotas.criarQuery("SELECT e FROM EstadoNFe e WHERE (e.dataGerada >= :dataD1 AND e.dataGerada <= :dataD2 AND e.cnpj = :cnpj AND e.estado = :estado1 AND e.modoOperacao = :op) ORDER BY e.dataGerada DESC");
        q.setParameter("dataD1", (Object)d1);
        q.setParameter("dataD2", (Object)d2);
        q.setParameter("estado1", (Object)EstadoNFe.ESTADO_NFE.GERADA);
        q.setParameter("op", (Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC);
        q.setParameter("cnpj", (Object)cnpj);
        try {
            notas = q.getResultList();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Vector<EstadoNFe>();
        }
        for (EstadoNFe nota : notas) {
            this.daoNotas.refresh(nota);
            notasDpec.add(nota);
        }
        return notasDpec;
    }

    public EstadoNFe procurarNota(String cnpj, String mod, String serie, String numero) {
        String sql = "select id,dataGerada, dataEnviada, dataAutorizada, dataAtualizada, cnpj, modoOperacao, estado,estadoNFe,protocolo, motivoErro from ESTADONFE where  cnpj = '" + cnpj + "' and id like '%" + numero + "%'";
        Query q = this.daoNotas.filter(sql);
        List o = q.getResultList();
        Vector<EstadoNFe> notas = this.convert(o);
        for (EstadoNFe estadoNFe : notas) {
            GerenciadorChavesNota chave = new GerenciadorChavesNota(estadoNFe.getId());
            String numerob = String.valueOf(Integer.parseInt(chave.getNumeroNota()));
            String serieb = String.valueOf(Integer.parseInt(chave.getSerie()));
            serie = String.valueOf(Integer.parseInt(serie));
            if (!numerob.equals(numero = String.valueOf(Integer.parseInt(numero))) || !serieb.equals(serie)) continue;
            return estadoNFe;
        }
        return null;
    }

    private List<EstadoNFe> obterNotasSQL() {
        DAOGenerico dao = new DAOGenerico(EstadoNFe.class);
        String sql = null;
        sql = "select id,dataGerada, dataEnviada, dataAutorizada, dataAtualizada, cnpj, modoOperacao, estado,estadoNFe,protocolo, motivoErro from ESTADONFE where (estado =2 or estado =3) and modoOperacao = 1";
        Query q = dao.filter(sql);
        List o = q.getResultList();
        return this.convert(o);
    }

    private Vector<EstadoNFe> convert(List o) {
        Vector<EstadoNFe> nfes = new Vector<EstadoNFe>();
        for (Object object : o) {
            Vector v = (Vector)object;
            String cnpj = v.get(5).toString();
            EstadoNFe ent = new EstadoNFe();
            String id = v.get(0).toString();
            Date dataGerada = null;
            if (v.get(1) != null) {
                dataGerada = (Date)v.get(1);
            }
            Date dateEnviada = null;
            if (v.get(2) != null) {
                dateEnviada = (Date)v.get(2);
            }
            Date dataAuto = null;
            if (v.get(3) != null) {
                dataAuto = (Date)v.get(3);
            }
            Date dataAct = null;
            if (v.get(4) != null) {
                dataAct = (Date)v.get(4);
            }
            PropriedadesSistema.MODO_OP mod = null;
            if (v.get(6) != null) {
                mod = this.getModo(Integer.parseInt(v.get(6).toString()));
            }
            EstadoNFe.ESTADO_NFE estado = null;
            if (v.get(7) != null) {
                estado = this.getEstado(Integer.parseInt(v.get(7).toString()));
            }
            Long estadoNFe = null;
            if (v.get(8) != null) {
                estadoNFe = new Long(Long.parseLong(v.get(8).toString()));
            }
            String protocolo = null;
            if (v.get(9) != null) {
                protocolo = v.get(9).toString();
            }
            String motivo = null;
            if (v.get(10) != null) {
                motivo = v.get(10).toString();
            }
            ent.setId(id);
            ent.setDataGerada(dataGerada);
            ent.setDataEnviada(dateEnviada);
            ent.setDataAutorizada(dataAuto);
            ent.setModoOperacao(mod);
            ent.setEstado(estado);
            ent.setEstadoNFe(estadoNFe);
            ent.setProtocolo(protocolo);
            ent.setMotivoErro(motivo);
            ent.setCnpj(cnpj);
            ent.setDataActualizada(dataAct);
            nfes.add(ent);
        }
        return nfes;
    }

    private PropriedadesSistema.MODO_OP getModo(int n) {
        switch (n) {
            case 0: {
                return PropriedadesSistema.MODO_OP.CONTINGENCIA;
            }
            case 1: {
                return PropriedadesSistema.MODO_OP.NORMAL;
            }
            case 2: {
                return PropriedadesSistema.MODO_OP.CONTINGENCIA_SCAN;
            }
            case 3: {
                return PropriedadesSistema.MODO_OP.LASER;
            }
            case 4: {
                return PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC;
            }
        }
        return null;
    }

    private EstadoNFe.ESTADO_NFE getEstado(int n) {
        switch (n) {
            case 0: {
                return EstadoNFe.ESTADO_NFE.USO_DENEGADO;
            }
            case 1: {
                return EstadoNFe.ESTADO_NFE.REJEITADA;
            }
            case 2: {
                return EstadoNFe.ESTADO_NFE.AUTORIZADA;
            }
            case 3: {
                return EstadoNFe.ESTADO_NFE.GERADA;
            }
            case 4: {
                return EstadoNFe.ESTADO_NFE.ASSINADA;
            }
            case 5: {
                return EstadoNFe.ESTADO_NFE.ENVIADA;
            }
            case 6: {
                return EstadoNFe.ESTADO_NFE.ERRO_VALIDACAO;
            }
            case 7: {
                return EstadoNFe.ESTADO_NFE.IMPRESSA_NORMAL;
            }
            case 8: {
                return EstadoNFe.ESTADO_NFE.IMPRESSA_CONT;
            }
            case 9: {
                return EstadoNFe.ESTADO_NFE.CANCELADA;
            }
            case 10: {
                return EstadoNFe.ESTADO_NFE.INUTILIZADA;
            }
            case 11: {
                return EstadoNFe.ESTADO_NFE.TENTANDO_ENVIO;
            }
            case 12: {
                return EstadoNFe.ESTADO_NFE.ERRO_ENVIO;
            }
            case 13: {
                return EstadoNFe.ESTADO_NFE.RESULTADO_SEFAZ;
            }
            case 14: {
                return EstadoNFe.ESTADO_NFE.ERRO;
            }
            case 15: {
                return EstadoNFe.ESTADO_NFE.PEDIDO_CANCELAMENTO;
            }
            case 16: {
                return EstadoNFe.ESTADO_NFE.ERRO_ESQUEMA;
            }
            case 17: {
                return EstadoNFe.ESTADO_NFE.TEMPO_PROCESSAMENTO_LIMITE;
            }
            case 18: {
                return EstadoNFe.ESTADO_NFE.ERRO_ESQUEMA_LOTE;
            }
            case 19: {
                return EstadoNFe.ESTADO_NFE.ERRO_CANCELAMENTO;
            }
            case 20: {
                return EstadoNFe.ESTADO_NFE.ERRO_INUTILIZACAO;
            }
            case 21: {
                return EstadoNFe.ESTADO_NFE.ERRO_IMPRESSAO;
            }
            case 22: {
                return EstadoNFe.ESTADO_NFE.IMPRESSA_LASER;
            }
            case 23: {
                return EstadoNFe.ESTADO_NFE.CANCELADA_CONTINGENCIA;
            }
            case 24: {
                return EstadoNFe.ESTADO_NFE.ERRO_XML_SEFAZ;
            }
            case 25: {
                return EstadoNFe.ESTADO_NFE.CANCELAR_SAIDA_CONTINGENCIA;
            }
            case 26: {
                return EstadoNFe.ESTADO_NFE.DPEC_ENVIADO;
            }
            case 27: {
                return EstadoNFe.ESTADO_NFE.PROBLEMAS_DPEC_ENVIADO;
            }
        }
        return null;
    }

    public synchronized void ajustarEstadoNotaInut(String id, String tpAmb, Long estado, String protocoloInutXML, String protocolo, boolean notificar, boolean atualizar, String idUsuario) {
        EntidadeId eid = new EntidadeId(id, tpAmb);
        EstadoNFe estadoNota = this.daoNotas.buscarPorIdObject(eid);
        if (estadoNota != null) {
            if (atualizar) {
                estadoNota.setProtocoloXML(protocoloInutXML);
                estadoNota.setProtocolo(protocolo);
            }
            estadoNota.setEstadoNFe(estado);
            estadoNota.setEstado(EstadoNFe.ESTADO_NFE.INUTILIZADA);
            this.daoNotas.unir(estadoNota);
            this.daoNotas.flush();
            GerenciadorProxy.notificarNota(estadoNota);
            if (notificar) {
                GerenciadorProxy.notificarNotaConector(estadoNota);
            }
            NFeLogger.log(estadoNota.getId(), estadoNota.getAmbiente(), estadoNota.getModoOperacao(), EstadoNFe.ESTADO_NFE.RESULTADO_SEFAZ, estado, idUsuario);
        }
    }
}

