/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.mensageiro.contingencia;

import br.com.taragona.nfe.cancinut.CanceladorInutilizador;
import br.com.taragona.nfe.controle.ControleLotesAsString;
import br.com.taragona.nfe.mensageiro.caches.CacheNotas;
import br.com.taragona.nfe.mensageiro.contingencia.EstrategiaContingencia;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.EstadoLote;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.util.ConfiguracaoSys;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.data.BaseDadosConfig;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.persistence.Query;

public class TratadorContingenciaTaragona
implements EstrategiaContingencia {
    private DAOGenerico<EstadoLote> daoLote = new DAOGenerico(EstadoLote.class);
    private DAOGenerico<EstadoNFe> daoNota = new DAOGenerico(EstadoNFe.class);
    private ControleLotesAsString consultor;
    private CanceladorInutilizador cancInun;
    private String cnpj;

    public TratadorContingenciaTaragona(String cnpj, ControleLotesAsString consultor) {
        this.cnpj = cnpj;
        this.consultor = consultor;
        this.cancInun = new CanceladorInutilizador();
    }

    private synchronized void ajustarNotasEnviadas(String tpAmb) {
        this.daoNota.clear();
        System.gc();
        Query q = this.daoNota.criarQuery("select e from EstadoNFe as e where (e.estado = :estado or e.estado = :estado1) and e.cnpj = :cnpj and e.ambiente = :tpAmb");
        q.setParameter("estado", (Object)EstadoNFe.ESTADO_NFE.ENVIADA);
        q.setParameter("estado1", (Object)EstadoNFe.ESTADO_NFE.GERADA);
        q.setParameter("cnpj", (Object)this.cnpj);
        q.setParameter("tpAmb", (Object)tpAmb);
        List notas = null;
        try {
            notas = q.getResultList();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        Vector<String> idNotasCancelar = new Vector<String>();
        for (EstadoNFe estadoNFe : notas) {
            this.daoNota.refresh(estadoNFe);
            System.out.println("Setando contingencia Nota: " + estadoNFe.getId());
            estadoNFe.setModoOperacao(PropriedadesSistema.MODO_OP.CONTINGENCIA);
            this.daoNota.unir(estadoNFe);
            idNotasCancelar.add(estadoNFe.getId());
        }
        String[] idNotasCancelar_s = new String[idNotasCancelar.size()];
        idNotasCancelar.toArray(idNotasCancelar_s);
        try {
            GerenciadorProxy.getGerenciador().notificarNotasCancelamentoERP(idNotasCancelar_s, tpAmb);
        }
        catch (RemoteException e) {
            System.out.println("Nao foi possivel notificar notas canceladas ao ERP: " + idNotasCancelar_s.toString());
        }
        Query q2 = this.daoLote.criarQuery("select l from EstadoLote as l where (l.estado = :estado) and l.cnpj = :cnpj");
        q2.setParameter("estado", (Object)EstadoLote.ESTADO_LOTE.CONFIRMADO_ENVIO);
        q2.setParameter("cnpj", (Object)this.cnpj);
        List lotes = q2.getResultList();
        for (EstadoLote estadoLote : lotes) {
            this.daoLote.refresh(estadoLote);
            System.out.println("Setando contingencia Lote: " + estadoLote.getId());
            estadoLote.setEstadoOperacao(PropriedadesSistema.MODO_OP.CONTINGENCIA);
            this.daoLote.unir(estadoLote);
        }
    }

    @Override
    public void entrarEmContingencia(String tpAmb) {
        System.out.println("Marcar como contingencia");
        this.ajustarNotasEnviadas(tpAmb);
    }

    private synchronized void checarEstadoNotasComServico(String tpAmb, String idUsuario) throws Exception {
        this.daoNota.clear();
        System.gc();
        Query q = this.daoNota.criarQuery("select e from EstadoNFe as e where e.estado = :estado and e.cnpj = :cnpj and e.ambiente = :tpAmb");
        q.setParameter("estado", (Object)EstadoNFe.ESTADO_NFE.ENVIADA);
        q.setParameter("cnpj", (Object)this.cnpj);
        q.setParameter("tpAmb", (Object)tpAmb);
        List notas = null;
        try {
            notas = q.getResultList();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        for (EstadoNFe estadoNFe : notas) {
            System.out.println("nfe: " + estadoNFe.getId());
            this.daoNota.refresh(estadoNFe);
            this.consultor.consularNota(estadoNFe.getId(), tpAmb, false, idUsuario);
            this.daoNota.refresh(estadoNFe);
            if (estadoNFe.getEstado() == EstadoNFe.ESTADO_NFE.AUTORIZADA && estadoNFe.getModoOperacao() == PropriedadesSistema.MODO_OP.CONTINGENCIA) {
                System.out.println("Cancelando Nota: " + estadoNFe.getId());
                try {
                    this.cancInun.cancelarNota(estadoNFe.getId(), tpAmb, "SAIDA DO MODO DE CONTIGENCIA", true, idUsuario);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (estadoNFe.getEstado() != EstadoNFe.ESTADO_NFE.REJEITADA || estadoNFe.getModoOperacao() != PropriedadesSistema.MODO_OP.CONTINGENCIA) continue;
            System.out.println("Inutilizar: " + estadoNFe.getId());
            try {
                this.cancInun.inutulizarNota(estadoNFe.getId(), tpAmb, "SAIDA DO MODO DE CONTIGENCIA", true, idUsuario);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String tirarAssinatura(String nota) {
        int i1 = nota.indexOf("<Signature");
        int i2 = nota.indexOf("</Signature>");
        if (i1 < 0 || i2 < 0) {
            return nota;
        }
        String assinatura = nota.substring(i1, i2 + "</Signature>".length());
        return nota.replace(assinatura, "");
    }

    private synchronized void retransmitirNotas(String tpAmb, String idUsuario) {
        this.daoNota.clear();
        System.gc();
        Query q = this.daoNota.criarQuery("select e from EstadoNFe as e where ((e.estado = :estado1 and e.modoOperacao = :op) OR (e.estado = :estado2 and e.modoOperacao = :op) OR (e.estado = :estado3)) and e.cnpj = :cnpj and e.ambiente = :tpAmb");
        q.setParameter("estado1", (Object)EstadoNFe.ESTADO_NFE.GERADA);
        q.setParameter("estado2", (Object)EstadoNFe.ESTADO_NFE.TENTANDO_ENVIO);
        q.setParameter("op", (Object)PropriedadesSistema.MODO_OP.CONTINGENCIA);
        q.setParameter("estado3", (Object)EstadoNFe.ESTADO_NFE.IMPRESSA_CONT);
        q.setParameter("cnpj", (Object)this.cnpj);
        q.setParameter("tpAmb", (Object)tpAmb);
        List notas = null;
        try {
            notas = q.getResultList();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        for (EstadoNFe estadoNFe : notas) {
            try {
                this.daoNota.refresh(estadoNFe);
                String notaXML = estadoNFe.getXmlString();
                if (notaXML == null) {
                    System.out.println("Nota sem XML: " + notaXML);
                    continue;
                }
                try {
                    notaXML = this.tirarAssinatura(notaXML);
                    GerenciadorProxy.getGerenciador().enviarNota(estadoNFe.getCnpj(), estadoNFe.getCnpjDestino(), estadoNFe.getId(), tpAmb, notaXML, estadoNFe.getDataActualizada(), idUsuario);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void inutilizarContingencia(String tpAmb, String idUsuario) {
        this.daoNota.clear();
        System.gc();
        Query q = this.daoNota.criarQuery("select e from EstadoNFe as e where e.estado = :estado1 and e.cnpj = :cnpj and e.ambiente = :tpAmb");
        q.setParameter("estado1", (Object)EstadoNFe.ESTADO_NFE.CANCELADA_CONTINGENCIA);
        q.setParameter("cnpj", (Object)this.cnpj);
        q.setParameter("tpAmb", (Object)tpAmb);
        List notas = null;
        try {
            notas = q.getResultList();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        for (EstadoNFe nota : notas) {
            try {
                this.cancInun.inutulizarNota(nota.getId(), tpAmb, "CANCELADA EM CONTINGENCIA", true, idUsuario);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void cancelarContingencia(String tpAmb, String idUsuario) {
        this.daoNota.clear();
        System.gc();
        Query q = this.daoNota.criarQuery("select e from EstadoNFe as e where e.estado = :estado1 and e.cnpj = :cnpj and e.ambiente = :tpAmb");
        q.setParameter("estado1", (Object)EstadoNFe.ESTADO_NFE.CANCELAR_SAIDA_CONTINGENCIA);
        q.setParameter("cnpj", (Object)this.cnpj);
        q.setParameter("tpAmb", (Object)tpAmb);
        List notas = null;
        try {
            notas = q.getResultList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (EstadoNFe nota : notas) {
            try {
                CacheNotas.obterInstancia().ajustarEstado(nota.getId(), tpAmb, EstadoNFe.ESTADO_NFE.AUTORIZADA, true, idUsuario);
                this.cancInun.cancelarNota(nota.getId(), tpAmb, nota.getMotivoErro(), false, idUsuario);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void salirDeContingencia(String tpAmb, String idUsuario) {
        System.out.println("Checando estado com servicos & Cancelando e Inutilizando notas");
        try {
            this.checarEstadoNotasComServico(tpAmb, idUsuario);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Retransmissao de notas");
        this.retransmitirNotas(tpAmb, idUsuario);
        this.inutilizarContingencia(tpAmb, idUsuario);
        this.cancelarContingencia(tpAmb, idUsuario);
    }

    public static void main(String[] args) {
        PropriedadesMain.processarComandos(args);
        BaseDadosConfig bd = new BaseDadosConfig();
        bd.setNomeDriver(ConfiguracaoSys.getDRIVER());
        bd.setUsuario(ConfiguracaoSys.getUSER_NAME());
        bd.setSenha(ConfiguracaoSys.getPASSWORD());
        bd.setUrl(ConfiguracaoSys.getURL_CONECTION());
        bd.setToplinkProp("updates");
        PropriedadesSistema.setBdConfig(bd);
        TratadorContingenciaTaragona t = new TratadorContingenciaTaragona("12345678901234", null);
        try {
            t.ajustarNotasEnviadas(ConfiguracaoSys.getTipoAmbiente());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

