/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.persistence;

import br.com.taragona.nfe.persistence.LogNFe;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.data.BaseDadosConfig;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import javax.persistence.Query;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;

public class DAOGenerico<Classe> {
    private static boolean update_tables = true;
    public static volatile EntityManagerFactory fact;
    private EntityManager em;
    private Class c;

    public synchronized void criarEntityManger() {
        if (fact == null) {
            BaseDadosConfig bdConfig = PropriedadesSistema.getBdConfig();
            HashMap<String, String> h = new HashMap<String, String>();
            h.put("javax.persistence.jdbc.password", bdConfig.getSenha());
            h.put("javax.persistence.jdbc.user", bdConfig.getUsuario());
            h.put("javax.persistence.jdbc.url", bdConfig.getUrl());
            h.put("javax.persistence.jdbc.driver", bdConfig.getNomeDriver());
            if (bdConfig.getToplinkProp().toLowerCase().equals("create-or-extend-tables")) {
                h.put("eclipselink.ddl-generation.output-mode", "database");
            }
            h.put("eclipselink.ddl-generation", bdConfig.getToplinkProp());
            System.out.println("DAOGenerico: conectando em " + bdConfig.getUrl());
            System.out.println("DAOGenerico: driver = " + bdConfig.getNomeDriver());
            System.out.println("DAOGenerico: toplink: " + bdConfig.getToplinkProp());
            System.out.println("DAOGenerico: url=" + bdConfig.getUrl());
            fact = Persistence.createEntityManagerFactory((String)"MessengerAPIPU", h);
            this.em = fact.createEntityManager();
            if (update_tables) {
                if (bdConfig.getUrl().toLowerCase().indexOf("mysql") >= 0) {
                    DAOGenerico.addNewField(this.em, "LogNFe", "IDUSUARIO", "varchar(255)");
                    DAOGenerico.addNewField(this.em, "EventoInfo", "IDUSUARIO", "varchar(255)");
                    DAOGenerico.addNewField(this.em, "EstadoNFe", "OBSERVACAO", "longtext");
                    DAOGenerico.addNewField(this.em, "EstadoNFe", "AMBIENTE", "varchar(1)");
                    DAOGenerico.addNewField(this.em, "EstadoNFeOld", "AMBIENTE", "varchar(1)");
                    DAOGenerico.addNewField(this.em, "EstadoLote", "AMBIENTE", "varchar(1)");
                    DAOGenerico.addNewField(this.em, "ExtraXMLInfo", "AMBIENTE", "varchar(1)");
                    DAOGenerico.addNewField(this.em, "LogNFe", "AMBIENTE", "varchar(1)");
                    DAOGenerico.addNewField(this.em, "LogEnvioEmail", "AMBIENTE", "varchar(1)");
                    DAOGenerico.addNewField(this.em, "EstadoRecibo", "AMBIENTE", "varchar(1)");
                    DAOGenerico.addNewField(this.em, "EPECInfo", "AMBIENTE", "varchar(1)");
                    DAOGenerico.addNewField(this.em, "Empresa", "AMBIENTE", "varchar(1)");
                    DAOGenerico.addNewField(this.em, "EmpresaLFU", "AMBIENTE", "varchar(1)");
                    DAOGenerico.addNewField(this.em, "XMLBoleto", "AMBIENTE", "varchar(1)");
                } else if (bdConfig.getUrl().toLowerCase().indexOf("oracle") >= 0) {
                    DAOGenerico.addNewFieldOracle(this.em, "LogNFe", "IDUSUARIO", "varchar2(255)");
                    DAOGenerico.addNewFieldOracle(this.em, "EventoInfo", "IDUSUARIO", "varchar2(255)");
                    DAOGenerico.addNewFieldOracle(this.em, "EstadoNFe", "OBSERVACAO", "clob");
                    DAOGenerico.addNewFieldOracle(this.em, "EstadoNFe", "AMBIENTE", "varchar2(1)");
                    DAOGenerico.addNewFieldOracle(this.em, "EstadoNFeOld", "AMBIENTE", "varchar2(1)");
                    DAOGenerico.addNewFieldOracle(this.em, "EstadoLote", "AMBIENTE", "varchar2(1)");
                    DAOGenerico.addNewFieldOracle(this.em, "ExtraXMLInfo", "AMBIENTE", "varchar2(1)");
                    DAOGenerico.addNewFieldOracle(this.em, "LogNFe", "AMBIENTE", "varchar2(1)");
                    DAOGenerico.addNewFieldOracle(this.em, "LogEnvioEmail", "AMBIENTE", "varchar2(1)");
                    DAOGenerico.addNewFieldOracle(this.em, "EstadoRecibo", "AMBIENTE", "varchar2(1)");
                    DAOGenerico.addNewFieldOracle(this.em, "EPECInfo", "AMBIENTE", "varchar2(1)");
                    DAOGenerico.addNewFieldOracle(this.em, "Empresa", "AMBIENTE", "varchar2(1)");
                    DAOGenerico.addNewFieldOracle(this.em, "EmpresaLFU", "AMBIENTE", "varchar2(1)");
                    DAOGenerico.addNewFieldOracle(this.em, "XMLBoleto", "AMBIENTE", "varchar2(1)");
                } else if (bdConfig.getUrl().toLowerCase().indexOf("sqlserver") >= 0) {
                    DAOGenerico.addNewFieldSQLServer(this.em, "LogNFe", "IDUSUARIO", "NVARCHAR(255)");
                    DAOGenerico.addNewFieldSQLServer(this.em, "EventoInfo", "IDUSUARIO", "NVARCHAR(255)");
                    DAOGenerico.addNewFieldSQLServer(this.em, "EstadoNFe", "OBSERVACAO", "NVARCHAR(MAX)");
                    DAOGenerico.addNewFieldSQLServer(this.em, "EstadoNFe", "AMBIENTE", "NVARCHAR(1)");
                    DAOGenerico.addNewFieldSQLServer(this.em, "EstadoNFeOld", "AMBIENTE", "NVARCHAR(1)");
                    DAOGenerico.addNewFieldSQLServer(this.em, "EstadoLote", "AMBIENTE", "NVARCHAR(1)");
                    DAOGenerico.addNewFieldSQLServer(this.em, "ExtraXMLInfo", "AMBIENTE", "NVARCHAR(1)");
                    DAOGenerico.addNewFieldSQLServer(this.em, "LogNFe", "AMBIENTE", "NVARCHAR(1)");
                    DAOGenerico.addNewFieldSQLServer(this.em, "LogEnvioEmail", "AMBIENTE", "NVARCHAR(1)");
                    DAOGenerico.addNewFieldSQLServer(this.em, "EstadoRecibo", "AMBIENTE", "NVARCHAR(1)");
                    DAOGenerico.addNewFieldSQLServer(this.em, "EPECInfo", "AMBIENTE", "NVARCHAR(1)");
                    DAOGenerico.addNewFieldSQLServer(this.em, "Empresa", "AMBIENTE", "NVARCHAR(1)");
                    DAOGenerico.addNewFieldSQLServer(this.em, "EmpresaLFU", "AMBIENTE", "NVARCHAR(1)");
                    DAOGenerico.addNewFieldSQLServer(this.em, "XMLBoleto", "AMBIENTE", "NVARCHAR(1)");
                }
                update_tables = false;
            }
        } else {
            this.em = fact.createEntityManager();
        }
    }

    public DAOGenerico(Class c) {
        this.c = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureEntityManager() {
        if (this.em != null && this.em.isOpen()) {
            return;
        }
        DAOGenerico dAOGenerico = this;
        synchronized (dAOGenerico) {
            if (this.em == null || !this.em.isOpen()) {
                this.criarEntityManger();
            }
        }
    }

    public synchronized void clear() {
        this.ensureEntityManager();
        this.em.clear();
    }

    public synchronized void detach(Object entity) {
        this.ensureEntityManager();
        EntityTransaction t = this.em.getTransaction();
        try {
            if (t.isActive()) {
                t.rollback();
            }
            this.em.detach(entity);
        }
        catch (Exception e) {
            Throwable causa = e.getCause();
            causa.printStackTrace();
        }
    }

    public synchronized void salvar(Classe obj) {
        this.ensureEntityManager();
        if (obj instanceof LogNFe) {
            LogNFe log = (LogNFe)obj;
            System.out.println(">>> Salvando LogNFe, id atual = " + log.getId());
        }
        EntityTransaction t = this.em.getTransaction();
        try {
            t.begin();
            this.em.persist(obj);
            t.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            t.rollback();
        }
    }

    public synchronized Classe carregar(Object id) {
        this.ensureEntityManager();
        return (Classe)this.em.find(this.c, id);
    }

    public synchronized void remover(Object id) {
        this.ensureEntityManager();
        EntityTransaction t = this.em.getTransaction();
        try {
            t.begin();
            this.em.remove(this.carregar(id));
            t.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            t.rollback();
        }
    }

    public synchronized void removerEntity(Object obj) {
        this.ensureEntityManager();
        EntityTransaction t = this.em.getTransaction();
        try {
            t.begin();
            this.em.remove(obj);
            t.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            t.rollback();
        }
    }

    public synchronized List<Classe> fazerConsulta(String sql) {
        this.ensureEntityManager();
        return this.em.createQuery(sql).getResultList();
    }

    public synchronized List<Classe> obterElementos() {
        this.ensureEntityManager();
        String sql = "select o from " + this.c.getSimpleName() + " as o ";
        return this.fazerConsulta(sql);
    }

    public synchronized void unir(Classe obj) {
        this.ensureEntityManager();
        EntityTransaction t = this.em.getTransaction();
        try {
            t.begin();
            this.em.merge(obj);
            t.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            t.rollback();
        }
    }

    public synchronized void refresh(Classe obj) {
        this.ensureEntityManager();
        EntityTransaction t = this.em.getTransaction();
        try {
            t.begin();
            this.em.refresh(obj);
            t.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            t.rollback();
        }
    }

    public synchronized Classe buscarPorIdObject(Object id) {
        this.ensureEntityManager();
        return (Classe)this.em.find(this.c, id);
    }

    public synchronized Classe buscarPorIdString(String id) {
        this.ensureEntityManager();
        return (Classe)this.em.find(this.c, (Object)id);
    }

    public synchronized Classe buscarPorIdLong(Long id) {
        this.ensureEntityManager();
        String sql = "select o from " + this.c.getSimpleName() + " as o where o.id = " + id.toString();
        List list = this.em.createQuery(sql).getResultList();
        if (list.isEmpty()) {
            return null;
        }
        return (Classe)list.get(0);
    }

    public synchronized Classe buscarPorIdInt(int id) {
        this.ensureEntityManager();
        String sql = "select o from " + this.c.getSimpleName() + " as o where o.id = " + id;
        List list = this.em.createQuery(sql).getResultList();
        if (list.isEmpty()) {
            return null;
        }
        return (Classe)list.get(0);
    }

    public synchronized Classe buscarPorNome(String nome) {
        this.ensureEntityManager();
        String sql = "select o from " + this.c.getCanonicalName() + " as o where o.nome like '%" + nome + "%'";
        List list = this.em.createQuery(sql).getResultList();
        if (list.isEmpty()) {
            return null;
        }
        return (Classe)list.get(0);
    }

    public synchronized void flush() {
        this.ensureEntityManager();
        EntityTransaction t = this.em.getTransaction();
        t.begin();
        this.em.flush();
        t.commit();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.em.isOpen()) {
                this.em.close();
                this.em = null;
            }
        }
        finally {
            super.finalize();
        }
    }

    public Query criarQuery(String sql) {
        this.ensureEntityManager();
        return this.em.createQuery(sql);
    }

    public synchronized Query criarNativeQuery(String sql) {
        this.ensureEntityManager();
        Query q = this.em.createNativeQuery(sql, this.c);
        return q;
    }

    public synchronized Query filter(String sql) {
        this.ensureEntityManager();
        Query q = this.em.createNativeQuery(sql);
        return q;
    }

    public synchronized void close() {
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
            this.em = null;
        }
    }

    private static void addNewField(EntityManager em, String table, String field, String type) {
        try {
            EntityManagerImpl emi = (EntityManagerImpl)em.getDelegate();
            UnitOfWorkImpl uow = (UnitOfWorkImpl)emi.getUnitOfWork();
            Connection cn = uow.getAccessor().getConnection();
            DatabaseMetaData metadata = cn.getMetaData();
            boolean columnExists = false;
            try {
                ResultSet rs = metadata.getColumns(null, null, table, field);
                columnExists = rs.next();
                rs.getStatement().close();
                rs.close();
                rs = null;
            }
            catch (Exception rs) {
                // empty catch block
            }
            if (!columnExists) {
                String query = "ALTER TABLE " + table + " ADD COLUMN " + field + " " + type;
                Statement stmt = cn.createStatement();
                stmt.executeUpdate(query);
                stmt.close();
                System.out.println("Coluna " + field + " adicionada com sucesso em " + table + ".");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addNewFieldOracle(EntityManager em, String table, String field, String type) {
        try {
            EntityManagerImpl emi = (EntityManagerImpl)em.getDelegate();
            UnitOfWorkImpl uow = (UnitOfWorkImpl)emi.getUnitOfWork();
            Connection cn = uow.getAccessor().getConnection();
            DatabaseMetaData metadata = cn.getMetaData();
            boolean columnExists = false;
            try {
                ResultSet rs = metadata.getColumns(null, null, table.toUpperCase(), field.toUpperCase());
                columnExists = rs.next();
                rs.getStatement().close();
                rs.close();
                rs = null;
            }
            catch (Exception rs) {
                // empty catch block
            }
            if (!columnExists) {
                String query = "ALTER TABLE " + table + " ADD " + field + " " + type;
                Statement stmt = cn.createStatement();
                stmt.executeUpdate(query);
                stmt.close();
                System.out.println("Coluna " + field + " adicionada com sucesso em " + table + ".");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addNewFieldSQLServer(EntityManager em, String table, String field, String type) {
        try {
            EntityManagerImpl emi = (EntityManagerImpl)em.getDelegate();
            UnitOfWorkImpl uow = (UnitOfWorkImpl)emi.getUnitOfWork();
            Connection cn = uow.getAccessor().getConnection();
            DatabaseMetaData metadata = cn.getMetaData();
            boolean columnExists = false;
            try {
                ResultSet rs = metadata.getColumns(null, null, table, field);
                columnExists = rs.next();
                rs.getStatement().close();
                rs.close();
                rs = null;
            }
            catch (Exception rs) {
                // empty catch block
            }
            if (!columnExists) {
                String query = "ALTER TABLE " + table + " ADD " + field + " " + type;
                Statement stmt = cn.createStatement();
                stmt.executeUpdate(query);
                stmt.close();
                System.out.println("Coluna " + field + " adicionada com sucesso em " + table + ".");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

