/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.persistence;

import br.com.taragona.nfe.cockpitserver.CockpitPartch;
import br.com.taragona.nfe.persistence.EntidadeId;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.util.PropriedadesSistema;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@IdClass(value=EntidadeId.class)
public class EstadoLote
implements Serializable {
    private static final long serialVersionUID = 1302415217288508166L;
    @Id
    private String id;
    @Id
    @Column(name="AMBIENTE", nullable=false, length=1)
    private String ambiente = "2";
    private String cnpj;
    private ESTADO_LOTE estado;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date data;
    private Long estadoNFe;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataEnvio;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataConsulta;
    @Lob
    private String xmlString;
    private PropriedadesSistema.MODO_OP estadoOperacao;
    @OneToMany(mappedBy="lote")
    private Set<EstadoNFe> notas;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date ultimaTentativa;
    private int numeroTentativa;
    private String numeroRecibo;
    private ESTADO_RECIBO estadoRecibo;
    private Long estadoNFeRecibo;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataProcessamentoRecibo;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataRecebementoRecibo;

    public Date getData() {
        return this.data;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public ESTADO_LOTE getEstado() {
        return this.estado;
    }

    public void setEstado(ESTADO_LOTE estado) {
        this.estado = estado;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(String ambiente) {
        this.ambiente = ambiente;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    public Long getEstadoNFe() {
        return this.estadoNFe;
    }

    public void setEstadoNFe(Long estadoNFe) {
        this.estadoNFe = estadoNFe;
    }

    public Date getDataConsulta() {
        return this.dataConsulta;
    }

    public void setDataConsulta(Date dataConsulta) {
        this.dataConsulta = dataConsulta;
    }

    public Date getDataEnvio() {
        return this.dataEnvio;
    }

    public void setDataEnvio(Date dataEnvio) {
        this.dataEnvio = dataEnvio;
    }

    public String getXmlString() {
        return this.xmlString;
    }

    public void setXmlString(String xmlString) {
        this.xmlString = xmlString;
        if (this.xmlString != null) {
            this.ambiente = CockpitPartch.getValueByTag(this.xmlString, "tpAmb");
        }
    }

    public PropriedadesSistema.MODO_OP getEstadoOperacao() {
        return this.estadoOperacao;
    }

    public void setEstadoOperacao(PropriedadesSistema.MODO_OP estadoOperacao) {
        this.estadoOperacao = estadoOperacao;
    }

    public Set<EstadoNFe> getNotas() {
        return this.notas;
    }

    public void setNotas(Set<EstadoNFe> notas) {
        this.notas = notas;
    }

    public int getNumeroTentativa() {
        return this.numeroTentativa;
    }

    public void setNumeroTentativa(int numeroTentativa) {
        this.numeroTentativa = numeroTentativa;
    }

    public Date getUltimaTentativa() {
        return this.ultimaTentativa;
    }

    public void setUltimaTentativa(Date ultimaTentativa) {
        this.ultimaTentativa = ultimaTentativa;
    }

    public Date getDataProcessamentoRecibo() {
        return this.dataProcessamentoRecibo;
    }

    public void setDataProcessamentoRecibo(Date dataProcessamentoRecibo) {
        this.dataProcessamentoRecibo = dataProcessamentoRecibo;
    }

    public Long getEstadoNFeRecibo() {
        return this.estadoNFeRecibo;
    }

    public void setEstadoNFeRecibo(Long estadoNFeRecibo) {
        this.estadoNFeRecibo = estadoNFeRecibo;
    }

    public ESTADO_RECIBO getEstadoRecibo() {
        return this.estadoRecibo;
    }

    public void setEstadoRecibo(ESTADO_RECIBO estadoRecibo) {
        this.estadoRecibo = estadoRecibo;
    }

    public String getNumeroRecibo() {
        return this.numeroRecibo;
    }

    public void setNumeroRecibo(String numeroRecibo) {
        this.numeroRecibo = numeroRecibo;
    }

    public Date getDataRecebementoRecibo() {
        return this.dataRecebementoRecibo;
    }

    public void setDataRecebementoRecibo(Date dataRecebementoRecibo) {
        this.dataRecebementoRecibo = dataRecebementoRecibo;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof EstadoLote)) {
            return false;
        }
        EstadoLote other = (EstadoLote)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "br.com.taragona.nfe.persistence.EstadoLote[id=" + this.id + "]";
    }

    public static enum ESTADO_LOTE {
        ENVIADO,
        CONFIRMADO_ENVIO,
        ERRO_ENVIO,
        GERADO,
        PROCESSADO,
        TEMPO_PROCESSAMENTO_LIMITE,
        TENTANDO_ENVIO,
        ERRO_ESQUEMA;

    }

    public static enum ESTADO_RECIBO {
        CHECADO,
        PENDENTE;

    }
}

