/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.persistence;

import br.com.taragona.nfe.persistence.EntidadeId;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@IdClass(value=EntidadeId.class)
public class EstadoRecibo
implements Serializable {
    private static final long serialVersionUID = -3956384758121466128L;
    @Id
    private String id;
    @Id
    @Column(name="AMBIENTE", length=1)
    private String ambiente = "2";
    private String cnpj;
    private ESTADO_RECIBO estado;
    private String idLote;
    private Long estadoNFe;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataRecebido;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataProcessamento;
    @Lob
    private String xmlString;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    public ESTADO_RECIBO getEstado() {
        return this.estado;
    }

    public void setEstado(ESTADO_RECIBO estado) {
        this.estado = estado;
    }

    public String getIdLote() {
        return this.idLote;
    }

    public void setIdLote(String idLote) {
        this.idLote = idLote;
    }

    public String getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(String ambiente) {
        this.ambiente = ambiente;
        this.initializeAmbiente();
    }

    public Date getDataProcessamento() {
        return this.dataProcessamento;
    }

    public void setDataProcessamento(Date dataProcessamento) {
        this.dataProcessamento = dataProcessamento;
    }

    public Date getDataRecebido() {
        return this.dataRecebido;
    }

    public void setDataRecebido(Date dataRecebido) {
        this.dataRecebido = dataRecebido;
    }

    public Long getEstadoNFe() {
        return this.estadoNFe;
    }

    public void setEstadoNFe(Long estadoNFe) {
        this.estadoNFe = estadoNFe;
    }

    public String getXmlString() {
        return this.xmlString;
    }

    public void setXmlString(String xmlString) {
        this.xmlString = xmlString;
        this.initializeAmbiente();
    }

    private void initializeAmbiente() {
        if ((this.ambiente == null || this.ambiente.equals("")) && this.xmlString != null && this.xmlString.contains("<tpAmb>")) {
            int startIndex = this.xmlString.indexOf("<tpAmb>") + 7;
            int endIndex = this.xmlString.indexOf("</tpAmb>");
            if (startIndex >= 0 && endIndex > startIndex) {
                this.ambiente = this.xmlString.substring(startIndex, endIndex);
            }
        }
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof EstadoRecibo)) {
            return false;
        }
        EstadoRecibo other = (EstadoRecibo)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "br.com.taragona.nfe.persistence.EstadoRecibo[id=" + this.id + "]";
    }

    public static enum ESTADO_RECIBO {
        CHECADO,
        PENDENTE;

    }
}

