/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.persistence.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Vector;

public class QuickDB {
    private Connection cx;
    private String urlCx;
    private String user;
    private String password;

    public QuickDB(String urlCx, String user, String password) {
        this.urlCx = urlCx;
        this.user = user;
        this.password = password;
        try {
            this.cx = DriverManager.getConnection(urlCx, user, password);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void autorizarNota(String id) {
        try {
            if (this.cx == null || this.cx.isClosed()) {
                this.cx = DriverManager.getConnection(this.urlCx, this.user, this.password);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            String sql = "UPDATE EstadoNFe SET estado = 2 WHERE id =?";
            PreparedStatement sta = this.cx.prepareStatement(sql);
            sta.setString(1, id);
            sta.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void associarLote(String idLote, Collection<String> idNotas) {
        try {
            if (this.cx == null || this.cx.isClosed()) {
                this.cx = DriverManager.getConnection(this.urlCx, this.user, this.password);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            String sql = "UPDATE EstadoNFe SET lote_id = ? WHERE id = ?";
            PreparedStatement statement = this.cx.prepareStatement(sql);
            statement.setString(1, idLote);
            System.out.println("lote ->" + idLote);
            for (String idNota : idNotas) {
                System.out.println("nota -> " + idNota);
                statement.setString(2, idNota);
                statement.executeUpdate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void limparTabela(String tabela) {
        try {
            String sql = "DELETE FROM " + tabela;
            Statement stat = this.cx.createStatement();
            stat.executeUpdate(sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Vector<String> obterIdLotesPendendetsDB(String tabela) {
        try {
            if (this.cx == null || this.cx.isClosed()) {
                this.cx = DriverManager.getConnection(this.urlCx, this.user, this.password);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        Vector<String> lotes = new Vector<String>();
        try {
            String sql = "select * from " + tabela + " where estado = 1 ";
            Statement s = this.cx.createStatement();
            ResultSet rs = s.executeQuery(sql);
            while (rs.next()) {
                lotes.add(rs.getString("Id"));
            }
            return lotes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean existeNota(String table, String id) {
        try {
            if (this.cx == null || this.cx.isClosed()) {
                this.cx = DriverManager.getConnection(this.urlCx, this.user, this.password);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            String sql = "select * from " + table + " where id = '" + id + "';";
            Statement stat = this.cx.createStatement();
            ResultSet r = stat.executeQuery(sql);
            return r.next();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void deleteEntity(String table, String id) {
        try {
            if (this.cx == null || this.cx.isClosed()) {
                this.cx = DriverManager.getConnection(this.urlCx, this.user, this.password);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            String sql = "delete from " + table + " where id = '" + id + "'";
            Statement stat = this.cx.createStatement();
            stat.executeUpdate(sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws SQLException {
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        QuickDB d = new QuickDB("jdbc:mysql://localhost/nfe", "root", "taragona");
        System.out.println(d.existeNota("estadonfe", "NFe00792629994932267140073004596321535248515787"));
    }
}

