/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.sender;

import br.com.taragona.nfe.sender.MyServer;
import br.com.taragona.nfe.sender.util.MyAuthenticator;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.logger.LoggingJava;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;

public class PortFactory {
    private Hashtable<String, MyServer> services = new Hashtable();
    private Hashtable<String, Hashtable<String, Object>> ports = new Hashtable();
    protected Hashtable<String, String> portNames;
    protected Hashtable<String, String> namespaceNames;
    protected Hashtable<String, String> nomeServico;
    protected Hashtable<String, Class> classServices;
    protected Hashtable<String, Hashtable<String, String>> urlServicosNormal;
    protected Hashtable<String, Hashtable<String, String>> urlServicosScan;
    protected Hashtable<String, Hashtable<String, String>> urlServicosHomolgacao;
    protected Hashtable<String, Hashtable<String, String>> urlServicosDpecHom;
    protected Hashtable<String, Hashtable<String, String>> urlServicosDpecProd;

    public Object criarPort(String idServico, String UF, String tipo) throws RemoteException {
        Class c = this.classServices.get(idServico);
        return this.criarPort(idServico, c, UF, tipo);
    }

    public Object criarPort(String idServico, Class classe, String UF, String tipo) throws RemoteException {
        Object port;
        Hashtable<String, Object> portUF;
        String url = null;
        if (tipo.equals(PropriedadesSistema.ID_PRODUCAO)) {
            url = this.urlServicosNormal.get(UF).get(idServico);
        }
        if (tipo.equals(PropriedadesSistema.ID_HOMOLOGACAO)) {
            url = this.urlServicosHomolgacao.get(UF).get(idServico);
        }
        if (tipo.equals(PropriedadesSistema.ID_SCAN)) {
            url = this.urlServicosScan.get(UF).get(idServico);
        }
        System.out.println("url: " + url);
        LoggingJava.logger.log(Level.WARNING, " URL:" + url + " servico:" + idServico + " uf:" + UF + " tipo: " + tipo);
        System.out.println("port:" + this.portNames.get(url));
        QName portName = new QName(this.namespaceNames.get(url), this.portNames.get(url));
        QName servicoName = new QName(this.namespaceNames.get(url), this.nomeServico.get(url));
        MyServer servico = this.services.get(url);
        if (servico == null) {
            URL urlO = null;
            try {
                urlO = new URL(url);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            try {
                servico = new MyServer(urlO, servicoName);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.services.remove(url);
                throw new RemoteException("Erro criando servico:" + url);
            }
            if (servico != null) {
                this.services.put(url, servico);
            }
        }
        if ((portUF = this.ports.get(url)) == null) {
            portUF = new Hashtable();
        }
        if ((port = portUF.get(classe.getCanonicalName())) == null) {
            try {
                port = servico.getPort(portName, classe);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.ports.remove(classe.getCanonicalName());
                throw new RemoteException("Erro criando port:" + portName);
            }
            portUF.put(classe.getCanonicalName(), port);
        }
        this.ports.put(url, portUF);
        if (PropriedadesMain.isProxy()) {
            BindingProvider binding = (BindingProvider)port;
            binding.getRequestContext().put("javax.xml.ws.security.auth.username", MyAuthenticator.loginStatic);
            binding.getRequestContext().put("javax.xml.ws.security.auth.password", MyAuthenticator.passStatic);
        }
        return port;
    }

    public void setPortNames(Hashtable<String, String> portNames) {
        this.portNames = portNames;
    }

    public void setNamespaceNames(Hashtable<String, String> namespaceNames) {
        this.namespaceNames = namespaceNames;
    }

    public void setUrlServicosNormal(Hashtable<String, Hashtable<String, String>> urlServicosNormal) {
        this.urlServicosNormal = urlServicosNormal;
    }

    public void setUrlServicosScan(Hashtable<String, Hashtable<String, String>> urlServicosScan) {
        this.urlServicosScan = urlServicosScan;
    }

    public void setUrlServicosHomolgacao(Hashtable<String, Hashtable<String, String>> urlServicosHomolgacao) {
        this.urlServicosHomolgacao = urlServicosHomolgacao;
    }

    public void setNomeServico(Hashtable<String, String> nomeServico) {
        this.nomeServico = nomeServico;
    }

    public void setClassServices(Hashtable<String, Class> classServices) {
        this.classServices = classServices;
    }

    public Hashtable<String, Hashtable<String, String>> getUrlServicosDpecHom() {
        return this.urlServicosDpecHom;
    }

    public void setUrlServicosDpecHom(Hashtable<String, Hashtable<String, String>> urlServicosDpecHom) {
        this.urlServicosDpecHom = urlServicosDpecHom;
    }

    public Hashtable<String, Hashtable<String, String>> getUrlServicosDpecProd() {
        return this.urlServicosDpecProd;
    }

    public void setUrlServicosDpecProd(Hashtable<String, Hashtable<String, String>> urlServicosDpecProd) {
        this.urlServicosDpecProd = urlServicosDpecProd;
    }
}

