/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.tools;

import assinador.Main;
import assinador.pkcs11.AssinadorPKCS11;
import br.com.taragona.nfe.danfe.ImprimirDANFEImpl;
import br.com.taragona.nfe.util.xml.XMLFactory;
import java.io.File;
import java.io.FileWriter;
import java.util.Vector;

public class AssinadorRPS {
    private Main ass;
    private String senha;
    private File sourcedir;
    private File targetdir;

    public AssinadorRPS(String configname, String senha) {
        this.senha = senha;
        if (configname.endsWith("cfg")) {
            this.ass = new AssinadorPKCS11(configname, this.senha);
        }
        if (configname.endsWith("pfx")) {
            this.ass = new Main(configname, senha);
        }
    }

    public Vector<String> extractRPS(String xml) {
        String[] partes;
        int pos1 = xml.indexOf("<ListaRps>");
        int pos2 = xml.indexOf("</ListaRps>");
        xml = xml.substring(pos1 + "<ListaRps>".length(), pos2);
        Vector<String> xmlrps = new Vector<String>();
        String[] stringArray = partes = xml.split("<Rps>");
        int n = partes.length;
        int n2 = 0;
        while (n2 < n) {
            String rps = stringArray[n2];
            if ((rps = rps.trim()).startsWith("<InfRps")) {
                xmlrps.add("<Rps>" + rps);
            }
            ++n2;
        }
        return xmlrps;
    }

    private String extractHeader(String xml) {
        int pos1 = xml.indexOf("<Envia");
        int pos2 = xml.indexOf("<ListaRps>");
        String header = xml.substring(pos1, pos2 + "<ListaRps>".length());
        return header;
    }

    private String extractFooter() {
        return "</ListaRps></LoteRps></EnviarLoteRpsEnvio>";
    }

    private String extractRPSAss(String rps) {
        int pos1 = rps.indexOf("<Rps>");
        int pos2 = rps.indexOf("</enviNFe>");
        return rps.substring(pos1, pos2);
    }

    private String extractLoteRPSAss(String rps) {
        int pos1 = rps.indexOf("<Enviar");
        int pos2 = rps.indexOf("</enviNFe>");
        return rps.substring(pos1, pos2);
    }

    public String sign(String xml) throws Exception {
        xml = xml.replace("\n", "");
        Vector<String> rpss = this.extractRPS(xml);
        String allrpsass = new String();
        for (String rps : rpss) {
            String rpslote = XMLFactory.montarLoteRPS("12345", rps.trim());
            String xmlass = this.ass.myAssina(rpslote, "InfRps", "Rps");
            allrpsass = String.valueOf(allrpsass) + this.extractRPSAss(xmlass);
        }
        String loterps = String.valueOf(this.extractHeader(xml)) + allrpsass + this.extractFooter();
        String rpslote = XMLFactory.montarLoteRPS("12345", loterps.trim());
        String loterpsass = this.ass.myAssina(rpslote, "LoteRps", "EnviarLoteRpsEnvio");
        loterpsass = this.extractLoteRPSAss(loterpsass);
        return loterpsass;
    }

    public void readDir() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    File[] files;
                    File[] fileArray = files = AssinadorRPS.this.sourcedir.listFiles();
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        if (file.getAbsolutePath().endsWith(".xml")) {
                            System.out.println("Processando arquivo:" + file.getAbsolutePath());
                            String xml = ImprimirDANFEImpl.lerArquivo(file.getAbsolutePath());
                            String xmlass = null;
                            try {
                                xmlass = AssinadorRPS.this.sign(xml);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            if (xmlass != null) {
                                AssinadorRPS.this.writeFile(file.getName(), xmlass);
                            }
                            file.delete();
                        }
                        ++n2;
                    }
                    System.out.println("Checando pasta:" + AssinadorRPS.this.sourcedir.getAbsolutePath());
                    try {
                        Thread.sleep(2000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
        t.start();
    }

    private void writeFile(String filename, String xml) {
        try {
            FileWriter fw = new FileWriter(String.valueOf(this.targetdir.getAbsolutePath()) + "/" + "assinado_" + filename);
            fw.write(xml);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSourcedir(File sourcedir) {
        this.sourcedir = sourcedir;
    }

    public void setTargetdir(File targetdir) {
        this.targetdir = targetdir;
    }

    public static void main(String[] args) {
        AssinadorRPS ass = new AssinadorRPS("C:\\TTINFe\\certificados\\ttinfe.pfx", "ttinfe");
        String xml = ImprimirDANFEImpl.lerArquivo("C:\\tti.xml");
        try {
            ass.sign(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

