/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.tools;

import br.com.taragona.nfe.clientreferencia.ReferenciaGerenciador;
import br.com.taragona.nfe.gerenciador.GerenciadorInterface;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.util.ConfiguracaoSys;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.data.BaseDadosConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.persistence.Query;

public class CheckNFeIBS {
    private static GerenciadorInterface ger;

    public static void init() {
        try {
            ger = ReferenciaGerenciador.obterReferenciaGerenciador("localhost");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseDadosConfig bd = new BaseDadosConfig();
        bd.setNomeDriver(ConfiguracaoSys.getDRIVER());
        bd.setUsuario(ConfiguracaoSys.getUSER_NAME());
        bd.setSenha(ConfiguracaoSys.getPASSWORD());
        bd.setUrl(ConfiguracaoSys.getURL_CONECTION());
        bd.setToplinkProp("update-tables");
        PropriedadesSistema.setBdConfig(bd);
    }

    public void process(String tpAmb, String idUsuario) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(new File(PropriedadesMain.getOutros())));
        String line = br.readLine();
        DAOGenerico dao = new DAOGenerico(EstadoNFe.class);
        while (line != null) {
            if (!line.trim().isEmpty()) {
                try {
                    String[] tokens = line.split("\\;");
                    String chave = tokens[1].trim();
                    String sql = "SELECT id,dataGerada, dataEnviada, dataAutorizada, dataAtualizada, cnpj, modoOperacao, estado,estadoNFe,protocolo, motivoErro, cnpjDestino from ESTADONFE where id = 'NFe" + chave + "'";
                    Query q = dao.filter(sql);
                    List o = q.getResultList();
                    if (o == null || o.isEmpty()) {
                        System.out.println("[NFe] chave nao encontrada: " + chave);
                    } else {
                        for (Object object1 : o) {
                            try {
                                Vector v = (Vector)object1;
                                String cnpj = v.get(5).toString();
                                EstadoNFe ent = new EstadoNFe();
                                String id = v.get(0).toString();
                                Date dataGerada = null;
                                if (v.get(1) != null) {
                                    dataGerada = (Date)v.get(1);
                                }
                                Date dateEnviada = null;
                                if (v.get(2) != null) {
                                    dateEnviada = (Date)v.get(2);
                                }
                                Date dataAuto = null;
                                if (v.get(3) != null) {
                                    dataAuto = (Date)v.get(3);
                                }
                                Date dataAct = null;
                                if (v.get(4) != null) {
                                    dataAct = (Date)v.get(4);
                                }
                                PropriedadesSistema.MODO_OP mod = null;
                                if (v.get(6) != null) {
                                    mod = this.getModo(Integer.parseInt(v.get(6).toString()));
                                }
                                EstadoNFe.ESTADO_NFE estado = null;
                                if (v.get(7) != null) {
                                    estado = this.getEstado(Integer.parseInt(v.get(7).toString()));
                                }
                                Long estadoNFe = null;
                                if (v.get(8) != null) {
                                    estadoNFe = new Long(Long.parseLong(v.get(8).toString()));
                                }
                                String protocolo = null;
                                if (v.get(9) != null) {
                                    protocolo = v.get(9).toString();
                                }
                                String motivo = null;
                                if (v.get(10) != null) {
                                    motivo = v.get(10).toString();
                                }
                                String dest = null;
                                if (v.get(11) != null) {
                                    dest = v.get(11).toString();
                                }
                                ent.setId(id);
                                ent.setDataGerada(dataGerada);
                                ent.setDataEnviada(dateEnviada);
                                ent.setDataAutorizada(dataAuto);
                                ent.setModoOperacao(mod);
                                ent.setEstado(estado);
                                ent.setEstadoNFe(estadoNFe);
                                ent.setProtocolo(protocolo);
                                ent.setMotivoErro(motivo);
                                ent.setCnpj(cnpj);
                                ent.setDataActualizada(dataAct);
                                ent.setCnpjDestino(dest);
                                System.out.println("[NFe] processando: " + ent.getId() + " estado:" + (Object)((Object)ent.getEstado()));
                                if (EstadoNFe.ESTADO_NFE.AUTORIZADA.equals((Object)ent.getEstado()) || EstadoNFe.ESTADO_NFE.CANCELADA.equals((Object)ent.getEstado()) || EstadoNFe.ESTADO_NFE.REJEITADA.equals((Object)ent.getEstado()) || EstadoNFe.ESTADO_NFE.ERRO_ESQUEMA.equals((Object)ent.getEstado()) || EstadoNFe.ESTADO_NFE.ERRO_VALIDACAO.equals((Object)ent.getEstado())) {
                                    ger.atualizarNota(ent);
                                    continue;
                                }
                                Vector<String> chaves = new Vector<String>();
                                chaves.add(ent.getId());
                                ger.checarConsistencia(chaves, tpAmb, idUsuario);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            line = br.readLine();
        }
    }

    private PropriedadesSistema.MODO_OP getModo(int n) {
        switch (n) {
            case 0: {
                return PropriedadesSistema.MODO_OP.CONTINGENCIA;
            }
            case 1: {
                return PropriedadesSistema.MODO_OP.NORMAL;
            }
            case 2: {
                return PropriedadesSistema.MODO_OP.CONTINGENCIA_SCAN;
            }
            case 3: {
                return PropriedadesSistema.MODO_OP.LASER;
            }
            case 4: {
                return PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC;
            }
        }
        return null;
    }

    private EstadoNFe.ESTADO_NFE getEstado(int n) {
        switch (n) {
            case 0: {
                return EstadoNFe.ESTADO_NFE.USO_DENEGADO;
            }
            case 1: {
                return EstadoNFe.ESTADO_NFE.REJEITADA;
            }
            case 2: {
                return EstadoNFe.ESTADO_NFE.AUTORIZADA;
            }
            case 3: {
                return EstadoNFe.ESTADO_NFE.GERADA;
            }
            case 4: {
                return EstadoNFe.ESTADO_NFE.ASSINADA;
            }
            case 5: {
                return EstadoNFe.ESTADO_NFE.ENVIADA;
            }
            case 6: {
                return EstadoNFe.ESTADO_NFE.ERRO_VALIDACAO;
            }
            case 7: {
                return EstadoNFe.ESTADO_NFE.IMPRESSA_NORMAL;
            }
            case 8: {
                return EstadoNFe.ESTADO_NFE.IMPRESSA_CONT;
            }
            case 9: {
                return EstadoNFe.ESTADO_NFE.CANCELADA;
            }
            case 10: {
                return EstadoNFe.ESTADO_NFE.INUTILIZADA;
            }
            case 11: {
                return EstadoNFe.ESTADO_NFE.TENTANDO_ENVIO;
            }
            case 12: {
                return EstadoNFe.ESTADO_NFE.ERRO_ENVIO;
            }
            case 13: {
                return EstadoNFe.ESTADO_NFE.RESULTADO_SEFAZ;
            }
            case 14: {
                return EstadoNFe.ESTADO_NFE.ERRO;
            }
            case 15: {
                return EstadoNFe.ESTADO_NFE.PEDIDO_CANCELAMENTO;
            }
            case 16: {
                return EstadoNFe.ESTADO_NFE.ERRO_ESQUEMA;
            }
            case 17: {
                return EstadoNFe.ESTADO_NFE.TEMPO_PROCESSAMENTO_LIMITE;
            }
            case 18: {
                return EstadoNFe.ESTADO_NFE.ERRO_ESQUEMA_LOTE;
            }
            case 19: {
                return EstadoNFe.ESTADO_NFE.ERRO_CANCELAMENTO;
            }
            case 20: {
                return EstadoNFe.ESTADO_NFE.ERRO_INUTILIZACAO;
            }
            case 21: {
                return EstadoNFe.ESTADO_NFE.ERRO_IMPRESSAO;
            }
            case 22: {
                return EstadoNFe.ESTADO_NFE.IMPRESSA_LASER;
            }
            case 23: {
                return EstadoNFe.ESTADO_NFE.CANCELADA_CONTINGENCIA;
            }
            case 24: {
                return EstadoNFe.ESTADO_NFE.ERRO_XML_SEFAZ;
            }
            case 25: {
                return EstadoNFe.ESTADO_NFE.CANCELAR_SAIDA_CONTINGENCIA;
            }
            case 26: {
                return EstadoNFe.ESTADO_NFE.DPEC_ENVIADO;
            }
            case 27: {
                return EstadoNFe.ESTADO_NFE.PROBLEMAS_DPEC_ENVIADO;
            }
        }
        return null;
    }

    public static void main(String[] args) {
        PropriedadesMain.processarComandos(args);
        CheckNFeIBS.init();
        CheckNFeIBS c = new CheckNFeIBS();
        try {
            c.process(ConfiguracaoSys.getTipoAmbiente(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

