/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.tools;

import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.util.ConfiguracaoSys;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.data.BaseDadosConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.persistence.Query;

public class CheckXMLTXT {
    private String rootdirstring;
    private File lastdir;
    private File rootdir;
    private FileWriter fw;
    private DAOGenerico<EstadoNFe> dao;

    public CheckXMLTXT(String rootDir) {
        this.rootdirstring = rootDir;
        this.rootdir = new File(this.rootdirstring);
        this.lastdir = new File(this.rootdirstring);
        this.dao = new DAOGenerico(EstadoNFe.class);
        try {
            this.fw = new FileWriter("log_check.log");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String queryXML(String id) {
        String sql = "select xmlString from ESTADONFE where id = '" + id + "'";
        Query q = this.dao.filter(sql);
        List list = q.getResultList();
        if (list.size() == 1) {
            Vector v = (Vector)list.get(0);
            String xml = v.get(0).toString();
            return xml;
        }
        return null;
    }

    public void procurarnotas(String[] args) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
        SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat df3 = new SimpleDateFormat("dd/MM/yyyy");
        Date d1 = null;
        Date d2 = null;
        try {
            d1 = df.parse(String.valueOf(PropriedadesMain.getData_inicio()) + " 00:00:00");
            d2 = df.parse(String.valueOf(PropriedadesMain.getData_fim()) + " 23:59:00");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        System.out.println("Checando notas entre datas:" + d1.toGMTString() + " ate: " + d2.toGMTString());
        String sql = "select id, dataGerada from ESTADONFE where dataGerada >= '" + df2.format(d1).toUpperCase() + "' and dataGerada <= '" + df2.format(d2).toUpperCase() + "'";
        Query q = this.dao.filter(sql);
        List list = q.getResultList();
        for (Object object : list) {
            Vector v = (Vector)object;
            String id = v.get(0).toString();
            String data = v.get(1).toString();
            try {
                System.out.println("Tratando nota: " + id);
                Vector<File> filepaths = this.findTXTFile(id);
                if (!filepaths.isEmpty()) {
                    for (File filepath : filepaths) {
                        String xml = this.queryXML(id);
                        int xmlsize = CheckXMLTXT.countXML(xml);
                        int txtsize = CheckXMLTXT.countTXT(filepath.getAbsolutePath());
                        if (txtsize == xmlsize) continue;
                        System.out.println("Nota com problemas, copiando arquivo: " + filepath);
                        CheckXMLTXT.copyfile(filepath.getAbsolutePath(), filepath.getName());
                        try {
                            this.fw.write("Nota com problemas: " + id + " arquivo: " + filepath + "\n");
                            this.fw.flush();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    try {
                        System.out.println("Arquivo TXT nao encontrado da nota: " + id);
                        this.fw.write("Arquivo TXT nao encontrado da nota: " + id + "\n");
                        this.fw.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                System.gc();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    this.fw.write("Problema processando a nota: " + id + " excecao: " + e.getLocalizedMessage() + "\n");
                    this.fw.flush();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        try {
            this.fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int countXML2(String xml) {
        int pos;
        int contador = 0;
        int inicio = 0;
        while ((pos = xml.indexOf("<prod>", inicio)) != -1) {
            ++contador;
            inicio = pos + "<prod>".length() + 10;
        }
        System.out.println("\ntamanho:" + contador);
        return contador;
    }

    public static int countXML(String xml) {
        String[] partes;
        int contador = 0;
        String[] stringArray = partes = xml.split("<prod>");
        int n = partes.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string.startsWith("<cProd>")) {
                ++contador;
            }
            ++n2;
        }
        System.out.println("Numero de item XML:" + contador);
        return contador;
    }

    public Vector<File> findTXTFile(String id) {
        GerenciadorChavesNota nota = new GerenciadorChavesNota(id);
        String nametemplate = PropriedadesMain.getConfig();
        nametemplate = nametemplate.replace("NUMERO", String.valueOf(Integer.parseInt(nota.getNumeroNota())));
        nametemplate = nametemplate.replace("SERIE", String.valueOf(Integer.parseInt(nota.getSerie())));
        nametemplate = nametemplate.replace("CNPJ", nota.getCnpj());
        nametemplate = nametemplate.replace("DATA", Calendar.getInstance().getTime().toGMTString());
        nametemplate = nametemplate.replace("CHAVE", id);
        String path = null;
        if (this.lastdir != null) {
            path = String.valueOf(this.lastdir.getAbsolutePath()) + "/" + nametemplate;
        } else {
            this.lastdir = this.rootdir;
            path = String.valueOf(this.rootdir.getAbsolutePath()) + "/" + nametemplate;
        }
        File f = new File(path);
        System.out.println("Procurando arquivo: " + f.getAbsolutePath());
        Vector<File> founded = this.findCheck(this.lastdir, f.getAbsolutePath());
        if (!founded.isEmpty()) {
            return founded;
        }
        return this.findDirs(nametemplate, this.rootdir);
    }

    private Vector<File> findCheck(File root, String name) {
        File[] files;
        name = name.replace(".txt", "");
        Vector<File> filesv = new Vector<File>();
        File[] fileArray = files = root.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile() && file.getAbsolutePath().toLowerCase().equals(name.toLowerCase())) {
                filesv.add(file);
                return filesv;
            }
            ++n2;
        }
        return filesv;
    }

    private Vector<File> findDirs(String name, File dir) {
        String completname = String.valueOf(dir.getAbsolutePath()) + "\\" + name;
        Vector<File> filev = new Vector<File>();
        File[] files = dir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                Vector<File> findeds;
                File file = fileArray[n2];
                if (file.isFile()) {
                    if (file.getAbsolutePath().toLowerCase().equals(completname.toLowerCase())) {
                        this.lastdir = dir;
                        filev.add(file);
                    }
                } else if (file.isDirectory() && (findeds = this.findDirs(name, file)) != null) {
                    filev.addAll(findeds);
                }
                ++n2;
            }
        }
        return filev;
    }

    public static void copyfile(String srFile, String dtFile) throws Exception {
        int len;
        File f1 = new File(srFile);
        File f2 = new File(dtFile);
        FileInputStream in = new FileInputStream(f1);
        FileOutputStream out = new FileOutputStream(f2);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static int countTXT(String filepath) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filepath);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        String linha = "";
        int counter = 0;
        BufferedReader r = new BufferedReader(new InputStreamReader(fis));
        try {
            while ((linha = r.readLine()) != null) {
                if (!linha.trim().startsWith("3000")) continue;
                ++counter;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fis.close();
            r.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Numero de item TXT:" + counter);
        return counter;
    }

    public static void main(String[] args) {
        PropriedadesMain.processarComandos(args);
        BaseDadosConfig bd = new BaseDadosConfig();
        bd.setNomeDriver(ConfiguracaoSys.getDRIVER());
        bd.setUsuario(ConfiguracaoSys.getUSER_NAME());
        bd.setSenha(ConfiguracaoSys.getPASSWORD());
        bd.setUrl(ConfiguracaoSys.getURL_CONECTION());
        bd.setToplinkProp("update-tables");
        PropriedadesSistema.setBdConfig(bd);
        CheckXMLTXT c = new CheckXMLTXT(PropriedadesMain.getOutros());
        c.procurarnotas(args);
    }
}

