/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.tools;

import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.Empresa;
import br.com.taragona.nfe.persistence.EntidadeCnpj;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class ExcelDocumentGenerator {
    protected Vector<Object> infos;
    protected Hashtable<String, String> headerdata;
    protected File fileout;
    private DAOGenerico<EstadoNFe> daoinfo;
    private DAOGenerico<Empresa> daoemp;
    private SimpleDateFormat sdf;
    private boolean islogs;

    public ExcelDocumentGenerator(Hashtable<String, String> headerdata, Vector<Object> infos) {
        this.infos = infos;
        this.headerdata = headerdata;
        this.daoinfo = new DAOGenerico(EstadoNFe.class);
        this.daoemp = new DAOGenerico(Empresa.class);
        this.sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    }

    public void fillXMLInfoRow(int rownum, Row row, EstadoNFe info) {
        EntidadeCnpj eCnpj;
        Empresa emp;
        GerenciadorChavesNota key = new GerenciadorChavesNota(info.getId());
        Cell cellserienum = row.createCell(0);
        cellserienum.setCellValue(String.valueOf(key.getSerie()) + " - " + key.getNumeroNota());
        Cell celldest = row.createCell(1);
        celldest.setCellValue(key.getCnpj());
        String cnpjdest = info.getCnpjDestino();
        if (cnpjdest != null && cnpjdest.contains(":")) {
            cnpjdest = cnpjdest.split(":")[0];
            cnpjdest = cnpjdest.trim();
        }
        Cell cellemit = row.createCell(2);
        cellemit.setCellValue(cnpjdest);
        if (info.getCnpjDestino() != null && (emp = this.daoemp.buscarPorIdObject(eCnpj = new EntidadeCnpj(cnpjdest, info.getAmbiente()))) != null) {
            Cell cellrazao = row.createCell(3);
            cellrazao.setCellValue(emp.getNome());
        }
        if (info.getDataAutorizada() != null) {
            try {
                Cell celldata = row.createCell(4);
                celldata.setCellValue(this.sdf.format(info.getDataAutorizada()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Cell cellstatus = row.createCell(5);
        cellstatus.setCellValue(info.getEstado() != null ? info.getEstado().toString() : "");
        Cell cellkey = row.createCell(6);
        cellkey.setCellValue(info.getId().replace("NFe", ""));
    }

    public void create() {
        try {
            this.fileout = new File(String.valueOf(System.getProperty("user.home")) + "/relatorio.xls");
            FileOutputStream out = new FileOutputStream(this.fileout);
            HSSFWorkbook wb = new HSSFWorkbook();
            Sheet s = wb.createSheet();
            CellStyle cs = wb.createCellStyle();
            CellStyle cs2 = wb.createCellStyle();
            CellStyle cs3 = wb.createCellStyle();
            DataFormat df = wb.createDataFormat();
            Font f = wb.createFont();
            Font f2 = wb.createFont();
            f.setFontHeightInPoints((short)12);
            f.setColor((short)12);
            f.setBoldweight((short)700);
            f2.setFontHeightInPoints((short)10);
            f2.setColor((short)10);
            f2.setBoldweight((short)700);
            f2.setStrikeout(true);
            cs.setFont(f);
            cs.setDataFormat(df.getFormat("#,##0.0"));
            cs2.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"MM/dd/yyyy"));
            wb.setSheetName(0, "consulta");
            s.setColumnWidth(0, 4000);
            s.setColumnWidth(1, 4000);
            s.setColumnWidth(2, 5600);
            s.setColumnWidth(3, 12000);
            s.setColumnWidth(4, 5600);
            s.setColumnWidth(5, 5600);
            s.setColumnWidth(6, 13600);
            boolean isheader = true;
            int rownum = 0;
            while (rownum < this.infos.size()) {
                Row row = s.createRow((int)((short)(rownum + 1)));
                Object info = this.infos.get(rownum);
                if (info instanceof EstadoNFe) {
                    if (isheader) {
                        Row header = s.createRow(0);
                        header.createCell(0).setCellValue("\"serie - numero\"");
                        header.createCell(1).setCellValue("\"cnpj emitente\"");
                        header.createCell(2).setCellValue("\"cnpj detinatario\"");
                        header.createCell(3).setCellValue("\"razao social detinatario\"");
                        header.createCell(4).setCellValue("\"data autorizacao\"");
                        header.createCell(5).setCellValue("\"status\"");
                        header.createCell(6).setCellValue("\"chave\"");
                        isheader = false;
                    }
                    EstadoNFe xmlinfo = (EstadoNFe)info;
                    this.fillXMLInfoRow(rownum, row, xmlinfo);
                }
                ++rownum;
            }
            wb.write((OutputStream)out);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public File generateExcelFile() {
        return this.fileout;
    }

    public static void main(String[] args) {
        try {
            System.out.println(Double.parseDouble("0"));
            HSSFWorkbook workbook = new HSSFWorkbook((InputStream)new FileInputStream("C:\\teste.xls"));
            HSSFSheet sheet = workbook.getSheetAt(0);
            Iterator rows = sheet.rowIterator();
            boolean first = true;
            while (rows.hasNext()) {
                HSSFRow row = (HSSFRow)rows.next();
                if (first) {
                    row.createCell(16).setCellValue("Valida\u00e7\u00e3o CT-e");
                    first = false;
                    continue;
                }
                Iterator cells = row.cellIterator();
                while (cells.hasNext()) {
                    HSSFCell cell = (HSSFCell)cells.next();
                    System.out.println(cell.toString());
                }
                row.createCell(16).setCellValue("VALIDADA");
            }
            workbook.write((OutputStream)new FileOutputStream(new File("C:\\teste2.xls")));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

