/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.tools;

import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.Empresa;
import br.com.taragona.nfe.persistence.EntidadeCnpj;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.util.ConfiguracaoSys;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.data.BaseDadosConfig;
import br.com.tti.nfev200.TNFe;
import br.com.tti.sefaz.xml.XMLGenerator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.persistence.Query;
import javax.xml.bind.JAXBElement;

public class ExtractEmpresas {
    public ExtractEmpresas() {
        this.init();
    }

    public void init() {
        BaseDadosConfig bd = new BaseDadosConfig();
        bd.setNomeDriver(ConfiguracaoSys.getDRIVER());
        bd.setUsuario(ConfiguracaoSys.getUSER_NAME());
        bd.setSenha(ConfiguracaoSys.getPASSWORD());
        bd.setUrl(ConfiguracaoSys.getURL_CONECTION());
        bd.setToplinkProp("update-tables");
        PropriedadesSistema.setBdConfig(bd);
    }

    public void process() throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
        SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd");
        Date d1 = null;
        Date d2 = null;
        try {
            d1 = df.parse(String.valueOf(PropriedadesMain.getData_inicio()) + " 00:00:00");
            d2 = df.parse(String.valueOf(PropriedadesMain.getData_fim()) + " 23:00:00");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        XMLGenerator gen = new XMLGenerator("br.com.tti.nfev200");
        DAOGenerico dao = new DAOGenerico(EstadoNFe.class);
        DAOGenerico<Empresa> daoEmp = new DAOGenerico<Empresa>(Empresa.class);
        String sql = "select id, xmlString from ESTADONFE where dataGerada >= '" + df2.format(d1).toUpperCase() + "' and dataGerada <= '" + df2.format(d2).toUpperCase() + "'";
        Query q = dao.filter(sql);
        List list = q.getResultList();
        for (Object object : list) {
            Vector v = (Vector)object;
            String id = v.get(0).toString();
            if (v.get(1) == null) continue;
            String xmlstring = v.get(1).toString();
            System.out.println("Processando NFe: " + id);
            TNFe nfe = (TNFe)((JAXBElement)gen.toObject(xmlstring)).getValue();
            String CNPJDestino = String.valueOf(nfe.getInfNFe().getDest().getCNPJ()) + nfe.getInfNFe().getDest().getCPF();
            CNPJDestino = CNPJDestino.replace("null", "");
            String destnome = nfe.getInfNFe().getDest().getXNome();
            EntidadeCnpj eCnpj = new EntidadeCnpj(CNPJDestino, nfe.getInfNFe().getIde().getTpAmb());
            Empresa emp = (Empresa)daoEmp.buscarPorIdObject(eCnpj);
            if (emp == null) {
                emp = new Empresa();
                emp.setCnpj(CNPJDestino);
                emp.setAmbiente(eCnpj.getAmbiente());
                emp.setNome(destnome);
                emp.setTipo(Empresa.TIPO_EMPRESA.DEST);
                daoEmp.salvar(emp);
                daoEmp.flush();
            }
            if (nfe.getInfNFe().getTransp() == null || nfe.getInfNFe().getTransp().getTransporta() == null) continue;
            String CNPJTransp = String.valueOf(nfe.getInfNFe().getTransp().getTransporta().getCNPJ()) + nfe.getInfNFe().getTransp().getTransporta().getCPF();
            CNPJTransp = CNPJTransp.replace("null", "");
            String transpnome = nfe.getInfNFe().getTransp().getTransporta().getXNome();
            eCnpj = new EntidadeCnpj(CNPJTransp, nfe.getInfNFe().getIde().getTpAmb());
            Empresa empt = (Empresa)daoEmp.buscarPorIdObject(eCnpj);
            if (empt != null) continue;
            empt = new Empresa();
            empt.setCnpj(CNPJTransp);
            empt.setAmbiente(eCnpj.getAmbiente());
            empt.setNome(transpnome);
            empt.setTipo(Empresa.TIPO_EMPRESA.TRANSP);
            daoEmp.salvar(empt);
            daoEmp.flush();
        }
    }

    public static void main(String[] args) {
        PropriedadesMain.processarComandos(args);
        ExtractEmpresas extract = new ExtractEmpresas();
        try {
            extract.process();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

