/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.tools;

import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.tti.sefaz.remote.DBConfig;
import br.com.tti.sefaz.systemconfig.XMLConfigSystem;
import br.com.tti.sefaz.util.MainParameters;
import br.com.tti.xmldb.XMLDBInterfaceProvider;
import br.com.tti.xmldb.XMLDBProviderFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;

public class ImportToXMLDB {
    private DBConfig dbconfig;
    private XMLDBInterfaceProvider provider;

    public ImportToXMLDB() {
        XMLConfigSystem config = XMLConfigSystem.getInstance((String)MainParameters.getXml());
        config.make();
        this.dbconfig = config.getDbConfig();
    }

    public void process() {
        Connection cx = null;
        try {
            Class.forName(this.dbconfig.getDriver());
            cx = DriverManager.getConnection(String.valueOf(this.dbconfig.getUrl()) + "?autocommit=true", this.dbconfig.getUser(), this.dbconfig.getPassword());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.provider = XMLDBProviderFactory.createProvider();
        String sqlquery = "";
        String sqlupdateorig = "";
        if (this.dbconfig.getDriver().contains("mysql.jdbc")) {
            sqlquery = "SELECT ID,XMLSTRING, XMLDBKEY FROM ESTADONFE WHERE XMLDBKEY IS NULL ORDER BY DATAGERADA ";
            sqlupdateorig = "UPDATE ESTADONFE SET XMLDBKEY = '%1%' WHERE ID = '%2%'";
        }
        if (this.dbconfig.getDriver().contains("net.sourceforge.jtds.jdbc")) {
            sqlquery = "SELECT TOP 50 ID,XMLSTRING, XMLDBKEY FROM ESTADONFE WHERE XMLDBKEY IS NULL ORDER BY DATAGERADA ASC";
            sqlupdateorig = "UPDATE ESTADONFE SET XMLDBKEY = '%1%' WHERE ID = '%2%'";
        }
        boolean hasmore = true;
        while (hasmore) {
            try {
                Statement stat = cx.createStatement();
                ResultSet res = stat.executeQuery(sqlquery);
                hasmore = false;
                while (res.next()) {
                    String ID = res.getString("ID");
                    String XMLSTRING = res.getString("XMLSTRING");
                    String XMLDBKEY = res.getString("XMLDBKEY");
                    hasmore = true;
                    System.out.println("\n[NFe:]" + ID);
                    String xmlkey = "NAO TEM";
                    if (XMLSTRING != null) {
                        xmlkey = this.provider.saveXMLDocument(ID, XMLSTRING, null);
                    }
                    sqlupdateorig = "UPDATE ESTADONFE SET XMLDBKEY = '%1%' WHERE ID = '%2%'";
                    String sqlupdate = sqlupdateorig.replace("%1%", xmlkey);
                    sqlupdate = sqlupdate.replace("%2%", ID);
                    try {
                        cx.setAutoCommit(true);
                        Statement upstat = cx.createStatement();
                        upstat.executeUpdate(sqlupdate);
                        upstat.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    System.out.println("[KEY:]" + xmlkey);
                }
                stat.close();
                res.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                System.gc();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        PropriedadesMain.processarComandos(args);
        MainParameters.processArguments((String[])args);
        ImportToXMLDB importer = new ImportToXMLDB();
        importer.process();
    }
}

