/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.util;

import br.com.taragona.nfe.clientreferencia.ReferenciaGerenciador;
import br.com.taragona.nfe.cockpitserver.CockpitServer;
import br.com.taragona.nfe.gerenciador.GerenciadorInterface;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.util.ConfiguracaoSys;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.data.BaseDadosConfig;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Vector;

public class GenerateRetorno {
    private CockpitServer cockpit;
    private SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
    private String tpAmb;
    private String cnpj;
    private String serie;
    private String ini;
    private String fim;

    public GenerateRetorno(String tpAmb, String cnpj, String serie, String ini, String fim) {
        this.tpAmb = tpAmb;
        this.cnpj = cnpj;
        this.serie = serie;
        this.ini = ini;
        this.fim = fim;
        this.cockpit = new CockpitServer();
    }

    public Vector<EstadoNFe> getNotas() {
        try {
            return this.cockpit.findNota(this.tpAmb, this.cnpj, this.serie, this.ini, this.fim, this.df.parse("01/01/2009"));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void generate() {
        GerenciadorInterface ger = null;
        try {
            ger = ReferenciaGerenciador.obterReferenciaGerenciador("localhost");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        Vector<EstadoNFe> notas = this.getNotas();
        for (EstadoNFe estadoNFe : notas) {
            try {
                ger.atualizarNota(estadoNFe);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        PropriedadesMain.processarComandos(args);
        BaseDadosConfig bd = new BaseDadosConfig();
        bd.setNomeDriver(ConfiguracaoSys.getDRIVER());
        bd.setUsuario(ConfiguracaoSys.getUSER_NAME());
        bd.setSenha(ConfiguracaoSys.getPASSWORD());
        bd.setUrl(ConfiguracaoSys.getURL_CONECTION());
        bd.setToplinkProp("create-tables");
        PropriedadesSistema.setBdConfig(bd);
        GenerateRetorno gen = new GenerateRetorno(ConfiguracaoSys.getTipoAmbiente(), PropriedadesMain.getCnpjs().get(0), PropriedadesMain.getIps().get(0), PropriedadesMain.getIps().get(1), PropriedadesMain.getIps().get(2));
        gen.generate();
    }
}

