/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.util;

import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.EntidadeId;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.tools.PathFileFinder;
import br.com.taragona.nfe.tools.ZipCreator;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.extract.XMLFormer;
import br.com.tti.sefaz.log.MyLogger;
import br.com.tti.sefaz.remote.DBConfig;
import br.com.tti.sefaz.systemconfig.XMLConfigSystem;
import br.com.tti.sefaz.util.MainParameters;
import br.com.tti.util.DataUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import javax.persistence.Query;

public class XMLProtExtractor {
    public static String ROOT_PATH = "C:\\";
    public static String ROOT_PATH_FILESZIP = "C:\\";
    private SimpleDateFormat sfmes;
    private SimpleDateFormat sfano;
    private SimpleDateFormat sf;
    private DBConfig dbConfig;
    private XMLFormer former;
    private Vector<String> filestozip;
    private String tpAmb;
    SimpleDateFormat sdfperiod = new SimpleDateFormat("dd_MM_yyyy");

    public XMLProtExtractor(String tpAmb) {
        this.tpAmb = tpAmb;
        this.sf = new SimpleDateFormat("yyyy-MM-dd");
        this.sfmes = new SimpleDateFormat("MMM_yyyy");
        this.sfano = new SimpleDateFormat("yyyy");
        XMLConfigSystem config = XMLConfigSystem.getInstance((String)MainParameters.getXml());
        config.make();
        this.dbConfig = config.getDbConfig();
        this.former = new XMLFormer(tpAmb);
    }

    public File process(String tpAmb, Vector<String> xmls) throws Exception {
        File[] filesroot;
        block7: {
            if (tpAmb != null && !tpAmb.equals("") && !tpAmb.equals(this.tpAmb)) {
                this.tpAmb = tpAmb;
                this.former.setTpAmb(tpAmb);
            }
            try {
                DAOGenerico daoinfo = new DAOGenerico(EstadoNFe.class);
                this.filestozip = new Vector();
                for (String key : xmls) {
                    EntidadeId id = new EntidadeId(key, this.tpAmb);
                    EstadoNFe info = (EstadoNFe)daoinfo.buscarPorIdObject(id);
                    if (info.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.AUTORIZADA)) {
                        this.createFileAutorizada(info, "", false, null, null, true, true);
                    }
                    if (!info.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.CANCELADA)) continue;
                    this.createFileCancelada(info, "", false);
                }
                System.gc();
                System.out.println("tozip:" + this.filestozip.toString());
                filesroot = new File[this.filestozip.size()];
                int i = 0;
                while (i < this.filestozip.size()) {
                    filesroot[i] = new File(this.filestozip.get(i));
                    ++i;
                }
                if (filesroot.length != 0) break block7;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        ZipCreator zipc = new ZipCreator(filesroot);
        File fileziped = zipc.process();
        System.out.println("fileziped:" + fileziped.getAbsolutePath());
        return fileziped;
    }

    public File process(String tpAmb, Vector<String> cnpjsemit, Vector<String> cnpjsdest, Date d1, Date d2, Hashtable<String, String> props) throws Exception {
        if (tpAmb != null && !tpAmb.equals("") && !tpAmb.equals(this.tpAmb)) {
            this.tpAmb = tpAmb;
            this.former.setTpAmb(tpAmb);
        }
        DAOGenerico dao = new DAOGenerico(EstadoNFe.class);
        System.out.println(cnpjsemit.toString());
        System.out.println(cnpjsdest.toString());
        ROOT_PATH_FILESZIP = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + UUID.randomUUID().toString().split("-")[0];
        System.out.println("file dir: " + ROOT_PATH_FILESZIP);
        new File(ROOT_PATH_FILESZIP).mkdirs();
        String sql = null;
        String sqlemit = "";
        if (!cnpjsemit.isEmpty()) {
            for (String cc : cnpjsemit) {
                if (cc == null) continue;
                sqlemit = " e.cnpj = '" + cc.trim() + "' or " + sqlemit;
            }
            sqlemit = String.valueOf(sqlemit.trim()) + "@";
            sqlemit = sqlemit.replace("or@", "");
            sqlemit = "( " + sqlemit + ") and";
        }
        boolean haslike = false;
        String sqldest = "";
        String onecnpj = "";
        if (!cnpjsdest.isEmpty()) {
            for (String cc : cnpjsdest) {
                if (cc == null) continue;
                sqldest = " e.cnpjDestino like '" + cc.trim() + "' or " + sqldest;
            }
            sqldest = String.valueOf(sqldest.trim()) + "@";
            sqldest = sqldest.replace("or@", "");
            sqldest = "( " + sqldest + ") and";
        }
        sql = "select e from EstadoNFe e where " + sqlemit + " e.dataGerada >= ?1" + " and e.dataGerada <= ?2" + " and e.ambiente = ?3" + " order by e.dataGerada desc";
        d1 = DataUtil.truncate(d1);
        if (d2 != null) {
            d2 = DataUtil.truncate(d2);
            String dt = this.sf.format(d2);
            dt = String.valueOf(dt) + " 23:59:59";
            d2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dt);
        }
        Query q = null;
        try {
            q = dao.criarQuery(sql);
            q.setParameter(1, (Object)d1);
            if (d2 != null) {
                q.setParameter(2, (Object)d2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        q.setParameter(3, (Object)this.tpAmb);
        List o = q.getResultList();
        this.filestozip = new Vector();
        Boolean addxml = props.containsKey("xml") ? Boolean.parseBoolean(props.get("xml")) : false;
        Boolean addpdf = props.containsKey("pdf") ? Boolean.parseBoolean(props.get("pdf")) : false;
        for (EstadoNFe info : o) {
            System.out.println("processing:" + info.getId() + " estado: " + (Object)((Object)info.getEstado()));
            if (!info.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.AUTORIZADA)) continue;
            this.createFileAutorizada(info, onecnpj, haslike, d1, d2, addxml, addpdf);
        }
        o.clear();
        o = null;
        dao.clear();
        dao.close();
        dao = null;
        System.gc();
        MyLogger.getLog().info("tozip:" + this.filestozip.toString());
        File[] filesroot = new File[this.filestozip.size()];
        int i = 0;
        while (i < this.filestozip.size()) {
            filesroot[i] = new File(this.filestozip.get(i));
            ++i;
        }
        if (filesroot.length == 0) {
            return null;
        }
        ZipCreator zipc = new ZipCreator(filesroot);
        File fileziped = zipc.process();
        MyLogger.getLog().info("fileziped:" + fileziped.getAbsolutePath());
        return fileziped;
    }

    private EstadoNFe.ESTADO_NFE getEstado(int n) {
        switch (n) {
            case 0: {
                return EstadoNFe.ESTADO_NFE.USO_DENEGADO;
            }
            case 1: {
                return EstadoNFe.ESTADO_NFE.REJEITADA;
            }
            case 2: {
                return EstadoNFe.ESTADO_NFE.AUTORIZADA;
            }
            case 3: {
                return EstadoNFe.ESTADO_NFE.GERADA;
            }
            case 4: {
                return EstadoNFe.ESTADO_NFE.ASSINADA;
            }
            case 5: {
                return EstadoNFe.ESTADO_NFE.ENVIADA;
            }
            case 6: {
                return EstadoNFe.ESTADO_NFE.ERRO_VALIDACAO;
            }
            case 7: {
                return EstadoNFe.ESTADO_NFE.IMPRESSA_NORMAL;
            }
            case 8: {
                return EstadoNFe.ESTADO_NFE.IMPRESSA_CONT;
            }
            case 9: {
                return EstadoNFe.ESTADO_NFE.CANCELADA;
            }
            case 10: {
                return EstadoNFe.ESTADO_NFE.INUTILIZADA;
            }
            case 11: {
                return EstadoNFe.ESTADO_NFE.TENTANDO_ENVIO;
            }
            case 12: {
                return EstadoNFe.ESTADO_NFE.ERRO_ENVIO;
            }
            case 13: {
                return EstadoNFe.ESTADO_NFE.RESULTADO_SEFAZ;
            }
            case 14: {
                return EstadoNFe.ESTADO_NFE.ERRO;
            }
            case 15: {
                return EstadoNFe.ESTADO_NFE.PEDIDO_CANCELAMENTO;
            }
            case 16: {
                return EstadoNFe.ESTADO_NFE.ERRO_ESQUEMA;
            }
            case 17: {
                return EstadoNFe.ESTADO_NFE.TEMPO_PROCESSAMENTO_LIMITE;
            }
            case 18: {
                return EstadoNFe.ESTADO_NFE.ERRO_ESQUEMA_LOTE;
            }
            case 19: {
                return EstadoNFe.ESTADO_NFE.ERRO_CANCELAMENTO;
            }
            case 20: {
                return EstadoNFe.ESTADO_NFE.ERRO_INUTILIZACAO;
            }
            case 21: {
                return EstadoNFe.ESTADO_NFE.ERRO_IMPRESSAO;
            }
            case 22: {
                return EstadoNFe.ESTADO_NFE.IMPRESSA_LASER;
            }
            case 23: {
                return EstadoNFe.ESTADO_NFE.CANCELADA_CONTINGENCIA;
            }
            case 24: {
                return EstadoNFe.ESTADO_NFE.ERRO_XML_SEFAZ;
            }
            case 25: {
                return EstadoNFe.ESTADO_NFE.CANCELAR_SAIDA_CONTINGENCIA;
            }
            case 26: {
                return EstadoNFe.ESTADO_NFE.DPEC_ENVIADO;
            }
            case 27: {
                return EstadoNFe.ESTADO_NFE.PROBLEMAS_DPEC_ENVIADO;
            }
        }
        return null;
    }

    public static void copyFile(String srFile, String dtFile) throws Exception {
        int len;
        File f1 = new File(srFile);
        File f2 = new File(dtFile);
        FileInputStream in = new FileInputStream(f1);
        FileOutputStream out = new FileOutputStream(f2);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private void createFileAutorizada(EstadoNFe info, String rootcnpj, boolean haslike, Date d1, Date d2, Boolean addxml, Boolean addpdf) {
        try {
            String xml = this.former.getXML(info.getId(), info.getAmbiente());
            if (xml != null) {
                String filetozippath;
                Hashtable<String, String> fantasynames = GerenciadorProxy.gerenciador.obterNomesFantasia();
                String cnpjemitente = String.valueOf(info.getCnpj()) + "_" + fantasynames.get(info.getCnpj());
                String cnpjdestinatario = info.getCnpjDestino();
                if (cnpjdestinatario == null) {
                    cnpjdestinatario = "destinatario";
                }
                String type = "";
                if (xml.contains("<tpNF>0</tpNF>")) {
                    type = "Entrada";
                } else if (xml.contains("<tpNF>1</tpNF>")) {
                    type = "Saida";
                }
                String datapath = String.valueOf(this.sdfperiod.format(d1)) + "__" + this.sdfperiod.format(d2);
                if (addxml.booleanValue()) {
                    File fileoutxml = new File(String.valueOf(ROOT_PATH_FILESZIP) + "/" + cnpjemitente + "/" + datapath + "/" + type + "/" + info.getId() + "_prot.xml");
                    System.out.println("XML protocolo:" + fileoutxml.getAbsolutePath());
                    if (!fileoutxml.getParentFile().exists()) {
                        fileoutxml.getParentFile().mkdirs();
                    }
                    FileOutputStream fis = new FileOutputStream(fileoutxml.getAbsoluteFile());
                    OutputStreamWriter out = new OutputStreamWriter((OutputStream)fis, "UTF-8");
                    out.write(xml);
                    out.close();
                    fis.close();
                }
                if (!this.filestozip.contains(filetozippath = String.valueOf(ROOT_PATH_FILESZIP) + "/" + cnpjemitente)) {
                    this.filestozip.add(filetozippath);
                }
                if (addpdf.booleanValue()) {
                    File fileoutpdf = new File(String.valueOf(ROOT_PATH_FILESZIP) + "/" + cnpjemitente + "/" + datapath + "/" + type + "/" + info.getId() + ".pdf");
                    System.out.println("PDF:" + fileoutpdf.getAbsolutePath());
                    if (!fileoutpdf.getParentFile().exists()) {
                        fileoutpdf.getParentFile().mkdirs();
                    }
                    String pdffile = PathFileFinder.getINSTANCE().findPDFPath(info.getId(), info.getAmbiente(), info.getDataGerada());
                    XMLProtExtractor.copyFile(String.valueOf(pdffile) + File.separator + info.getId() + ".pdf", fileoutpdf.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createFileCancelada(EstadoNFe info, String rootcnpj, boolean haslike) {
        try {
            String xml = info.getProtocoloCancelamentoXML();
            if (xml != null) {
                File fileout = null;
                Hashtable<String, String> fantasynames = GerenciadorProxy.gerenciador.obterNomesFantasia();
                String cnpjemitente = String.valueOf(info.getCnpj()) + "_" + fantasynames.get(info.getCnpj());
                String cnpjdestinatario = info.getCnpjDestino();
                if (cnpjdestinatario == null) {
                    cnpjdestinatario = "destinatario";
                }
                String datapath = String.valueOf(this.sfano.format(info.getDataGerada())) + "/" + this.sfmes.format(info.getDataGerada());
                fileout = new File(String.valueOf(ROOT_PATH_FILESZIP) + "/" + cnpjemitente + "/" + cnpjdestinatario + "/" + datapath + "/" + info.getId() + "_canc_prot.xml");
                System.out.println("XML protocolo canc:" + fileout.getAbsolutePath());
                if (!fileout.getParentFile().exists()) {
                    fileout.getParentFile().mkdirs();
                }
                FileOutputStream fis = new FileOutputStream(fileout.getAbsoluteFile());
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)fis, "UTF-8");
                out.write(xml);
                out.close();
                fis.close();
                String filetozippath = String.valueOf(ROOT_PATH_FILESZIP) + "/" + cnpjemitente;
                if (!this.filestozip.contains(filetozippath)) {
                    this.filestozip.add(filetozippath);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

