/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.util.importdata;

import br.com.taragona.nfe.persistence.EstadoNFe;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;

public class ImportData {
    private EntityManager daoSource;
    private EntityManager daoTarget;

    private void createSource() {
        ResourceBundle s = ResourceBundle.getBundle("source");
        HashMap<String, String> h = new HashMap<String, String>();
        h.put("javax.persistence.jdbc.password", s.getString("password"));
        h.put("javax.persistence.jdbc.user", s.getString("user"));
        h.put("javax.persistence.jdbc.url", s.getString("url"));
        h.put("javax.persistence.jdbc.driver", s.getString("driver"));
        h.put("eclipselink.ddl-generation", "create-or-extend-tables");
        EntityManagerFactory fact = Persistence.createEntityManagerFactory((String)"MessengerAPIPU", h);
        this.daoSource = fact.createEntityManager();
    }

    private void createTarget() {
        ResourceBundle s = ResourceBundle.getBundle("target");
        HashMap<String, String> h = new HashMap<String, String>();
        h.put("javax.persistence.jdbc.password", s.getString("password"));
        h.put("javax.persistence.jdbc.user", s.getString("user"));
        h.put("javax.persistence.jdbc.url", s.getString("url"));
        h.put("javax.persistence.jdbc.driver", s.getString("driver"));
        h.put("eclipselink.ddl-generation", "create-or-extend-tables");
        EntityManagerFactory fact = Persistence.createEntityManagerFactory((String)"MessengerAPIPU2", h);
        this.daoTarget = fact.createEntityManager();
    }

    private EstadoNFe convert(EstadoNFe e) {
        EstadoNFe es = new EstadoNFe();
        es.setId(e.getId());
        return es;
    }

    public void importData() {
        this.createSource();
        this.createTarget();
        String sql = "SELECT E FROM EstadoNFe AS E";
        List notas = this.daoSource.createQuery(sql).getResultList();
        for (EstadoNFe nota : notas) {
            System.out.println(nota.getId());
            EstadoNFe old = (EstadoNFe)this.daoTarget.find(EstadoNFe.class, (Object)nota.getId());
            if (old != null) continue;
            System.out.println("Adicionando:" + nota.getId());
            EntityTransaction t = this.daoTarget.getTransaction();
            t.begin();
            nota.setLote(null);
            this.daoTarget.persist((Object)nota);
            t.commit();
        }
    }

    public static void main(String[] args) {
        ImportData data = new ImportData();
        data.importData();
    }
}

